/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.code.Instruction;
import com.android.tools.r8.code.ReturnVoid;
import com.android.tools.r8.code.SwitchPayload;
import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexDebugEntry;
import com.android.tools.r8.graph.DexDebugEntryBuilder;
import com.android.tools.r8.graph.DexDebugEvent;
import com.android.tools.r8.graph.DexDebugInfo;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexItemBasedString;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.ValueNumberGenerator;
import com.android.tools.r8.ir.conversion.DexSourceCode;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2IntMap;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.StringUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class DexCode
extends Code {
    public final int registerSize;
    public final int incomingRegisterSize;
    public final int outgoingRegisterSize;
    public final Try[] tries;
    public final TryHandler[] handlers;
    public final Instruction[] instructions;
    public DexString highestSortingString;
    private DexDebugInfo debugInfo;

    public DexCode(int registerSize, int insSize, int outsSize, Instruction[] instructions, Try[] tries, TryHandler[] handlers, DexDebugInfo debugInfo) {
        this.incomingRegisterSize = insSize;
        this.registerSize = registerSize;
        this.outgoingRegisterSize = outsSize;
        this.instructions = instructions;
        this.tries = tries;
        this.handlers = handlers;
        this.debugInfo = debugInfo;
        this.hashCode();
    }

    public DexCode withoutThisParameter() {
        return new DexCode(this.registerSize, this.incomingRegisterSize - 1, this.outgoingRegisterSize, this.instructions, this.tries, this.handlers, this.debugInfoWithoutFirstParameter());
    }

    @Override
    public boolean isDexCode() {
        return true;
    }

    @Override
    public int estimatedSizeForInlining() {
        return this.instructions.length;
    }

    @Override
    public DexCode asDexCode() {
        return this;
    }

    public DexDebugInfo getDebugInfo() {
        return this.debugInfo;
    }

    public void setDebugInfo(DexDebugInfo debugInfo) {
        this.debugInfo = debugInfo;
    }

    public boolean hasDebugPositions() {
        if (this.debugInfo != null) {
            for (DexDebugEvent event : this.debugInfo.events) {
                if (!(event instanceof DexDebugEvent.Default)) continue;
                return true;
            }
        }
        return false;
    }

    public DexDebugInfo debugInfoWithAdditionalFirstParameter(DexString name) {
        if (this.debugInfo == null) {
            return null;
        }
        DexString[] parameters = this.debugInfo.parameters;
        DexString[] newParameters = new DexString[parameters.length + 1];
        newParameters[0] = name;
        System.arraycopy(parameters, 0, newParameters, 1, parameters.length);
        return new DexDebugInfo(this.debugInfo.startLine, newParameters, this.debugInfo.events);
    }

    public DexDebugInfo debugInfoWithoutFirstParameter() {
        if (this.debugInfo == null) {
            return null;
        }
        DexString[] parameters = this.debugInfo.parameters;
        if (parameters.length == 0) {
            return this.debugInfo;
        }
        DexString[] newParameters = new DexString[parameters.length - 1];
        System.arraycopy(parameters, 1, newParameters, 0, parameters.length - 1);
        return new DexDebugInfo(this.debugInfo.startLine, newParameters, this.debugInfo.events);
    }

    public int codeSizeInBytes() {
        Instruction last = this.instructions[this.instructions.length - 1];
        return last.getOffset() + last.getSize();
    }

    @Override
    public int computeHashCode() {
        return this.incomingRegisterSize * 2 + this.registerSize * 3 + this.outgoingRegisterSize * 5 + Arrays.hashCode(this.instructions) * 7 + (this.debugInfo == null ? 0 : this.debugInfo.hashCode()) * 11 + Arrays.hashCode(this.tries) * 13 + Arrays.hashCode(this.handlers) * 17;
    }

    @Override
    public boolean computeEquals(Object other) {
        if (other instanceof DexCode) {
            DexCode o = (DexCode)other;
            if (this.incomingRegisterSize != o.incomingRegisterSize) {
                return false;
            }
            if (this.registerSize != o.registerSize) {
                return false;
            }
            if (this.outgoingRegisterSize != o.outgoingRegisterSize) {
                return false;
            }
            if (this.debugInfo == null ? o.debugInfo != null : !this.debugInfo.equals(o.debugInfo)) {
                return false;
            }
            if (!Arrays.equals(this.tries, o.tries)) {
                return false;
            }
            if (!Arrays.equals(this.handlers, o.handlers)) {
                return false;
            }
            return Arrays.equals(this.instructions, o.instructions);
        }
        return false;
    }

    @Override
    public boolean isEmptyVoidMethod() {
        return this.instructions.length == 1 && this.instructions[0] instanceof ReturnVoid;
    }

    @Override
    public IRCode buildIR(DexEncodedMethod encodedMethod, AppInfo appInfo, GraphLense graphLense, InternalOptions options, Origin origin) {
        assert (this.getOwner() == encodedMethod);
        DexSourceCode source = new DexSourceCode(this, encodedMethod, graphLense.getOriginalMethodSignature(encodedMethod.method), null);
        IRBuilder builder = new IRBuilder(encodedMethod, appInfo, source, options, origin);
        return builder.build();
    }

    @Override
    public IRCode buildInliningIR(DexEncodedMethod encodedMethod, AppInfo appInfo, GraphLense graphLense, InternalOptions options, ValueNumberGenerator valueNumberGenerator, Position callerPosition, Origin origin) {
        assert (this.getOwner() == encodedMethod);
        DexSourceCode source = new DexSourceCode(this, encodedMethod, graphLense.getOriginalMethodSignature(encodedMethod.method), callerPosition);
        IRBuilder builder = new IRBuilder(encodedMethod, appInfo, source, options, origin, valueNumberGenerator);
        return builder.build();
    }

    @Override
    public void registerCodeReferences(UseRegistry registry) {
        for (Instruction insn : this.instructions) {
            insn.registerUse(registry);
        }
        if (this.handlers != null) {
            for (TryHandler handler : this.handlers) {
                for (TryHandler.TypeAddrPair pair : handler.pairs) {
                    registry.registerTypeReference(pair.type);
                }
            }
        }
    }

    @Override
    public String toString() {
        return this.toString(null, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toString(DexEncodedMethod method, ClassNameMapper naming) {
        StringBuilder builder = new StringBuilder();
        if (method != null) {
            builder.append(method.toSourceString()).append("\n");
        }
        builder.append("registers: ").append(this.registerSize);
        builder.append(", inputs: ").append(this.incomingRegisterSize);
        builder.append(", outputs: ").append(this.outgoingRegisterSize).append("\n");
        builder.append("------------------------------------------------------------\n");
        builder.append("inst#  offset  instruction         arguments\n");
        builder.append("------------------------------------------------------------\n");
        HashMap<Integer, Instruction> payloadUsers = new HashMap<Integer, Instruction>();
        for (Instruction instruction : this.instructions) {
            if (!instruction.hasPayload()) continue;
            payloadUsers.put(instruction.getOffset() + instruction.getPayloadOffset(), instruction);
        }
        DexDebugEntry debugInfo = null;
        Iterator<Object> debugInfoIterator = Collections.emptyIterator();
        if (this.getDebugInfo() != null && method != null) {
            debugInfoIterator = new DexDebugEntryBuilder(method, new DexItemFactory()).build().iterator();
            debugInfo = debugInfoIterator.hasNext() ? (DexDebugEntry)debugInfoIterator.next() : null;
        }
        int instructionNumber = 0;
        for (Instruction insn : this.instructions) {
            while (debugInfo != null && debugInfo.address == insn.getOffset()) {
                builder.append("         ").append(debugInfo.toString(false)).append("\n");
                debugInfo = debugInfoIterator.hasNext() ? (DexDebugEntry)debugInfoIterator.next() : null;
            }
            StringUtils.appendLeftPadded(builder, Integer.toString(instructionNumber++), 5);
            builder.append(": ");
            if (insn.isSwitchPayload()) {
                Instruction payloadUser = (Instruction)payloadUsers.get(insn.getOffset());
                builder.append(insn.toString(naming, payloadUser));
            } else {
                builder.append(insn.toString(naming));
            }
            builder.append('\n');
        }
        if (debugInfoIterator.hasNext()) {
            throw new Unreachable("Could not print all debug information.");
        }
        if (this.tries.length > 0) {
            builder.append("Tries (numbers are offsets)\n");
            for (Try atry : this.tries) {
                builder.append("  ");
                builder.append(atry.toString());
                builder.append('\n');
            }
            if (this.handlers != null) {
                void var8_13;
                builder.append("Handlers (numbers are offsets)\n");
                boolean bl = false;
                while (var8_13 < this.handlers.length) {
                    TryHandler handler = this.handlers[var8_13];
                    builder.append("  ").append((int)var8_13).append(": ");
                    builder.append(handler.toString());
                    builder.append('\n');
                    ++var8_13;
                }
            }
        }
        return builder.toString();
    }

    public String toSmaliString(ClassNameMapper naming) {
        Instruction payloadUser;
        StringBuilder builder = new StringBuilder();
        HashMap<Integer, Instruction> payloadUsers = new HashMap<Integer, Instruction>();
        HashSet<Integer> labledTargets = new HashSet<Integer>();
        for (Instruction dex : this.instructions) {
            int[] targets = dex.getTargets();
            if (targets != Instruction.NO_TARGETS && targets != Instruction.EXIT_TARGET) {
                assert (targets.length <= 2);
                labledTargets.add(dex.getOffset() + targets[0]);
                continue;
            }
            if (!dex.hasPayload()) continue;
            labledTargets.add(dex.getOffset() + dex.getPayloadOffset());
            payloadUsers.put(dex.getOffset() + dex.getPayloadOffset(), dex);
        }
        for (Instruction dex : this.instructions) {
            if (!dex.isSwitchPayload()) continue;
            payloadUser = (Instruction)payloadUsers.get(dex.getOffset());
            if (!(dex instanceof SwitchPayload)) continue;
            SwitchPayload payload = (SwitchPayload)dex;
            for (int target : payload.switchTargetOffsets()) {
                labledTargets.add(payloadUser.getOffset() + target);
            }
        }
        for (Instruction dex : this.instructions) {
            if (labledTargets.contains(dex.getOffset())) {
                builder.append("  :label_");
                builder.append(dex.getOffset());
                builder.append("\n");
            }
            if (dex.isSwitchPayload()) {
                payloadUser = (Instruction)payloadUsers.get(dex.getOffset());
                builder.append(dex.toSmaliString(payloadUser)).append('\n');
                continue;
            }
            builder.append(dex.toSmaliString(naming)).append('\n');
        }
        if (this.tries.length > 0) {
            builder.append("Tries (numbers are offsets)\n");
            for (Try atry : this.tries) {
                builder.append("  ");
                builder.append(atry.toString());
                builder.append('\n');
            }
            if (this.handlers != null) {
                builder.append("Handlers (numbers are offsets)\n");
                for (TryHandler handler : this.handlers) {
                    builder.append(handler.toString());
                    builder.append('\n');
                }
            }
        }
        return builder.toString();
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems, DexMethod method, int instructionOffset) {
        assert (instructionOffset == -1);
        this.highestSortingString = null;
        for (Instruction insn : this.instructions) {
            insn.collectIndexedItems(indexedItems, method, insn.getOffset());
            if (insn.isConstString()) {
                this.updateHighestSortingString(insn.asConstString().getString());
                continue;
            }
            if (!insn.isConstStringJumbo()) continue;
            this.updateHighestSortingString(insn.asConstStringJumbo().getString());
        }
        if (this.debugInfo != null) {
            this.debugInfo.collectIndexedItems(indexedItems);
        }
        if (this.handlers != null) {
            for (TryHandler handler : this.handlers) {
                handler.collectIndexedItems(indexedItems);
            }
        }
    }

    private void updateHighestSortingString(DexString candidate) {
        assert (candidate != null);
        assert (!(candidate instanceof DexItemBasedString));
        if (this.highestSortingString == null || this.highestSortingString.slowCompareTo(candidate) < 0) {
            this.highestSortingString = candidate;
        }
    }

    public boolean usesExceptionHandling() {
        return this.tries.length != 0;
    }

    @Override
    void collectMixedSectionItems(MixedSectionCollection mixedItems) {
        if (mixedItems.add(this) && this.debugInfo != null) {
            this.debugInfo.collectMixedSectionItems(mixedItems);
        }
    }

    public static class TryHandler
    extends DexItem {
        public static final int NO_HANDLER = -1;
        public final TypeAddrPair[] pairs;
        public final int catchAllAddr;

        public TryHandler(TypeAddrPair[] pairs, int catchAllAddr) {
            this.pairs = pairs;
            this.catchAllAddr = catchAllAddr;
        }

        public int hashCode() {
            return this.catchAllAddr + Arrays.hashCode(this.pairs) * 7;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof TryHandler) {
                TryHandler o = (TryHandler)other;
                if (this.catchAllAddr != o.catchAllAddr) {
                    return false;
                }
                return Arrays.equals(this.pairs, o.pairs);
            }
            return false;
        }

        @Override
        public void collectIndexedItems(IndexedItemCollection indexedItems, DexMethod method, int instructionOffset) {
            TryHandler.collectAll((IndexedItemCollection)indexedItems, (DexItem[])this.pairs);
        }

        @Override
        void collectMixedSectionItems(MixedSectionCollection mixedItems) {
            assert (false);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[\n");
            for (TypeAddrPair pair : this.pairs) {
                builder.append("       ");
                builder.append(pair.type);
                builder.append(" -> ");
                builder.append(StringUtils.hexString(pair.addr, 2));
                builder.append("\n");
            }
            if (this.catchAllAddr != -1) {
                builder.append("       default -> ");
                builder.append(StringUtils.hexString(this.catchAllAddr, 2));
                builder.append("\n");
            }
            builder.append("     ]");
            return builder.toString();
        }

        public static class TypeAddrPair
        extends DexItem {
            public final DexType type;
            public final int addr;

            public TypeAddrPair(DexType type, int addr) {
                this.type = type;
                this.addr = addr;
            }

            @Override
            public void collectIndexedItems(IndexedItemCollection indexedItems, DexMethod method, int instructionOffset) {
                this.type.collectIndexedItems(indexedItems, method, instructionOffset);
            }

            @Override
            void collectMixedSectionItems(MixedSectionCollection mixedItems) {
                assert (false);
            }

            public int hashCode() {
                return this.type.hashCode() * 7 + this.addr;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other instanceof TypeAddrPair) {
                    TypeAddrPair o = (TypeAddrPair)other;
                    return this.type.equals(o.type) && this.addr == o.addr;
                }
                return false;
            }
        }
    }

    public static class Try
    extends DexItem {
        public static final int NO_INDEX = -1;
        public final int handlerOffset;
        public int startAddress;
        public int instructionCount;
        public int handlerIndex;

        public Try(int startAddress, int instructionCount, int handlerOffset) {
            this.startAddress = startAddress;
            this.instructionCount = instructionCount;
            this.handlerOffset = handlerOffset;
            this.handlerIndex = -1;
        }

        public void setHandlerIndex(Int2IntMap map2) {
            this.handlerIndex = map2.get(this.handlerOffset);
        }

        public int hashCode() {
            return this.startAddress * 2 + this.instructionCount * 3 + this.handlerIndex * 5;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof Try) {
                Try o = (Try)other;
                if (this.startAddress != o.startAddress) {
                    return false;
                }
                if (this.instructionCount != o.instructionCount) {
                    return false;
                }
                return this.handlerIndex == o.handlerIndex;
            }
            return false;
        }

        public String toString() {
            return "[" + StringUtils.hexString(this.startAddress, 2) + " .. " + StringUtils.hexString(this.startAddress + this.instructionCount - 1, 2) + "] -> " + this.handlerIndex;
        }

        @Override
        void collectIndexedItems(IndexedItemCollection indexedItems, DexMethod method, int instructionOffset) {
        }

        @Override
        void collectMixedSectionItems(MixedSectionCollection mixedItems) {
            assert (false);
        }
    }
}

