/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.classinliner;

import com.android.tools.r8.com.google.common.collect.Streams;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.InstanceGet;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import com.android.tools.r8.ir.code.NewInstance;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.optimize.Inliner;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class ClassInliner {
    private final DexItemFactory factory;
    private final int totalMethodInstructionLimit;
    private final ConcurrentHashMap<DexType, Boolean> knownClasses = new ConcurrentHashMap();

    public ClassInliner(DexItemFactory factory, int totalMethodInstructionLimit) {
        this.factory = factory;
        this.totalMethodInstructionLimit = totalMethodInstructionLimit;
    }

    public final void processMethodCode(AppInfoWithSubtyping appInfo, DexEncodedMethod method, IRCode code, Predicate<DexEncodedMethod> isProcessedConcurrently, InlinerAction inliner) {
        List newInstances = Streams.stream(code.instructionIterator()).filter(Instruction::isNewInstance).map(Instruction::asNewInstance).collect(Collectors.toList());
        for (NewInstance newInstance : newInstances) {
            Map<InvokeMethodWithReceiver, Inliner.InliningInfo> methodCalls;
            DexType eligibleClass;
            Value eligibleInstance = newInstance.outValue();
            if (eligibleInstance == null || !this.isClassEligible(appInfo, eligibleClass = newInstance.clazz) || (methodCalls = this.checkInstanceUsersEligibility(appInfo, method, isProcessedConcurrently, newInstance, eligibleInstance, eligibleClass)) == null || this.getTotalEstimatedMethodSize(methodCalls) >= this.totalMethodInstructionLimit) continue;
            this.forceInlineAllMethodInvocations(inliner, methodCalls);
            this.removeSuperClassInitializerAndFieldReads(code, newInstance, eligibleInstance);
            this.removeFieldWrites(eligibleInstance, eligibleClass);
            this.removeInstruction(newInstance);
            code.removeAllTrivialPhis();
            assert (code.isConsistentSSA());
        }
    }

    private Map<InvokeMethodWithReceiver, Inliner.InliningInfo> checkInstanceUsersEligibility(AppInfoWithSubtyping appInfo, DexEncodedMethod method, Predicate<DexEncodedMethod> isProcessedConcurrently, NewInstance newInstanceInsn, Value receiver, DexType clazz) {
        if (receiver.numberOfPhiUsers() > 0) {
            return null;
        }
        IdentityHashMap<InvokeMethodWithReceiver, Inliner.InliningInfo> methodCalls = new IdentityHashMap<InvokeMethodWithReceiver, Inliner.InliningInfo>();
        for (Instruction user : receiver.uniqueUsers()) {
            Inliner.InliningInfo inliningInfo;
            if (user.isInstanceGet() || user.isInstancePut() && user.asInstancePut().value() != receiver) {
                if (user.asFieldInstruction().getField().clazz == newInstanceInsn.clazz) continue;
                return null;
            }
            if (user.isInvokeDirect()) {
                inliningInfo = this.isEligibleConstructorCall(appInfo, method, user.asInvokeDirect(), receiver, clazz, isProcessedConcurrently);
                if (inliningInfo != null) {
                    methodCalls.put(user.asInvokeDirect(), inliningInfo);
                    continue;
                }
                return null;
            }
            if (user.isInvokeVirtual() || user.isInvokeInterface()) {
                inliningInfo = this.isEligibleMethodCall(appInfo, method, user.asInvokeMethodWithReceiver(), receiver, clazz, isProcessedConcurrently);
                if (inliningInfo != null) {
                    methodCalls.put(user.asInvokeMethodWithReceiver(), inliningInfo);
                    continue;
                }
                return null;
            }
            return null;
        }
        return methodCalls;
    }

    private void removeSuperClassInitializerAndFieldReads(IRCode code, NewInstance newInstance, Value eligibleInstance) {
        IdentityHashMap<DexField, FieldValueHelper> fieldHelpers = new IdentityHashMap<DexField, FieldValueHelper>();
        for (Instruction user : eligibleInstance.uniqueUsers()) {
            if (user.isInvokeDirect() && user.asInvokeDirect().getInvokedMethod() == this.factory.objectMethods.constructor) {
                this.removeInstruction(user);
                continue;
            }
            if (user.isInstanceGet()) {
                this.replaceFieldRead(code, newInstance, user.asInstanceGet(), fieldHelpers);
                continue;
            }
            if (user.isInstancePut()) continue;
            throw new Unreachable("Unexpected usage left after method inlining: " + user);
        }
    }

    private void removeFieldWrites(Value receiver, DexType clazz) {
        for (Instruction user : receiver.uniqueUsers()) {
            if (!user.isInstancePut()) {
                throw new Unreachable("Unexpected usage left after field reads removed: " + user);
            }
            if (user.asInstancePut().getField().clazz != clazz) {
                throw new Unreachable("Unexpected field write left after field reads removed: " + user);
            }
            this.removeInstruction(user);
        }
    }

    private int getTotalEstimatedMethodSize(Map<InvokeMethodWithReceiver, Inliner.InliningInfo> methodCalls) {
        int totalSize = 0;
        for (Inliner.InliningInfo info : methodCalls.values()) {
            totalSize += info.target.getCode().estimatedSizeForInlining();
        }
        return totalSize;
    }

    private void replaceFieldRead(IRCode code, NewInstance newInstance, InstanceGet fieldRead, Map<DexField, FieldValueHelper> fieldHelpers) {
        Value value = fieldRead.outValue();
        if (value != null) {
            FieldValueHelper helper = fieldHelpers.computeIfAbsent(fieldRead.getField(), field -> new FieldValueHelper((DexField)field, code, newInstance));
            Value newValue = helper.getValueForFieldRead(fieldRead.getBlock(), fieldRead);
            value.replaceUsers(newValue);
            for (FieldValueHelper fieldValueHelper : fieldHelpers.values()) {
                fieldValueHelper.replaceValue(value, newValue);
            }
            assert (value.numberOfAllUsers() == 0);
        }
        this.removeInstruction(fieldRead);
    }

    private void forceInlineAllMethodInvocations(InlinerAction inliner, Map<InvokeMethodWithReceiver, Inliner.InliningInfo> methodCalls) {
        if (!methodCalls.isEmpty()) {
            inliner.inline(methodCalls);
        }
    }

    private void removeInstruction(Instruction instruction) {
        instruction.inValues().forEach(v -> v.removeUser(instruction));
        instruction.getBlock().removeInstruction(instruction);
    }

    private DexEncodedMethod findSingleTarget(AppInfo appInfo, InvokeMethodWithReceiver invoke, DexType instanceType) {
        DexClass clazz = appInfo.definitionFor(instanceType);
        if (clazz != null) {
            DexMethod callee = invoke.getInvokedMethod();
            for (DexEncodedMethod candidate : clazz.virtualMethods()) {
                if (candidate.method.name != callee.name || candidate.method.proto != callee.proto) continue;
                return candidate;
            }
        }
        return null;
    }

    private Inliner.InliningInfo isEligibleConstructorCall(AppInfoWithSubtyping appInfo, DexEncodedMethod method, InvokeDirect initInvoke, Value receiver, DexType inlinedClass, Predicate<DexEncodedMethod> isProcessedConcurrently) {
        DexMethod init = initInvoke.getInvokedMethod();
        if (!this.factory.isConstructor(init)) {
            return null;
        }
        if (initInvoke.inValues().lastIndexOf(receiver) != 0) {
            return null;
        }
        assert (init.holder == inlinedClass) : "Inlined constructor? [invoke: " + initInvoke + ", expected class: " + inlinedClass + "]";
        DexEncodedMethod definition = appInfo.definitionFor(init);
        if (definition == null || isProcessedConcurrently.test(definition)) {
            return null;
        }
        if (!definition.isInliningCandidate(method, Inliner.Reason.SIMPLE, appInfo)) {
            return null;
        }
        return definition.getOptimizationInfo().getClassInlinerEligibility() != null ? new Inliner.InliningInfo(definition, inlinedClass) : null;
    }

    private Inliner.InliningInfo isEligibleMethodCall(AppInfoWithSubtyping appInfo, DexEncodedMethod method, InvokeMethodWithReceiver invoke, Value receiver, DexType inlinedClass, Predicate<DexEncodedMethod> isProcessedConcurrently) {
        if (invoke.inValues().lastIndexOf(receiver) > 0) {
            return null;
        }
        DexEncodedMethod singleTarget = this.findSingleTarget(appInfo, invoke, inlinedClass);
        if (singleTarget == null || isProcessedConcurrently.test(singleTarget)) {
            return null;
        }
        if (method == singleTarget) {
            return null;
        }
        DexEncodedMethod.ClassInlinerEligibility eligibility = singleTarget.getOptimizationInfo().getClassInlinerEligibility();
        if (eligibility == null) {
            return null;
        }
        if (eligibility.returnsReceiver && invoke.outValue() != null && invoke.outValue().numberOfAllUsers() > 0) {
            return null;
        }
        if (!singleTarget.isInliningCandidate(method, Inliner.Reason.SIMPLE, appInfo)) {
            return null;
        }
        return new Inliner.InliningInfo(singleTarget, inlinedClass);
    }

    private boolean isClassEligible(AppInfo appInfo, DexType clazz) {
        Boolean eligible = this.knownClasses.get(clazz);
        if (eligible == null) {
            Boolean computed = this.computeClassEligible(appInfo, clazz);
            Boolean existing = this.knownClasses.putIfAbsent(clazz, computed);
            assert (existing == null || existing == computed);
            eligible = existing == null ? computed : existing;
        }
        return eligible;
    }

    private boolean computeClassEligible(AppInfo appInfo, DexType clazz) {
        DexClass definition = appInfo.definitionFor(clazz);
        if (definition == null || definition.isLibraryClass() || definition.accessFlags.isAbstract() || definition.accessFlags.isInterface()) {
            return false;
        }
        if (definition.superType != this.factory.objectType) {
            return false;
        }
        for (DexEncodedMethod method : definition.virtualMethods()) {
            if (method.method.name != this.factory.finalizeMethodName || method.method.proto != this.factory.objectMethods.finalize.proto) continue;
            return false;
        }
        return !appInfo.canTriggerStaticInitializer(clazz);
    }

    private static final class FieldValueHelper {
        final DexField field;
        final IRCode code;
        final NewInstance newInstance;
        private Value defaultValue = null;
        private final Map<BasicBlock, Value> ins = new IdentityHashMap<BasicBlock, Value>();
        private final Map<BasicBlock, Value> outs = new IdentityHashMap<BasicBlock, Value>();

        private FieldValueHelper(DexField field, IRCode code, NewInstance newInstance) {
            this.field = field;
            this.code = code;
            this.newInstance = newInstance;
        }

        void replaceValue(Value oldValue, Value newValue) {
            for (Map.Entry<BasicBlock, Value> entry : this.ins.entrySet()) {
                if (entry.getValue() != oldValue) continue;
                entry.setValue(newValue);
            }
            for (Map.Entry<BasicBlock, Value> entry : this.outs.entrySet()) {
                if (entry.getValue() != oldValue) continue;
                entry.setValue(newValue);
            }
        }

        Value getValueForFieldRead(BasicBlock block, Instruction valueUser) {
            assert (valueUser != null);
            Value value = this.getValueDefinedInTheBlock(block, valueUser);
            return value != null ? value : this.getOrCreateInValue(block);
        }

        private Value getOrCreateOutValue(BasicBlock block) {
            Value value = this.outs.get(block);
            if (value != null) {
                return value;
            }
            value = this.getValueDefinedInTheBlock(block, null);
            if (value == null) {
                value = this.getOrCreateInValue(block);
            }
            assert (value != null);
            this.outs.put(block, value);
            return value;
        }

        private Value getOrCreateInValue(BasicBlock block) {
            Value value = this.ins.get(block);
            if (value != null) {
                return value;
            }
            List<BasicBlock> predecessors = block.getPredecessors();
            if (predecessors.size() == 1) {
                value = this.getOrCreateOutValue(predecessors.get(0));
                this.ins.put(block, value);
            } else {
                Phi phi = new Phi(this.code.valueNumberGenerator.next(), block, ValueType.fromDexType(this.field.type), null);
                this.ins.put(block, phi);
                ArrayList<Value> operands = new ArrayList<Value>();
                for (BasicBlock predecessor : block.getPredecessors()) {
                    operands.add(this.getOrCreateOutValue(predecessor));
                }
                phi.addOperands(operands, false);
                value = phi;
            }
            assert (value != null);
            return value;
        }

        private Value getValueDefinedInTheBlock(BasicBlock block, Instruction stopAt) {
            InstructionListIterator iterator = stopAt == null ? block.listIterator(block.getInstructions().size()) : block.listIterator(stopAt);
            Instruction valueProducingInsn = null;
            while (iterator.hasPrevious()) {
                Instruction instruction = (Instruction)iterator.previous();
                assert (instruction != null);
                if (instruction != this.newInstance && (!instruction.isInstancePut() || instruction.asInstancePut().getField() != this.field || instruction.asInstancePut().object() != this.newInstance.outValue())) continue;
                valueProducingInsn = instruction;
                break;
            }
            if (valueProducingInsn == null) {
                return null;
            }
            if (valueProducingInsn.isInstancePut()) {
                return valueProducingInsn.asInstancePut().value();
            }
            assert (this.newInstance == valueProducingInsn);
            if (this.defaultValue == null) {
                this.defaultValue = this.code.createValue(ValueType.fromDexType(this.field.type));
                ConstNumber defaultValueInsn = new ConstNumber(this.defaultValue, 0L);
                defaultValueInsn.setPosition(this.newInstance.getPosition());
                LinkedList<Instruction> instructions = block.getInstructions();
                instructions.add(instructions.indexOf(this.newInstance) + 1, defaultValueInsn);
                defaultValueInsn.setBlock(block);
            }
            return this.defaultValue;
        }
    }

    public static interface InlinerAction {
        public void inline(Map<InvokeMethodWithReceiver, Inliner.InliningInfo> var1);
    }
}

