/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexMethod;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class ParameterAnnotationsList
extends DexItem {
    private static final ParameterAnnotationsList EMPTY_PARAMETER_ANNOTATIONS_LIST = new ParameterAnnotationsList();
    private final DexAnnotationSet[] values;
    private final int missingParameterAnnotations;

    public static ParameterAnnotationsList empty() {
        return EMPTY_PARAMETER_ANNOTATIONS_LIST;
    }

    private ParameterAnnotationsList() {
        this.values = new DexAnnotationSet[0];
        this.missingParameterAnnotations = 0;
    }

    public ParameterAnnotationsList(DexAnnotationSet[] values) {
        this(values, 0);
    }

    public ParameterAnnotationsList(DexAnnotationSet[] values, int missingParameterAnnotations) {
        assert (values != null && values.length > 0);
        this.values = values;
        this.missingParameterAnnotations = missingParameterAnnotations;
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ParameterAnnotationsList) {
            return Arrays.equals(this.values, ((ParameterAnnotationsList)other).values);
        }
        return false;
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems, DexMethod method, int instructionOffset) {
        ParameterAnnotationsList.collectAll((IndexedItemCollection)indexedItems, (DexItem[])this.values);
    }

    @Override
    void collectMixedSectionItems(MixedSectionCollection mixedItems) {
        ParameterAnnotationsList.collectAll((MixedSectionCollection)mixedItems, (DexItem[])this.values);
        mixedItems.add(this);
    }

    public boolean isEmpty() {
        return this.values.length == 0;
    }

    public void forEachAnnotation(Consumer<DexAnnotation> consumer) {
        for (DexAnnotationSet parameterAnnotations : this.values) {
            for (DexAnnotation annotation : parameterAnnotations.annotations) {
                consumer.accept(annotation);
            }
        }
    }

    public int size() {
        return this.missingParameterAnnotations + this.values.length;
    }

    public int countNonMissing() {
        return this.values.length;
    }

    public boolean isMissing(int i) {
        assert (i >= 0);
        return i < this.missingParameterAnnotations;
    }

    public DexAnnotationSet get(int i) {
        assert (i >= 0);
        int adjustedIndex = i - this.missingParameterAnnotations;
        return 0 <= adjustedIndex && adjustedIndex < this.values.length ? this.values[adjustedIndex] : DexAnnotationSet.empty();
    }

    public ParameterAnnotationsList withParameterCount(int parameterCount) {
        assert (parameterCount >= this.size());
        if (this == EMPTY_PARAMETER_ANNOTATIONS_LIST || parameterCount == this.size()) {
            return this;
        }
        return new ParameterAnnotationsList(this.values, parameterCount - this.values.length);
    }

    public ParameterAnnotationsList keepIf(Predicate<DexAnnotation> filter) {
        DexAnnotationSet[] filtered = null;
        boolean allEmpty = true;
        for (int i = 0; i < this.values.length; ++i) {
            DexAnnotationSet updated = this.values[i].keepIf(filter);
            if (updated != this.values[i]) {
                if (filtered == null) {
                    filtered = (DexAnnotationSet[])this.values.clone();
                }
                filtered[i] = updated;
            }
            if (updated.isEmpty()) continue;
            allEmpty = false;
        }
        if (filtered == null) {
            return this;
        }
        if (allEmpty) {
            return ParameterAnnotationsList.empty();
        }
        return new ParameterAnnotationsList(filtered, this.missingParameterAnnotations);
    }
}

