/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.ProgramResourceProvider;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.dex.ApplicationReader;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DirectMappedDexApplication;
import com.android.tools.r8.graph.LazyLoadedDexApplication;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.utils.ProgramClassCollection;
import com.android.tools.r8.utils.Timing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class DexApplication {
    final ProgramClassCollection programClasses;
    public final ImmutableList<ProgramResourceProvider> programResourceProviders;
    public final ImmutableSet<DexType> mainDexList;
    public final String deadCode;
    private final ClassNameMapper proguardMap;
    public final Timing timing;
    public final DexItemFactory dexItemFactory;
    public final DexString highestSortingString;

    DexApplication(ClassNameMapper proguardMap, ProgramClassCollection programClasses, ImmutableList<ProgramResourceProvider> programResourceProviders, ImmutableSet<DexType> mainDexList, String deadCode, DexItemFactory dexItemFactory, DexString highestSortingString, Timing timing) {
        assert (programClasses != null);
        this.proguardMap = proguardMap;
        this.programClasses = programClasses;
        this.programResourceProviders = programResourceProviders;
        this.mainDexList = mainDexList;
        this.deadCode = deadCode;
        this.dexItemFactory = dexItemFactory;
        this.highestSortingString = highestSortingString;
        this.timing = timing;
    }

    public abstract Builder<?> builder();

    private <T> boolean reorderClasses(List<T> classes) {
        Collections.shuffle(classes);
        return true;
    }

    public List<DexProgramClass> classes() {
        this.programClasses.forceLoad(type -> true);
        List<DexProgramClass> classes = this.programClasses.getAllClasses();
        assert (this.reorderClasses(classes));
        return classes;
    }

    public Iterable<DexProgramClass> classesWithDeterministicOrder() {
        this.programClasses.forceLoad(type -> true);
        List<DexProgramClass> classes = this.programClasses.getAllClasses();
        classes.sort((a, b) -> a.type.slowCompareTo(b.type));
        return classes;
    }

    public abstract DexClass definitionFor(DexType var1);

    public DexProgramClass programDefinitionFor(DexType type) {
        Object clazz = this.programClasses.get(type);
        return clazz == null ? null : ((DexClass)clazz).asProgramClass();
    }

    public abstract String toString();

    public ClassNameMapper getProguardMap() {
        return this.proguardMap;
    }

    public static LazyLoadedDexApplication.Builder builder(DexItemFactory factory, Timing timing) {
        return DexApplication.builder(factory, timing, ProgramClassCollection::resolveClassConflictImpl);
    }

    public static LazyLoadedDexApplication.Builder builder(DexItemFactory factory, Timing timing, ApplicationReader.ProgramClassConflictResolver resolver) {
        return new LazyLoadedDexApplication.Builder(resolver, factory, timing);
    }

    public DirectMappedDexApplication asDirect() {
        throw new Unreachable("Cannot use a LazyDexApplication where a DirectDexApplication is expected.");
    }

    public abstract DirectMappedDexApplication toDirect();

    public static abstract class Builder<T extends Builder<T>> {
        final List<DexProgramClass> programClasses;
        final List<ProgramResourceProvider> programResourceProviders = new ArrayList<ProgramResourceProvider>();
        public final DexItemFactory dexItemFactory;
        ClassNameMapper proguardMap;
        final Timing timing;
        DexString highestSortingString;
        String deadCode;
        final Set<DexType> mainDexList = Sets.newIdentityHashSet();
        private final Collection<DexProgramClass> synthesizedClasses;

        public Builder(DexItemFactory dexItemFactory, Timing timing) {
            this.programClasses = new ArrayList<DexProgramClass>();
            this.dexItemFactory = dexItemFactory;
            this.timing = timing;
            this.deadCode = null;
            this.synthesizedClasses = new ArrayList<DexProgramClass>();
        }

        abstract T self();

        public Builder(DexApplication application) {
            this.programClasses = application.programClasses.getAllClasses();
            this.addProgramResourceProviders(application.programResourceProviders);
            this.proguardMap = application.getProguardMap();
            this.timing = application.timing;
            this.highestSortingString = application.highestSortingString;
            this.dexItemFactory = application.dexItemFactory;
            this.mainDexList.addAll(application.mainDexList);
            this.deadCode = application.deadCode;
            this.synthesizedClasses = new ArrayList<DexProgramClass>();
        }

        public synchronized T setProguardMap(ClassNameMapper proguardMap) {
            assert (this.proguardMap == null);
            this.proguardMap = proguardMap;
            return this.self();
        }

        public synchronized T replaceProgramClasses(List<DexProgramClass> newProgramClasses) {
            assert (newProgramClasses != null);
            this.programClasses.clear();
            this.programClasses.addAll(newProgramClasses);
            return this.self();
        }

        public synchronized T addProgramResourceProviders(List<ProgramResourceProvider> programResourceProviders) {
            if (programResourceProviders != null) {
                this.programResourceProviders.addAll(programResourceProviders);
            }
            return this.self();
        }

        public T appendDeadCode(String deadCodeAtAnotherRound) {
            if (deadCodeAtAnotherRound == null) {
                return this.self();
            }
            if (this.deadCode == null) {
                this.deadCode = deadCodeAtAnotherRound;
                return this.self();
            }
            this.deadCode = this.deadCode + deadCodeAtAnotherRound;
            return this.self();
        }

        public synchronized T setHighestSortingString(DexString value) {
            this.highestSortingString = value;
            return this.self();
        }

        public synchronized T addProgramClass(DexProgramClass clazz) {
            this.programClasses.add(clazz);
            return this.self();
        }

        public synchronized T addSynthesizedClass(DexProgramClass synthesizedClass, boolean addToMainDexList) {
            assert (synthesizedClass.isProgramClass()) : "All synthesized classes must be program classes";
            this.addProgramClass(synthesizedClass);
            this.synthesizedClasses.add(synthesizedClass);
            if (addToMainDexList && !this.mainDexList.isEmpty()) {
                this.mainDexList.add(synthesizedClass.type);
            }
            return this.self();
        }

        public Collection<DexProgramClass> getProgramClasses() {
            return this.programClasses;
        }

        public Collection<DexProgramClass> getSynthesizedClasses() {
            return this.synthesizedClasses;
        }

        public Set<DexType> getMainDexList() {
            return this.mainDexList;
        }

        public Builder<T> addToMainDexList(Collection<DexType> mainDexList) {
            this.mainDexList.addAll(mainDexList);
            return this;
        }

        public abstract DexApplication build();
    }
}

