/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging;

import com.android.apkzlib.zfile.ApkCreator;
import com.android.apkzlib.zfile.ApkCreatorFactory;
import com.android.builder.files.NativeLibraryAbiPredicate;
import com.android.builder.files.RelativeFile;
import com.android.builder.internal.packaging.DexIncrementalRenameManager;
import com.android.builder.internal.packaging.PackagedFileUpdate;
import com.android.builder.internal.packaging.PackagedFileUpdates;
import com.android.builder.packaging.PackagerException;
import com.android.ide.common.res2.FileStatus;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class IncrementalPackager
implements Closeable {
    private ApkCreator mApkCreator;
    private final DexIncrementalRenameManager mDexRenamer;
    private final NativeLibraryAbiPredicate mAbiPredicate;

    public IncrementalPackager(ApkCreatorFactory.CreationData creationData, File intermediateDir, ApkCreatorFactory factory, Set<String> acceptedAbis, boolean jniDebugMode) throws PackagerException, IOException {
        if (!intermediateDir.isDirectory()) {
            throw new IllegalArgumentException("!intermediateDir.isDirectory(): " + intermediateDir);
        }
        IncrementalPackager.checkOutputFile(creationData.getApkPath());
        this.mApkCreator = factory.make(creationData);
        this.mDexRenamer = new DexIncrementalRenameManager(intermediateDir);
        this.mAbiPredicate = new NativeLibraryAbiPredicate(acceptedAbis, jniDebugMode);
    }

    public void updateDex(ImmutableMap<RelativeFile, FileStatus> files) throws IOException {
        this.updateFiles(this.mDexRenamer.update(files));
    }

    private void updateFiles(Set<PackagedFileUpdate> updates) throws IOException {
        Preconditions.checkNotNull((Object)this.mApkCreator, (Object)"mApkCreator == null");
        Iterable deletedPaths = updates.stream().filter(p -> p.getStatus() == FileStatus.REMOVED).map(PackagedFileUpdate::getName).collect(Collectors.toList());
        for (String deletedPath : deletedPaths) {
            this.mApkCreator.deleteFile(deletedPath);
        }
        Predicate<PackagedFileUpdate> isNewOrChanged = pfu -> pfu.getStatus() == FileStatus.NEW || pfu.getStatus() == FileStatus.CHANGED;
        Iterable newOrChangedNonArchiveFiles = updates.stream().filter(pfu -> pfu.getSource().getType() == RelativeFile.Type.DIRECTORY && isNewOrChanged.test((PackagedFileUpdate)pfu)).collect(Collectors.toList());
        for (PackagedFileUpdate rf : newOrChangedNonArchiveFiles) {
            File out = new File(rf.getSource().getBase(), rf.getSource().getRelativePath());
            this.mApkCreator.writeFile(out, rf.getName());
        }
        Iterable newOrChangedArchiveFiles = updates.stream().filter(pfu -> pfu.getSource().getType() == RelativeFile.Type.JAR && isNewOrChanged.test((PackagedFileUpdate)pfu)).collect(Collectors.toList());
        Set archives = StreamSupport.stream(newOrChangedArchiveFiles.spliterator(), false).map(pfu -> pfu.getSource().getBase()).collect(Collectors.toSet());
        HashSet names = Sets.newHashSet((Iterable)Iterables.transform((Iterable)newOrChangedArchiveFiles, PackagedFileUpdate::getName));
        HashMap pathNameMap = Maps.newHashMap();
        for (PackagedFileUpdate archiveUpdate : newOrChangedArchiveFiles) {
            pathNameMap.put(archiveUpdate.getSource().getRelativePath(), archiveUpdate.getName());
        }
        for (File arch : archives) {
            this.mApkCreator.writeZip(arch, pathNameMap::get, name -> !names.contains(name));
        }
    }

    public void updateJavaResources(ImmutableMap<RelativeFile, FileStatus> files) throws IOException {
        this.updateFiles(PackagedFileUpdates.fromIncrementalRelativeFileSet(Maps.filterKeys(files, rf -> !rf.getRelativePath().endsWith(".class"))));
    }

    public void updateAssets(ImmutableMap<RelativeFile, FileStatus> files) throws IOException {
        this.updateFiles(PackagedFileUpdates.fromIncrementalRelativeFileSet(files).stream().map(pfu -> new PackagedFileUpdate(pfu.getSource(), "assets/" + pfu.getName(), pfu.getStatus())).collect(Collectors.toSet()));
    }

    public void updateAndroidResources(ImmutableMap<RelativeFile, FileStatus> files) throws IOException {
        this.updateFiles(PackagedFileUpdates.fromIncrementalRelativeFileSet(files));
    }

    public void updateNativeLibraries(ImmutableMap<RelativeFile, FileStatus> files) throws IOException {
        this.updateFiles(PackagedFileUpdates.fromIncrementalRelativeFileSet(Maps.filterKeys(files, rf -> this.mAbiPredicate.test(rf.getRelativePath()))));
    }

    private static void checkOutputFile(File file) throws IOException {
        if (file.isDirectory()) {
            throw new IOException(String.format("'%s' is a directory", file.getAbsolutePath()));
        }
        if (file.exists()) {
            if (!file.canWrite()) {
                throw new IOException(String.format("'%s' is not writeable", file.getAbsolutePath()));
            }
        } else {
            try {
                if (!file.createNewFile()) {
                    throw new IOException(String.format("Failed to create '%s'", file.getAbsolutePath()));
                }
                if (!file.delete()) {
                    throw new IOException(String.format("Failed to delete newly created '%s'", file.getAbsolutePath()));
                }
            }
            catch (IOException e) {
                throw new IOException(String.format("Failed to create '%s'", file.getAbsolutePath()), e);
            }
        }
    }

    public boolean hasPendingChangesWithWait() throws IOException {
        return this.mApkCreator != null && this.mApkCreator.hasPendingChangesWithWait();
    }

    @Override
    public void close() throws IOException {
        if (this.mApkCreator == null) {
            return;
        }
        try (Closer closer = Closer.create();){
            closer.register((Closeable)this.mApkCreator);
            closer.register((Closeable)this.mDexRenamer);
            this.mApkCreator = null;
        }
    }
}

