/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.compiler;

import com.android.SdkConstants;
import com.android.builder.internal.compiler.SourceSearcher;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.process.ProcessResult;
import com.android.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class ShaderProcessor
implements SourceSearcher.SourceFileProcessor {
    public static final String EXT_VERT = "vert";
    public static final String EXT_TESC = "tesc";
    public static final String EXT_TESE = "tese";
    public static final String EXT_GEOM = "geom";
    public static final String EXT_FRAG = "frag";
    public static final String EXT_COMP = "comp";
    private File mNdkLocation;
    private File mSourceFolder;
    private final File mOutputDir;
    private List<String> mDefaultArgs;
    private Map<String, List<String>> mScopedArgs;
    private final ProcessExecutor mProcessExecutor;
    private final ProcessOutputHandler mProcessOutputHandler;
    private File mGlslcLocation;

    public ShaderProcessor(File ndkLocation, File sourceFolder, File outputDir, List<String> defaultArgs, Map<String, List<String>> scopedArgs, ProcessExecutor processExecutor, ProcessOutputHandler processOutputHandler) {
        this.mNdkLocation = ndkLocation;
        this.mSourceFolder = sourceFolder;
        this.mOutputDir = new File(outputDir, "shaders");
        this.mDefaultArgs = defaultArgs;
        this.mScopedArgs = scopedArgs;
        this.mProcessExecutor = processExecutor;
        this.mProcessOutputHandler = processOutputHandler;
    }

    @Override
    public void initOnFirstFile() {
        if (this.mNdkLocation == null) {
            throw new IllegalStateException("NDK location is missing. It is required to compile shaders.");
        }
        if (!this.mNdkLocation.isDirectory()) {
            throw new IllegalStateException("NDK location does not exist. It is required to compile shaders: " + this.mNdkLocation);
        }
        File glslcRootFolder = new File(this.mNdkLocation, "shader-tools");
        switch (SdkConstants.currentPlatform()) {
            case 3: {
                glslcRootFolder = new File(glslcRootFolder, "darwin-x86_64");
                break;
            }
            case 2: {
                glslcRootFolder = new File(glslcRootFolder, "windows-x86_64");
                if (glslcRootFolder.isDirectory()) break;
                glslcRootFolder = new File(glslcRootFolder, "windows");
                break;
            }
            case 1: {
                glslcRootFolder = new File(glslcRootFolder, "linux-x86_64");
            }
        }
        if (!glslcRootFolder.isDirectory()) {
            throw new IllegalStateException("Missing NDK subfolder: " + glslcRootFolder);
        }
        this.mGlslcLocation = new File(glslcRootFolder, SdkConstants.FN_GLSLC);
        if (!this.mGlslcLocation.isFile()) {
            throw new IllegalStateException("glslc is missing: " + this.mGlslcLocation);
        }
    }

    @Override
    public void processFile(File sourceFolder, File sourceFile) throws ProcessException, IOException {
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.setExecutable(this.mGlslcLocation);
        builder.addArgs("-I", this.mSourceFolder.getPath());
        String relativePath = FileUtils.relativePath((File)sourceFile, (File)sourceFolder);
        File destFile = new File(this.mOutputDir, relativePath + ".spv");
        builder.addArgs(this.getArgs(relativePath));
        builder.addArgs(sourceFile.getPath());
        builder.addArgs("-o", destFile.getPath());
        FileUtils.mkdirs((File)destFile.getParentFile());
        ProcessResult result = this.mProcessExecutor.execute(builder.createProcess(), this.mProcessOutputHandler);
        result.rethrowFailure().assertNormalExitValue();
    }

    private List<String> getArgs(String relativePath) {
        int pos = relativePath.indexOf(File.separatorChar);
        if (pos == -1) {
            return this.mDefaultArgs;
        }
        String key = relativePath.substring(0, pos);
        List<String> args = this.mScopedArgs.get(key);
        if (args != null) {
            return args;
        }
        return this.mDefaultArgs;
    }
}

