/*
 * Decompiled with CFR 0.152.
 */
package com.android.apkzlib.sign;

import com.android.apkzlib.sign.DigestAlgorithm;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Nonnull;

public enum SignatureAlgorithm {
    RSA("RSA", 0, "withRSA"),
    ECDSA("EC", 18, "withECDSA"),
    DSA("DSA", 0, "withDSA");

    @Nonnull
    public final String keyAlgorithm;
    public final int minSdkVersion;
    @Nonnull
    public final String signatureAlgorithmSuffix;

    private SignatureAlgorithm(@Nonnull String keyAlgorithm, int minSdkVersion, String signatureAlgorithmSuffix) {
        this.keyAlgorithm = keyAlgorithm;
        this.minSdkVersion = minSdkVersion;
        this.signatureAlgorithmSuffix = signatureAlgorithmSuffix;
    }

    @Nonnull
    public static SignatureAlgorithm fromKeyAlgorithm(@Nonnull String keyAlgorithm, int minSdkVersion) throws NoSuchAlgorithmException {
        for (SignatureAlgorithm alg : SignatureAlgorithm.values()) {
            if (!alg.keyAlgorithm.equalsIgnoreCase(keyAlgorithm)) continue;
            if (alg.minSdkVersion > minSdkVersion) {
                throw new NoSuchAlgorithmException("Signatures with " + keyAlgorithm + " keys are not supported on minSdkVersion " + minSdkVersion + ". They are supported only for minSdkVersion >= " + alg.minSdkVersion);
            }
            return alg;
        }
        throw new NoSuchAlgorithmException("Signing with " + keyAlgorithm + " keys is not supported");
    }

    @Nonnull
    public String signatureAlgorithmName(@Nonnull DigestAlgorithm digestAlgorithm) {
        return digestAlgorithm.messageDigestName.replace("-", "") + this.signatureAlgorithmSuffix;
    }
}

