/*
 * Decompiled with CFR 0.152.
 */
package com.android.apkzlib.sign;

import com.android.apkzlib.utils.CachedSupplier;
import com.android.apkzlib.utils.IOExceptionRunnable;
import com.android.apkzlib.zip.StoredEntry;
import com.android.apkzlib.zip.ZFile;
import com.android.apkzlib.zip.ZFileExtension;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ManifestGenerationExtension {
    public static final String META_INF_DIR = "META-INF";
    public static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    @Nonnull
    private final String mBuiltBy;
    @Nonnull
    private final String mCreatedBy;
    @Nullable
    private ZFile mZFile;
    @Nonnull
    private final Manifest mManifest;
    @Nonnull
    private CachedSupplier<byte[]> mManifestBytes;
    private boolean mDirty;
    @Nullable
    private ZFileExtension mExtension;

    public ManifestGenerationExtension(@Nonnull String builtBy, @Nonnull String createdBy) {
        this.mBuiltBy = builtBy;
        this.mCreatedBy = createdBy;
        this.mManifest = new Manifest();
        this.mDirty = false;
        this.mManifestBytes = new CachedSupplier<byte[]>(() -> {
            ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
            try {
                this.mManifest.write(outBytes);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return outBytes.toByteArray();
        });
    }

    private void markDirty() {
        this.mDirty = true;
        this.mManifestBytes.reset();
    }

    public void register(@Nonnull ZFile zFile) throws IOException {
        Preconditions.checkState((this.mExtension == null ? 1 : 0) != 0, (Object)"register() has already been invoked.");
        this.mZFile = zFile;
        this.rebuildManifest();
        this.mExtension = new ZFileExtension(){

            @Override
            @Nullable
            public IOExceptionRunnable beforeUpdate() {
                return () -> ManifestGenerationExtension.this.updateManifest();
            }
        };
        this.mZFile.addZFileExtension(this.mExtension);
    }

    private void rebuildManifest() throws IOException {
        Attributes mainAttributes;
        String currentVersion;
        Verify.verifyNotNull((Object)this.mZFile, (String)"mZFile == null", (Object[])new Object[0]);
        StoredEntry manifestEntry = this.mZFile.get(MANIFEST_NAME);
        if (manifestEntry != null) {
            this.mManifest.clear();
            byte[] manifestBytes = manifestEntry.read();
            this.mManifest.read(new ByteArrayInputStream(manifestBytes));
            this.mManifestBytes.precomputed(manifestBytes);
        }
        if ((currentVersion = (mainAttributes = this.mManifest.getMainAttributes()).getValue("Manifest-Version")) == null) {
            this.setMainAttribute("Manifest-Version", "1.0");
        } else if (!currentVersion.equals("1.0")) {
            throw new IOException("Unsupported manifest version: " + currentVersion + ".");
        }
        this.setMainAttribute("Built-By", this.mBuiltBy);
        this.setMainAttribute("Created-By", this.mCreatedBy);
    }

    private void setMainAttribute(@Nonnull String attribute, @Nonnull String value) {
        Attributes mainAttributes = this.mManifest.getMainAttributes();
        String current = mainAttributes.getValue(attribute);
        if (!value.equals(current)) {
            mainAttributes.putValue(attribute, value);
            this.markDirty();
        }
    }

    private void updateManifest() throws IOException {
        Verify.verifyNotNull((Object)this.mZFile, (String)"mZFile == null", (Object[])new Object[0]);
        if (!this.mDirty) {
            return;
        }
        this.mZFile.add(MANIFEST_NAME, new ByteArrayInputStream(this.mManifestBytes.get()));
        this.mDirty = false;
    }

    @Nonnull
    public ZFile zFile() {
        Preconditions.checkNotNull((Object)this.mZFile, (Object)"mZFile == null");
        return this.mZFile;
    }

    @Nullable
    public StoredEntry manifestEntry() {
        Preconditions.checkNotNull((Object)this.mZFile, (Object)"mZFile == null");
        return this.mZFile.get(MANIFEST_NAME);
    }

    @Nullable
    public String getAttribute(@Nonnull String entryName, @Nonnull String attr) {
        Attributes attrs = this.mManifest.getAttributes(entryName);
        if (attrs == null) {
            return null;
        }
        return attrs.getValue(attr);
    }

    public void setAttribute(@Nonnull String entryName, @Nonnull String attr, @Nonnull String value) {
        String current;
        Attributes attrs = this.mManifest.getAttributes(entryName);
        if (attrs == null) {
            attrs = new Attributes();
            this.markDirty();
            this.mManifest.getEntries().put(entryName, attrs);
        }
        if (!value.equals(current = attrs.getValue(attr))) {
            attrs.putValue(attr, value);
            this.markDirty();
        }
    }

    @Nonnull
    public byte[] getManifestBytes() throws IOException {
        return this.mManifestBytes.get();
    }

    @Nonnull
    public Map<String, Attributes> allEntries() {
        return Maps.newHashMap(this.mManifest.getEntries());
    }

    public void removeEntry(@Nonnull String name) {
        if (this.mManifest.getEntries().remove(name) != null) {
            this.markDirty();
        }
    }
}

