/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dependency;

import com.android.builder.dependency.HashCodeUtils;
import com.android.builder.model.MavenCoordinates;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;

public class MavenCoordinatesImpl
implements MavenCoordinates,
Serializable {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String packaging;
    private final String classifier;
    private final int hashCode;
    private final String toString;
    private final String versionLessId;

    public MavenCoordinatesImpl(String groupId, String artifactId, String version) {
        this(groupId, artifactId, version, null, null);
    }

    public MavenCoordinatesImpl(String groupId, String artifactId, String version, String packaging, String classifier) {
        this.groupId = groupId.intern();
        this.artifactId = artifactId.intern();
        this.version = version.intern();
        this.packaging = packaging != null ? packaging.intern() : "jar";
        this.classifier = classifier != null ? classifier.intern() : null;
        this.toString = this.computeToString();
        this.hashCode = this.computeHashCode();
        this.versionLessId = this.computeVersionLessId();
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public boolean compareWithoutVersion(MavenCoordinates coordinates) {
        return this == coordinates || Objects.equal((Object)this.groupId, (Object)coordinates.getGroupId()) && Objects.equal((Object)this.artifactId, (Object)coordinates.getArtifactId()) && Objects.equal((Object)this.packaging, (Object)coordinates.getPackaging()) && Objects.equal((Object)this.classifier, (Object)coordinates.getClassifier());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenCoordinatesImpl that = (MavenCoordinatesImpl)o;
        return Objects.equal((Object)this.groupId, (Object)that.groupId) && Objects.equal((Object)this.artifactId, (Object)that.artifactId) && Objects.equal((Object)this.version, (Object)that.version) && Objects.equal((Object)this.packaging, (Object)that.packaging) && Objects.equal((Object)this.classifier, (Object)that.classifier);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.toString;
    }

    public String getVersionLessId() {
        return this.versionLessId;
    }

    private int computeHashCode() {
        return HashCodeUtils.hashCode(this.groupId, this.artifactId, this.version, this.packaging, this.classifier);
    }

    private String computeToString() {
        ArrayList segments = Lists.newArrayList((Object[])new String[]{this.groupId, this.artifactId, this.packaging});
        if (!Strings.isNullOrEmpty((String)this.classifier)) {
            segments.add(this.classifier);
        }
        segments.add(this.version);
        return Joiner.on((char)':').join((Iterable)segments);
    }

    private String computeVersionLessId() {
        StringBuilder sb = new StringBuilder(this.groupId);
        sb.append(':').append(this.artifactId);
        if (this.classifier != null) {
            sb.append(':').append(this.classifier);
        }
        return sb.toString();
    }
}

