/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.profile;

import com.android.builder.profile.ProcessRecorder;
import com.android.builder.profile.ProcessRecorderFactory;
import com.android.builder.profile.Recorder;
import com.google.wireless.android.sdk.stats.AndroidStudioStats;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ThreadRecorder
implements Recorder {
    private static final Logger logger = Logger.getLogger(ThreadRecorder.class.getName());
    protected static final Recorder dummyRecorder = new Recorder(){

        @Override
        public <T> T record(AndroidStudioStats.GradleBuildProfileSpan.ExecutionType executionType, String project, String variant, Recorder.Block<T> block) {
            try {
                return (T)block.call();
            }
            catch (Exception e) {
                block.handleException(e);
                return null;
            }
        }

        @Override
        public <T> T record(AndroidStudioStats.GradleBuildProfileSpan.ExecutionType executionType, AndroidStudioStats.GradleTransformExecution transform, String project, String variant, Recorder.Block<T> block) {
            return this.record(executionType, project, variant, block);
        }

        @Override
        public long allocationRecordId() {
            return 0L;
        }

        @Override
        public void closeRecord(String project, String variant, AndroidStudioStats.GradleBuildProfileSpan.Builder executionRecord) {
        }
    };
    private static final Recorder recorder = new ThreadRecorder();
    protected final ThreadLocal<Deque<Long>> recordStacks = new ThreadLocal<Deque<Long>>(){

        @Override
        protected Deque<Long> initialValue() {
            return new ArrayDeque<Long>();
        }
    };

    public static Recorder get() {
        return ProcessRecorderFactory.getFactory().isInitialized() ? recorder : dummyRecorder;
    }

    @Override
    public long allocationRecordId() {
        long recordId = ProcessRecorder.allocateRecordId();
        this.recordStacks.get().push(recordId);
        return recordId;
    }

    @Override
    public void closeRecord(String project, String variant, AndroidStudioStats.GradleBuildProfileSpan.Builder executionRecord) {
        if (this.recordStacks.get().pop().longValue() != executionRecord.getId()) {
            logger.severe("Internal Error : mixed records in profiling stack");
        }
        ProcessRecorder.get().writeRecord(project, variant, executionRecord);
    }

    @Override
    public <T> T record(AndroidStudioStats.GradleBuildProfileSpan.ExecutionType executionType, String project, String variant, Recorder.Block<T> block) {
        return this.record(executionType, null, project, variant, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T record(AndroidStudioStats.GradleBuildProfileSpan.ExecutionType executionType, AndroidStudioStats.GradleTransformExecution transform, String project, String variant, Recorder.Block<T> block) {
        long thisRecordId = ProcessRecorder.allocateRecordId();
        Long parentId = this.recordStacks.get().peek();
        long startTimeInMs = System.currentTimeMillis();
        AndroidStudioStats.GradleBuildProfileSpan.Builder currentRecord = AndroidStudioStats.GradleBuildProfileSpan.newBuilder().setId(thisRecordId).setType(executionType).setStartTimeInMs(startTimeInMs);
        if (transform != null) {
            currentRecord.setTransform(transform);
        }
        if (parentId != null) {
            currentRecord.setParentId(parentId.longValue());
        }
        this.recordStacks.get().push(thisRecordId);
        try {
            Object v = block.call();
            return (T)v;
        }
        catch (Exception e) {
            block.handleException(e);
        }
        finally {
            if (this.recordStacks.get().pop().longValue() != currentRecord.getId()) {
                logger.log(Level.SEVERE, "Profiler stack corrupted");
            }
            currentRecord.setDurationInMs(System.currentTimeMillis() - currentRecord.getStartTimeInMs());
            ProcessRecorder.get().writeRecord(project, variant, currentRecord);
        }
        return null;
    }
}

