/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.profile;

import com.android.builder.profile.ProcessRecorder;
import com.android.builder.profile.ProcessRecorderFactory;
import com.android.builder.profile.Recorder;
import com.android.builder.profile.ThreadRecorder;
import com.google.wireless.android.sdk.stats.AndroidStudioStats;
import java.util.Deque;
import java.util.logging.Logger;

public class AsyncRecorder
extends ThreadRecorder {
    private static final Logger logger = Logger.getLogger(AsyncRecorder.class.getName());
    private static final Recorder recorder = new AsyncRecorder();

    public static Recorder get() {
        return ProcessRecorderFactory.getFactory().isInitialized() ? recorder : dummyRecorder;
    }

    @Override
    public void closeRecord(String project, String variant, AndroidStudioStats.GradleBuildProfileSpan.Builder executionRecord) {
        if (!((Deque)this.recordStacks.get()).removeFirstOccurrence(executionRecord.getId())) {
            logger.severe("Internal Error : missing async record in profiling stack");
        }
        ProcessRecorder.get().writeRecord(project, variant, executionRecord);
    }
}

