/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.utils;

import com.android.builder.internal.utils.IOExceptionRunnable;
import com.android.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

public class ProcessLock {
    private static final File LOCK_FOLDER = FileUtils.join((File)new File(System.getProperty("user.home")), (String[])new String[]{".android-studio", "process-lock"});

    public static void doLocked(String key, IOExceptionRunnable runnable, boolean interProcessLocking) throws IOException {
        if (interProcessLocking) {
            ProcessLock.doProcessLocked(key, runnable);
        } else {
            ProcessLock.doThreadLocked(key, runnable);
        }
    }

    private static void doProcessLocked(String key, IOExceptionRunnable runnable) throws IOException {
        ProcessLock.doThreadLocked(key, () -> {
            String lockFileName = FileUtils.getValidFileName((String)key, (String)"", (File)LOCK_FOLDER);
            FileUtils.mkdirs((File)LOCK_FOLDER);
            File lockFile = new File(LOCK_FOLDER, lockFileName);
            FileChannel fileChannel = new RandomAccessFile(lockFile, "rw").getChannel();
            FileLock fileLock = fileChannel.lock();
            try {
                runnable.run();
            }
            finally {
                lockFile.delete();
                fileLock.release();
                fileChannel.close();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doThreadLocked(String key, IOExceptionRunnable runnable) throws IOException {
        String string = key.intern();
        synchronized (string) {
            runnable.run();
        }
    }
}

