/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging.zip.compress;

import com.android.builder.internal.packaging.zip.CompressionResult;
import com.android.builder.internal.packaging.zip.Compressor;
import com.android.builder.internal.packaging.zip.utils.CloseableByteSource;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.Executor;

public abstract class ExecutorCompressor
implements Compressor {
    private final Executor mExecutor;

    public ExecutorCompressor(Executor executor) {
        this.mExecutor = executor;
    }

    @Override
    public ListenableFuture<CompressionResult> compress(CloseableByteSource source) {
        SettableFuture future = SettableFuture.create();
        this.mExecutor.execute(() -> {
            try {
                future.set((Object)this.immediateCompress(source));
            }
            catch (Exception e) {
                future.setException((Throwable)e);
            }
        });
        return future;
    }

    protected abstract CompressionResult immediateCompress(CloseableByteSource var1) throws Exception;
}

