/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.compiler;

import com.android.builder.internal.compiler.DexKey;
import com.android.builder.internal.compiler.PreProcessCache;
import com.android.repository.Revision;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import java.io.File;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

final class DxDexKey
extends DexKey {
    private static final char ADDITIONAL_PARAMETERS_SEPARATOR = ',';
    private static final String ATTR_ADDITIONAL_PARAMETERS = "custom-flags";
    private static final String ATTR_IS_MULTIDEX = "is-multidex";
    private final ImmutableSortedSet<String> mAdditionalParameters;
    private Boolean mIsMultiDex;
    static final PreProcessCache.KeyFactory<DxDexKey> FACTORY = (sourceFile, revision, attrMap) -> {
        boolean jumboMode = Boolean.parseBoolean(attrMap.getNamedItem("jumboMode").getNodeValue());
        Node optimizeAttribute = attrMap.getNamedItem("optimize");
        boolean optimize = optimizeAttribute != null ? Boolean.parseBoolean(optimizeAttribute.getNodeValue()) : true;
        Object additionalParameters = ImmutableList.of();
        Node additionalParametersAttribute = attrMap.getNamedItem(ATTR_ADDITIONAL_PARAMETERS);
        if (additionalParametersAttribute != null) {
            additionalParameters = Splitter.on((char)',').omitEmptyStrings().splitToList((CharSequence)additionalParametersAttribute.getNodeValue());
        }
        Boolean isMultiDex = null;
        Node multiDexAttr = attrMap.getNamedItem(ATTR_IS_MULTIDEX);
        if (multiDexAttr != null) {
            isMultiDex = Boolean.parseBoolean(multiDexAttr.getNodeValue());
        }
        return DxDexKey.of(sourceFile, revision, jumboMode, optimize, (Iterable<String>)additionalParameters, isMultiDex);
    };

    private DxDexKey(File sourceFile, Revision buildToolsRevision, boolean jumboMode, boolean optimize, Iterable<String> additionalParameters, Boolean isMultiDex) {
        super(sourceFile, buildToolsRevision, jumboMode, optimize);
        this.mAdditionalParameters = ImmutableSortedSet.copyOf(additionalParameters);
        this.mIsMultiDex = isMultiDex;
    }

    static DxDexKey of(File sourceFile, Revision buildToolsRevision, boolean jumboMode, boolean optimize, Iterable<String> additionalParameters, Boolean isMultiDex) {
        return new DxDexKey(sourceFile, buildToolsRevision, jumboMode, optimize, additionalParameters, isMultiDex);
    }

    @Override
    protected void writeFieldsToXml(Node itemNode) {
        super.writeFieldsToXml(itemNode);
        Document document = itemNode.getOwnerDocument();
        if (!this.mAdditionalParameters.isEmpty()) {
            Attr additionalParameters = document.createAttribute(ATTR_ADDITIONAL_PARAMETERS);
            additionalParameters.setValue(Joiner.on((char)',').join(this.mAdditionalParameters));
            itemNode.getAttributes().setNamedItem(additionalParameters);
        }
        if (this.mIsMultiDex != null) {
            Attr multiDexAttr = document.createAttribute(ATTR_IS_MULTIDEX);
            multiDexAttr.setValue(Boolean.toString(this.mIsMultiDex));
            itemNode.getAttributes().setNamedItem(multiDexAttr);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DxDexKey dxDexKey = (DxDexKey)o;
        return this.mAdditionalParameters.equals(dxDexKey.mAdditionalParameters) && Objects.equal((Object)this.mIsMultiDex, (Object)dxDexKey.mIsMultiDex);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.mAdditionalParameters, this.mIsMultiDex});
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("dexKey", (Object)super.toString()).add("mAdditionalParameters", this.mAdditionalParameters).add("mIsMultiDex", (Object)this.mIsMultiDex).toString();
    }
}

