/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.files;

import com.android.utils.FileUtils;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.File;

public class RelativeFile {
    public static Function<RelativeFile, File> EXTRACT_BASE = new Function<RelativeFile, File>(){

        public File apply(RelativeFile input) {
            return input.getBase();
        }
    };
    public static Function<RelativeFile, File> EXTRACT_FILE = new Function<RelativeFile, File>(){

        public File apply(RelativeFile input) {
            return input.getFile();
        }
    };
    public static Function<RelativeFile, String> EXTRACT_PATH = new Function<RelativeFile, String>(){

        public String apply(RelativeFile input) {
            return input.getOsIndependentRelativePath();
        }
    };
    private final File mBase;
    private final File mFile;
    private final String mOsIndependentRelativePath;

    public RelativeFile(File base, File file) {
        Preconditions.checkArgument((!base.equals(file) ? 1 : 0) != 0, (Object)"base.equals(file)");
        this.mBase = base;
        this.mFile = file;
        String relativePath = FileUtils.relativePossiblyNonExistingPath((File)file, (File)base);
        this.mOsIndependentRelativePath = FileUtils.toSystemIndependentPath((String)relativePath);
    }

    public File getBase() {
        return this.mBase;
    }

    public File getFile() {
        return this.mFile;
    }

    public String getOsIndependentRelativePath() {
        return this.mOsIndependentRelativePath;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mBase, this.mFile});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RelativeFile)) {
            return false;
        }
        RelativeFile rf = (RelativeFile)obj;
        return Objects.equal((Object)this.mBase, (Object)rf.mBase) && Objects.equal((Object)this.mFile, (Object)rf.mFile);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("base", (Object)this.mBase).add("file", (Object)this.mFile).add("path", (Object)this.mOsIndependentRelativePath).toString();
    }
}

