/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dependency;

import com.android.builder.model.MavenCoordinates;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;

public class MavenCoordinatesImpl
implements MavenCoordinates,
Serializable {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String packaging;
    private final String classifier;

    public MavenCoordinatesImpl(String groupId, String artifactId, String version) {
        this(groupId, artifactId, version, null, null);
    }

    public MavenCoordinatesImpl(String groupId, String artifactId, String version, String packaging, String classifier) {
        this.groupId = groupId.intern();
        this.artifactId = artifactId.intern();
        this.version = version.intern();
        this.packaging = packaging != null ? packaging.intern() : "jar";
        this.classifier = classifier != null ? classifier.intern() : null;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public boolean compareWithoutVersion(MavenCoordinates coordinates) {
        return this == coordinates || Objects.equal((Object)this.groupId, (Object)coordinates.getGroupId()) && Objects.equal((Object)this.artifactId, (Object)coordinates.getArtifactId()) && Objects.equal((Object)this.packaging, (Object)coordinates.getPackaging()) && Objects.equal((Object)this.classifier, (Object)coordinates.getClassifier());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenCoordinatesImpl that = (MavenCoordinatesImpl)o;
        return Objects.equal((Object)this.groupId, (Object)that.groupId) && Objects.equal((Object)this.artifactId, (Object)that.artifactId) && Objects.equal((Object)this.version, (Object)that.version) && Objects.equal((Object)this.packaging, (Object)that.packaging) && Objects.equal((Object)this.classifier, (Object)that.classifier);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.groupId, this.artifactId, this.version, this.packaging, this.classifier});
    }

    public String toString() {
        ArrayList segments = Lists.newArrayList((Object[])new String[]{this.groupId, this.artifactId, this.packaging});
        if (!Strings.isNullOrEmpty((String)this.classifier)) {
            segments.add(this.classifier);
        }
        segments.add(this.version);
        return Joiner.on((char)':').join((Iterable)segments);
    }
}

