/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dependency;

import com.android.builder.dependency.DependencyContainer;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.JavaLibrary;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class DependencyContainerImpl
implements DependencyContainer {
    private final ImmutableList<AndroidLibrary> mLibraryDependencies;
    private final ImmutableList<JavaLibrary> mJavaDependencies;
    private final ImmutableList<JavaLibrary> mLocalJars;

    public DependencyContainerImpl(List<? extends AndroidLibrary> aars, Collection<? extends JavaLibrary> jars, Collection<? extends JavaLibrary> localJars) {
        this.mLibraryDependencies = ImmutableList.copyOf(aars);
        this.mJavaDependencies = ImmutableList.copyOf(jars);
        this.mLocalJars = ImmutableList.copyOf(localJars);
    }

    @Override
    public ImmutableList<AndroidLibrary> getAndroidDependencies() {
        return this.mLibraryDependencies;
    }

    @Override
    public ImmutableList<JavaLibrary> getJarDependencies() {
        return this.mJavaDependencies;
    }

    @Override
    public ImmutableList<JavaLibrary> getLocalDependencies() {
        return this.mLocalJars;
    }

    @Override
    public DependencyContainer flatten(AndroidLibrary testedLibrary, DependencyContainer testedDependencyContainer) {
        ArrayList flatAndroidLibs = Lists.newArrayList();
        Set flatJavaLibs = Sets.newIdentityHashSet();
        DependencyContainerImpl.computeFlatLibraryList(this.mLibraryDependencies, (List<AndroidLibrary>)flatAndroidLibs, (Set<JavaLibrary>)flatJavaLibs);
        if (testedLibrary != null) {
            DependencyContainerImpl.computeFlatLibraryList(testedLibrary, (List<AndroidLibrary>)flatAndroidLibs, (Set<JavaLibrary>)flatJavaLibs);
        }
        DependencyContainerImpl.computeFlatJarList(this.mJavaDependencies, flatJavaLibs);
        Object localJars = this.mLocalJars;
        if (testedDependencyContainer != null && testedLibrary != null) {
            ImmutableList<JavaLibrary> testedLocalJars = testedDependencyContainer.getLocalDependencies();
            localJars = Lists.newArrayListWithExpectedSize((int)this.mLocalJars.size());
            for (JavaLibrary javaLibrary : this.mLocalJars) {
                if (testedLocalJars.contains(javaLibrary)) continue;
                localJars.add((JavaLibrary)javaLibrary);
            }
        }
        return new DependencyContainerImpl(flatAndroidLibs, flatJavaLibs, (Collection<? extends JavaLibrary>)localJars);
    }

    private static void computeFlatLibraryList(List<? extends AndroidLibrary> androidLibs, List<AndroidLibrary> outFlatAndroidLibs, Set<JavaLibrary> outFlatJavaLibs) {
        for (int i = androidLibs.size() - 1; i >= 0; --i) {
            DependencyContainerImpl.computeFlatLibraryList(androidLibs.get(i), outFlatAndroidLibs, outFlatJavaLibs);
        }
    }

    private static void computeFlatLibraryList(AndroidLibrary androidLibrary, List<AndroidLibrary> outFlatAndroidLibs, Set<JavaLibrary> outFlatJavaLibs) {
        DependencyContainerImpl.computeFlatLibraryList(androidLibrary.getLibraryDependencies(), outFlatAndroidLibs, outFlatJavaLibs);
        DependencyContainerImpl.computeFlatJarList(androidLibrary.getJavaDependencies(), outFlatJavaLibs);
        if (!androidLibrary.isSkipped() && !outFlatAndroidLibs.contains(androidLibrary)) {
            outFlatAndroidLibs.add(0, androidLibrary);
        }
    }

    private static void computeFlatJarList(Collection<? extends JavaLibrary> javaLibs, Set<JavaLibrary> outFlatJavaLibs) {
        for (JavaLibrary javaLibrary : javaLibs) {
            if (!javaLibrary.isSkipped()) {
                outFlatJavaLibs.add(javaLibrary);
            }
            DependencyContainerImpl.computeFlatJarList(javaLibrary.getDependencies(), outFlatJavaLibs);
        }
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("mLibraryDependencies", this.mLibraryDependencies).add("mJavaDependencies", this.mJavaDependencies).add("mLocalJars", this.mLocalJars).toString();
    }
}

