/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.android.builder.core.VariantType;
import com.android.builder.model.AaptOptions;
import com.android.builder.model.AndroidLibrary;
import com.android.ide.common.process.ProcessEnvBuilder;
import com.android.ide.common.process.ProcessInfo;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.resources.Density;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.utils.ILogger;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AaptPackageProcessBuilder
extends ProcessEnvBuilder<AaptPackageProcessBuilder> {
    private final File mManifestFile;
    private final AaptOptions mOptions;
    private File mResFolder;
    private File mAssetsFolder;
    private boolean mVerboseExec = false;
    private String mSourceOutputDir;
    private String mSymbolOutputDir;
    private List<? extends AndroidLibrary> mLibraries;
    private String mResPackageOutput;
    private String mProguardOutput;
    private VariantType mType;
    private boolean mDebuggable = false;
    private boolean mPseudoLocalesEnabled = false;
    private Collection<String> mResourceConfigs;
    Collection<String> mSplits;
    String mPackageForR;
    String mPreferredDensity;

    public AaptPackageProcessBuilder(File manifestFile, AaptOptions options) {
        Preconditions.checkNotNull((Object)manifestFile, (Object)"manifestFile cannot be null.");
        Preconditions.checkNotNull((Object)options, (Object)"options cannot be null.");
        this.mManifestFile = manifestFile;
        this.mOptions = options;
    }

    public File getManifestFile() {
        return this.mManifestFile;
    }

    public AaptPackageProcessBuilder setResFolder(File resFolder) {
        if (!resFolder.isDirectory()) {
            throw new RuntimeException("resFolder parameter is not a directory");
        }
        this.mResFolder = resFolder;
        return this;
    }

    public AaptPackageProcessBuilder setAssetsFolder(File assetsFolder) {
        if (!assetsFolder.isDirectory()) {
            throw new RuntimeException("assetsFolder parameter is not a directory");
        }
        this.mAssetsFolder = assetsFolder;
        return this;
    }

    public AaptPackageProcessBuilder setSourceOutputDir(String sourceOutputDir) {
        this.mSourceOutputDir = sourceOutputDir;
        return this;
    }

    public String getSourceOutputDir() {
        return this.mSourceOutputDir;
    }

    public AaptPackageProcessBuilder setSymbolOutputDir(String symbolOutputDir) {
        this.mSymbolOutputDir = symbolOutputDir;
        return this;
    }

    public String getSymbolOutputDir() {
        return this.mSymbolOutputDir;
    }

    public AaptPackageProcessBuilder setLibraries(List<? extends AndroidLibrary> libraries) {
        this.mLibraries = libraries;
        return this;
    }

    public List<? extends AndroidLibrary> getLibraries() {
        return this.mLibraries == null ? ImmutableList.of() : this.mLibraries;
    }

    public AaptPackageProcessBuilder setResPackageOutput(String resPackageOutput) {
        this.mResPackageOutput = resPackageOutput;
        return this;
    }

    public AaptPackageProcessBuilder setProguardOutput(String proguardOutput) {
        this.mProguardOutput = proguardOutput;
        return this;
    }

    public AaptPackageProcessBuilder setType(VariantType type) {
        this.mType = type;
        return this;
    }

    public VariantType getType() {
        return this.mType;
    }

    public AaptPackageProcessBuilder setDebuggable(boolean debuggable) {
        this.mDebuggable = debuggable;
        return this;
    }

    public AaptPackageProcessBuilder setResourceConfigs(Collection<String> resourceConfigs) {
        this.mResourceConfigs = resourceConfigs;
        return this;
    }

    public AaptPackageProcessBuilder setSplits(Collection<String> splits) {
        this.mSplits = splits;
        return this;
    }

    public AaptPackageProcessBuilder setVerbose() {
        this.mVerboseExec = true;
        return this;
    }

    public AaptPackageProcessBuilder setPackageForR(String packageForR) {
        this.mPackageForR = packageForR;
        return this;
    }

    public AaptPackageProcessBuilder setPseudoLocalesEnabled(boolean pseudoLocalesEnabled) {
        this.mPseudoLocalesEnabled = pseudoLocalesEnabled;
        return this;
    }

    public AaptPackageProcessBuilder setPreferredDensity(String density) {
        this.mPreferredDensity = density;
        return this;
    }

    String getPackageForR() {
        return this.mPackageForR;
    }

    public ProcessInfo build(BuildToolInfo buildToolInfo, IAndroidTarget target, ILogger logger) {
        List additionalParameters;
        String ignoreAssets;
        Preconditions.checkArgument((this.mSourceOutputDir != null || this.mResPackageOutput != null ? 1 : 0) != 0, (Object)"No output provided for aapt task");
        if (this.mSymbolOutputDir != null || this.mSourceOutputDir != null) {
            Preconditions.checkNotNull(this.mLibraries, (Object)"libraries cannot be null if symbolOutputDir or sourceOutputDir is non-null");
        }
        this.checkResConfigsVersusSplitSettings(logger);
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.addEnvironments(this.mEnvironment);
        String aapt = buildToolInfo.getPath(BuildToolInfo.PathId.AAPT);
        if (aapt == null || !new File(aapt).isFile()) {
            throw new IllegalStateException("aapt is missing");
        }
        builder.setExecutable(aapt);
        builder.addArgs("package");
        if (this.mVerboseExec) {
            builder.addArgs("-v");
        }
        builder.addArgs("-f");
        builder.addArgs("--no-crunch");
        builder.addArgs("-I", target.getPath(1));
        builder.addArgs("-M", this.mManifestFile.getAbsolutePath());
        if (this.mResFolder != null) {
            builder.addArgs("-S", this.mResFolder.getAbsolutePath());
        }
        if (this.mAssetsFolder != null) {
            builder.addArgs("-A", this.mAssetsFolder.getAbsolutePath());
        }
        if (this.mSourceOutputDir != null) {
            builder.addArgs("-m");
            builder.addArgs("-J", this.mSourceOutputDir);
        }
        if (this.mResPackageOutput != null) {
            builder.addArgs("-F", this.mResPackageOutput);
        }
        if (this.mProguardOutput != null) {
            builder.addArgs("-G", this.mProguardOutput);
        }
        if (this.mSplits != null) {
            for (String split : this.mSplits) {
                builder.addArgs("--split", split);
            }
        }
        if (this.mDebuggable) {
            builder.addArgs("--debug-mode");
        }
        if (this.mType != VariantType.ANDROID_TEST && this.mPackageForR != null) {
            builder.addArgs("--custom-package", this.mPackageForR);
            logger.verbose("Custom package for R class: '%s'", new Object[]{this.mPackageForR});
        }
        if (this.mPseudoLocalesEnabled) {
            if (buildToolInfo.getRevision().getMajor() >= 21) {
                builder.addArgs("--pseudo-localize");
            } else {
                throw new RuntimeException("Pseudolocalization is only available since Build Tools version 21.0.0, please upgrade or turn it off.");
            }
        }
        if (this.mType == VariantType.LIBRARY) {
            builder.addArgs("--non-constant-id");
        }
        if ((ignoreAssets = this.mOptions.getIgnoreAssets()) != null) {
            builder.addArgs("--ignore-assets", ignoreAssets);
        }
        if (this.mOptions.getFailOnMissingConfigEntry()) {
            if (buildToolInfo.getRevision().getMajor() > 20) {
                builder.addArgs("--error-on-missing-config-entry");
            } else {
                throw new IllegalStateException("aaptOptions:failOnMissingConfigEntry cannot be used with SDK Build Tools revision earlier than 21.0.0");
            }
        }
        builder.addArgs("-0", "apk");
        Collection noCompressList = this.mOptions.getNoCompress();
        if (noCompressList != null) {
            for (String noCompress : noCompressList) {
                builder.addArgs("-0", noCompress);
            }
        }
        if (!AaptPackageProcessBuilder.isNullOrEmpty(additionalParameters = this.mOptions.getAdditionalParameters())) {
            builder.addArgs(additionalParameters);
        }
        ArrayList<String> resourceConfigs = new ArrayList<String>();
        if (!AaptPackageProcessBuilder.isNullOrEmpty(this.mResourceConfigs)) {
            resourceConfigs.addAll(this.mResourceConfigs);
        }
        if (buildToolInfo.getRevision().getMajor() < 21 && this.mPreferredDensity != null) {
            resourceConfigs.add(this.mPreferredDensity);
            resourceConfigs.add(Density.NODPI.getResourceValue());
        }
        ArrayList<String> otherResourceConfigs = new ArrayList<String>();
        ArrayList<String> densityResourceConfigs = new ArrayList<String>();
        if (!resourceConfigs.isEmpty()) {
            if (buildToolInfo.getRevision().getMajor() >= 21) {
                for (String resourceConfig : resourceConfigs) {
                    if (Density.getEnum((String)resourceConfig) != null) {
                        densityResourceConfigs.add(resourceConfig);
                        continue;
                    }
                    otherResourceConfigs.add(resourceConfig);
                }
            } else {
                otherResourceConfigs = resourceConfigs;
            }
        }
        if (!otherResourceConfigs.isEmpty()) {
            Joiner joiner = Joiner.on((char)',');
            builder.addArgs("-c", joiner.join(otherResourceConfigs));
        }
        if (!densityResourceConfigs.isEmpty()) {
            if (densityResourceConfigs.size() != 1) {
                throw new RuntimeException("Cannot filter assets for multiple densities using SDK build tools 21 or later. Consider using apk splits instead.");
            }
            builder.addArgs("--preferred-density", (String)Iterables.getOnlyElement(densityResourceConfigs));
        }
        if (buildToolInfo.getRevision().getMajor() >= 21 && this.mPreferredDensity != null) {
            Collection<String> densityResConfig;
            if (!AaptPackageProcessBuilder.isNullOrEmpty(this.mResourceConfigs) && !(densityResConfig = AaptPackageProcessBuilder.getDensityResConfigs(this.mResourceConfigs)).isEmpty()) {
                throw new RuntimeException(String.format("When using splits in tools 21 and above, resConfigs should not contain any densities. Right now, it contains \"%1$s\"\nSuggestion: remove these from resConfigs from build.gradle", Joiner.on((String)"\",\"").join(densityResConfig)));
            }
            builder.addArgs("--preferred-density", this.mPreferredDensity);
        }
        if (buildToolInfo.getRevision().getMajor() < 21 && this.mPreferredDensity != null) {
            logger.warning(String.format("Warning : Project is building density based multiple APKs but using tools version %1$s, you should upgrade to build-tools 21 or above to ensure proper packaging of resources.", buildToolInfo.getRevision().getMajor()), new Object[0]);
        }
        if (!(this.mSymbolOutputDir == null || this.mType != VariantType.LIBRARY && this.mLibraries.isEmpty())) {
            builder.addArgs("--output-text-symbols", this.mSymbolOutputDir);
        }
        if (buildToolInfo.getRevision().getMajor() >= 23) {
            builder.addArgs("--no-version-vectors");
        }
        return builder.createProcess();
    }

    private void checkResConfigsVersusSplitSettings(ILogger logger) {
        if (AaptPackageProcessBuilder.isNullOrEmpty(this.mResourceConfigs) || AaptPackageProcessBuilder.isNullOrEmpty(this.mSplits)) {
            return;
        }
        Collection<String> resConfigs = AaptPackageProcessBuilder.getDensityResConfigs(this.mResourceConfigs);
        ArrayList<String> splits = new ArrayList<String>(this.mSplits);
        splits.removeAll(resConfigs);
        if (!splits.isEmpty()) {
            throw new RuntimeException(String.format("Splits for densities \"%1$s\" were configured, yet the resConfigs settings does not include such splits. The resulting split APKs would be empty.\nSuggestion : exclude those splits in your build.gradle : \nsplits {\n     density {\n         enable true\n         exclude \"%2$s\"\n     }\n}\nOR add them to the resConfigs list.", Joiner.on((String)",").join(splits), Joiner.on((String)"\",\"").join(splits)));
        }
        resConfigs.removeAll(this.mSplits);
        if (!resConfigs.isEmpty()) {
            throw new RuntimeException(String.format("Inconsistent density configuration, with \"%1$s\" present on resConfig settings, while only \"%2$s\" densities are requested in splits APK density settings.\nSuggestion : remove extra densities from the resConfig : \ndefaultConfig {\n     resConfigs \"%2$s\"\n}\nOR remove such densities from the split's exclude list.\n", Joiner.on((String)",").join(resConfigs), Joiner.on((String)"\",\"").join(this.mSplits)));
        }
    }

    private static boolean isNullOrEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    private static Collection<String> getDensityResConfigs(Collection<String> resourceConfigs) {
        return Collections2.filter(new ArrayList<String>(resourceConfigs), (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return Density.getEnum((String)input) != null;
            }
        });
    }
}

