/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.shrinker.parser;

import com.android.builder.shrinker.parser.ClassSpecification;
import com.android.builder.shrinker.parser.FilterSpecification;
import com.android.builder.shrinker.parser.NameSpecification;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class Flags {
    private boolean shrink = true;
    private boolean optimize = true;
    private boolean preverify = true;
    private boolean obfuscate = true;
    private boolean keepParameterNames = false;
    private boolean useMixedCaseClassName = true;
    private File obfuscationMapping = null;
    private boolean printMapping = false;
    private boolean useUniqueClassMemberNames = false;
    private String packageForRenamedClasses = null;
    private String packageForFlatHierarchy = null;
    private String libraryJars = null;
    private final List<File> inJars = new ArrayList<File>(1);
    private final List<File> outJars = new ArrayList<File>(1);
    private File outputMapping;
    private File obfuscationDictionary;
    private File classObfuscationDictionary;
    private File packageObfuscationDictionary;
    private FilterSpecification keepAttributes;
    private String renameSourceFileAttribute;
    private FilterSpecification keepPackageNames;
    private FilterSpecification adaptClassStrings;
    private final List<ClassSpecification> keepClassSpecs = new ArrayList<ClassSpecification>();
    private final List<ClassSpecification> keepClassesWithMembersSpecs = new ArrayList<ClassSpecification>();
    private final List<ClassSpecification> keepClassMembersSpecs = new ArrayList<ClassSpecification>();
    private boolean printSeeds = false;
    private File seedsFile;
    private FilterSpecification adaptResourceFileNames;
    private FilterSpecification adaptResourceFileContents;

    public void setShrink(boolean shrink) {
        this.shrink = shrink;
    }

    public void setOptimize(boolean optimize) {
        this.optimize = optimize;
    }

    public void setPreverify(boolean preverify) {
        this.preverify = preverify;
    }

    public void setPrintMapping(boolean printMapping) {
        this.printMapping = printMapping;
    }

    public boolean printMapping() {
        return this.printMapping;
    }

    public void setOutputMapping(File outputMapping) {
        this.outputMapping = outputMapping;
    }

    public boolean shrink() {
        return this.shrink;
    }

    public boolean optimize() {
        return this.optimize;
    }

    public boolean preverify() {
        return this.preverify;
    }

    public void setObfuscate(boolean obfuscate) {
        this.obfuscate = obfuscate;
    }

    public boolean obfuscate() {
        return this.obfuscate;
    }

    public void setKeepParameterNames(boolean keepParameterNames) {
        this.keepParameterNames = keepParameterNames;
    }

    public boolean getKeepParameterNames() {
        assert (this.obfuscate);
        return this.keepParameterNames;
    }

    public void setObfuscationMapping(File obfuscationMapping) {
        this.obfuscationMapping = obfuscationMapping;
    }

    public void setUseMixedCaseClassName(boolean useMixedCaseClassName) {
        this.useMixedCaseClassName = useMixedCaseClassName;
    }

    public void setUseUniqueClassMemberNames(boolean useUniqueClassMemberNames) {
        this.useUniqueClassMemberNames = useUniqueClassMemberNames;
    }

    public void addInJars(List<File> inJars) {
        this.inJars.addAll(inJars);
    }

    public void addOutJars(List<File> outJars) {
        this.outJars.addAll(outJars);
    }

    public void addLibraryJars(String libraryJars) {
        this.libraryJars = this.libraryJars == null ? libraryJars : this.libraryJars + File.pathSeparatorChar + libraryJars;
    }

    public boolean getUseUniqueClassMemberNames() {
        return this.useUniqueClassMemberNames;
    }

    public boolean getUseMixedCaseClassName() {
        return this.useMixedCaseClassName;
    }

    public List<File> getInJars() {
        return this.inJars;
    }

    public List<File> getOutJars() {
        return this.outJars;
    }

    public String getLibraryJars() {
        return this.libraryJars;
    }

    public File getObfuscationMapping() {
        return this.obfuscationMapping;
    }

    public File getOutputMapping() {
        return this.outputMapping;
    }

    public File getObfuscationDictionary() {
        return this.obfuscationDictionary;
    }

    public void setObfuscationDictionary(File obfuscationDictionary) {
        this.obfuscationDictionary = obfuscationDictionary;
    }

    public File getPackageObfuscationDictionary() {
        return this.packageObfuscationDictionary;
    }

    public void setPackageObfuscationDictionary(File packageObfuscationDictionary) {
        this.packageObfuscationDictionary = packageObfuscationDictionary;
    }

    public File getClassObfuscationDictionary() {
        return this.classObfuscationDictionary;
    }

    public void setClassObfuscationDictionary(File classObfuscationDictionary) {
        this.classObfuscationDictionary = classObfuscationDictionary;
    }

    public void setPackageForRenamedClasses(String packageForRenamedClasses) {
        this.packageForRenamedClasses = packageForRenamedClasses;
        if (packageForRenamedClasses != null) {
            this.packageForFlatHierarchy = null;
        }
    }

    public String getPackageForRenamedClasses() {
        return this.packageForRenamedClasses;
    }

    public void setPackageForFlatHierarchy(String packageForFlatHierarchy) {
        if (this.packageForRenamedClasses == null) {
            this.packageForFlatHierarchy = packageForFlatHierarchy;
        } else assert (this.packageForFlatHierarchy == null);
    }

    public String getPackageForFlatHierarchy() {
        return this.packageForFlatHierarchy;
    }

    public List<ClassSpecification> getKeepClassSpecs() {
        return this.keepClassSpecs;
    }

    public List<ClassSpecification> getKeepClassesWithMembersSpecs() {
        return this.keepClassesWithMembersSpecs;
    }

    public List<ClassSpecification> getKeepClassMembersSpecs() {
        return this.keepClassMembersSpecs;
    }

    public void addKeepClassSpecification(ClassSpecification classSpecification) {
        assert (classSpecification != null);
        this.keepClassSpecs.add(classSpecification);
    }

    public void addKeepClassesWithMembers(ClassSpecification classSpecification) {
        assert (classSpecification != null);
        this.keepClassesWithMembersSpecs.add(classSpecification);
    }

    public void addKeepClassMembers(ClassSpecification classSpecification) {
        assert (classSpecification != null);
        this.keepClassMembersSpecs.add(classSpecification);
    }

    public void setKeepAttribute(FilterSpecification attribute) {
        this.keepAttributes = attribute;
    }

    public void setKeepPackageName(FilterSpecification packageSpec) {
        this.keepPackageNames = packageSpec;
    }

    public FilterSpecification getKeepPackageNames() {
        return this.keepPackageNames;
    }

    public void addKeepPackageNames(NameSpecification packageName, boolean negator) {
        if (this.keepPackageNames == null) {
            this.keepPackageNames = new FilterSpecification();
        }
        this.keepPackageNames.addElement(packageName, negator);
    }

    public boolean keepAttribute(String attributeName) {
        assert (this.obfuscate);
        return this.keepAttributes != null && this.keepAttributes.matches(attributeName);
    }

    public void setRenameSourceFileAttribute(String renameSourceFileAttribute) {
        this.renameSourceFileAttribute = renameSourceFileAttribute;
    }

    public String getRenameSourceFileAttribute() {
        return this.renameSourceFileAttribute;
    }

    public FilterSpecification getAdaptClassStrings() {
        return this.adaptClassStrings;
    }

    public void setAdaptClassStrings(FilterSpecification adaptClassStrings) {
        this.adaptClassStrings = adaptClassStrings;
    }

    public boolean printSeeds() {
        return this.printSeeds;
    }

    public void setPrintSeeds(boolean printSeeds) {
        this.printSeeds = printSeeds;
    }

    public File getSeedsFile() {
        return this.seedsFile;
    }

    public void setSeedsFile(File seedsFile) {
        this.seedsFile = seedsFile;
    }

    public void adaptResourceFileNames(FilterSpecification filter) {
        this.adaptResourceFileNames = filter;
    }

    public FilterSpecification getAdaptResourceFileNames() {
        return this.adaptResourceFileNames;
    }

    public void adaptResourceFileContents(FilterSpecification filter) {
        this.adaptResourceFileContents = filter;
    }

    public FilterSpecification getAdaptResourceFileContents() {
        return this.adaptResourceFileContents;
    }
}

