/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.android.annotations.NonNull;
import com.android.ide.common.process.JavaProcessInfo;
import com.android.ide.common.process.ProcessEnvBuilder;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.repository.FullRevision;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collection;
import java.util.List;

public class JackProcessBuilder
extends ProcessEnvBuilder<JackProcessBuilder> {
    static final FullRevision JACK_MIN_REV = new FullRevision(21, 1, 0);
    private boolean mDebugLog = false;
    private boolean mVerbose = false;
    private String mClasspath = null;
    private File mDexOutputFolder = null;
    private File mJackOutputFile = null;
    private List<File> mImportFiles = null;
    private List<File> mProguardFiles = null;
    private String mJavaMaxHeapSize = null;
    private File mMappingFile = null;
    private boolean mMultiDex = false;
    private int mMinSdkVersion = 21;
    private File mEcjOptionFile = null;
    private Collection<File> mJarJarRuleFiles = null;
    private File mIncrementalDir = null;

    @NonNull
    public JackProcessBuilder setDebugLog(boolean debugLog) {
        this.mDebugLog = debugLog;
        return this;
    }

    @NonNull
    public JackProcessBuilder setVerbose(boolean verbose) {
        this.mVerbose = verbose;
        return this;
    }

    @NonNull
    public JackProcessBuilder setJavaMaxHeapSize(String javaMaxHeapSize) {
        this.mJavaMaxHeapSize = javaMaxHeapSize;
        return this;
    }

    @NonNull
    public JackProcessBuilder setClasspath(String classpath) {
        this.mClasspath = classpath;
        return this;
    }

    @NonNull
    public JackProcessBuilder setDexOutputFolder(File dexOutputFolder) {
        this.mDexOutputFolder = dexOutputFolder;
        return this;
    }

    @NonNull
    public JackProcessBuilder setJackOutputFile(File jackOutputFile) {
        this.mJackOutputFile = jackOutputFile;
        return this;
    }

    @NonNull
    public JackProcessBuilder addImportFiles(@NonNull Collection<File> importFiles) {
        if (this.mImportFiles == null) {
            this.mImportFiles = Lists.newArrayListWithExpectedSize((int)importFiles.size());
        }
        this.mImportFiles.addAll(importFiles);
        return this;
    }

    @NonNull
    public JackProcessBuilder addProguardFiles(@NonNull Collection<File> proguardFiles) {
        if (this.mProguardFiles == null) {
            this.mProguardFiles = Lists.newArrayListWithExpectedSize((int)proguardFiles.size());
        }
        this.mProguardFiles.addAll(proguardFiles);
        return this;
    }

    @NonNull
    public JackProcessBuilder setMappingFile(File mappingFile) {
        this.mMappingFile = mappingFile;
        return this;
    }

    @NonNull
    public JackProcessBuilder setMultiDex(boolean multiDex) {
        this.mMultiDex = multiDex;
        return this;
    }

    @NonNull
    public JackProcessBuilder setMinSdkVersion(int minSdkVersion) {
        this.mMinSdkVersion = minSdkVersion;
        return this;
    }

    @NonNull
    public JackProcessBuilder setEcjOptionFile(File ecjOptionFile) {
        this.mEcjOptionFile = ecjOptionFile;
        return this;
    }

    @NonNull
    public JackProcessBuilder setJarJarRuleFiles(@NonNull Collection<File> jarJarRuleFiles) {
        this.mJarJarRuleFiles = jarJarRuleFiles;
        return this;
    }

    @NonNull
    public JavaProcessInfo build(@NonNull BuildToolInfo buildToolInfo) throws ProcessException {
        FullRevision revision = buildToolInfo.getRevision();
        if (revision.compareTo(JACK_MIN_REV) < 0) {
            throw new ProcessException("Jack requires Build Tools " + JACK_MIN_REV.toString() + " or later");
        }
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.addEnvironments(this.mEnvironment);
        String jackJar = buildToolInfo.getPath(BuildToolInfo.PathId.JACK);
        if (jackJar == null || !new File(jackJar).isFile()) {
            throw new IllegalStateException("jack.jar is missing");
        }
        builder.setClasspath(jackJar);
        builder.setMain("com.android.jack.Main");
        if (this.mJavaMaxHeapSize != null) {
            builder.addJvmArg("-Xmx" + this.mJavaMaxHeapSize);
        } else {
            builder.addJvmArg("-Xmx1024M");
        }
        if (this.mDebugLog) {
            builder.addArgs("--verbose", "debug");
        } else if (this.mVerbose) {
            builder.addArgs("--verbose", "info");
        }
        builder.addArgs("--classpath", this.mClasspath);
        if (this.mImportFiles != null) {
            for (File lib : this.mImportFiles) {
                builder.addArgs("--import", lib.getAbsolutePath());
            }
        }
        builder.addArgs("--output-dex", this.mDexOutputFolder.getAbsolutePath());
        builder.addArgs("--output-jack", this.mJackOutputFile.getAbsolutePath());
        builder.addArgs("-D", "jack.import.resource.policy=keep-first");
        builder.addArgs("-D", "jack.reporter=sdk");
        if (this.mProguardFiles != null && !this.mProguardFiles.isEmpty()) {
            for (File file : this.mProguardFiles) {
                builder.addArgs("--config-proguard", file.getAbsolutePath());
            }
        }
        if (this.mMappingFile != null) {
            builder.addArgs("-D", "jack.obfuscation.mapping.dump=true");
            builder.addArgs("-D", "jack.obfuscation.mapping.dump.file=" + this.mMappingFile.getAbsolutePath());
        }
        if (this.mMultiDex) {
            builder.addArgs("--multi-dex");
            if (this.mMinSdkVersion < 21) {
                builder.addArgs("legacy");
            } else {
                builder.addArgs("native");
            }
        }
        if (this.mJarJarRuleFiles != null) {
            for (File jarjarRuleFile : this.mJarJarRuleFiles) {
                builder.addArgs("--config-jarjar", jarjarRuleFile.getAbsolutePath());
            }
        }
        builder.addArgs("@" + this.mEcjOptionFile.getAbsolutePath());
        return builder.createJavaProcess();
    }
}

