/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.DefaultProductFlavor;
import com.android.builder.DexOptions;
import com.android.builder.SdkParser;
import com.android.builder.VariantConfiguration;
import com.android.builder.compiling.DependencyFileProcessor;
import com.android.builder.dependency.ManifestDependency;
import com.android.builder.dependency.SymbolFileProvider;
import com.android.builder.internal.ClassFieldImpl;
import com.android.builder.internal.SymbolLoader;
import com.android.builder.internal.SymbolWriter;
import com.android.builder.internal.TestManifestGenerator;
import com.android.builder.internal.compiler.AidlProcessor;
import com.android.builder.internal.compiler.LeafFolderGatherer;
import com.android.builder.internal.compiler.RenderScriptProcessor;
import com.android.builder.internal.compiler.SourceSearcher;
import com.android.builder.internal.packaging.JavaResourceProcessor;
import com.android.builder.internal.packaging.Packager;
import com.android.builder.model.AaptOptions;
import com.android.builder.model.ClassField;
import com.android.builder.model.PackagingOptions;
import com.android.builder.model.SigningConfig;
import com.android.builder.packaging.DuplicateFileException;
import com.android.builder.packaging.PackagerException;
import com.android.builder.packaging.SealedPackageException;
import com.android.builder.packaging.SigningException;
import com.android.builder.signing.CertificateInfo;
import com.android.builder.signing.KeystoreHelper;
import com.android.builder.signing.KeytoolException;
import com.android.ide.common.internal.AaptRunner;
import com.android.ide.common.internal.CommandLineRunner;
import com.android.ide.common.internal.LoggedErrorException;
import com.android.manifmerger.ManifestMerger;
import com.android.manifmerger.MergerLog;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.FullRevision;
import com.android.utils.ILogger;
import com.android.utils.SdkUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AndroidBuilder {
    private static final FullRevision MIN_BUILD_TOOLS_REV = new FullRevision(16, 0, 0);
    private static final DependencyFileProcessor sNoOpDependencyFileProcessor = new DependencyFileProcessor(){

        @Override
        public boolean processFile(@NonNull File dependencyFile) {
            return true;
        }
    };
    private final SdkParser mSdkParser;
    private final ILogger mLogger;
    private final CommandLineRunner mCmdLineRunner;
    private final boolean mVerboseExec;
    private boolean mLibrary;
    @NonNull
    private final IAndroidTarget mTarget;
    @NonNull
    private final BuildToolInfo mBuildTools;
    private String mCreatedBy;

    public AndroidBuilder(@NonNull SdkParser sdkParser, @Nullable String createdBy, @NonNull ILogger logger, boolean verboseExec) {
        this.mCreatedBy = createdBy;
        this.mSdkParser = (SdkParser)Preconditions.checkNotNull((Object)sdkParser);
        this.mLogger = (ILogger)Preconditions.checkNotNull((Object)logger);
        this.mVerboseExec = verboseExec;
        this.mCmdLineRunner = new CommandLineRunner(this.mLogger);
        BuildToolInfo buildToolInfo = this.mSdkParser.getBuildTools();
        FullRevision buildToolsRevision = buildToolInfo.getRevision();
        if (buildToolsRevision.compareTo(MIN_BUILD_TOOLS_REV) < 0) {
            throw new IllegalArgumentException(String.format("The SDK Build Tools revision (%1$s) is too low. Minimum required is %2$s", buildToolsRevision, MIN_BUILD_TOOLS_REV));
        }
        this.mTarget = this.mSdkParser.getTarget();
        this.mBuildTools = this.mSdkParser.getBuildTools();
    }

    AndroidBuilder(@NonNull SdkParser sdkParser, @NonNull CommandLineRunner cmdLineRunner, @NonNull ILogger logger, boolean verboseExec) {
        this.mSdkParser = (SdkParser)Preconditions.checkNotNull((Object)sdkParser);
        this.mCmdLineRunner = (CommandLineRunner)Preconditions.checkNotNull((Object)cmdLineRunner);
        this.mLogger = (ILogger)Preconditions.checkNotNull((Object)logger);
        this.mVerboseExec = verboseExec;
        this.mTarget = this.mSdkParser.getTarget();
        this.mBuildTools = this.mSdkParser.getBuildTools();
    }

    @NonNull
    public static List<String> getBootClasspath(@NonNull SdkParser sdkParser) {
        ArrayList classpath = Lists.newArrayList();
        IAndroidTarget target = sdkParser.getTarget();
        classpath.addAll(target.getBootClasspath());
        IAndroidTarget.IOptionalLibrary[] libs = target.getOptionalLibraries();
        if (libs != null) {
            for (IAndroidTarget.IOptionalLibrary lib : libs) {
                classpath.add(lib.getJarPath());
            }
        }
        if (target.getVersion().getApiLevel() <= 15) {
            classpath.add(sdkParser.getAnnotationsJar());
        }
        return classpath;
    }

    public AndroidBuilder setBuildingLibrary(boolean library) {
        this.mLibrary = library;
        return this;
    }

    public boolean isBuildingLibrary() {
        return this.mLibrary;
    }

    @NonNull
    public File getRenderScriptSupportJar() {
        return RenderScriptProcessor.getSupportJar(this.mBuildTools.getLocation().getAbsolutePath());
    }

    @NonNull
    public Set<File> getCompileClasspath(@NonNull VariantConfiguration variantConfiguration) {
        HashSet compileClasspath = variantConfiguration.getCompileClasspath();
        DefaultProductFlavor mergedFlavor = variantConfiguration.getMergedFlavor();
        if (mergedFlavor.getRenderscriptSupportMode()) {
            File renderScriptSupportJar = this.getRenderScriptSupportJar();
            HashSet fullJars = Sets.newHashSetWithExpectedSize((int)(compileClasspath.size() + 1));
            fullJars.addAll(compileClasspath);
            fullJars.add(renderScriptSupportJar);
            compileClasspath = fullJars;
        }
        return compileClasspath;
    }

    @NonNull
    public Set<File> getPackagedJars(@NonNull VariantConfiguration variantConfiguration) {
        HashSet packagedJars = variantConfiguration.getPackagedJars();
        DefaultProductFlavor mergedFlavor = variantConfiguration.getMergedFlavor();
        if (mergedFlavor.getRenderscriptSupportMode()) {
            File renderScriptSupportJar = this.getRenderScriptSupportJar();
            HashSet fullJars = Sets.newHashSetWithExpectedSize((int)(packagedJars.size() + 1));
            fullJars.addAll(packagedJars);
            fullJars.add(renderScriptSupportJar);
            packagedJars = fullJars;
        }
        return packagedJars;
    }

    @NonNull
    public File getSupportNativeLibFolder() {
        return RenderScriptProcessor.getSupportNativeLibFolder(this.mBuildTools.getLocation().getAbsolutePath());
    }

    @NonNull
    public AaptRunner getAaptRunner() {
        return new AaptRunner(this.mBuildTools.getPath(BuildToolInfo.PathId.AAPT), this.mCmdLineRunner);
    }

    @NonNull
    public CommandLineRunner getCommandLineRunner() {
        return this.mCmdLineRunner;
    }

    @NonNull
    public static ClassField createClassField(@NonNull String type, @NonNull String name, @NonNull String value) {
        return new ClassFieldImpl(type, name, value);
    }

    public void processManifest(@NonNull File mainManifest, @NonNull List<File> manifestOverlays, @NonNull List<? extends ManifestDependency> libraries, String packageOverride, int versionCode, String versionName, int minSdkVersion, int targetSdkVersion, @NonNull String outManifestLocation) {
        Preconditions.checkNotNull((Object)mainManifest, (Object)"mainManifest cannot be null.");
        Preconditions.checkNotNull(manifestOverlays, (Object)"manifestOverlays cannot be null.");
        Preconditions.checkNotNull(libraries, (Object)"libraries cannot be null.");
        Preconditions.checkNotNull((Object)outManifestLocation, (Object)"outManifestLocation cannot be null.");
        try {
            Map<String, String> attributeInjection = this.getAttributeInjectionMap(versionCode, versionName, minSdkVersion, targetSdkVersion);
            if (manifestOverlays.isEmpty() && libraries.isEmpty()) {
                if (attributeInjection.isEmpty() && packageOverride == null) {
                    SdkUtils.copyXmlWithSourceReference((File)mainManifest, (File)new File(outManifestLocation));
                } else {
                    ManifestMerger merger = new ManifestMerger(MergerLog.wrapSdkLog((ILogger)this.mLogger), null);
                    merger.setInsertSourceMarkers(this.isInsertSourceMarkers());
                    this.doMerge(merger, new File(outManifestLocation), mainManifest, attributeInjection, packageOverride);
                }
            } else {
                File outManifest = new File(outManifestLocation);
                if (!manifestOverlays.isEmpty()) {
                    File mainManifestOut = outManifest;
                    if (!libraries.isEmpty()) {
                        mainManifestOut = File.createTempFile("manifestMerge", ".xml");
                        mainManifestOut.deleteOnExit();
                    }
                    ManifestMerger merger = new ManifestMerger(MergerLog.wrapSdkLog((ILogger)this.mLogger), null);
                    merger.setInsertSourceMarkers(this.isInsertSourceMarkers());
                    this.doMerge(merger, mainManifestOut, mainManifest, manifestOverlays, attributeInjection, packageOverride);
                    mainManifest = mainManifestOut;
                    attributeInjection = null;
                }
                if (!libraries.isEmpty()) {
                    this.mergeLibraryManifests(mainManifest, libraries, new File(outManifestLocation), attributeInjection, packageOverride);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void processTestManifest(@NonNull String testPackageName, int minSdkVersion, int targetSdkVersion, @NonNull String testedPackageName, @NonNull String instrumentationRunner, @NonNull Boolean handleProfiling, @NonNull Boolean functionalTest, @NonNull List<? extends ManifestDependency> libraries, @NonNull String outManifestLocation) {
        Preconditions.checkNotNull((Object)testPackageName, (Object)"testPackageName cannot be null.");
        Preconditions.checkNotNull((Object)testedPackageName, (Object)"testedPackageName cannot be null.");
        Preconditions.checkNotNull((Object)instrumentationRunner, (Object)"instrumentationRunner cannot be null.");
        Preconditions.checkNotNull((Object)handleProfiling, (Object)"handleProfiling cannot be null.");
        Preconditions.checkNotNull((Object)functionalTest, (Object)"functionalTest cannot be null.");
        Preconditions.checkNotNull(libraries, (Object)"libraries cannot be null.");
        Preconditions.checkNotNull((Object)outManifestLocation, (Object)"outManifestLocation cannot be null.");
        if (!libraries.isEmpty()) {
            try {
                File generatedTestManifest = File.createTempFile("manifestMerge", ".xml");
                this.generateTestManifest(testPackageName, minSdkVersion, targetSdkVersion, testedPackageName, instrumentationRunner, handleProfiling, functionalTest, generatedTestManifest.getAbsolutePath());
                this.mergeLibraryManifests(generatedTestManifest, libraries, new File(outManifestLocation), null, null);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.generateTestManifest(testPackageName, minSdkVersion, targetSdkVersion, testedPackageName, instrumentationRunner, handleProfiling, functionalTest, outManifestLocation);
        }
    }

    private void generateTestManifest(String testPackageName, int minSdkVersion, int targetSdkVersion, String testedPackageName, String instrumentationRunner, Boolean handleProfiling, Boolean functionalTest, String outManifestLocation) {
        TestManifestGenerator generator = new TestManifestGenerator(outManifestLocation, testPackageName, minSdkVersion, targetSdkVersion, testedPackageName, instrumentationRunner, handleProfiling, functionalTest);
        try {
            generator.generate();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NonNull
    private Map<String, String> getAttributeInjectionMap(int versionCode, @Nullable String versionName, int minSdkVersion, int targetSdkVersion) {
        HashMap attributeInjection = Maps.newHashMap();
        if (versionCode != -1) {
            attributeInjection.put("/manifest|http://schemas.android.com/apk/res/android versionCode", Integer.toString(versionCode));
        }
        if (versionName != null) {
            attributeInjection.put("/manifest|http://schemas.android.com/apk/res/android versionName", versionName);
        }
        if (minSdkVersion != -1) {
            attributeInjection.put("/manifest/uses-sdk|http://schemas.android.com/apk/res/android minSdkVersion", Integer.toString(minSdkVersion));
        }
        if (targetSdkVersion != -1) {
            attributeInjection.put("/manifest/uses-sdk|http://schemas.android.com/apk/res/android targetSdkVersion", Integer.toString(targetSdkVersion));
        }
        return attributeInjection;
    }

    private void mergeLibraryManifests(File mainManifest, Iterable<? extends ManifestDependency> directLibraries, File outManifest, Map<String, String> attributeInjection, String packageOverride) throws IOException {
        ArrayList manifests = Lists.newArrayList();
        for (ManifestDependency manifestDependency : directLibraries) {
            List<? extends ManifestDependency> subLibraries = manifestDependency.getManifestDependencies();
            if (subLibraries.isEmpty()) {
                manifests.add(manifestDependency.getManifest());
                continue;
            }
            File mergeLibManifest = File.createTempFile("manifestMerge", ".xml");
            mergeLibManifest.deleteOnExit();
            this.mergeLibraryManifests(manifestDependency.getManifest(), subLibraries, mergeLibManifest, null, null);
            manifests.add(mergeLibManifest);
        }
        ManifestMerger merger = new ManifestMerger(MergerLog.wrapSdkLog((ILogger)this.mLogger), null);
        merger.setInsertSourceMarkers(this.isInsertSourceMarkers());
        this.doMerge(merger, outManifest, mainManifest, manifests, attributeInjection, packageOverride);
    }

    public boolean isInsertSourceMarkers() {
        boolean isRelease = false;
        return !this.mLibrary || !isRelease;
    }

    private void doMerge(ManifestMerger merger, File output, File input, Map<String, String> injectionMap, String packageOverride) {
        List<File> list = Collections.emptyList();
        this.doMerge(merger, output, input, list, injectionMap, packageOverride);
    }

    private void doMerge(ManifestMerger merger, File output, File input, List<File> subManifests, Map<String, String> injectionMap, String packageOverride) {
        if (!merger.process(output, input, subManifests.toArray(new File[subManifests.size()]), injectionMap, packageOverride)) {
            throw new RuntimeException("Manifest merging failed. See console for more info.");
        }
    }

    public void processResources(@NonNull File manifestFile, @NonNull File resFolder, @Nullable File assetsDir, @NonNull List<? extends SymbolFileProvider> libraries, @Nullable String packageForR, @Nullable String sourceOutputDir, @Nullable String symbolOutputDir, @Nullable String resPackageOutput, @Nullable String proguardOutput, VariantConfiguration.Type type, boolean debuggable, @NonNull AaptOptions options, @NonNull Collection<String> resourceConfigs) throws IOException, InterruptedException, LoggedErrorException {
        Collection noCompressList;
        String ignoreAssets;
        Preconditions.checkNotNull((Object)manifestFile, (Object)"manifestFile cannot be null.");
        Preconditions.checkNotNull((Object)resFolder, (Object)"resFolder cannot be null.");
        Preconditions.checkNotNull(libraries, (Object)"libraries cannot be null.");
        Preconditions.checkNotNull((Object)options, (Object)"options cannot be null.");
        Preconditions.checkArgument((sourceOutputDir != null || resPackageOutput != null ? 1 : 0) != 0, (Object)"No output provided for aapt task");
        ArrayList command = Lists.newArrayList();
        String aapt = this.mBuildTools.getPath(BuildToolInfo.PathId.AAPT);
        if (aapt == null || !new File(aapt).isFile()) {
            throw new IllegalStateException("aapt is missing");
        }
        command.add(aapt);
        command.add("package");
        if (this.mVerboseExec) {
            command.add("-v");
        }
        command.add("-f");
        command.add("--no-crunch");
        command.add("-I");
        command.add(this.mTarget.getPath(1));
        command.add("-M");
        command.add(manifestFile.getAbsolutePath());
        if (resFolder.isDirectory()) {
            command.add("-S");
            command.add(resFolder.getAbsolutePath());
        }
        if (assetsDir != null && assetsDir.isDirectory()) {
            command.add("-A");
            command.add(assetsDir.getAbsolutePath());
        }
        if (sourceOutputDir != null) {
            command.add("-m");
            command.add("-J");
            command.add(sourceOutputDir);
        }
        if (resPackageOutput != null) {
            command.add("-F");
            command.add(resPackageOutput);
        }
        if (proguardOutput != null) {
            command.add("-G");
            command.add(proguardOutput);
        }
        if (debuggable) {
            command.add("--debug-mode");
        }
        if (type == VariantConfiguration.Type.DEFAULT && packageForR != null) {
            command.add("--custom-package");
            command.add(packageForR);
            this.mLogger.verbose("Custom package for R class: '%s'", new Object[]{packageForR});
        }
        if (type == VariantConfiguration.Type.LIBRARY) {
            command.add("--non-constant-id");
        }
        if ((ignoreAssets = options.getIgnoreAssets()) != null) {
            command.add("--ignore-assets");
            command.add(ignoreAssets);
        }
        if ((noCompressList = options.getNoCompress()) != null) {
            for (String noCompress : noCompressList) {
                command.add("-0");
                command.add(noCompress);
            }
        }
        if (!resourceConfigs.isEmpty()) {
            command.add("-c");
            Joiner joiner = Joiner.on((char)',');
            command.add(joiner.join(resourceConfigs));
        }
        if (!(symbolOutputDir == null || type != VariantConfiguration.Type.LIBRARY && libraries.isEmpty())) {
            command.add("--output-text-symbols");
            command.add(symbolOutputDir);
        }
        this.mCmdLineRunner.runCmdLine((List)command, null);
        if (type != VariantConfiguration.Type.LIBRARY && !libraries.isEmpty()) {
            SymbolLoader fullSymbolValues = null;
            String appPackageName = packageForR;
            if (appPackageName == null) {
                appPackageName = VariantConfiguration.getManifestPackage(manifestFile);
            }
            ArrayListMultimap libMap = ArrayListMultimap.create();
            for (SymbolFileProvider symbolFileProvider : libraries) {
                String packageName;
                File rFile = symbolFileProvider.getSymbolFile();
                if (!rFile.isFile() || appPackageName.equals(packageName = VariantConfiguration.getManifestPackage(symbolFileProvider.getManifest()))) continue;
                if (fullSymbolValues == null) {
                    fullSymbolValues = new SymbolLoader(new File(symbolOutputDir, "R.txt"), this.mLogger);
                    fullSymbolValues.load();
                }
                SymbolLoader libSymbols = new SymbolLoader(rFile, this.mLogger);
                libSymbols.load();
                libMap.put((Object)packageName, (Object)libSymbols);
            }
            for (String string : libMap.keySet()) {
                Collection symbols = libMap.get((Object)string);
                SymbolWriter writer = new SymbolWriter(sourceOutputDir, string, fullSymbolValues);
                for (SymbolLoader symbolLoader : symbols) {
                    writer.addSymbolsToWrite(symbolLoader);
                }
                writer.write();
            }
        }
    }

    public void compileAllAidlFiles(@NonNull List<File> sourceFolders, @NonNull File sourceOutputDir, @NonNull List<File> importFolders, @Nullable DependencyFileProcessor dependencyFileProcessor) throws IOException, InterruptedException, LoggedErrorException {
        Preconditions.checkNotNull(sourceFolders, (Object)"sourceFolders cannot be null.");
        Preconditions.checkNotNull((Object)sourceOutputDir, (Object)"sourceOutputDir cannot be null.");
        Preconditions.checkNotNull(importFolders, (Object)"importFolders cannot be null.");
        String aidl = this.mBuildTools.getPath(BuildToolInfo.PathId.AIDL);
        if (aidl == null || !new File(aidl).isFile()) {
            throw new IllegalStateException("aidl is missing");
        }
        ArrayList fullImportList = Lists.newArrayListWithCapacity((int)(sourceFolders.size() + importFolders.size()));
        fullImportList.addAll(sourceFolders);
        fullImportList.addAll(importFolders);
        AidlProcessor processor = new AidlProcessor(aidl, this.mTarget.getPath(2), fullImportList, sourceOutputDir, dependencyFileProcessor != null ? dependencyFileProcessor : sNoOpDependencyFileProcessor, this.mCmdLineRunner);
        SourceSearcher searcher = new SourceSearcher(sourceFolders, "aidl");
        searcher.setUseExecutor(true);
        searcher.search(processor);
    }

    public void compileAidlFile(@NonNull File aidlFile, @NonNull File sourceOutputDir, @NonNull List<File> importFolders, @Nullable DependencyFileProcessor dependencyFileProcessor) throws IOException, InterruptedException, LoggedErrorException {
        Preconditions.checkNotNull((Object)aidlFile, (Object)"aidlFile cannot be null.");
        Preconditions.checkNotNull((Object)sourceOutputDir, (Object)"sourceOutputDir cannot be null.");
        Preconditions.checkNotNull(importFolders, (Object)"importFolders cannot be null.");
        String aidl = this.mBuildTools.getPath(BuildToolInfo.PathId.AIDL);
        if (aidl == null || !new File(aidl).isFile()) {
            throw new IllegalStateException("aidl is missing");
        }
        AidlProcessor processor = new AidlProcessor(aidl, this.mTarget.getPath(2), importFolders, sourceOutputDir, dependencyFileProcessor != null ? dependencyFileProcessor : sNoOpDependencyFileProcessor, this.mCmdLineRunner);
        processor.processFile(aidlFile);
    }

    public void compileAllRenderscriptFiles(@NonNull List<File> sourceFolders, @NonNull List<File> importFolders, @NonNull File sourceOutputDir, @NonNull File resOutputDir, @NonNull File objOutputDir, @NonNull File libOutputDir, int targetApi, boolean debugBuild, int optimLevel, boolean ndkMode, boolean supportMode, @Nullable Set<String> abiFilters) throws IOException, InterruptedException, LoggedErrorException {
        Preconditions.checkNotNull(sourceFolders, (Object)"sourceFolders cannot be null.");
        Preconditions.checkNotNull(importFolders, (Object)"importFolders cannot be null.");
        Preconditions.checkNotNull((Object)sourceOutputDir, (Object)"sourceOutputDir cannot be null.");
        Preconditions.checkNotNull((Object)resOutputDir, (Object)"resOutputDir cannot be null.");
        String renderscript = this.mBuildTools.getPath(BuildToolInfo.PathId.LLVM_RS_CC);
        if (renderscript == null || !new File(renderscript).isFile()) {
            throw new IllegalStateException("llvm-rs-cc is missing");
        }
        if (supportMode && this.mBuildTools.getRevision().compareTo(new FullRevision(18, 1, 0)) == -1) {
            throw new IllegalStateException("RenderScript Support Mode requires buildToolsVersion >= 18.1");
        }
        RenderScriptProcessor processor = new RenderScriptProcessor(sourceFolders, importFolders, sourceOutputDir, resOutputDir, objOutputDir, libOutputDir, this.mBuildTools, targetApi, debugBuild, optimLevel, ndkMode, supportMode, abiFilters);
        processor.build(this.mCmdLineRunner);
    }

    @NonNull
    public List<File> getLeafFolders(@NonNull String extension, List<File> ... importFolders) {
        ArrayList results = Lists.newArrayList();
        if (importFolders != null) {
            for (List<File> folders : importFolders) {
                SourceSearcher searcher = new SourceSearcher(folders, extension);
                searcher.setUseExecutor(false);
                LeafFolderGatherer processor = new LeafFolderGatherer();
                try {
                    searcher.search(processor);
                }
                catch (InterruptedException e) {
                }
                catch (IOException e) {
                }
                catch (LoggedErrorException e) {
                    // empty catch block
                }
                results.addAll(processor.getFolders());
            }
        }
        return results;
    }

    public void convertByteCode(@NonNull Iterable<File> inputs, @NonNull Iterable<File> preDexedLibraries, @NonNull File outDexFolder, @NonNull DexOptions dexOptions, @Nullable List<String> additionalParameters, boolean incremental) throws IOException, InterruptedException, LoggedErrorException {
        Preconditions.checkNotNull(inputs, (Object)"inputs cannot be null.");
        Preconditions.checkNotNull(preDexedLibraries, (Object)"preDexedLibraries cannot be null.");
        Preconditions.checkNotNull((Object)outDexFolder, (Object)"outDexFolder cannot be null.");
        Preconditions.checkNotNull((Object)dexOptions, (Object)"dexOptions cannot be null.");
        Preconditions.checkArgument((boolean)outDexFolder.isDirectory(), (Object)"outDexFolder must be a folder");
        ArrayList command = Lists.newArrayList();
        String dx = this.mBuildTools.getPath(BuildToolInfo.PathId.DX);
        if (dx == null || !new File(dx).isFile()) {
            throw new IllegalStateException("dx is missing");
        }
        command.add(dx);
        if (dexOptions.getJavaMaxHeapSize() != null) {
            command.add("-JXmx" + dexOptions.getJavaMaxHeapSize());
        }
        command.add("--dex");
        if (this.mVerboseExec) {
            command.add("--verbose");
        }
        if (dexOptions.getJumboMode()) {
            command.add("--force-jumbo");
        }
        if (incremental) {
            command.add("--incremental");
            command.add("--no-strict");
        }
        if (additionalParameters != null) {
            for (String arg : additionalParameters) {
                command.add(arg);
            }
        }
        command.add("--output");
        command.add(outDexFolder.getAbsolutePath());
        ArrayList inputList = Lists.newArrayList();
        for (File f : inputs) {
            if (f == null || !f.exists()) continue;
            inputList.add(f.getAbsolutePath());
        }
        if (!inputList.isEmpty()) {
            this.mLogger.verbose("Dex inputs: " + inputList, new Object[0]);
            command.addAll(inputList);
        }
        ArrayList libraryList = Lists.newArrayList();
        for (File f : preDexedLibraries) {
            if (f == null || !f.exists()) continue;
            libraryList.add(f.getAbsolutePath());
        }
        if (!libraryList.isEmpty()) {
            this.mLogger.verbose("Dex pre-dexed inputs: " + libraryList, new Object[0]);
            command.addAll(libraryList);
        }
        this.mCmdLineRunner.runCmdLine((List)command, null);
    }

    public void preDexLibrary(@NonNull File inputFile, @NonNull File outFile, @NonNull DexOptions dexOptions) throws IOException, InterruptedException, LoggedErrorException {
        Preconditions.checkNotNull((Object)inputFile, (Object)"inputFile cannot be null.");
        Preconditions.checkNotNull((Object)outFile, (Object)"outFile cannot be null.");
        Preconditions.checkNotNull((Object)dexOptions, (Object)"dexOptions cannot be null.");
        ArrayList command = Lists.newArrayList();
        String dx = this.mBuildTools.getPath(BuildToolInfo.PathId.DX);
        if (dx == null || !new File(dx).isFile()) {
            throw new IllegalStateException("dx is missing");
        }
        command.add(dx);
        if (dexOptions.getJavaMaxHeapSize() != null) {
            command.add("-JXmx" + dexOptions.getJavaMaxHeapSize());
        }
        command.add("--dex");
        if (this.mVerboseExec) {
            command.add("--verbose");
        }
        if (dexOptions.getJumboMode()) {
            command.add("--force-jumbo");
        }
        command.add("--output");
        command.add(outFile.getAbsolutePath());
        command.add(inputFile.getAbsolutePath());
        this.mCmdLineRunner.runCmdLine((List)command, null);
    }

    public void packageApk(@NonNull String androidResPkgLocation, @NonNull File dexFolder, @NonNull Collection<File> packagedJars, @Nullable String javaResourcesLocation, @Nullable Collection<File> jniLibsFolders, @Nullable Set<String> abiFilters, boolean jniDebugBuild, @Nullable SigningConfig signingConfig, @Nullable PackagingOptions packagingOptions, @NonNull String outApkLocation) throws DuplicateFileException, FileNotFoundException, KeytoolException, PackagerException, SigningException {
        Preconditions.checkNotNull((Object)androidResPkgLocation, (Object)"androidResPkgLocation cannot be null.");
        Preconditions.checkNotNull((Object)dexFolder, (Object)"dexFolder cannot be null.");
        Preconditions.checkArgument((boolean)dexFolder.isDirectory(), (Object)"dexFolder is not a directory");
        Preconditions.checkNotNull((Object)outApkLocation, (Object)"outApkLocation cannot be null.");
        CertificateInfo certificateInfo = null;
        if (signingConfig != null && signingConfig.isSigningReady() && (certificateInfo = KeystoreHelper.getCertificateInfo(signingConfig)) == null) {
            throw new SigningException("Failed to read key from keystore", new Object[0]);
        }
        try {
            Packager packager = new Packager(outApkLocation, androidResPkgLocation, dexFolder, certificateInfo, this.mCreatedBy, packagingOptions, this.mLogger);
            packager.setJniDebugMode(jniDebugBuild);
            JavaResourceProcessor resProcessor = new JavaResourceProcessor(packager);
            if (javaResourcesLocation != null) {
                resProcessor.addSourceFolder(javaResourcesLocation);
            }
            HashSet hashs = Sets.newHashSet();
            for (File jar : packagedJars) {
                String hash = AndroidBuilder.getFileHash(jar);
                if (hash == null) {
                    throw new PackagerException("Unable to compute hash of " + jar.getAbsolutePath(), new Object[0]);
                }
                if (hashs.contains(hash)) continue;
                hashs.add(hash);
                packager.addResourcesFromJar(jar);
            }
            if (jniLibsFolders != null) {
                for (File jniFolder : jniLibsFolders) {
                    if (!jniFolder.isDirectory()) continue;
                    packager.addNativeLibraries(jniFolder, abiFilters);
                }
            }
            packager.sealApk();
        }
        catch (SealedPackageException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    private static String getFileHash(@NonNull File file) {
        try {
            HashCode hashCode = Files.hash((File)file, (HashFunction)Hashing.sha1());
            return hashCode.toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

