/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.apkzlib.zfile;

import com.android.tools.build.apkzlib.zfile.ApkCreator;
import com.android.tools.build.apkzlib.zfile.NativeLibrariesPackagingMode;
import com.google.common.base.Preconditions;
import java.io.File;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public interface ApkCreatorFactory {
    public ApkCreator make(CreationData var1);

    public static class CreationData {
        private final File apkPath;
        @Nullable
        private final PrivateKey key;
        @Nullable
        private final X509Certificate certificate;
        private final boolean v1SigningEnabled;
        private final boolean v2SigningEnabled;
        @Nullable
        private final String builtBy;
        @Nullable
        private final String createdBy;
        private final int minSdkVersion;
        private final NativeLibrariesPackagingMode nativeLibrariesPackagingMode;
        private final Predicate<String> noCompressPredicate;

        public CreationData(File apkPath, @Nullable PrivateKey key, @Nullable X509Certificate certificate, boolean v1SigningEnabled, boolean v2SigningEnabled, @Nullable String builtBy, @Nullable String createdBy, int minSdkVersion, NativeLibrariesPackagingMode nativeLibrariesPackagingMode, Predicate<String> noCompressPredicate) {
            Preconditions.checkArgument((key == null == (certificate == null) ? 1 : 0) != 0, (Object)"(key == null) != (certificate == null)");
            Preconditions.checkArgument((minSdkVersion >= 0 ? 1 : 0) != 0, (Object)"minSdkVersion < 0");
            this.apkPath = apkPath;
            this.key = key;
            this.certificate = certificate;
            this.v1SigningEnabled = v1SigningEnabled;
            this.v2SigningEnabled = v2SigningEnabled;
            this.builtBy = builtBy;
            this.createdBy = createdBy;
            this.minSdkVersion = minSdkVersion;
            this.nativeLibrariesPackagingMode = (NativeLibrariesPackagingMode)((Object)Preconditions.checkNotNull((Object)((Object)nativeLibrariesPackagingMode)));
            this.noCompressPredicate = (Predicate)Preconditions.checkNotNull(noCompressPredicate);
        }

        public File getApkPath() {
            return this.apkPath;
        }

        @Nullable
        public PrivateKey getPrivateKey() {
            return this.key;
        }

        @Nullable
        public X509Certificate getCertificate() {
            return this.certificate;
        }

        public boolean isV1SigningEnabled() {
            return this.v1SigningEnabled;
        }

        public boolean isV2SigningEnabled() {
            return this.v2SigningEnabled;
        }

        @Nullable
        public String getBuiltBy() {
            return this.builtBy;
        }

        @Nullable
        public String getCreatedBy() {
            return this.createdBy;
        }

        public int getMinSdkVersion() {
            return this.minSdkVersion;
        }

        public NativeLibrariesPackagingMode getNativeLibrariesPackagingMode() {
            return this.nativeLibrariesPackagingMode;
        }

        public Predicate<String> getNoCompressPredicate() {
            return this.noCompressPredicate;
        }
    }
}

