/*
 * Decompiled with CFR 0.152.
 */
package com.android.aaptcompiler;

import com.android.aaptcompiler.AaptResourceType;
import com.android.aaptcompiler.AaptResourceTypeKt;
import com.android.aaptcompiler.AttributeResource;
import com.android.aaptcompiler.BinaryPrimitive;
import com.android.aaptcompiler.Item;
import com.android.aaptcompiler.ParsedParentInfo;
import com.android.aaptcompiler.PossibleResourceName;
import com.android.aaptcompiler.Reference;
import com.android.aaptcompiler.ReferenceInfo;
import com.android.aaptcompiler.ResourceFileKt;
import com.android.aaptcompiler.ResourceName;
import com.android.aaptcompiler.ResourceNameInfo;
import com.android.aaptcompiler.android.ResValue;
import com.android.aaptcompiler.android.ResourceTypesKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000h\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006\u001a\u0006\u0010\n\u001a\u00020\u000b\u001a\u0006\u0010\f\u001a\u00020\r\u001a\u0015\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0010\u001a\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\t\u001a\u00020\u0006\u001a\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\t\u001a\u00020\u0006\u001a\u0015\u0010\u0014\u001a\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0015\u001a\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\t\u001a\u00020\u0006\u001a\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0006\u001a\u000e\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u0006\u001a\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\t\u001a\u00020\u0006\u001a\u0018\u0010\u001e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\t\u001a\u00020\u0006\u001a\u0010\u0010!\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\t\u001a\u00020\u0006\u001a\u0010\u0010\"\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\t\u001a\u00020\u0006\u001a?\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u00012%\b\u0002\u0010&\u001a\u001f\u0012\u0013\u0012\u00110(\u00a2\u0006\f\b)\u0012\b\b*\u0012\u0004\b\b(*\u0012\u0004\u0012\u00020\u000f\u0018\u00010'\u001a\u0010\u0010+\u001a\u0004\u0018\u00010$2\u0006\u0010\t\u001a\u00020\u0006\u001a\u0010\u0010,\u001a\u0004\u0018\u00010\u00122\u0006\u0010\t\u001a\u00020\u0006\u001a\u000e\u0010-\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006."}, d2={"androidTypeToAttributeTypeMask", "", "type", "Lcom/android/aaptcompiler/android/ResValue$DataType;", "consumeDigits", "string", "", "extractResourceName", "Lcom/android/aaptcompiler/PossibleResourceName;", "value", "makeEmpty", "Lcom/android/aaptcompiler/BinaryPrimitive;", "makeNull", "Lcom/android/aaptcompiler/Reference;", "parseAsBool", "", "(Ljava/lang/String;)Ljava/lang/Boolean;", "parseAttributeReference", "Lcom/android/aaptcompiler/ReferenceInfo;", "parseReference", "parseResourceId", "(Ljava/lang/String;)Ljava/lang/Integer;", "parseResourceName", "Lcom/android/aaptcompiler/ResourceNameInfo;", "parseStyleParentReference", "Lcom/android/aaptcompiler/ParsedParentInfo;", "str", "parseXmlAttributeName", "tryParseBool", "tryParseColor", "tryParseFlagSymbol", "attribute", "Lcom/android/aaptcompiler/AttributeResource;", "tryParseFloat", "tryParseInt", "tryParseItemForAttribute", "Lcom/android/aaptcompiler/Item;", "resourceTypeMask", "onCreateReference", "Lkotlin/Function1;", "Lcom/android/aaptcompiler/ResourceName;", "Lkotlin/ParameterName;", "name", "tryParseNullOrEmpty", "tryParseReference", "verifyJavaStringFormat", "aaptcompiler"})
public final class ResourceUtilsKt {
    @Nullable
    public static final BinaryPrimitive tryParseBool(@NotNull String string) {
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Boolean bl2 = bl = ResourceUtilsKt.parseAsBool(string);
        if (bl2 == null) {
            return null;
        }
        bl2.booleanValue();
        int data = bl != false ? -1 : 0;
        return new BinaryPrimitive(new ResValue(ResValue.DataType.INT_BOOLEAN, data, 0, 4, null));
    }

    @Nullable
    public static final Boolean parseAsBool(@NotNull String string) {
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        switch (((Object)StringsKt.trim((CharSequence)string)).toString()) {
            case "true": 
            case "True": 
            case "TRUE": {
                bl = true;
                break;
            }
            case "false": 
            case "FALSE": 
            case "False": {
                bl = false;
                break;
            }
            default: {
                bl = null;
            }
        }
        return bl;
    }

    @Nullable
    public static final Item tryParseNullOrEmpty(@NotNull String value) {
        String trimmedValue;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = trimmedValue = ((Object)StringsKt.trim((CharSequence)value)).toString();
        return Intrinsics.areEqual((Object)string, (Object)"@null") ? (Item)ResourceUtilsKt.makeNull() : (Intrinsics.areEqual((Object)string, (Object)"@empty") ? (Item)ResourceUtilsKt.makeEmpty() : null);
    }

    @NotNull
    public static final Reference makeNull() {
        return new Reference(null, 1, null);
    }

    @NotNull
    public static final BinaryPrimitive makeEmpty() {
        return new BinaryPrimitive(new ResValue(ResValue.DataType.NULL, 1, 0, 4, null));
    }

    @Nullable
    public static final BinaryPrimitive tryParseInt(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String trimmedValue = ((Object)StringsKt.trim((CharSequence)value)).toString();
        ResValue resValue = ResourceTypesKt.stringToInt(trimmedValue);
        return resValue != null ? new BinaryPrimitive(resValue) : null;
    }

    @Nullable
    public static final Integer parseResourceId(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ResValue resValue = ResourceTypesKt.stringToInt(value);
        if (resValue != null && resValue.getDataType() == ResValue.DataType.INT_HEX && ResourceFileKt.isValidDynamicId(resValue.getData())) {
            return resValue.getData();
        }
        return null;
    }

    @Nullable
    public static final BinaryPrimitive tryParseFloat(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ResValue floatResource = ResourceTypesKt.stringToFloat(value);
        if (floatResource == null) {
            return null;
        }
        return new BinaryPrimitive(floatResource);
    }

    @Nullable
    public static final BinaryPrimitive tryParseColor(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String colorStr = ((Object)StringsKt.trim((CharSequence)value)).toString();
        if (((CharSequence)colorStr).length() == 0 || colorStr.charAt(0) != '#') {
            return null;
        }
        ResValue.DataType dataType = null;
        int data = 0;
        boolean error = false;
        block0 : switch (colorStr.length()) {
            case 4: {
                dataType = ResValue.DataType.INT_COLOR_RGB4;
                for (int i = 1; i < 4; ++i) {
                    int hexValue = ResourceTypesKt.parseHex(colorStr.codePointAt(i));
                    if (hexValue == -1) {
                        error = true;
                        break;
                    }
                    data = data << 8 | hexValue + (hexValue << 4);
                }
                data |= 0xFF000000;
                break;
            }
            case 5: {
                dataType = ResValue.DataType.INT_COLOR_ARGB4;
                for (int i = 1; i < 5; ++i) {
                    int hexValue = ResourceTypesKt.parseHex(colorStr.codePointAt(i));
                    if (hexValue == -1) {
                        error = true;
                        break block0;
                    }
                    data = data << 8 | hexValue + (hexValue << 4);
                }
                break;
            }
            case 7: {
                dataType = ResValue.DataType.INT_COLOR_RGB8;
                for (int i = 1; i < 7; ++i) {
                    int hexValue = ResourceTypesKt.parseHex(colorStr.codePointAt(i));
                    if (hexValue == -1) {
                        error = true;
                        break;
                    }
                    data = data << 4 | hexValue;
                }
                data |= 0xFF000000;
                break;
            }
            case 9: {
                dataType = ResValue.DataType.INT_COLOR_ARGB8;
                for (int i = 1; i < 9; ++i) {
                    int hexValue = ResourceTypesKt.parseHex(colorStr.codePointAt(i));
                    if (hexValue == -1) {
                        error = true;
                        break block0;
                    }
                    data = data << 4 | hexValue;
                }
                break;
            }
            default: {
                return null;
            }
        }
        if (error) {
            throw new Exception("Unable to parse hex color '" + value + "'.");
        }
        return new BinaryPrimitive(new ResValue(dataType, data, 0, 4, null));
    }

    @Nullable
    public static final ReferenceInfo tryParseReference(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ReferenceInfo parsedReference = ResourceUtilsKt.parseReference(value);
        if (parsedReference != null) {
            return parsedReference;
        }
        ReferenceInfo parsedAttribute = ResourceUtilsKt.parseAttributeReference(value);
        if (parsedAttribute != null) {
            return parsedAttribute;
        }
        return null;
    }

    @Nullable
    public static final ReferenceInfo parseAttributeReference(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String trimmedValue = ((Object)StringsKt.trim((CharSequence)value)).toString();
        if (((CharSequence)trimmedValue).length() == 0) {
            return null;
        }
        if (trimmedValue.charAt(0) != '?') {
            return null;
        }
        String string = trimmedValue.substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        PossibleResourceName possibleResourceName = ResourceUtilsKt.extractResourceName(string);
        if (!possibleResourceName.getSuccess()) {
            return null;
        }
        if (!(((CharSequence)possibleResourceName.getTypeName()).length() == 0) && !Intrinsics.areEqual((Object)possibleResourceName.getTypeName(), (Object)"attr")) {
            return null;
        }
        if (((CharSequence)possibleResourceName.getEntry()).length() == 0) {
            return null;
        }
        Reference reference = new Reference(null, 1, null);
        reference.setName(new ResourceName(possibleResourceName.getPackageName(), AaptResourceType.ATTR, possibleResourceName.getEntry()));
        reference.setReferenceType(Reference.Type.ATTRIBUTE);
        return new ReferenceInfo(reference, false);
    }

    @Nullable
    public static final ReferenceInfo parseReference(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String trimmedValue = ((Object)StringsKt.trim((CharSequence)value)).toString();
        if (((CharSequence)trimmedValue).length() == 0) {
            return null;
        }
        if (trimmedValue.charAt(0) == '@') {
            boolean create = false;
            int offset = 1;
            if (trimmedValue.length() > 1 && trimmedValue.charAt(1) == '+') {
                create = true;
                ++offset;
            }
            String string = trimmedValue.substring(offset);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            ResourceNameInfo referenceNameInfo = ResourceUtilsKt.parseResourceName(string);
            if (referenceNameInfo == null) {
                return null;
            }
            if (create && referenceNameInfo.isPrivate()) {
                return null;
            }
            if (create && referenceNameInfo.getResourceName().getType() != AaptResourceType.ID) {
                return null;
            }
            Reference reference = new Reference(null, 1, null);
            reference.setName(referenceNameInfo.getResourceName());
            reference.setPrivate(referenceNameInfo.isPrivate());
            return new ReferenceInfo(reference, create);
        }
        return null;
    }

    @Nullable
    public static final ResourceNameInfo parseResourceName(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (((CharSequence)value).length() == 0) {
            return null;
        }
        int offset = 0;
        boolean isPrivate = false;
        if (value.charAt(0) == '*') {
            isPrivate = true;
            offset = 1;
        }
        String string = value.substring(offset);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        PossibleResourceName possibleResourceName = ResourceUtilsKt.extractResourceName(string);
        if (!possibleResourceName.getSuccess()) {
            return null;
        }
        AaptResourceType resourceType = AaptResourceTypeKt.resourceTypeFromTag(possibleResourceName.getTypeName());
        if (resourceType == null) {
            return null;
        }
        if (((CharSequence)possibleResourceName.getEntry()).length() == 0) {
            return null;
        }
        return new ResourceNameInfo(new ResourceName(possibleResourceName.getPackageName(), resourceType, possibleResourceName.getEntry()), isPrivate);
    }

    @NotNull
    public static final PossibleResourceName extractResourceName(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String packageName = "";
        String typeName = "";
        boolean hasPackageSeparator = false;
        boolean hasTypeSeparator = false;
        int offsetCurrent = 0;
        if (((CharSequence)value).length() > 0 && value.charAt(0) == '@') {
            ++offsetCurrent;
        }
        for (int currentChar = offsetCurrent; currentChar < value.length(); ++currentChar) {
            if (((CharSequence)typeName).length() == 0 && value.charAt(currentChar) == '/') {
                hasTypeSeparator = true;
                Intrinsics.checkNotNullExpressionValue((Object)value.substring(offsetCurrent, currentChar), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                offsetCurrent = currentChar + 1;
                continue;
            }
            if (!(((CharSequence)packageName).length() == 0) || value.charAt(currentChar) != ':') continue;
            hasPackageSeparator = true;
            Intrinsics.checkNotNullExpressionValue((Object)value.substring(offsetCurrent, currentChar), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            offsetCurrent = currentChar + 1;
        }
        String string = value.substring(offsetCurrent);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        String entryName = string;
        boolean success = !(hasPackageSeparator && ((CharSequence)packageName).length() == 0 || hasTypeSeparator && ((CharSequence)typeName).length() == 0);
        return new PossibleResourceName(packageName, typeName, entryName, success);
    }

    @Nullable
    public static final Item tryParseItemForAttribute(@NotNull String value, int resourceTypeMask, @Nullable Function1<? super ResourceName, Boolean> onCreateReference) {
        BinaryPrimitive floatingPoint;
        BinaryPrimitive integer;
        BinaryPrimitive binaryPrimitive;
        BinaryPrimitive color;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Item nullOrEmpty = ResourceUtilsKt.tryParseNullOrEmpty(value);
        if (nullOrEmpty != null) {
            return nullOrEmpty;
        }
        ReferenceInfo reference = ResourceUtilsKt.tryParseReference(value);
        if (reference != null) {
            reference.getReference().setTypeFlags(resourceTypeMask);
            if (reference.getCreateNew()) {
                Boolean result;
                Function1<? super ResourceName, Boolean> function1 = onCreateReference;
                Boolean bl = result = function1 != null ? (Boolean)function1.invoke((Object)reference.getReference().getName()) : null;
                if (result != null && !result.booleanValue()) {
                    return null;
                }
            }
            return reference.getReference();
        }
        if ((resourceTypeMask & 0x10) != 0 && (color = ResourceUtilsKt.tryParseColor(value)) != null) {
            return color;
        }
        if ((resourceTypeMask & 8) != 0 && (binaryPrimitive = ResourceUtilsKt.tryParseBool(value)) != null) {
            return binaryPrimitive;
        }
        if ((resourceTypeMask & 4) != 0 && (integer = ResourceUtilsKt.tryParseInt(value)) != null) {
            return integer;
        }
        int floatMask = 224;
        if ((resourceTypeMask & floatMask) != 0 && (floatingPoint = ResourceUtilsKt.tryParseFloat(value)) != null && (ResourceUtilsKt.androidTypeToAttributeTypeMask(floatingPoint.getResValue().getDataType()) & resourceTypeMask) != 0) {
            return floatingPoint;
        }
        return null;
    }

    public static /* synthetic */ Item tryParseItemForAttribute$default(String string, int n, Function1 function1, int n2, Object object) {
        if ((n2 & 4) != 0) {
            function1 = null;
        }
        return ResourceUtilsKt.tryParseItemForAttribute(string, n, (Function1<? super ResourceName, Boolean>)function1);
    }

    public static final int androidTypeToAttributeTypeMask(@NotNull ResValue.DataType type) {
        int n;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n = 1;
                break;
            }
            case 5: {
                n = 2;
                break;
            }
            case 6: {
                n = 32;
                break;
            }
            case 7: {
                n = 64;
                break;
            }
            case 8: {
                n = 128;
                break;
            }
            case 9: 
            case 10: {
                n = 196612;
                break;
            }
            case 11: {
                n = 8;
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n = 16;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    public static final boolean verifyJavaStringFormat(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        int argumentCount = 0;
        boolean nonpositionalArgs = false;
        int currentIndex = 0;
        while (currentIndex < string.length()) {
            int codePoint = string.codePointAt(currentIndex);
            if (codePoint == 37 && currentIndex + 1 < string.length()) {
                if (string.codePointAt(++currentIndex) == 37) {
                    ++currentIndex;
                    continue;
                }
                ++argumentCount;
                String string2 = string.substring(currentIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                int numDigits = ResourceUtilsKt.consumeDigits(string2);
                if (numDigits > 0) {
                    if ((currentIndex += numDigits) < string.length() && string.codePointAt(currentIndex) != 36) {
                        nonpositionalArgs = true;
                    }
                } else if (currentIndex < string.length() && string.codePointAt(currentIndex) == 60) {
                    nonpositionalArgs = true;
                    if (++currentIndex < string.length() && string.codePointAt(currentIndex) == 36) {
                        ++currentIndex;
                    }
                } else {
                    nonpositionalArgs = true;
                }
                while (currentIndex < string.length()) {
                    boolean bl;
                    int n = string.codePointAt(currentIndex);
                    switch (n) {
                        case 32: 
                        case 35: 
                        case 40: 
                        case 43: 
                        case 44: 
                        case 45: {
                            bl = true;
                            break;
                        }
                        default: {
                            if (48 <= n) {
                                if (n < 58) {
                                    bl = true;
                                    break;
                                }
                                bl = false;
                                break;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) break;
                    ++currentIndex;
                }
                if (currentIndex < string.length()) {
                    switch (string.codePointAt(currentIndex)) {
                        case 68: 
                        case 70: 
                        case 75: 
                        case 77: 
                        case 87: 
                        case 90: 
                        case 107: 
                        case 109: 
                        case 119: 
                        case 121: 
                        case 122: {
                            return true;
                        }
                    }
                }
            }
            ++currentIndex;
        }
        return argumentCount <= true || !nonpositionalArgs;
    }

    public static final int consumeDigits(@NotNull String string) {
        int currentIndex;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        for (currentIndex = 0; currentIndex < string.length() && Character.isDigit(string.charAt(currentIndex)); ++currentIndex) {
        }
        return currentIndex;
    }

    @NotNull
    public static final ParsedParentInfo parseStyleParentReference(@NotNull String str) {
        AaptResourceType parsedType;
        PossibleResourceName possibleResourceName;
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        if (((CharSequence)str).length() == 0) {
            ParsedParentInfo.Companion.getEMPTY();
        }
        String name = str;
        boolean hasLeadingIdentifiers = false;
        boolean privateRef = false;
        int nameStart = name.codePointAt(0);
        switch (nameStart) {
            case 63: 
            case 64: {
                hasLeadingIdentifiers = true;
                String string = name.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                name = string;
            }
        }
        if (name.codePointAt(0) == 42) {
            privateRef = true;
            String string = name.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            name = string;
        }
        if (((CharSequence)(possibleResourceName = ResourceUtilsKt.extractResourceName(name)).getTypeName()).length() > 0 && (parsedType = AaptResourceTypeKt.resourceTypeFromTag(possibleResourceName.getTypeName())) != AaptResourceType.STYLE) {
            String errorString = "Invalid resource type " + possibleResourceName.getTypeName() + " for parent of style";
            return new ParsedParentInfo(null, errorString);
        }
        ResourceName resourceName = new ResourceName(possibleResourceName.getPackageName(), AaptResourceType.STYLE, possibleResourceName.getEntry());
        if (!hasLeadingIdentifiers) {
            String string = resourceName.getPck();
            Intrinsics.checkNotNull((Object)string);
            if (((CharSequence)string).length() == 0 && ((CharSequence)possibleResourceName.getTypeName()).length() > 0) {
                String errorString = "Invalid parent reference '" + str + "'";
                return new ParsedParentInfo(null, errorString);
            }
        }
        Reference result = new Reference(null, 1, null);
        result.setName(resourceName);
        result.setPrivate(privateRef);
        return new ParsedParentInfo(result, "");
    }

    @NotNull
    public static final Reference parseXmlAttributeName(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        String name = ((Object)StringsKt.trim((CharSequence)str)).toString();
        Reference result = new Reference(null, 1, null);
        int startOffset = 0;
        if (((CharSequence)name).length() > 0 && name.codePointAt(0) == 42) {
            ++startOffset;
            result.setPrivate(true);
        }
        String packageName = "";
        String entryName = "";
        int n = name.length();
        for (int i = startOffset; i < n; ++i) {
            if (name.codePointAt(i) != 58) continue;
            Intrinsics.checkNotNullExpressionValue((Object)name.substring(startOffset, i), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            Intrinsics.checkNotNullExpressionValue((Object)name.substring(i + 1), (String)"this as java.lang.String).substring(startIndex)");
        }
        result.setName(new ResourceName(packageName, AaptResourceType.ATTR, ((CharSequence)entryName).length() == 0 ? name : entryName));
        return result;
    }

    @Nullable
    public static final BinaryPrimitive tryParseFlagSymbol(@NotNull AttributeResource attribute, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ResValue.DataType flagsType = ResValue.DataType.INT_HEX;
        int flagsData = 0;
        if (((CharSequence)((Object)StringsKt.trim((CharSequence)value)).toString()).length() == 0) {
            return new BinaryPrimitive(new ResValue(flagsType, flagsData, 0, 4, null));
        }
        char[] cArray = new char[]{'|'};
        for (String part : StringsKt.split$default((CharSequence)value, (char[])cArray, (boolean)false, (int)0, (int)6, null)) {
            String trimmedPart = ((Object)StringsKt.trim((CharSequence)part)).toString();
            boolean flagSet = false;
            for (AttributeResource.Symbol symbol : attribute.getSymbols()) {
                ResourceName flagResourceName = symbol.getSymbol().getName();
                if (!Intrinsics.areEqual((Object)trimmedPart, (Object)flagResourceName.getEntry())) continue;
                flagsData |= symbol.getValue();
                flagSet = true;
                break;
            }
            if (flagSet) continue;
            return null;
        }
        return new BinaryPrimitive(new ResValue(flagsType, flagsData, 0, 4, null));
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResValue.DataType.values().length];
            try {
                nArray[ResValue.DataType.NULL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResValue.DataType.REFERENCE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResValue.DataType.ATTRIBUTE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResValue.DataType.DYNAMIC_REFERENCE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResValue.DataType.STRING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResValue.DataType.FLOAT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResValue.DataType.DIMENSION.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResValue.DataType.FRACTION.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResValue.DataType.INT_DEC.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResValue.DataType.INT_HEX.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResValue.DataType.INT_BOOLEAN.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResValue.DataType.INT_COLOR_ARGB8.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResValue.DataType.INT_COLOR_RGB8.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResValue.DataType.INT_COLOR_ARGB4.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResValue.DataType.INT_COLOR_RGB4.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

