/*
 * Decompiled with CFR 0.152.
 */
package com.android.aaptcompiler;

import com.android.aaptcompiler.AaptResourceType;
import com.android.aaptcompiler.BlameLogger;
import com.android.aaptcompiler.BlameLoggerKt;
import com.android.aaptcompiler.ExtractedPackage;
import com.android.aaptcompiler.NamespaceContext;
import com.android.aaptcompiler.Reference;
import com.android.aaptcompiler.ReferenceInfo;
import com.android.aaptcompiler.ResourceFile;
import com.android.aaptcompiler.ResourceName;
import com.android.aaptcompiler.ResourceUtilsKt;
import com.android.aaptcompiler.Source;
import com.android.aaptcompiler.SourcedResourceName;
import com.android.aaptcompiler.UnicodeUtilKt;
import com.android.aaptcompiler.XmlProcessorKt;
import com.android.aaptcompiler.XmlResource;
import com.android.aaptcompiler.XmlResourceBuilder;
import com.android.aaptcompiler.XmlUtilKt;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001aH\u0002J\u0018\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0018H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002JH\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020*2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020'0\u001aH\u0002J\u0016\u0010,\u001a\u00020\u00162\u0006\u0010-\u001a\u00020\n2\u0006\u0010.\u001a\u00020/JH\u00100\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010)\u001a\u00020*2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020'0\u001a2\u0006\u00101\u001a\u000202H\u0002J\u0010\u00103\u001a\u00020'2\u0006\u00104\u001a\u00020'H\u0002JT\u00105\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010)\u001a\u00020*2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020'0\u001a2\u0006\u00106\u001a\u00020'2\n\b\u0002\u00107\u001a\u0004\u0018\u000102H\u0002J\u0018\u00108\u001a\u00020'2\u0006\u00109\u001a\u00020:2\u0006\u00104\u001a\u00020'H\u0002R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR*\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006;"}, d2={"Lcom/android/aaptcompiler/XmlProcessor;", "", "source", "Lcom/android/aaptcompiler/Source;", "logger", "Lcom/android/aaptcompiler/BlameLogger;", "(Lcom/android/aaptcompiler/Source;Lcom/android/aaptcompiler/BlameLogger;)V", "getLogger", "()Lcom/android/aaptcompiler/BlameLogger;", "<set-?>", "Lcom/android/aaptcompiler/ResourceFile;", "primaryFile", "getPrimaryFile", "()Lcom/android/aaptcompiler/ResourceFile;", "getSource", "()Lcom/android/aaptcompiler/Source;", "", "Lcom/android/aaptcompiler/XmlResource;", "xmlResources", "getXmlResources", "()Ljava/util/List;", "gatherIds", "", "startElement", "Ljavax/xml/stream/events/StartElement;", "collectedIds", "", "Lcom/android/aaptcompiler/ResourceName;", "Lcom/android/aaptcompiler/SourcedResourceName;", "getNextAttrResourceFile", "suffix", "", "element", "isAaptAttribute", "", "elName", "Ljavax/xml/namespace/QName;", "outlineAttribute", "parentBuilder", "Lcom/android/aaptcompiler/XmlResourceBuilder;", "attrElement", "eventReader", "Ljavax/xml/stream/XMLEventReader;", "resourceBuilders", "process", "file", "inputFile", "Ljava/io/InputStream;", "processAaptAttr", "namespaceContext", "Lcom/android/aaptcompiler/NamespaceContext;", "processComment", "builder", "processElement", "currentBuilder", "inheritedNamespaceContext", "processText", "characters", "Ljavax/xml/stream/events/Characters;", "aaptcompiler"})
public final class XmlProcessor {
    @NotNull
    private final Source source;
    @Nullable
    private final BlameLogger logger;
    private ResourceFile primaryFile;
    @NotNull
    private List<XmlResource> xmlResources;

    public XmlProcessor(@NotNull Source source, @Nullable BlameLogger logger) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = source;
        this.logger = logger;
        boolean bl = false;
        this.xmlResources = CollectionsKt.emptyList();
    }

    @NotNull
    public final Source getSource() {
        return this.source;
    }

    @Nullable
    public final BlameLogger getLogger() {
        return this.logger;
    }

    @NotNull
    public final ResourceFile getPrimaryFile() {
        ResourceFile resourceFile = this.primaryFile;
        if (resourceFile != null) {
            return resourceFile;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"primaryFile");
        return null;
    }

    @NotNull
    public final List<XmlResource> getXmlResources() {
        return this.xmlResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void process(@NotNull ResourceFile file, @NotNull InputStream inputFile) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)inputFile, (String)"inputFile");
        this.primaryFile = file;
        XMLEventReader eventReader = null;
        try {
            Collection<XmlResource> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            eventReader = XmlUtilKt.getXmlInputFactory().createXMLEventReader(inputFile);
            boolean bl = false;
            Map collectedIds = new LinkedHashMap();
            boolean bl2 = false;
            Map protoBuilders = new LinkedHashMap();
            XMLEvent documentStart = eventReader.nextEvent();
            if (!documentStart.isStartDocument()) {
                String string = Intrinsics.stringPlus((String)"Failed to find start of XML from ", (Object)BlameLoggerKt.blameSource$default(this.source, null, null, 6, null));
                boolean bl3 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            XMLEvent rootStart = null;
            while (eventReader.hasNext() && !(rootStart = eventReader.nextEvent()).isStartElement()) {
            }
            XMLEvent xMLEvent = rootStart;
            if (xMLEvent == null) {
                return;
            }
            XmlResourceBuilder builder = new XmlResourceBuilder(this.getPrimaryFile(), false, 2, null);
            Object object = protoBuilders;
            boolean bl4 = false;
            object.put(file, builder);
            object = rootStart.asStartElement();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"rootStart.asStartElement()");
            XmlProcessor.processElement$default(this, (StartElement)object, eventReader, collectedIds, protoBuilders, builder, null, 32, null);
            Iterable $this$sortedBy$iv = CollectionsKt.toList((Iterable)collectedIds.values());
            boolean $i$f$sortedBy = false;
            boolean bl5 = false;
            this.getPrimaryFile().getExportedSymbols().addAll(CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    SourcedResourceName it = (SourcedResourceName)a;
                    boolean bl2 = false;
                    Comparable comparable = it.getName();
                    it = (SourcedResourceName)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    ResourceName resourceName = it.getName();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)resourceName);
                }
            }));
            $this$sortedBy$iv = protoBuilders.values();
            XmlProcessor xmlProcessor = this;
            boolean $i$f$map = false;
            void var11_20 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                XmlResourceBuilder xmlResourceBuilder = (XmlResourceBuilder)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl6 = false;
                XmlResource xmlResource = it.build();
                collection.add(xmlResource);
            }
            collection = (List)destination$iv$iv;
            xmlProcessor.xmlResources = CollectionsKt.sortedWith((Iterable)collection, (Comparator)new Comparator(this){
                final /* synthetic */ XmlProcessor this$0;
                {
                    this.this$0 = $receiver;
                }

                public final int compare(XmlResource left, XmlResource right) {
                    return left == right ? 0 : (left.getFile().getName() == this.this$0.getPrimaryFile().getName() ? -1 : (right.getFile().getName() == this.this$0.getPrimaryFile().getName() ? 1 : left.getFile().getName().compareTo(right.getFile().getName())));
                }
            });
        }
        catch (XMLStreamException xmlException) {
            String message;
            String string = xmlException.getMessage();
            String string2 = message = string == null ? "" : string;
            if (!StringsKt.contains((CharSequence)message, (CharSequence)"Premature end of file", (boolean)true)) {
                throw xmlException;
            }
        }
        finally {
            XMLEventReader xMLEventReader = eventReader;
            if (xMLEventReader != null) {
                xMLEventReader.close();
            }
        }
    }

    private final void processElement(StartElement startElement, XMLEventReader eventReader, Map<ResourceName, SourcedResourceName> collectedIds, Map<ResourceFile, XmlResourceBuilder> resourceBuilders, XmlResourceBuilder currentBuilder, NamespaceContext inheritedNamespaceContext) {
        XMLEvent nextEvent;
        Object $this$forEach$iv;
        Set<String> set;
        QName qName = startElement.getName();
        Intrinsics.checkNotNullExpressionValue((Object)qName, (String)"startElement.name");
        if (this.isAaptAttribute(qName)) {
            StringBuilder stringBuilder = new StringBuilder();
            Location location = startElement.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"startElement.location");
            RuntimeException exception = new RuntimeException(stringBuilder.append(BlameLoggerKt.blameSource(this.source, location)).append(": <aapt:attr> blocks are not allowed as the root of documents, or as a child element under another <aapt:attr>.").toString());
            XmlUtilKt.walkToEndOfElement(startElement, eventReader);
            throw exception;
        }
        this.gatherIds(startElement, collectedIds);
        QName elementName = startElement.getName();
        Location elementLocation = startElement.getLocation();
        String string = elementName.getLocalPart();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"elementName.localPart");
        String string2 = string;
        string = elementName.getNamespaceURI();
        currentBuilder.startElement(string2, string == null ? "" : string, elementLocation.getLineNumber(), elementLocation.getColumnNumber());
        Iterator<Namespace> namespaceDeclarations = startElement.getNamespaces();
        boolean bl = false;
        List namespaces = new ArrayList();
        while (namespaceDeclarations.hasNext()) {
            Namespace namespace = namespaceDeclarations.next();
            if (namespace == null) {
                throw new NullPointerException("null cannot be cast to non-null type javax.xml.stream.events.Namespace");
            }
            namespaces.add(namespace);
        }
        NamespaceContext namespaceContext = inheritedNamespaceContext;
        if (namespaceContext != null && (set = namespaceContext.namespacePrefixes()) != null) {
            $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object v2;
                String prefix;
                block13: {
                    Object element$iv = iterator.next();
                    prefix = (String)element$iv;
                    boolean bl2 = false;
                    Iterable $this$firstOrNull$iv = namespaces;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv2 : $this$firstOrNull$iv) {
                        Namespace ns = (Namespace)element$iv2;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)ns.getPrefix(), (Object)prefix)) continue;
                        v2 = element$iv2;
                        break block13;
                    }
                    v2 = null;
                }
                if (v2 != null) continue;
                String string3 = inheritedNamespaceContext.uriForPrefix(prefix);
                Intrinsics.checkNotNull((Object)string3);
                XmlResourceBuilder.addNamespaceDeclaration$default(currentBuilder, string3, prefix, 0, 0, 12, null);
            }
        }
        for (Namespace namespace : namespaces) {
            $this$forEach$iv = namespace.getNamespaceURI();
            Intrinsics.checkNotNullExpressionValue((Object)$this$forEach$iv, (String)"namespace.namespaceURI");
            Object object = $this$forEach$iv;
            $this$forEach$iv = namespace.getPrefix();
            Intrinsics.checkNotNullExpressionValue((Object)$this$forEach$iv, (String)"namespace.prefix");
            currentBuilder.addNamespaceDeclaration((String)object, (String)$this$forEach$iv, elementLocation.getLineNumber(), elementLocation.getColumnNumber());
        }
        Iterator<Attribute> attributes = startElement.getAttributes();
        while (attributes.hasNext()) {
            $this$forEach$iv = attributes.next();
            if ($this$forEach$iv == null) {
                throw new NullPointerException("null cannot be cast to non-null type javax.xml.stream.events.Attribute");
            }
            Attribute attribute = (Attribute)$this$forEach$iv;
            QName attrName = attribute.getName();
            String string4 = attrName.getLocalPart();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"attrName.localPart");
            String string5 = string4;
            string4 = attrName.getNamespaceURI();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"attrName.namespaceURI");
            String string6 = string4;
            string4 = attribute.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"attribute.value");
            currentBuilder.addAttribute(string5, string6, string4, elementLocation.getLineNumber(), elementLocation.getColumnNumber());
        }
        while (eventReader.hasNext() && !(nextEvent = eventReader.nextEvent()).isEndElement()) {
            if (nextEvent.isStartElement()) {
                StartElement startElement2;
                QName elName = nextEvent.asStartElement().getName();
                Intrinsics.checkNotNullExpressionValue((Object)elName, (String)"elName");
                if (this.isAaptAttribute(elName)) {
                    startElement2 = nextEvent.asStartElement();
                    Intrinsics.checkNotNullExpressionValue((Object)startElement2, (String)"nextEvent.asStartElement()");
                    this.outlineAttribute(currentBuilder, startElement2, eventReader, collectedIds, resourceBuilders);
                    continue;
                }
                startElement2 = nextEvent.asStartElement();
                Intrinsics.checkNotNullExpressionValue((Object)startElement2, (String)"nextEvent.asStartElement()");
                XmlProcessor.processElement$default(this, startElement2, eventReader, collectedIds, resourceBuilders, currentBuilder, null, 32, null);
                continue;
            }
            if (nextEvent.isCharacters()) {
                Characters characters = nextEvent.asCharacters();
                Intrinsics.checkNotNullExpressionValue((Object)characters, (String)"nextEvent.asCharacters()");
                this.processText(characters, currentBuilder);
            }
            if (nextEvent.getEventType() != 5) continue;
            this.processComment(currentBuilder);
        }
        currentBuilder.endElement();
    }

    static /* synthetic */ void processElement$default(XmlProcessor xmlProcessor, StartElement startElement, XMLEventReader xMLEventReader, Map map, Map map2, XmlResourceBuilder xmlResourceBuilder, NamespaceContext namespaceContext, int n, Object object) {
        if ((n & 0x20) != 0) {
            namespaceContext = null;
        }
        xmlProcessor.processElement(startElement, xMLEventReader, map, map2, xmlResourceBuilder, namespaceContext);
    }

    private final void outlineAttribute(XmlResourceBuilder parentBuilder, StartElement attrElement, XMLEventReader eventReader, Map<ResourceName, SourcedResourceName> collectedIds, Map<ResourceFile, XmlResourceBuilder> resourceBuilders) {
        String string;
        Attribute nameAttribute = attrElement.getAttributeByName(new QName("name"));
        if (nameAttribute == null) {
            StringBuilder stringBuilder = new StringBuilder();
            Location location = attrElement.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"attrElement.location");
            RuntimeException exception = new RuntimeException(stringBuilder.append(BlameLoggerKt.blameSource(this.source, location)).append(":<").append(attrElement.getName()).append("> tag requires the 'name' attribute.").toString());
            XmlUtilKt.walkToEndOfElement(attrElement, eventReader);
            throw exception;
        }
        String string2 = nameAttribute.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"nameAttribute.value");
        Reference reference = ResourceUtilsKt.parseXmlAttributeName(string2);
        ResourceName nameValue = reference.getName();
        String string3 = nameValue.getPck();
        Intrinsics.checkNotNull((Object)string3);
        ExtractedPackage extractedPackage = XmlUtilKt.transformPackageAlias(attrElement, string3);
        if (extractedPackage == null) {
            StringBuilder stringBuilder = new StringBuilder();
            Location location = attrElement.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"attrElement.location");
            RuntimeException exception = new RuntimeException(stringBuilder.append(BlameLoggerKt.blameSource(this.source, location)).append("Invalid namespace prefix '").append((Object)nameValue.getPck()).append("' for value of 'name' attribute '").append(nameValue).append("'.").toString());
            XmlUtilKt.walkToEndOfElement(attrElement, eventReader);
            throw exception;
        }
        boolean isPrivateNs = extractedPackage.isPrivate() || reference.isPrivate();
        CharSequence charSequence = nameValue.getPck();
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            string = "";
        } else {
            charSequence = extractedPackage.getPackageName();
            bl = false;
            string = charSequence.length() == 0 ? "http://schemas.android.com/apk/res-auto" : XmlUtilKt.constructPackageUri(extractedPackage.getPackageName(), isPrivateNs);
        }
        String attrUri = string;
        ResourceFile resource = this.processAaptAttr(attrElement, eventReader, collectedIds, resourceBuilders, parentBuilder.getNamespaceContext());
        String string4 = nameValue.getEntry();
        Intrinsics.checkNotNull((Object)string4);
        if (parentBuilder.findAttribute(string4, attrUri) != null) {
            String string5 = Intrinsics.stringPlus((String)"Cannot find attribute ", (Object)nameValue.getEntry());
            bl2 = false;
            throw (Throwable)new IllegalStateException(string5.toString());
        }
        parentBuilder.addAttribute(nameValue.getEntry(), attrUri, Intrinsics.stringPlus((String)"@", (Object)resource.getName()), attrElement.getLocation().getLineNumber(), attrElement.getLocation().getColumnNumber());
    }

    private final boolean isAaptAttribute(QName elName) {
        return Intrinsics.areEqual((Object)elName.getNamespaceURI(), (Object)"http://schemas.android.com/aapt") && Intrinsics.areEqual((Object)elName.getLocalPart(), (Object)"attr");
    }

    private final ResourceFile processAaptAttr(StartElement startElement, XMLEventReader eventReader, Map<ResourceName, SourcedResourceName> collectedIds, Map<ResourceFile, XmlResourceBuilder> resourceBuilders, NamespaceContext namespaceContext) {
        Object object;
        XMLEvent event;
        ResourceFile outputFile = this.getNextAttrResourceFile(resourceBuilders.size() - 1, startElement);
        XmlResourceBuilder outputBuilder = new XmlResourceBuilder(outputFile, false, 2, null);
        Map<ResourceFile, XmlResourceBuilder> map = resourceBuilders;
        boolean bl = false;
        map.put(outputFile, outputBuilder);
        bl = false;
        List errors = new ArrayList();
        boolean foundChild = false;
        while (eventReader.hasNext() && !(event = eventReader.nextEvent()).isEndElement()) {
            boolean bl2;
            Object object2;
            Object object3;
            if (event.isCharacters()) {
                if (event.asCharacters().isWhiteSpace()) continue;
                object3 = errors;
                StringBuilder stringBuilder = new StringBuilder();
                object2 = event.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"event.location");
                object2 = stringBuilder.append(BlameLoggerKt.blameSource(this.source, (Location)object2)).append(": Can't extract text into its own resource.").toString();
                bl2 = false;
                object3.add(object2);
                continue;
            }
            if (!event.isStartElement()) continue;
            if (foundChild) {
                object3 = errors;
                StringBuilder stringBuilder = new StringBuilder();
                object2 = event.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"event.location");
                object2 = stringBuilder.append(BlameLoggerKt.blameSource(this.source, (Location)object2)).append(": Inline XML resources must have a single root.").toString();
                bl2 = false;
                object3.add(object2);
                object3 = event.asStartElement();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"event.asStartElement()");
                XmlUtilKt.walkToEndOfElement((StartElement)object3, eventReader);
                continue;
            }
            foundChild = true;
            object3 = event.asStartElement();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"event.asStartElement()");
            this.processElement((StartElement)object3, eventReader, collectedIds, resourceBuilders, outputBuilder, namespaceContext);
        }
        if (!foundChild) {
            StringBuilder stringBuilder = new StringBuilder();
            object = startElement.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"startElement.location");
            object = stringBuilder.append(BlameLoggerKt.blameSource(this.source, (Location)object)).append(": No resource to outline. <").append(startElement.getName()).append("> block is empty.").toString();
            boolean bl3 = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        if (CollectionsKt.any((Iterable)errors)) {
            object = CollectionsKt.joinToString$default((Iterable)errors, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            boolean bl4 = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        return outputFile;
    }

    private final XmlResourceBuilder processText(Characters characters, XmlResourceBuilder builder) {
        String string = characters.getData();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"characters.data");
        return XmlResourceBuilder.addText$default(builder, string, 0, 0, 6, null);
    }

    private final XmlResourceBuilder processComment(XmlResourceBuilder builder) {
        return builder.addComment();
    }

    private final void gatherIds(StartElement startElement, Map<ResourceName, SourcedResourceName> collectedIds) {
        Iterator<Attribute> iterator = startElement.getAttributes();
        while (iterator.hasNext()) {
            Attribute attribute = iterator.next();
            if (attribute == null) {
                throw new NullPointerException("null cannot be cast to non-null type javax.xml.stream.events.Attribute");
            }
            Attribute attribute2 = attribute;
            Object object = attribute2.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"attribute.value");
            ReferenceInfo parsedRef = ResourceUtilsKt.parseReference((String)object);
            object = parsedRef;
            if (object == null) continue;
            ResourceName resourceName = parsedRef.getReference().getName();
            if (!parsedRef.getCreateNew() || resourceName.getType() != AaptResourceType.ID) continue;
            String string = resourceName.getEntry();
            Intrinsics.checkNotNull((Object)string);
            if (!UnicodeUtilKt.isValidResourceEntryName(string)) {
                StringBuilder stringBuilder = new StringBuilder();
                Object object2 = startElement.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"startElement.location");
                object2 = stringBuilder.append(BlameLoggerKt.blameSource(this.source, (Location)object2)).append(" Id '").append(resourceName).append("' has an invalid entry name '").append((Object)resourceName.getEntry()).append("'.").toString();
                boolean bl = false;
                throw (Throwable)new IllegalStateException(object2.toString());
            }
            collectedIds.putIfAbsent(resourceName, new SourcedResourceName(resourceName, startElement.getLocation().getLineNumber()));
        }
    }

    private final ResourceFile getNextAttrResourceFile(int suffix, StartElement element) {
        String newEntryName = XmlProcessorKt.access$mangleEntry("", this.getPrimaryFile().getName().getEntry() + "__" + suffix);
        return new ResourceFile(ResourceName.copy$default(this.getPrimaryFile().getName(), null, null, newEntryName, 3, null), this.getPrimaryFile().getConfiguration(), this.getPrimaryFile().getSource().withLine(element.getLocation().getLineNumber()), ResourceFile.Type.ProtoXml, null, 16, null);
    }
}

