/*
 * Decompiled with CFR 0.152.
 */
package com.android.aaptcompiler.android;

import com.android.aaptcompiler.android.LocaleData;
import com.android.aaptcompiler.android.UtilKt;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b:\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b-\b\u0016\u0018\u0000 \u0091\u00012\b\u0012\u0004\u0012\u00020\u00000\u0001:\u001a\u0090\u0001\u0091\u0001\u0092\u0001\u0093\u0001\u0094\u0001\u0095\u0001\u0096\u0001\u0097\u0001\u0098\u0001\u0099\u0001\u009a\u0001\u009b\u0001\u009c\u0001Bo\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\u0003\u0012\u0006\u0010\u0010\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0011B\u000f\b\u0016\u0012\u0006\u0010\u0012\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0013B\u0089\u0002\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u0012\b\b\u0002\u0010\u0017\u001a\u00020\u0016\u0012\b\b\u0002\u0010\u0018\u001a\u00020\r\u0012\b\b\u0002\u0010\u0019\u001a\u00020\r\u0012\b\b\u0002\u0010\u001a\u001a\u00020\u001b\u0012\b\b\u0002\u0010\u001c\u001a\u00020\u001b\u0012\b\b\u0002\u0010\u001d\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u001e\u001a\u00020\u001b\u0012\b\b\u0002\u0010\u001f\u001a\u00020\u001b\u0012\b\b\u0002\u0010 \u001a\u00020\u001b\u0012\b\b\u0002\u0010!\u001a\u00020\u0003\u0012\b\b\u0002\u0010\"\u001a\u00020\u0003\u0012\b\b\u0002\u0010#\u001a\u00020\u0016\u0012\b\b\u0002\u0010$\u001a\u00020\u0016\u0012\b\b\u0002\u0010%\u001a\u00020\u001b\u0012\b\b\u0002\u0010&\u001a\u00020\u001b\u0012\b\b\u0002\u0010'\u001a\u00020\u0003\u0012\b\b\u0002\u0010(\u001a\u00020\u0003\u0012\b\b\u0002\u0010)\u001a\u00020\u0003\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\r\u0012\b\b\u0002\u0010*\u001a\u00020\u001b\u0012\b\b\u0002\u0010+\u001a\u00020\u001b\u0012\b\b\u0002\u0010,\u001a\u00020-\u0012\b\b\u0002\u0010\u0010\u001a\u00020\r\u00a2\u0006\u0002\u0010.J\u0014\u0010g\u001a\u00020h2\n\u0010i\u001a\u00060jj\u0002`kH\u0002J\u000e\u0010l\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0000J\u0011\u0010m\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0000H\u0096\u0002J\u000e\u0010n\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0000J\u0010\u0010o\u001a\u00020p2\b\b\u0002\u0010q\u001a\u00020-J\u0006\u0010r\u001a\u00020\u0003J\u0006\u0010s\u001a\u00020\u0003J\u0006\u0010t\u001a\u00020\u0003J\u0006\u0010u\u001a\u00020\u0003J\u0006\u0010v\u001a\u00020\u0003J\u0006\u0010w\u001a\u00020\u0003J\u0006\u0010x\u001a\u00020\u0003J\u0006\u0010y\u001a\u00020\u0003J\u0006\u0010z\u001a\u00020\u0003J\u0006\u0010{\u001a\u00020\u0003J\u0006\u0010|\u001a\u00020\u001bJ\u0018\u0010}\u001a\u00020-2\u0006\u0010\u0012\u001a\u00020\u00002\b\u0010~\u001a\u0004\u0018\u00010\u0000J\u0016\u0010\u007f\u001a\u00020-2\u0006\u0010\u0012\u001a\u00020\u00002\u0006\u0010~\u001a\u00020\u0000J\u000f\u0010\u0080\u0001\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0000J\u000f\u0010\u0081\u0001\u001a\u00020-2\u0006\u0010\u0012\u001a\u00020\u0000J\u0007\u0010\u0082\u0001\u001a\u00020\u001bJ\u0007\u0010\u0083\u0001\u001a\u00020\u001bJ\u0007\u0010\u0084\u0001\u001a\u00020\u001bJ\u0010\u0010\u0085\u0001\u001a\u00020-2\u0007\u0010\u0086\u0001\u001a\u00020\u0000J\u0010\u0010\u0087\u0001\u001a\u00020h2\u0007\u0010\u0088\u0001\u001a\u00020pJ\u0010\u0010\u0089\u0001\u001a\u00020h2\u0007\u0010\u0088\u0001\u001a\u00020pJ\t\u0010\u008a\u0001\u001a\u00020pH\u0016J\u0007\u0010\u008b\u0001\u001a\u00020\u001bJ\u0007\u0010\u008c\u0001\u001a\u00020\u001bJ\u0007\u0010\u008d\u0001\u001a\u00020pJ\u0007\u0010\u008e\u0001\u001a\u00020pJ\u0007\u0010\u008f\u0001\u001a\u00020\u001bR\u001a\u0010+\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u0011\u0010\u0019\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u001a\u0010\u001d\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u001a\u0010 \u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u00100\"\u0004\b:\u00102R\u001a\u0010\u001e\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u00100\"\u0004\b<\u00102R\u0011\u0010\u0018\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u00104R\u0011\u0010\u0010\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u00104R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u00104R\u001a\u0010,\u001a\u00020-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR\u0011\u0010\u000e\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u00104R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010F\"\u0004\bG\u0010HR\u001a\u0010$\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010F\"\u0004\bJ\u0010HR\u001a\u0010\u0017\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010F\"\u0004\bL\u0010HR\u001a\u0010\u001f\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u00100\"\u0004\bN\u00102R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u00100\"\u0004\bP\u00102R\u001a\u0010\"\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u00106\"\u0004\bR\u00108R\u001a\u0010)\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bS\u00106\"\u0004\bT\u00108R\u001a\u0010%\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bU\u00100\"\u0004\bV\u00102R\u001a\u0010*\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bW\u00100\"\u0004\bX\u00102R\u001a\u0010!\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bY\u00106\"\u0004\bZ\u00108R\u001a\u0010(\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b[\u00106\"\u0004\b\\\u00108R\u001a\u0010#\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b]\u0010F\"\u0004\b^\u0010HR\u001a\u0010\u0014\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b_\u00106\"\u0004\b`\u00108R\u001a\u0010'\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\ba\u00106\"\u0004\bb\u00108R\u001a\u0010\u001c\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bc\u00100\"\u0004\bd\u00102R\u001a\u0010&\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\be\u00100\"\u0004\bf\u00102\u00a8\u0006\u009d\u0001"}, d2={"Lcom/android/aaptcompiler/android/ResTableConfig;", "", "sizeFromDevice", "", "imsi", "locale", "screenType", "input", "screenSize", "version", "screenConfig", "screenSizeDp", "localeScript", "", "localeVariant", "screenConfig2", "localeNumberSystem", "(IIIIIIIII[B[BI[B)V", "other", "(Lcom/android/aaptcompiler/android/ResTableConfig;)V", "size", "mcc", "", "mnc", "language", "country", "orientation", "", "touchscreen", "density", "keyboard", "navigation", "inputFlags", "screenWidth", "screenHeight", "sdkVersion", "minorVersion", "screenLayout", "uiMode", "smallestScreenWidthDp", "screenWidthDp", "screenHeightDp", "screenLayout2", "colorMode", "localeScriptWasComputed", "", "(ISS[B[BBBIBBBIISSBBIII[B[BBBZ[B)V", "getColorMode", "()B", "setColorMode", "(B)V", "getCountry", "()[B", "getDensity", "()I", "setDensity", "(I)V", "getInputFlags", "setInputFlags", "getKeyboard", "setKeyboard", "getLanguage", "getLocaleNumberSystem", "getLocaleScript", "getLocaleScriptWasComputed", "()Z", "setLocaleScriptWasComputed", "(Z)V", "getLocaleVariant", "getMcc", "()S", "setMcc", "(S)V", "getMinorVersion", "setMinorVersion", "getMnc", "setMnc", "getNavigation", "setNavigation", "getOrientation", "setOrientation", "getScreenHeight", "setScreenHeight", "getScreenHeightDp", "setScreenHeightDp", "getScreenLayout", "setScreenLayout", "getScreenLayout2", "setScreenLayout2", "getScreenWidth", "setScreenWidth", "getScreenWidthDp", "setScreenWidthDp", "getSdkVersion", "setSdkVersion", "getSize", "setSize", "getSmallestScreenWidthDp", "setSmallestScreenWidthDp", "getTouchscreen", "setTouchscreen", "getUiMode", "setUiMode", "appendDirLocale", "", "result", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "compareLocales", "compareTo", "diff", "getBcp47Locale", "", "canonicalize", "getImportanceScoreOfLocale", "getImsi", "getInput", "getLocale", "getScreenConfig", "getScreenConfig2", "getScreenSize", "getScreenSizeDp", "getScreenType", "getVersion", "hdr", "isBetterThan", "requested", "isLocaleBetterThan", "isLocaleMoreSpecificThan", "isMoreSpecificThan", "layoutLong", "layoutRound", "layoutSize", "match", "settings", "packLanguage", "value", "packRegion", "toString", "uiModeNight", "uiModeType", "unpackLanguage", "unpackRegion", "wideColorGamut", "COLOR_MODE", "Companion", "DENSITY", "INPUT_FLAGS", "KEYBOARD", "NAVIGATION", "ORIENTATION", "SCREENSIZE", "SCREEN_LAYOUT", "SCREEN_LAYOUT2", "TOUCHSCREEN", "UI_MODE", "VERSION", "aaptcompiler"})
public class ResTableConfig
implements Comparable<ResTableConfig> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int size;
    private short mcc;
    private short mnc;
    @NotNull
    private final byte[] language;
    @NotNull
    private final byte[] country;
    private byte orientation;
    private byte touchscreen;
    private int density;
    private byte keyboard;
    private byte navigation;
    private byte inputFlags;
    private int screenWidth;
    private int screenHeight;
    private short sdkVersion;
    private short minorVersion;
    private byte screenLayout;
    private byte uiMode;
    private int smallestScreenWidthDp;
    private int screenWidthDp;
    private int screenHeightDp;
    @NotNull
    private final byte[] localeScript;
    @NotNull
    private final byte[] localeVariant;
    private byte screenLayout2;
    private byte colorMode;
    private boolean localeScriptWasComputed;
    @NotNull
    private final byte[] localeNumberSystem;
    @NotNull
    private static final byte[] ENGLISH;
    @NotNull
    private static final byte[] UNITED_STATES;
    @NotNull
    private static final byte[] FILIPINO;
    @NotNull
    private static final byte[] TAGALOG;
    @NotNull
    public static final String NUMBERING_SYSTEM_PREFIX = "u-nu-";
    public static final int CONFIG_MCC = 1;
    public static final int CONFIG_MNC = 2;
    public static final int CONFIG_LOCALE = 4;
    public static final int CONFIG_TOUCHSCREEN = 8;
    public static final int CONFIG_KEYBOARD = 16;
    public static final int CONFIG_KEYBOARD_HIDDEN = 32;
    public static final int CONFIG_NAVIGATION = 64;
    public static final int CONFIG_ORIENTATION = 128;
    public static final int CONFIG_DENSITY = 256;
    public static final int CONFIG_SCREEN_SIZE = 512;
    public static final int CONFIG_SMALLEST_SCREEN_SIZE = 8192;
    public static final int CONFIG_VERSION = 1024;
    public static final int CONFIG_SCREEN_LAYOUT = 2048;
    public static final int CONFIG_UI_MODE = 4096;
    public static final int CONFIG_LAYOUTDIR = 16384;
    public static final int CONFIG_SCREEN_ROUND = 32768;
    public static final int CONFIG_COLOR_MODE = 65536;
    public static final int SCREEN_CONFIG_MIN_SIZE = 32;
    public static final int SCREEN_DP_MIN_SIZE = 36;
    public static final int LOCALE_MIN_SIZE = 48;
    public static final int SCREEN_CONFIG_EXTENSION_MIN_SIZE = 52;
    public static final int NUMBER_SYSTEM_MIN_SIZE = 60;

    public ResTableConfig(int size, short mcc, short mnc, @NotNull byte[] language, @NotNull byte[] country, byte orientation, byte touchscreen, int density, byte keyboard, byte navigation, byte inputFlags, int screenWidth, int screenHeight, short sdkVersion, short minorVersion, byte screenLayout, byte uiMode, int smallestScreenWidthDp, int screenWidthDp, int screenHeightDp, @NotNull byte[] localeScript, @NotNull byte[] localeVariant, byte screenLayout2, byte colorMode, boolean localeScriptWasComputed, @NotNull byte[] localeNumberSystem) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)country, (String)"country");
        Intrinsics.checkNotNullParameter((Object)localeScript, (String)"localeScript");
        Intrinsics.checkNotNullParameter((Object)localeVariant, (String)"localeVariant");
        Intrinsics.checkNotNullParameter((Object)localeNumberSystem, (String)"localeNumberSystem");
        this.size = size;
        this.mcc = mcc;
        this.mnc = mnc;
        this.language = language;
        this.country = country;
        this.orientation = orientation;
        this.touchscreen = touchscreen;
        this.density = density;
        this.keyboard = keyboard;
        this.navigation = navigation;
        this.inputFlags = inputFlags;
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.sdkVersion = sdkVersion;
        this.minorVersion = minorVersion;
        this.screenLayout = screenLayout;
        this.uiMode = uiMode;
        this.smallestScreenWidthDp = smallestScreenWidthDp;
        this.screenWidthDp = screenWidthDp;
        this.screenHeightDp = screenHeightDp;
        this.localeScript = localeScript;
        this.localeVariant = localeVariant;
        this.screenLayout2 = screenLayout2;
        this.colorMode = colorMode;
        this.localeScriptWasComputed = localeScriptWasComputed;
        this.localeNumberSystem = localeNumberSystem;
        Preconditions.checkState((this.language.length == 2 ? 1 : 0) != 0);
        Preconditions.checkState((this.country.length == 2 ? 1 : 0) != 0);
        Preconditions.checkState((this.density <= 65535 ? 1 : 0) != 0);
        Preconditions.checkState((this.screenWidth <= 65535 ? 1 : 0) != 0);
        Preconditions.checkState((this.screenHeight <= 65535 ? 1 : 0) != 0);
        Preconditions.checkState((this.smallestScreenWidthDp <= 65535 ? 1 : 0) != 0);
        Preconditions.checkState((this.screenWidthDp <= 65535 ? 1 : 0) != 0);
        Preconditions.checkState((this.screenHeightDp <= 65535 ? 1 : 0) != 0);
        Preconditions.checkState((this.localeScript.length == 4 ? 1 : 0) != 0);
        Preconditions.checkState((this.localeVariant.length == 8 ? 1 : 0) != 0);
        Preconditions.checkState((this.localeNumberSystem.length == 8 ? 1 : 0) != 0);
    }

    public /* synthetic */ ResTableConfig(int n, short s, short s2, byte[] byArray, byte[] byArray2, byte by, byte by2, int n2, byte by3, byte by4, byte by5, int n3, int n4, short s3, short s4, byte by6, byte by7, int n5, int n6, int n7, byte[] byArray3, byte[] byArray4, byte by8, byte by9, boolean bl, byte[] byArray5, int n8, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n8 & 1) != 0) {
            n = 0;
        }
        if ((n8 & 2) != 0) {
            s = 0;
        }
        if ((n8 & 4) != 0) {
            s2 = 0;
        }
        if ((n8 & 8) != 0) {
            byArray = new byte[2];
        }
        if ((n8 & 0x10) != 0) {
            byArray2 = new byte[2];
        }
        if ((n8 & 0x20) != 0) {
            by = 0;
        }
        if ((n8 & 0x40) != 0) {
            by2 = 0;
        }
        if ((n8 & 0x80) != 0) {
            n2 = 0;
        }
        if ((n8 & 0x100) != 0) {
            by3 = 0;
        }
        if ((n8 & 0x200) != 0) {
            by4 = 0;
        }
        if ((n8 & 0x400) != 0) {
            by5 = 0;
        }
        if ((n8 & 0x800) != 0) {
            n3 = 0;
        }
        if ((n8 & 0x1000) != 0) {
            n4 = 0;
        }
        if ((n8 & 0x2000) != 0) {
            s3 = 0;
        }
        if ((n8 & 0x4000) != 0) {
            s4 = 0;
        }
        if ((n8 & 0x8000) != 0) {
            by6 = 0;
        }
        if ((n8 & 0x10000) != 0) {
            by7 = 0;
        }
        if ((n8 & 0x20000) != 0) {
            n5 = 0;
        }
        if ((n8 & 0x40000) != 0) {
            n6 = 0;
        }
        if ((n8 & 0x80000) != 0) {
            n7 = 0;
        }
        if ((n8 & 0x100000) != 0) {
            byArray3 = new byte[4];
        }
        if ((n8 & 0x200000) != 0) {
            byArray4 = new byte[8];
        }
        if ((n8 & 0x400000) != 0) {
            by8 = 0;
        }
        if ((n8 & 0x800000) != 0) {
            by9 = 0;
        }
        if ((n8 & 0x1000000) != 0) {
            bl = false;
        }
        if ((n8 & 0x2000000) != 0) {
            byArray5 = new byte[8];
        }
        this(n, s, s2, byArray, byArray2, by, by2, n2, by3, by4, by5, n3, n4, s3, s4, by6, by7, n5, n6, n7, byArray3, byArray4, by8, by9, bl, byArray5);
    }

    public final int getSize() {
        return this.size;
    }

    public final void setSize(int n) {
        this.size = n;
    }

    public final short getMcc() {
        return this.mcc;
    }

    public final void setMcc(short s) {
        this.mcc = s;
    }

    public final short getMnc() {
        return this.mnc;
    }

    public final void setMnc(short s) {
        this.mnc = s;
    }

    @NotNull
    public final byte[] getLanguage() {
        return this.language;
    }

    @NotNull
    public final byte[] getCountry() {
        return this.country;
    }

    public final byte getOrientation() {
        return this.orientation;
    }

    public final void setOrientation(byte by) {
        this.orientation = by;
    }

    public final byte getTouchscreen() {
        return this.touchscreen;
    }

    public final void setTouchscreen(byte by) {
        this.touchscreen = by;
    }

    public final int getDensity() {
        return this.density;
    }

    public final void setDensity(int n) {
        this.density = n;
    }

    public final byte getKeyboard() {
        return this.keyboard;
    }

    public final void setKeyboard(byte by) {
        this.keyboard = by;
    }

    public final byte getNavigation() {
        return this.navigation;
    }

    public final void setNavigation(byte by) {
        this.navigation = by;
    }

    public final byte getInputFlags() {
        return this.inputFlags;
    }

    public final void setInputFlags(byte by) {
        this.inputFlags = by;
    }

    public final int getScreenWidth() {
        return this.screenWidth;
    }

    public final void setScreenWidth(int n) {
        this.screenWidth = n;
    }

    public final int getScreenHeight() {
        return this.screenHeight;
    }

    public final void setScreenHeight(int n) {
        this.screenHeight = n;
    }

    public final short getSdkVersion() {
        return this.sdkVersion;
    }

    public final void setSdkVersion(short s) {
        this.sdkVersion = s;
    }

    public final short getMinorVersion() {
        return this.minorVersion;
    }

    public final void setMinorVersion(short s) {
        this.minorVersion = s;
    }

    public final byte getScreenLayout() {
        return this.screenLayout;
    }

    public final void setScreenLayout(byte by) {
        this.screenLayout = by;
    }

    public final byte getUiMode() {
        return this.uiMode;
    }

    public final void setUiMode(byte by) {
        this.uiMode = by;
    }

    public final int getSmallestScreenWidthDp() {
        return this.smallestScreenWidthDp;
    }

    public final void setSmallestScreenWidthDp(int n) {
        this.smallestScreenWidthDp = n;
    }

    public final int getScreenWidthDp() {
        return this.screenWidthDp;
    }

    public final void setScreenWidthDp(int n) {
        this.screenWidthDp = n;
    }

    public final int getScreenHeightDp() {
        return this.screenHeightDp;
    }

    public final void setScreenHeightDp(int n) {
        this.screenHeightDp = n;
    }

    @NotNull
    public final byte[] getLocaleScript() {
        return this.localeScript;
    }

    @NotNull
    public final byte[] getLocaleVariant() {
        return this.localeVariant;
    }

    public final byte getScreenLayout2() {
        return this.screenLayout2;
    }

    public final void setScreenLayout2(byte by) {
        this.screenLayout2 = by;
    }

    public final byte getColorMode() {
        return this.colorMode;
    }

    public final void setColorMode(byte by) {
        this.colorMode = by;
    }

    public final boolean getLocaleScriptWasComputed() {
        return this.localeScriptWasComputed;
    }

    public final void setLocaleScriptWasComputed(boolean bl) {
        this.localeScriptWasComputed = bl;
    }

    @NotNull
    public final byte[] getLocaleNumberSystem() {
        return this.localeNumberSystem;
    }

    public ResTableConfig(int sizeFromDevice, int imsi, int locale, int screenType, int input, int screenSize, int version, int screenConfig, int screenSizeDp, @NotNull byte[] localeScript, @NotNull byte[] localeVariant, int screenConfig2, @NotNull byte[] localeNumberSystem) {
        Intrinsics.checkNotNullParameter((Object)localeScript, (String)"localeScript");
        Intrinsics.checkNotNullParameter((Object)localeVariant, (String)"localeVariant");
        Intrinsics.checkNotNullParameter((Object)localeNumberSystem, (String)"localeNumberSystem");
        this(UtilKt.deviceToHost(sizeFromDevice), Companion.mccFromImsi$aaptcompiler(imsi), Companion.mncFromImsi$aaptcompiler(imsi), Companion.languageFromLocale$aaptcompiler(locale), Companion.countryFromLocale$aaptcompiler(locale), Companion.orientationFromScreenType$aaptcompiler(screenType), Companion.touchscreenFromScreenType$aaptcompiler(screenType), Companion.densityFromScreenType$aaptcompiler(screenType), Companion.keyboardFromInput$aaptcompiler(input), Companion.navigationFromInput$aaptcompiler(input), Companion.inputFlagsFromInput$aaptcompiler(input), Companion.screenWidthFromScreenSize$aaptcompiler(screenSize), Companion.screenHeightFromScreenSize$aaptcompiler(screenSize), Companion.sdkVersionFromVersion$aaptcompiler(version), Companion.minorVersionFromVersion$aaptcompiler(version), Companion.screenLayoutFromScreenConfig$aaptcompiler(screenConfig), Companion.uiModeFromScreenConfig$aaptcompiler(screenConfig), Companion.smallestScreenWidthDpFromScreenConfig$aaptcompiler(screenConfig), Companion.screenWidthDpFromScreenSizeDp$aaptcompiler(screenSizeDp), Companion.screenHeightDpFromScreenSizeDp$aaptcompiler(screenSizeDp), localeScript, localeVariant, Companion.screenLayout2FromScreenConfig2$aaptcompiler(screenConfig2), Companion.colorModeFromScreenConfig2$aaptcompiler(screenConfig2), false, localeNumberSystem);
    }

    public ResTableConfig(@NotNull ResTableConfig other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int n = other.size;
        short s = other.mcc;
        short s2 = other.mnc;
        byte[] byArray = other.language;
        boolean bl = false;
        byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"java.util.Arrays.copyOf(this, size)");
        byArray = other.country;
        bl = false;
        byte[] byArray3 = Arrays.copyOf(byArray, byArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"java.util.Arrays.copyOf(this, size)");
        byte by = other.orientation;
        byte by2 = other.touchscreen;
        int n2 = other.density;
        byte by3 = other.keyboard;
        byte by4 = other.navigation;
        byte by5 = other.inputFlags;
        int n3 = other.screenWidth;
        int n4 = other.screenHeight;
        short s3 = other.sdkVersion;
        short s4 = other.minorVersion;
        byte by6 = other.screenLayout;
        byte by7 = other.uiMode;
        int n5 = other.smallestScreenWidthDp;
        int n6 = other.screenWidthDp;
        int n7 = other.screenHeightDp;
        byArray = other.localeScript;
        bl = false;
        byte[] byArray4 = Arrays.copyOf(byArray, byArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"java.util.Arrays.copyOf(this, size)");
        byArray = other.localeVariant;
        bl = false;
        byte[] byArray5 = Arrays.copyOf(byArray, byArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray5, (String)"java.util.Arrays.copyOf(this, size)");
        byte by8 = other.screenLayout2;
        byte by9 = other.colorMode;
        boolean bl2 = other.localeScriptWasComputed;
        byArray = other.localeNumberSystem;
        bl = false;
        byte[] byArray6 = Arrays.copyOf(byArray, byArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray6, (String)"java.util.Arrays.copyOf(this, size)");
        this(n, s, s2, byArray2, byArray3, by, by2, n2, by3, by4, by5, n3, n4, s3, s4, by6, by7, n5, n6, n7, byArray4, byArray5, by8, by9, bl2, byArray6);
    }

    public final int getImsi() {
        return UtilKt.hostToDevice(this.mcc & 0xFFFF | this.mnc << 16);
    }

    public final int getLocale() {
        return UtilKt.hostToDevice((this.language[0] & 0xFF) << 8 | this.language[1] & 0xFF | (this.country[0] & 0xFF) << 24 | (this.country[1] & 0xFF) << 16);
    }

    public final int getScreenType() {
        return UtilKt.hostToDevice(this.orientation & 0xFF | (this.touchscreen & 0xFF) << 8 | this.density << 16);
    }

    public final int getInput() {
        return UtilKt.hostToDevice(this.keyboard & 0xFF | (this.navigation & 0xFF) << 8 | (this.inputFlags & 0xFF) << 16 | 0);
    }

    public final int getScreenSize() {
        return UtilKt.hostToDevice(this.screenWidth & 0xFFFF | this.screenHeight << 16);
    }

    public final int getVersion() {
        return UtilKt.hostToDevice(this.sdkVersion & 0xFFFF | this.minorVersion << 16);
    }

    public final int getScreenConfig() {
        return UtilKt.hostToDevice(this.screenLayout & 0xFF | (this.uiMode & 0xFF) << 8 | this.smallestScreenWidthDp << 16);
    }

    public final int getScreenSizeDp() {
        return UtilKt.hostToDevice(this.screenWidthDp & 0xFFFF | this.screenHeightDp << 16);
    }

    public final int getScreenConfig2() {
        return UtilKt.hostToDevice(this.screenLayout2 & 0xFF | (this.colorMode & 0xFF) << 8 | 0);
    }

    public final byte layoutSize() {
        return (byte)(this.screenLayout & 0xF);
    }

    public final byte layoutLong() {
        return (byte)(this.screenLayout & 0x30);
    }

    public final byte uiModeType() {
        return (byte)(this.uiMode & 0xF);
    }

    public final byte uiModeNight() {
        return (byte)(this.uiMode & 0x30);
    }

    public final byte layoutRound() {
        return (byte)(this.screenLayout2 & 3);
    }

    public final byte wideColorGamut() {
        return (byte)(this.colorMode & 3);
    }

    public final byte hdr() {
        return (byte)(this.colorMode & 0xC);
    }

    @NotNull
    public String toString() {
        byte navhidden;
        boolean bl;
        byte keysHidden;
        int n;
        int nightMode;
        byte uiModeType;
        byte by;
        byte hdr;
        byte wideGamut;
        byte screenRound;
        byte screenLong;
        byte screenSizeFlag;
        StringBuilder result = new StringBuilder();
        if (UtilKt.isTruthy(this.mcc)) {
            result.append("mcc" + this.mcc + '-');
        }
        if (UtilKt.isTruthy(this.mnc)) {
            result.append("mnc" + this.mnc + '-');
        }
        this.appendDirLocale(result);
        byte layoutDir = (byte)(this.screenLayout & 0xC0);
        if (layoutDir != 0) {
            byte by2 = layoutDir;
            result.append(by2 == 64 ? "ldltr" : (by2 == -128 ? "ldrtl" : Intrinsics.stringPlus((String)"layoutDir=", (Object)layoutDir)));
            result.append("-");
        }
        if (UtilKt.isTruthy(this.smallestScreenWidthDp)) {
            result.append("sw" + this.smallestScreenWidthDp + "dp-");
        }
        if (UtilKt.isTruthy(this.screenWidthDp)) {
            result.append("" + 'w' + this.screenWidthDp + "dp-");
        }
        if (UtilKt.isTruthy(this.screenHeightDp)) {
            result.append("" + 'h' + this.screenHeightDp + "dp-");
        }
        if ((screenSizeFlag = (byte)(this.screenLayout & 0xF)) != 0) {
            byte by3 = screenSizeFlag;
            result.append(by3 == 1 ? "small" : (by3 == 2 ? "normal" : (by3 == 3 ? "large" : (by3 == 4 ? "xlarge" : Intrinsics.stringPlus((String)"screenLayoutSize=", (Object)screenSizeFlag)))));
            result.append("-");
        }
        if ((screenLong = (byte)(this.screenLayout & 0x30)) != 0) {
            byte by4 = screenLong;
            result.append(by4 == 32 ? "long" : (by4 == 16 ? "notlong" : Intrinsics.stringPlus((String)"screenLayoutLong=", (Object)screenLong)));
            result.append("-");
        }
        if ((screenRound = (byte)(this.screenLayout2 & 3)) != 0) {
            byte by5 = screenRound;
            result.append(by5 == 2 ? "round" : (by5 == 1 ? "notround" : Intrinsics.stringPlus((String)"screenRound=", (Object)screenRound)));
            result.append("-");
        }
        if ((wideGamut = (byte)(this.colorMode & 3)) != 0) {
            byte by6 = wideGamut;
            result.append(by6 == 2 ? "widecg" : (by6 == 1 ? "nowidecg" : Intrinsics.stringPlus((String)"wideColorGamut=", (Object)wideGamut)));
            result.append("-");
        }
        if ((hdr = (byte)(this.colorMode & 0xC)) != 0) {
            by = hdr;
            result.append(by == 4 ? "lowdr" : (by == 8 ? "highdr" : Intrinsics.stringPlus((String)"hdr=", (Object)hdr)));
            result.append("-");
        }
        if (this.orientation != 0) {
            by = this.orientation;
            result.append(by == 1 ? "port" : (by == 2 ? "land" : (by == 3 ? "square" : Intrinsics.stringPlus((String)"orientation=", (Object)this.orientation))));
            result.append("-");
        }
        if ((uiModeType = (byte)(this.uiMode & 0xF)) != 0) {
            byte by7 = uiModeType;
            result.append(by7 == 2 ? "desk" : (by7 == 3 ? "car" : (by7 == 4 ? "television" : (by7 == 5 ? "appliance" : (by7 == 6 ? "watch" : (by7 == 7 ? "vrheadset" : Intrinsics.stringPlus((String)"uiModeType=", (Object)uiModeType)))))));
            result.append("-");
        }
        if ((nightMode = (int)(this.uiMode & 0x30)) != 0) {
            n = nightMode;
            result.append(n == 32 ? "night" : (n == 16 ? "notnight" : Intrinsics.stringPlus((String)"uiModeNight=", (Object)((byte)nightMode))));
            result.append("-");
        }
        if (this.density != 0) {
            String string;
            n = this.density;
            switch (n) {
                case 120: {
                    string = "ldpi";
                    break;
                }
                case 160: {
                    string = "mdpi";
                    break;
                }
                case 213: {
                    string = "tvdpi";
                    break;
                }
                case 240: {
                    string = "hdpi";
                    break;
                }
                case 320: {
                    string = "xhdpi";
                    break;
                }
                case 480: {
                    string = "xxhdpi";
                    break;
                }
                case 640: {
                    string = "xxxhdpi";
                    break;
                }
                case 65535: {
                    string = "nodpi";
                    break;
                }
                case 65534: {
                    string = "anydpi";
                    break;
                }
                default: {
                    string = this.density + "dpi";
                }
            }
            result.append(string);
            result.append("-");
        }
        if (this.touchscreen != 0) {
            n = this.touchscreen;
            result.append(n == 1 ? "notouch" : (n == 3 ? "finger" : (n == 2 ? "stylus" : Intrinsics.stringPlus((String)"touchscreen=", (Object)this.touchscreen))));
            result.append("-");
        }
        if (UtilKt.isTruthy(keysHidden = (byte)(this.inputFlags & 3))) {
            byte by8 = keysHidden;
            String keysString = by8 == 1 ? "keysexposed" : (by8 == 2 ? "keyshidden" : (by8 == 3 ? "keyssoft" : ""));
            CharSequence charSequence = keysString;
            bl = false;
            if (charSequence.length() > 0) {
                result.append(Intrinsics.stringPlus((String)keysString, (Object)"-"));
            }
        }
        if (this.keyboard != 0) {
            byte keysString = this.keyboard;
            result.append(keysString == 1 ? "nokeys" : (keysString == 2 ? "qwerty" : (keysString == 3 ? "12key" : Intrinsics.stringPlus((String)"keyboard=", (Object)this.keyboard))));
            result.append("-");
        }
        if (UtilKt.isTruthy(navhidden = (byte)(this.inputFlags & 0xC))) {
            byte by9 = navhidden;
            result.append(by9 == 4 ? "navexposed" : (by9 == 8 ? "navhidden" : Intrinsics.stringPlus((String)"inputFlagsNavHidden=", (Object)navhidden)));
            result.append("-");
        }
        if (this.navigation != 0) {
            byte by10 = this.navigation;
            result.append(by10 == 1 ? "nonav" : (by10 == 2 ? "dpad" : (by10 == 3 ? "trackball" : (by10 == 4 ? "wheel" : Intrinsics.stringPlus((String)"navigation=", (Object)this.navigation)))));
            result.append("-");
        }
        if (UtilKt.isTruthy(this.getScreenSize())) {
            result.append("" + this.screenWidth + 'x' + this.screenHeight + '-');
        }
        if (UtilKt.isTruthy(this.getVersion())) {
            result.append(Intrinsics.stringPlus((String)"v", (Object)this.sdkVersion));
            if (UtilKt.isTruthy(this.minorVersion)) {
                result.append(Intrinsics.stringPlus((String)".", (Object)this.minorVersion));
            }
            result.append("-");
        }
        CharSequence charSequence = result;
        bl = false;
        if (charSequence.length() == 0) {
            return "DEFAULT";
        }
        charSequence = result.substring(0, result.length() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"result.substring(0, result.length - 1)");
        return charSequence;
    }

    private final void appendDirLocale(StringBuilder result) {
        boolean bl;
        int n;
        byte[] byArray;
        boolean scriptProvided;
        if (!UtilKt.isTruthy(this.language[0])) {
            return;
        }
        boolean bl2 = scriptProvided = UtilKt.isTruthy(this.localeScript[0]) && !this.localeScriptWasComputed;
        if (!(scriptProvided || UtilKt.isTruthy(this.localeVariant[0]) || UtilKt.isTruthy(this.localeNumberSystem[0]))) {
            result.append(Intrinsics.stringPlus((String)this.unpackLanguage(), (Object)"-"));
            if (UtilKt.isTruthy(this.country[0])) {
                result.append('r' + this.unpackRegion() + '-');
            }
            return;
        }
        result.append(Intrinsics.stringPlus((String)"b+", (Object)this.unpackLanguage()));
        if (scriptProvided) {
            byte[] byArray2 = this.localeScript;
            boolean bl3 = false;
            result.append(Intrinsics.stringPlus((String)"+", (Object)new String(byArray2, Charsets.UTF_8)));
        }
        if (UtilKt.isTruthy(this.country[0])) {
            result.append(Intrinsics.stringPlus((String)"+", (Object)this.unpackRegion()));
        }
        if (UtilKt.isTruthy(this.localeVariant[0])) {
            String string;
            int variantTerminator = ArraysKt.indexOf((byte[])this.localeVariant, (byte)0);
            if (variantTerminator == -1) {
                byArray = this.localeVariant;
                n = 0;
                string = new String(byArray, Charsets.UTF_8);
            } else {
                byArray = this.localeVariant;
                n = 0;
                bl = false;
                string = new String(byArray, n, variantTerminator, Charsets.UTF_8);
            }
            String variantString = string;
            result.append(Intrinsics.stringPlus((String)"+", (Object)variantString));
        }
        if (UtilKt.isTruthy(this.localeNumberSystem[0])) {
            String string;
            int numberSystemTerminator = ArraysKt.indexOf((byte[])this.localeNumberSystem, (byte)0);
            if (numberSystemTerminator == -1) {
                byArray = this.localeNumberSystem;
                n = 0;
                string = new String(byArray, Charsets.UTF_8);
            } else {
                byArray = this.localeNumberSystem;
                n = 0;
                bl = false;
                string = new String(byArray, n, numberSystemTerminator, Charsets.UTF_8);
            }
            String numberSystemString = string;
            result.append(Intrinsics.stringPlus((String)"+u+nu+", (Object)numberSystemString));
        }
        result.append("-");
    }

    @NotNull
    public final String unpackLanguage() {
        return Companion.unpackLanguageOrRegion$aaptcompiler(this.language, (byte)97);
    }

    @NotNull
    public final String unpackRegion() {
        return Companion.unpackLanguageOrRegion$aaptcompiler(this.country, (byte)48);
    }

    public final void packLanguage(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ArraysKt.copyInto((byte[])Companion.packLanguageOrRegion$aaptcompiler(value, (byte)97), (byte[])this.language, (int)0, (int)0, (int)2);
    }

    public final void packRegion(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ArraysKt.copyInto((byte[])Companion.packLanguageOrRegion$aaptcompiler(value, (byte)48), (byte[])this.country, (int)0, (int)0, (int)2);
    }

    public final int diff(@NotNull ResTableConfig other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int result = 0;
        if (this.mcc != other.mcc) {
            result |= 1;
        }
        if (this.mnc != other.mnc) {
            result |= 2;
        }
        if (this.orientation != other.orientation) {
            result |= 0x80;
        }
        if (this.density != other.density) {
            result |= 0x100;
        }
        if (this.touchscreen != other.touchscreen) {
            result |= 8;
        }
        if ((this.inputFlags & 0xF) != (other.inputFlags & 0xF)) {
            result |= 0x20;
        }
        if (this.keyboard != other.keyboard) {
            result |= 0x10;
        }
        if (this.navigation != other.navigation) {
            result |= 0x40;
        }
        if (this.getScreenSize() != other.getScreenSize()) {
            result |= 0x200;
        }
        if (this.getVersion() != other.getVersion()) {
            result |= 0x400;
        }
        if ((this.screenLayout & 0xC0) != (other.screenLayout & 0xC0)) {
            result |= 0x4000;
        }
        if ((this.screenLayout & 0xFFFFFF3F) != (other.screenLayout & 0xFFFFFF3F)) {
            result |= 0x800;
        }
        if ((this.screenLayout2 & 3) != (other.screenLayout2 & 3)) {
            result |= 0x8000;
        }
        if ((this.colorMode & 0xF) != (other.colorMode & 0xF)) {
            result |= 0x10000;
        }
        if (this.uiMode != other.uiMode) {
            result |= 0x1000;
        }
        if (this.smallestScreenWidthDp != other.smallestScreenWidthDp) {
            result |= 0x2000;
        }
        if (this.getScreenSizeDp() != other.getScreenSizeDp()) {
            result |= 0x200;
        }
        if (this.compareLocales(other) != 0) {
            result |= 4;
        }
        return result;
    }

    @Override
    public int compareTo(@NotNull ResTableConfig other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int imsi = UtilKt.deviceToHost(this.getImsi());
        int oImsi = UtilKt.deviceToHost(other.getImsi());
        if (imsi > oImsi) {
            return 1;
        }
        if (oImsi > imsi) {
            return -1;
        }
        int localeDiff = this.compareLocales(other);
        if (localeDiff != 0) {
            return localeDiff;
        }
        int screenType = UtilKt.deviceToHost(this.getScreenType());
        int oScreenType = UtilKt.deviceToHost(other.getScreenType());
        if (screenType > oScreenType) {
            return 1;
        }
        if (oScreenType > screenType) {
            return -1;
        }
        int input = UtilKt.deviceToHost(this.getInput());
        int oInput = UtilKt.deviceToHost(other.getInput());
        if (input > oInput) {
            return 1;
        }
        if (oInput > input) {
            return -1;
        }
        int screenSize = UtilKt.deviceToHost(this.getScreenSize());
        int oScreenSize = UtilKt.deviceToHost(other.getScreenSize());
        if (screenSize > oScreenSize) {
            return 1;
        }
        if (oScreenSize > screenSize) {
            return -1;
        }
        int version = UtilKt.deviceToHost(this.getVersion());
        int oVersion = UtilKt.deviceToHost(other.getVersion());
        if (version > oVersion) {
            return 1;
        }
        if (oVersion > version) {
            return -1;
        }
        if (this.screenLayout > other.screenLayout) {
            return 1;
        }
        if (other.screenLayout > this.screenLayout) {
            return -1;
        }
        if (this.screenLayout2 > other.screenLayout2) {
            return 1;
        }
        if (other.screenLayout2 > this.screenLayout2) {
            return -1;
        }
        if (this.colorMode > other.colorMode) {
            return 1;
        }
        if (other.colorMode > this.colorMode) {
            return -1;
        }
        if (this.uiMode > other.uiMode) {
            return 1;
        }
        if (other.uiMode > this.uiMode) {
            return -1;
        }
        if (this.smallestScreenWidthDp > other.smallestScreenWidthDp) {
            return 1;
        }
        if (other.smallestScreenWidthDp > this.smallestScreenWidthDp) {
            return -1;
        }
        int screenSizeDp = UtilKt.deviceToHost(this.getScreenSizeDp());
        int oScreenSizeDp = UtilKt.deviceToHost(other.getScreenSizeDp());
        if (screenSizeDp > oScreenSizeDp) {
            return 1;
        }
        if (oScreenSizeDp > screenSizeDp) {
            return -1;
        }
        return 0;
    }

    public final int compareLocales(@NotNull ResTableConfig other) {
        byte[] oScript;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int locale = UtilKt.deviceToHost(this.getLocale());
        int oLocale = UtilKt.deviceToHost(other.getLocale());
        if (locale > oLocale) {
            return 1;
        }
        if (oLocale > locale) {
            return -1;
        }
        byte[] emptyScript = new byte[4];
        byte[] script = this.localeScriptWasComputed ? emptyScript : this.localeScript;
        int scriptDiff = Companion.compareArrays$aaptcompiler(script, oScript = other.localeScriptWasComputed ? emptyScript : other.localeScript);
        if (scriptDiff != 0) {
            return scriptDiff;
        }
        int variantDiff = Companion.compareArrays$aaptcompiler(this.localeVariant, other.localeVariant);
        if (variantDiff != 0) {
            return variantDiff;
        }
        int numberDiff = Companion.compareArrays$aaptcompiler(this.localeNumberSystem, other.localeNumberSystem);
        return numberDiff;
    }

    public final boolean isMoreSpecificThan(@NotNull ResTableConfig other) {
        block36: {
            block35: {
                Intrinsics.checkNotNullParameter((Object)other, (String)"other");
                if (UtilKt.isTruthy(this.getImsi())) break block35;
                if (!UtilKt.isTruthy(other.getImsi())) break block36;
            }
            if (this.mcc != other.mcc) {
                return UtilKt.isTruthy(this.mcc);
            }
            if (this.mnc != other.mnc) {
                return UtilKt.isTruthy(this.mnc);
            }
        }
        int localeDiff = this.isLocaleMoreSpecificThan(other);
        if (localeDiff < 0) {
            return false;
        }
        if (localeDiff > 0) {
            return true;
        }
        if ((UtilKt.isTruthy(this.screenLayout) || UtilKt.isTruthy(other.screenLayout)) && (this.screenLayout & 0xC0) != (other.screenLayout & 0xC0)) {
            return UtilKt.isTruthy(this.screenLayout & 0xC0);
        }
        if ((UtilKt.isTruthy(this.smallestScreenWidthDp) || UtilKt.isTruthy(other.smallestScreenWidthDp)) && this.smallestScreenWidthDp != other.smallestScreenWidthDp) {
            return UtilKt.isTruthy(this.smallestScreenWidthDp);
        }
        if (UtilKt.isTruthy(this.getScreenSizeDp()) || UtilKt.isTruthy(other.getScreenSizeDp())) {
            if (this.screenWidthDp != other.screenWidthDp) {
                return UtilKt.isTruthy(this.screenWidthDp);
            }
            if (this.screenHeightDp != other.screenHeightDp) {
                return UtilKt.isTruthy(this.screenHeightDp);
            }
        }
        if (UtilKt.isTruthy(this.screenLayout) || UtilKt.isTruthy(other.screenLayout)) {
            if ((this.screenLayout & 0xF) != (other.screenLayout & 0xF)) {
                return UtilKt.isTruthy(this.screenLayout & 0xF);
            }
            if ((this.screenLayout & 0x30) != (other.screenLayout & 0x30)) {
                return UtilKt.isTruthy(this.screenLayout & 0x30);
            }
        }
        if ((UtilKt.isTruthy(this.screenLayout2) || UtilKt.isTruthy(other.screenLayout2)) && (this.screenLayout2 & 3) != (other.screenLayout2 & 3)) {
            return UtilKt.isTruthy(this.screenLayout2 & 3);
        }
        if (UtilKt.isTruthy(this.colorMode) || UtilKt.isTruthy(other.colorMode)) {
            if ((this.colorMode & 0xC) != (other.colorMode & 0xC)) {
                return UtilKt.isTruthy(this.colorMode & 0xC);
            }
            if ((this.colorMode & 3) != (other.colorMode & 3)) {
                return UtilKt.isTruthy(this.colorMode & 3);
            }
        }
        if (this.orientation != other.orientation) {
            return UtilKt.isTruthy(this.orientation);
        }
        if (UtilKt.isTruthy(this.uiMode) || UtilKt.isTruthy(other.uiMode)) {
            if ((this.uiMode & 0xF) != (other.uiMode & 0xF)) {
                return UtilKt.isTruthy(this.uiMode & 0xF);
            }
            if ((this.uiMode & 0x30) != (other.uiMode & 0x30)) {
                return UtilKt.isTruthy(this.uiMode & 0x30);
            }
        }
        if (this.touchscreen != other.touchscreen) {
            return UtilKt.isTruthy(this.touchscreen);
        }
        if (UtilKt.isTruthy(this.getInput()) || UtilKt.isTruthy(other.getInput())) {
            if ((this.inputFlags & 3) != (other.inputFlags & 3)) {
                return UtilKt.isTruthy(this.inputFlags & 3);
            }
            if ((this.inputFlags & 0xC) != (other.inputFlags & 0xC)) {
                return UtilKt.isTruthy(this.inputFlags & 0xC);
            }
            if (this.keyboard != other.keyboard) {
                return UtilKt.isTruthy(this.keyboard);
            }
            if (this.navigation != other.navigation) {
                return UtilKt.isTruthy(this.navigation);
            }
        }
        if (UtilKt.isTruthy(this.getScreenSize()) || UtilKt.isTruthy(other.getScreenSize())) {
            if (this.screenWidth != other.screenWidth) {
                return UtilKt.isTruthy(this.screenWidth);
            }
            if (this.screenHeight != other.screenHeight) {
                return UtilKt.isTruthy(this.screenHeight);
            }
        }
        if (UtilKt.isTruthy(this.getVersion()) || UtilKt.isTruthy(other.getVersion())) {
            if (this.sdkVersion != other.sdkVersion) {
                return UtilKt.isTruthy(this.sdkVersion);
            }
            if (this.minorVersion != other.minorVersion) {
                return UtilKt.isTruthy(this.minorVersion);
            }
        }
        return false;
    }

    public final int isLocaleMoreSpecificThan(@NotNull ResTableConfig other) {
        block11: {
            block10: {
                Intrinsics.checkNotNullParameter((Object)other, (String)"other");
                if (UtilKt.isTruthy(this.getLocale())) break block10;
                if (!UtilKt.isTruthy(other.getLocale())) break block11;
            }
            if (this.language[0] != other.language[0]) {
                if (!UtilKt.isTruthy(this.language[0])) {
                    return -1;
                }
                if (!UtilKt.isTruthy(other.language[0])) {
                    return 1;
                }
            } else if (this.country[0] != other.country[0]) {
                if (!UtilKt.isTruthy(this.country[0])) {
                    return -1;
                }
                if (!UtilKt.isTruthy(other.country[0])) {
                    return 1;
                }
            }
        }
        return this.getImportanceScoreOfLocale() - other.getImportanceScoreOfLocale();
    }

    public final int getImportanceScoreOfLocale() {
        return (this.localeVariant[0] != 0 ? 4 : 0) + (this.localeScript[0] != 0 && !this.localeScriptWasComputed ? 2 : 0) + (this.localeNumberSystem[0] != 0 ? 1 : 0);
    }

    public final boolean isBetterThan(@NotNull ResTableConfig other, @Nullable ResTableConfig requested) {
        int otherNight;
        int otherRound;
        int myRound;
        int otherDelta;
        int otherLayoutDir;
        int myLayoutDir;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ResTableConfig resTableConfig = requested;
        if (resTableConfig == null) {
            return this.isMoreSpecificThan(other);
        }
        if (UtilKt.isTruthy(this.getImsi()) || UtilKt.isTruthy(other.getImsi())) {
            if (this.mcc != other.mcc && UtilKt.isTruthy(requested.mcc)) {
                return UtilKt.isTruthy(this.mcc);
            }
            if (this.mnc != other.mnc && UtilKt.isTruthy(requested.mnc)) {
                return UtilKt.isTruthy(this.mnc);
            }
        }
        if (this.isLocaleBetterThan(other, requested)) {
            return true;
        }
        if ((UtilKt.isTruthy(this.screenLayout) || UtilKt.isTruthy(other.screenLayout)) && (myLayoutDir = this.screenLayout & 0xC0) != (otherLayoutDir = other.screenLayout & 0xC0) && UtilKt.isTruthy(requested.screenLayout & 0xC0)) {
            return myLayoutDir > otherLayoutDir;
        }
        if ((UtilKt.isTruthy(this.smallestScreenWidthDp) || UtilKt.isTruthy(other.smallestScreenWidthDp)) && this.smallestScreenWidthDp != other.smallestScreenWidthDp) {
            return this.smallestScreenWidthDp > other.smallestScreenWidthDp;
        }
        if (UtilKt.isTruthy(this.getScreenSizeDp()) || UtilKt.isTruthy(other.getScreenSizeDp())) {
            int myDelta = 0;
            otherDelta = 0;
            if (UtilKt.isTruthy(requested.screenWidthDp)) {
                myDelta += requested.screenWidthDp - this.screenWidthDp;
                otherDelta += requested.screenWidthDp - other.screenWidthDp;
            }
            if (UtilKt.isTruthy(requested.screenHeightDp)) {
                myDelta += requested.screenHeightDp - this.screenHeightDp;
                otherDelta += requested.screenHeightDp - other.screenHeightDp;
            }
            if (myDelta != otherDelta) {
                return myDelta < otherDelta;
            }
        }
        if (UtilKt.isTruthy(this.screenLayout) || UtilKt.isTruthy(other.screenLayout)) {
            int mySL = this.screenLayout & 0xF;
            int otherSL = other.screenLayout & 0xF;
            if (mySL != otherSL && UtilKt.isTruthy(requested.screenLayout & 0xF)) {
                int fixedMySL = 0;
                int fixedOtherSL = 0;
                if ((requested.screenLayout & 0xF) > 2) {
                    fixedMySL = mySL == 0 ? 2 : mySL;
                    fixedOtherSL = otherSL == 0 ? 2 : otherSL;
                } else {
                    fixedMySL = mySL;
                    fixedOtherSL = otherSL;
                }
                return fixedMySL == fixedOtherSL ? mySL != 0 : fixedMySL > fixedOtherSL;
            }
            int myLong = this.screenLayout & 0x30;
            int otherLong = other.screenLayout & 0x30;
            if (myLong != otherLong && UtilKt.isTruthy(requested.screenLayout & 0x30)) {
                return UtilKt.isTruthy(myLong);
            }
        }
        if ((UtilKt.isTruthy(this.screenLayout2) || UtilKt.isTruthy(other.screenLayout2)) && (myRound = this.screenLayout2 & 3) != (otherRound = other.screenLayout2 & 3) && UtilKt.isTruthy(requested.screenLayout2 & 3)) {
            return UtilKt.isTruthy(myRound);
        }
        if (UtilKt.isTruthy(this.colorMode) || UtilKt.isTruthy(other.colorMode)) {
            int myGamut = this.colorMode & 3;
            int oGamut = other.colorMode & 3;
            if (myGamut != oGamut && UtilKt.isTruthy(requested.colorMode & 3)) {
                return UtilKt.isTruthy(myGamut);
            }
            int myHdr = this.colorMode & 0xC;
            int oHdr = other.colorMode & 0xC;
            if (myHdr != oHdr && UtilKt.isTruthy(requested.colorMode & 0xC)) {
                return UtilKt.isTruthy(myHdr);
            }
        }
        if (this.orientation != other.orientation && UtilKt.isTruthy(requested.orientation)) {
            return UtilKt.isTruthy(this.orientation);
        }
        if (UtilKt.isTruthy(this.uiMode) || UtilKt.isTruthy(other.uiMode)) {
            int myType = this.uiMode & 0xF;
            int otherType = other.uiMode & 0xF;
            if (myType != otherType && UtilKt.isTruthy(requested.uiMode & 0xF)) {
                return UtilKt.isTruthy(myType);
            }
            int myNight = this.uiMode & 0x30;
            otherNight = other.uiMode & 0x30;
            if (myNight != otherNight && UtilKt.isTruthy(requested.uiMode & 0x30)) {
                return UtilKt.isTruthy(myNight);
            }
        }
        if (UtilKt.isTruthy(this.getScreenType()) || UtilKt.isTruthy(other.getScreenType())) {
            if (this.density != other.density) {
                int n;
                int myDensity = UtilKt.isTruthy(this.density) ? this.density : 160;
                int otherDensity = UtilKt.isTruthy(other.density) ? other.density : 160;
                if (myDensity == 65534) {
                    return true;
                }
                if (otherDensity == 65534) {
                    return false;
                }
                otherNight = requested.density;
                switch (otherNight) {
                    case 0: 
                    case 65534: {
                        n = 160;
                        break;
                    }
                    default: {
                        n = requested.density;
                    }
                }
                int requestedDensity = n;
                int high = Math.max(myDensity, otherDensity);
                int low = Math.min(myDensity, otherDensity);
                boolean iAmBigger = high == myDensity;
                return requestedDensity >= high ? iAmBigger : (requestedDensity <= low ? !iAmBigger : ((2 * low - requestedDensity) * high > requestedDensity * requestedDensity ? !iAmBigger : iAmBigger));
            }
            if (this.touchscreen != other.touchscreen && UtilKt.isTruthy(requested.touchscreen)) {
                return UtilKt.isTruthy(this.touchscreen);
            }
        }
        if (UtilKt.isTruthy(this.getInput()) || UtilKt.isTruthy(other.getInput())) {
            int otherNavHidden;
            int navHidden;
            int requestedKeysHidden;
            int keysHidden = this.inputFlags & 3;
            int otherKeysHidden = other.inputFlags & 3;
            if (keysHidden != otherKeysHidden && UtilKt.isTruthy(requestedKeysHidden = requested.inputFlags & 3)) {
                if (!UtilKt.isTruthy(keysHidden)) {
                    return false;
                }
                if (!UtilKt.isTruthy(otherKeysHidden)) {
                    return true;
                }
                if (requestedKeysHidden == keysHidden) {
                    return true;
                }
                if (requestedKeysHidden == otherKeysHidden) {
                    return false;
                }
            }
            if ((navHidden = this.inputFlags & 0xC) != (otherNavHidden = other.inputFlags & 0xC) && UtilKt.isTruthy(requested.inputFlags & 0xC)) {
                return UtilKt.isTruthy(navHidden);
            }
            if (this.keyboard != other.keyboard && UtilKt.isTruthy(requested.keyboard)) {
                return UtilKt.isTruthy(this.keyboard);
            }
            if (this.navigation != other.navigation && UtilKt.isTruthy(requested.navigation)) {
                return UtilKt.isTruthy(this.navigation);
            }
        }
        if (UtilKt.isTruthy(this.getScreenSize()) || UtilKt.isTruthy(other.getScreenSize())) {
            int myDelta = 0;
            otherDelta = 0;
            if (UtilKt.isTruthy(requested.screenWidth)) {
                myDelta += requested.screenWidth - this.screenWidth;
                otherDelta += requested.screenWidth - other.screenWidth;
            }
            if (UtilKt.isTruthy(requested.screenHeight)) {
                myDelta += requested.screenHeight - this.screenHeight;
                otherDelta += requested.screenHeight - other.screenHeight;
            }
            if (myDelta != otherDelta) {
                return myDelta < otherDelta;
            }
        }
        if (UtilKt.isTruthy(this.getVersion()) || UtilKt.isTruthy(other.getVersion())) {
            if (this.sdkVersion != other.sdkVersion && UtilKt.isTruthy(requested.sdkVersion)) {
                return this.sdkVersion > other.sdkVersion;
            }
            if (this.minorVersion != other.minorVersion && UtilKt.isTruthy(requested.minorVersion)) {
                return UtilKt.isTruthy(this.minorVersion);
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isLocaleBetterThan(@NotNull ResTableConfig other, @NotNull ResTableConfig requested) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)requested, (String)"requested");
        if (requested.getLocale() == 0) {
            return false;
        }
        if (this.getLocale() == 0 && other.getLocale() == 0) {
            return false;
        }
        if (!Companion.langsAreEquivalent$aaptcompiler(this.language, other.language)) {
            byte[] byArray = requested.language;
            byte[] byArray2 = ENGLISH;
            boolean bl = false;
            if (!Arrays.equals(byArray, byArray2)) return UtilKt.isTruthy(this.language[0]);
            byArray = requested.country;
            byArray2 = UNITED_STATES;
            bl = false;
            if (Arrays.equals(byArray, byArray2)) {
                if (UtilKt.isTruthy(this.language[0])) {
                    if (this.country[0] == 0) return true;
                    byArray = this.country;
                    byArray2 = UNITED_STATES;
                    bl = false;
                    if (!Arrays.equals(byArray, byArray2)) return false;
                    return true;
                }
                if (other.country[0] == 0) return false;
                byArray = other.country;
                byArray2 = UNITED_STATES;
                bl = false;
                if (Arrays.equals(byArray, byArray2)) return false;
                return true;
            }
            if (!LocaleData.localeDataIsCloseToUsEnglish(requested.country)) return UtilKt.isTruthy(this.language[0]);
            if (!UtilKt.isTruthy(this.language[0])) {
                if (LocaleData.localeDataIsCloseToUsEnglish(other.country)) return false;
                return true;
            }
            boolean bl2 = LocaleData.localeDataIsCloseToUsEnglish(this.country);
            return bl2;
        }
        byte[] byArray = requested.localeScript;
        boolean bl = false;
        int regionComparision = LocaleData.localeDataCompareRegions(this.country, other.country, requested.language, new String(byArray, Charsets.UTF_8), requested.country);
        if (regionComparision != 0) {
            if (regionComparision <= 0) return false;
            return true;
        }
        byte[] byArray3 = this.localeVariant;
        byte[] byArray4 = requested.localeVariant;
        boolean bl3 = false;
        boolean localeVariantMatches = Arrays.equals(byArray3, byArray4);
        byArray4 = other.localeVariant;
        byte[] byArray5 = requested.localeVariant;
        boolean bl4 = false;
        boolean otherVariantMatches = Arrays.equals(byArray4, byArray5);
        if (localeVariantMatches != otherVariantMatches) {
            return localeVariantMatches;
        }
        byArray5 = this.localeNumberSystem;
        byte[] byArray6 = requested.localeNumberSystem;
        boolean bl5 = false;
        boolean localeNumberingMatches = Arrays.equals(byArray5, byArray6);
        byArray6 = other.localeNumberSystem;
        byte[] byArray7 = requested.localeNumberSystem;
        boolean bl6 = false;
        boolean otherNumberingMatches = Arrays.equals(byArray6, byArray7);
        if (localeNumberingMatches != otherNumberingMatches) {
            return localeNumberingMatches;
        }
        byArray6 = this.language;
        byArray7 = requested.language;
        bl6 = false;
        if (!Arrays.equals(byArray6, byArray7)) return false;
        byArray6 = other.language;
        byArray7 = requested.language;
        bl6 = false;
        if (Arrays.equals(byArray6, byArray7)) return false;
        return true;
    }

    public final boolean match(@NotNull ResTableConfig settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        if (UtilKt.isTruthy(this.mcc) && this.mcc != settings.mcc) {
            return false;
        }
        if (UtilKt.isTruthy(this.mnc) && this.mnc != settings.mnc) {
            return false;
        }
        if (UtilKt.isTruthy(this.getLocale())) {
            byte[] byArray;
            byte[] byArray2;
            if (!Companion.langsAreEquivalent$aaptcompiler(this.language, settings.language)) {
                return false;
            }
            boolean countriesMustMatch = false;
            byte[] computedScript = new byte[4];
            byte[] script = null;
            if (!UtilKt.isTruthy(settings.localeScript[0])) {
                countriesMustMatch = true;
            } else if (!UtilKt.isTruthy(this.localeScript[0]) && !this.localeScriptWasComputed) {
                LocaleData.localeDataComputeScript(computedScript, this.language, this.country);
                if (!UtilKt.isTruthy(computedScript[0])) {
                    countriesMustMatch = true;
                } else {
                    script = computedScript;
                }
            } else {
                script = this.localeScript;
            }
            if (countriesMustMatch) {
                if (UtilKt.isTruthy(this.country[0])) {
                    byArray2 = this.country;
                    byArray = settings.country;
                    boolean bl = false;
                    if (!Arrays.equals(byArray2, byArray)) {
                        return false;
                    }
                }
            } else {
                boolean bl;
                byArray2 = script;
                if (byArray2 == null) {
                    bl = false;
                } else {
                    byArray = byArray2;
                    byte[] byArray3 = this.localeScript;
                    boolean bl2 = false;
                    bl = Arrays.equals(byArray, byArray3);
                }
                if (!bl) {
                    return false;
                }
            }
        }
        if (UtilKt.isTruthy(this.getScreenConfig())) {
            int layoutDir = this.screenLayout & 0xC0;
            int setLayoutDir = settings.screenLayout & 0xC0;
            if (layoutDir != 0 && layoutDir != setLayoutDir) {
                return false;
            }
            int screenSize = this.screenLayout & 0xF;
            int setScreenSize = settings.screenLayout & 0xF;
            if (UtilKt.isTruthy(screenSize) && screenSize > setScreenSize) {
                return false;
            }
            int screenLong = this.screenLayout & 0x30;
            int setScreenLong = settings.screenLayout & 0x30;
            if (UtilKt.isTruthy(screenLong) && screenLong != setScreenLong) {
                return false;
            }
            int uiModeType = this.uiMode & 0xF;
            int setUiModeType = settings.uiMode & 0xF;
            if (UtilKt.isTruthy(uiModeType) && uiModeType != setUiModeType) {
                return false;
            }
            int uiModeNight = this.uiMode & 0x30;
            int setUiModeNight = settings.uiMode & 0x30;
            if (UtilKt.isTruthy(uiModeNight) && uiModeNight != setUiModeNight) {
                return false;
            }
            if (UtilKt.isTruthy(this.smallestScreenWidthDp) && this.smallestScreenWidthDp > settings.smallestScreenWidthDp) {
                return false;
            }
        }
        if (UtilKt.isTruthy(this.getScreenConfig2())) {
            int screenRound = this.screenLayout2 & 3;
            int setScreenRound = settings.screenLayout2 & 3;
            if (UtilKt.isTruthy(screenRound) && screenRound != setScreenRound) {
                return false;
            }
            int hdr = this.colorMode & 0xC;
            int setHdr = settings.colorMode & 0xC;
            if (UtilKt.isTruthy(hdr) && hdr != setHdr) {
                return false;
            }
            int wideGamut = this.colorMode & 3;
            int setWideGamut = settings.colorMode & 3;
            if (UtilKt.isTruthy(wideGamut) && wideGamut != setWideGamut) {
                return false;
            }
        }
        if (UtilKt.isTruthy(this.getScreenSizeDp())) {
            if (UtilKt.isTruthy(this.screenWidthDp) && this.screenWidthDp > settings.screenWidthDp) {
                return false;
            }
            if (UtilKt.isTruthy(this.screenHeightDp) && this.screenHeightDp > settings.screenHeightDp) {
                return false;
            }
        }
        if (UtilKt.isTruthy(this.getScreenType())) {
            if (UtilKt.isTruthy(this.orientation) && this.orientation != settings.orientation) {
                return false;
            }
            if (UtilKt.isTruthy(this.touchscreen) && this.touchscreen != settings.touchscreen) {
                return false;
            }
        }
        if (UtilKt.isTruthy(this.getInput())) {
            int keysHidden = this.inputFlags & 3;
            int setKeysHidden = settings.inputFlags & 3;
            if (UtilKt.isTruthy(keysHidden) && keysHidden != setKeysHidden && (keysHidden != 1 || setKeysHidden != 3)) {
                return false;
            }
            int navHidden = this.inputFlags & 0xC;
            int setNavHidden = settings.inputFlags & 0xC;
            if (UtilKt.isTruthy(navHidden) && navHidden != setNavHidden) {
                return false;
            }
            if (UtilKt.isTruthy(this.keyboard) && this.keyboard != settings.keyboard) {
                return false;
            }
            if (UtilKt.isTruthy(this.navigation) && this.navigation != settings.navigation) {
                return false;
            }
        }
        if (UtilKt.isTruthy(this.getScreenSize())) {
            if (UtilKt.isTruthy(this.screenWidth) && this.screenWidth > settings.screenWidth) {
                return false;
            }
            if (UtilKt.isTruthy(this.screenHeight) && this.screenHeight > settings.screenHeight) {
                return false;
            }
        }
        if (UtilKt.isTruthy(this.getVersion())) {
            if (UtilKt.isTruthy(this.sdkVersion) && this.sdkVersion > settings.sdkVersion) {
                return false;
            }
            if (UtilKt.isTruthy(this.minorVersion) && this.minorVersion != settings.minorVersion) {
                return false;
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final String getBcp47Locale(boolean canonicalize) {
        block12: {
            if (this.language[0] == 0 && this.country[0] == 0) {
                return "";
            }
            localeString = new StringBuilder();
            if (this.language[0] == 0) break block12;
            if (!canonicalize) ** GOTO lbl-1000
            var3_3 = this.language;
            var4_8 = ResTableConfig.TAGALOG;
            var5_12 = 0;
            if (Arrays.equals(var3_3, var4_8)) {
                localeString.append("fil");
            } else lbl-1000:
            // 2 sources

            {
                localeString.append(this.unpackLanguage());
            }
            localeString.append('-');
        }
        if (this.localeScript[0] != 0 && !this.localeScriptWasComputed) {
            localeScriptEnd = ArraysKt.indexOf((byte[])this.localeScript, (byte)0);
            if (localeScriptEnd == -1) {
                localeScriptEnd = this.localeScript.length;
            }
            var4_8 = this.localeScript;
            var5_12 = 0;
            var6_13 = false;
            localeString.append(new String(var4_8, var5_12, localeScriptEnd, Charsets.UTF_8));
            localeString.append('-');
        }
        if (this.country[0] != 0) {
            localeString.append(this.unpackRegion());
            localeString.append('-');
        }
        if (this.localeVariant[0] != 0) {
            localeVariantEnd = ArraysKt.indexOf((byte[])this.localeScript, (byte)0);
            if (localeVariantEnd == -1) {
                localeVariantEnd = this.localeVariant.length;
            }
            var4_8 = this.localeVariant;
            var5_12 = 0;
            var6_13 = false;
            localeString.append(new String(var4_8, var5_12, localeVariantEnd, Charsets.UTF_8));
            localeString.append('-');
        }
        if (this.localeNumberSystem[0] != 0) {
            localeVariantEnd = localeString;
            var4_9 = false;
            if (localeVariantEnd.length() > 0) {
                localeString.append("u-nu-");
                localeNumberEnd = ArraysKt.indexOf((byte[])this.localeNumberSystem, (byte)0);
                if (localeNumberEnd == -1) {
                    localeNumberEnd = this.localeNumberSystem.length;
                }
                var4_10 = this.localeNumberSystem;
                var5_12 = 0;
                var6_13 = false;
                localeString.append(new String(var4_10, var5_12, localeNumberEnd, Charsets.UTF_8));
                localeString.append('-');
            }
        }
        var3_7 = localeString;
        var4_11 = false;
        if (var3_7.length() == 0) {
            return "";
        }
        var3_7 = localeString.substring(0, localeString.length() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)var3_7, (String)"localeString.substring(0, localeString.length - 1)");
        return var3_7;
    }

    public static /* synthetic */ String getBcp47Locale$default(ResTableConfig resTableConfig, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getBcp47Locale");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        return resTableConfig.getBcp47Locale(bl);
    }

    public ResTableConfig() {
        this(0, 0, 0, null, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, null, null, 0, 0, false, null, 0x3FFFFFF, null);
    }

    static {
        byte[] byArray = new byte[]{101, 110};
        ENGLISH = byArray;
        byArray = new byte[]{85, 83};
        UNITED_STATES = byArray;
        byArray = new byte[]{-83, 5};
        FILIPINO = byArray;
        byArray = new byte[]{116, 108};
        TAGALOG = byArray;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0005\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\n\n\u0002\b(\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b)J\u001d\u0010*\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b-J\u0015\u0010.\u001a\u00020\u00162\u0006\u0010/\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b0J\u0015\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0000\u00a2\u0006\u0002\b5J\u0015\u00106\u001a\u00020\u00042\u0006\u00107\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b8J\u0015\u00109\u001a\u00020'2\u0006\u0010:\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b;J\u0015\u0010<\u001a\u00020'2\u0006\u0010:\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b=J\u001d\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\u00162\u0006\u0010A\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\bBJ\u0015\u0010C\u001a\u00020\u00162\u0006\u0010/\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\bDJ\u0015\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\bHJ\u0015\u0010I\u001a\u00020F2\u0006\u0010J\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\bKJ\u0015\u0010L\u001a\u00020F2\u0006\u0010G\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\bMJ\u0015\u0010N\u001a\u00020'2\u0006\u0010:\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\bOJ\u0015\u0010P\u001a\u00020'2\u0006\u00107\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\bQJ\u001f\u0010R\u001a\u00020\u00162\b\u0010:\u001a\u0004\u0018\u00010\u001d2\u0006\u0010S\u001a\u00020'H\u0000\u00a2\u0006\u0002\bTJ\u0015\u0010U\u001a\u00020\u00042\u0006\u0010V\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\bWJ\u0015\u0010X\u001a\u00020\u00042\u0006\u0010Y\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\bZJ\u0015\u0010[\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\\J\u0015\u0010]\u001a\u00020'2\u0006\u0010^\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b_J\u0015\u0010`\u001a\u00020\u00042\u0006\u0010V\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\baJ\u0015\u0010b\u001a\u00020\u00042\u0006\u0010Y\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\bcJ\u0015\u0010d\u001a\u00020F2\u0006\u0010J\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\beJ\u0015\u0010f\u001a\u00020\u00042\u0006\u0010^\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\bgJ\u0015\u0010h\u001a\u00020'2\u0006\u00107\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\biJ\u0015\u0010j\u001a\u00020'2\u0006\u0010^\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\bkJ\u001d\u0010l\u001a\u00020\u001d2\u0006\u0010:\u001a\u00020\u00162\u0006\u0010S\u001a\u00020'H\u0000\u00a2\u0006\u0002\bmR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u000e\u0010\u001b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\u00020\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0018R\u0014\u0010$\u001a\u00020\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0018\u00a8\u0006n"}, d2={"Lcom/android/aaptcompiler/android/ResTableConfig$Companion;", "", "()V", "CONFIG_COLOR_MODE", "", "CONFIG_DENSITY", "CONFIG_KEYBOARD", "CONFIG_KEYBOARD_HIDDEN", "CONFIG_LAYOUTDIR", "CONFIG_LOCALE", "CONFIG_MCC", "CONFIG_MNC", "CONFIG_NAVIGATION", "CONFIG_ORIENTATION", "CONFIG_SCREEN_LAYOUT", "CONFIG_SCREEN_ROUND", "CONFIG_SCREEN_SIZE", "CONFIG_SMALLEST_SCREEN_SIZE", "CONFIG_TOUCHSCREEN", "CONFIG_UI_MODE", "CONFIG_VERSION", "ENGLISH", "", "getENGLISH$aaptcompiler", "()[B", "FILIPINO", "getFILIPINO$aaptcompiler", "LOCALE_MIN_SIZE", "NUMBERING_SYSTEM_PREFIX", "", "NUMBER_SYSTEM_MIN_SIZE", "SCREEN_CONFIG_EXTENSION_MIN_SIZE", "SCREEN_CONFIG_MIN_SIZE", "SCREEN_DP_MIN_SIZE", "TAGALOG", "getTAGALOG$aaptcompiler", "UNITED_STATES", "getUNITED_STATES$aaptcompiler", "colorModeFromScreenConfig2", "", "screenConfig2", "colorModeFromScreenConfig2$aaptcompiler", "compareArrays", "left", "right", "compareArrays$aaptcompiler", "countryFromLocale", "locale", "countryFromLocale$aaptcompiler", "createConfig", "Lcom/android/aaptcompiler/android/ResTableConfig;", "buffer", "Ljava/nio/ByteBuffer;", "createConfig$aaptcompiler", "densityFromScreenType", "screenType", "densityFromScreenType$aaptcompiler", "inputFlagsFromInput", "input", "inputFlagsFromInput$aaptcompiler", "keyboardFromInput", "keyboardFromInput$aaptcompiler", "langsAreEquivalent", "", "lang1", "lang2", "langsAreEquivalent$aaptcompiler", "languageFromLocale", "languageFromLocale$aaptcompiler", "mccFromImsi", "", "imsi", "mccFromImsi$aaptcompiler", "minorVersionFromVersion", "version", "minorVersionFromVersion$aaptcompiler", "mncFromImsi", "mncFromImsi$aaptcompiler", "navigationFromInput", "navigationFromInput$aaptcompiler", "orientationFromScreenType", "orientationFromScreenType$aaptcompiler", "packLanguageOrRegion", "base", "packLanguageOrRegion$aaptcompiler", "screenHeightDpFromScreenSizeDp", "screenSizeDp", "screenHeightDpFromScreenSizeDp$aaptcompiler", "screenHeightFromScreenSize", "screenSize", "screenHeightFromScreenSize$aaptcompiler", "screenLayout2FromScreenConfig2", "screenLayout2FromScreenConfig2$aaptcompiler", "screenLayoutFromScreenConfig", "screenConfig", "screenLayoutFromScreenConfig$aaptcompiler", "screenWidthDpFromScreenSizeDp", "screenWidthDpFromScreenSizeDp$aaptcompiler", "screenWidthFromScreenSize", "screenWidthFromScreenSize$aaptcompiler", "sdkVersionFromVersion", "sdkVersionFromVersion$aaptcompiler", "smallestScreenWidthDpFromScreenConfig", "smallestScreenWidthDpFromScreenConfig$aaptcompiler", "touchscreenFromScreenType", "touchscreenFromScreenType$aaptcompiler", "uiModeFromScreenConfig", "uiModeFromScreenConfig$aaptcompiler", "unpackLanguageOrRegion", "unpackLanguageOrRegion$aaptcompiler", "aaptcompiler"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final byte[] getENGLISH$aaptcompiler() {
            return ENGLISH;
        }

        @NotNull
        public final byte[] getUNITED_STATES$aaptcompiler() {
            return UNITED_STATES;
        }

        @NotNull
        public final byte[] getFILIPINO$aaptcompiler() {
            return FILIPINO;
        }

        @NotNull
        public final byte[] getTAGALOG$aaptcompiler() {
            return TAGALOG;
        }

        public final boolean langsAreEquivalent$aaptcompiler(@NotNull byte[] lang1, @NotNull byte[] lang2) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)lang1, (String)"lang1");
            Intrinsics.checkNotNullParameter((Object)lang2, (String)"lang2");
            byte[] byArray = lang1;
            boolean bl2 = false;
            if (Arrays.equals(byArray, lang2)) {
                bl = true;
            } else {
                byArray = lang1;
                byte[] byArray2 = this.getFILIPINO$aaptcompiler();
                boolean bl3 = false;
                if (Arrays.equals(byArray, byArray2)) {
                    byArray = lang2;
                    byArray2 = this.getTAGALOG$aaptcompiler();
                    bl3 = false;
                    bl = Arrays.equals(byArray, byArray2);
                } else {
                    byArray = lang1;
                    byArray2 = this.getTAGALOG$aaptcompiler();
                    bl3 = false;
                    if (Arrays.equals(byArray, byArray2)) {
                        byArray = lang2;
                        byArray2 = this.getFILIPINO$aaptcompiler();
                        bl3 = false;
                        bl = Arrays.equals(byArray, byArray2);
                    } else {
                        bl = false;
                    }
                }
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        public final int compareArrays$aaptcompiler(@NotNull byte[] left, @NotNull byte[] right) {
            Intrinsics.checkNotNullParameter((Object)left, (String)"left");
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            byte[] $this$forEachIndexed$iv = left;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (byte item$iv : $this$forEachIndexed$iv) {
                void byteVal;
                int n = index$iv++;
                byte by = item$iv;
                int index = n;
                boolean bl = false;
                if (byteVal < right[index]) {
                    return -1;
                }
                if (byteVal <= right[index]) continue;
                return 1;
            }
            return 0;
        }

        @NotNull
        public final byte[] packLanguageOrRegion$aaptcompiler(@Nullable String input, byte base) {
            byte[] result = new byte[2];
            CharSequence charSequence = input;
            boolean bl = false;
            boolean bl2 = false;
            if (!(charSequence == null || charSequence.length() == 0)) {
                if (input.length() <= 2 || input.charAt(2) == '-') {
                    result[0] = (byte)input.charAt(0);
                    result[1] = (byte)input.charAt(1);
                } else {
                    int first = (byte)input.charAt(0) - base & 0x7F;
                    int second = (byte)input.charAt(1) - base & 0x7F;
                    int third = (byte)input.charAt(2) - base & 0x7F;
                    result[0] = (byte)(0x80 | third << 2 | second >>> 3);
                    result[1] = (byte)(second << 5 | first);
                }
            }
            return result;
        }

        @NotNull
        public final String unpackLanguageOrRegion$aaptcompiler(@NotNull byte[] input, byte base) {
            String string;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            if (UtilKt.isTruthy(input[0] & 0x80)) {
                byte firstChar = (byte)((input[1] & 0x1F) + base);
                byte secondChar = (byte)(((input[1] & 0xE0) >> 5) + ((input[0] & 3) << 3) + base);
                byte thirdChar = (byte)(((input[0] & 0x7C) >> 2) + base);
                byte[] byArray = new byte[]{firstChar, secondChar, thirdChar};
                boolean bl = false;
                string = new String(byArray, Charsets.UTF_8);
            } else if (UtilKt.isTruthy(input[0])) {
                boolean bl = false;
                string = new String(input, Charsets.UTF_8);
            } else {
                string = "";
            }
            return string;
        }

        @NotNull
        public final ResTableConfig createConfig$aaptcompiler(@NotNull ByteBuffer buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            int startPosition = buffer.position();
            int sizeOnDevice = buffer.getInt();
            int sizeOnHost = UtilKt.deviceToHost(sizeOnDevice);
            int imsi = buffer.getInt();
            int locale = buffer.getInt();
            int screenType = buffer.getInt();
            int input = buffer.getInt();
            int screenSize = buffer.getInt();
            int version = buffer.getInt();
            int screenConfig = sizeOnHost >= 32 ? buffer.getInt() : 0;
            int screenSizeDp = sizeOnHost >= 36 ? buffer.getInt() : 0;
            byte[] localeScript = new byte[4];
            byte[] localeVariant = new byte[8];
            if (sizeOnHost >= 48) {
                buffer.get(localeScript);
                buffer.get(localeVariant);
            }
            int screenConfig2 = sizeOnHost >= 52 ? buffer.getInt() : 0;
            byte[] numberSystem = new byte[8];
            if (sizeOnHost >= 60) {
                buffer.get(numberSystem);
            }
            if (buffer.position() < startPosition + sizeOnHost) {
                buffer.position(startPosition + sizeOnHost);
            }
            return new ResTableConfig(sizeOnDevice, imsi, locale, screenType, input, screenSize, version, screenConfig, screenSizeDp, localeScript, localeVariant, screenConfig2, numberSystem);
        }

        public final short mccFromImsi$aaptcompiler(int imsi) {
            return (short)UtilKt.deviceToHost(imsi);
        }

        public final short mncFromImsi$aaptcompiler(int imsi) {
            return (short)(UtilKt.deviceToHost(imsi) >>> 16);
        }

        @NotNull
        public final byte[] languageFromLocale$aaptcompiler(int locale) {
            int hostLocale = UtilKt.deviceToHost(locale);
            byte[] byArray = new byte[]{(byte)(hostLocale >>> 8), (byte)hostLocale};
            return byArray;
        }

        @NotNull
        public final byte[] countryFromLocale$aaptcompiler(int locale) {
            int hostLocale = UtilKt.deviceToHost(locale);
            byte[] byArray = new byte[]{(byte)(hostLocale >>> 24), (byte)(hostLocale >>> 16)};
            return byArray;
        }

        public final byte orientationFromScreenType$aaptcompiler(int screenType) {
            return (byte)UtilKt.deviceToHost(screenType);
        }

        public final byte touchscreenFromScreenType$aaptcompiler(int screenType) {
            return (byte)(UtilKt.deviceToHost(screenType) >>> 8);
        }

        public final int densityFromScreenType$aaptcompiler(int screenType) {
            return UtilKt.deviceToHost(screenType) >>> 16;
        }

        public final byte keyboardFromInput$aaptcompiler(int input) {
            return (byte)UtilKt.deviceToHost(input);
        }

        public final byte navigationFromInput$aaptcompiler(int input) {
            return (byte)(UtilKt.deviceToHost(input) >>> 8);
        }

        public final byte inputFlagsFromInput$aaptcompiler(int input) {
            return (byte)(UtilKt.deviceToHost(input) >>> 16);
        }

        public final int screenWidthFromScreenSize$aaptcompiler(int screenSize) {
            return UtilKt.deviceToHost(screenSize) & 0xFFFF;
        }

        public final int screenHeightFromScreenSize$aaptcompiler(int screenSize) {
            return UtilKt.deviceToHost(screenSize) >>> 16;
        }

        public final short sdkVersionFromVersion$aaptcompiler(int version) {
            return (short)UtilKt.deviceToHost(version);
        }

        public final short minorVersionFromVersion$aaptcompiler(int version) {
            return (short)(UtilKt.deviceToHost(version) >>> 16);
        }

        public final byte screenLayoutFromScreenConfig$aaptcompiler(int screenConfig) {
            return (byte)UtilKt.deviceToHost(screenConfig);
        }

        public final byte uiModeFromScreenConfig$aaptcompiler(int screenConfig) {
            return (byte)(UtilKt.deviceToHost(screenConfig) >>> 8);
        }

        public final int smallestScreenWidthDpFromScreenConfig$aaptcompiler(int screenConfig) {
            return UtilKt.deviceToHost(screenConfig) >>> 16;
        }

        public final int screenWidthDpFromScreenSizeDp$aaptcompiler(int screenSizeDp) {
            return UtilKt.deviceToHost(screenSizeDp) & 0xFFFF;
        }

        public final int screenHeightDpFromScreenSizeDp$aaptcompiler(int screenSizeDp) {
            return UtilKt.deviceToHost(screenSizeDp) >>> 16 & 0xFFFF;
        }

        public final byte screenLayout2FromScreenConfig2$aaptcompiler(int screenConfig2) {
            return (byte)UtilKt.deviceToHost(screenConfig2);
        }

        public final byte colorModeFromScreenConfig2$aaptcompiler(int screenConfig2) {
            return (byte)(UtilKt.deviceToHost(screenConfig2) >>> 8);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/aaptcompiler/android/ResTableConfig$ORIENTATION;", "", "()V", "ANY", "", "LAND", "PORT", "SQUARE", "aaptcompiler"})
    public static final class ORIENTATION {
        @NotNull
        public static final ORIENTATION INSTANCE = new ORIENTATION();
        public static final byte ANY = 0;
        public static final byte PORT = 1;
        public static final byte LAND = 2;
        public static final byte SQUARE = 3;

        private ORIENTATION() {
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/aaptcompiler/android/ResTableConfig$TOUCHSCREEN;", "", "()V", "ANY", "", "FINGER", "NOTOUCH", "STYLUS", "aaptcompiler"})
    public static final class TOUCHSCREEN {
        @NotNull
        public static final TOUCHSCREEN INSTANCE = new TOUCHSCREEN();
        public static final byte ANY = 0;
        public static final byte NOTOUCH = 1;
        public static final byte STYLUS = 2;
        public static final byte FINGER = 3;

        private TOUCHSCREEN() {
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/aaptcompiler/android/ResTableConfig$DENSITY;", "", "()V", "ANY", "", "DEFAULT", "HIGH", "LOW", "MEDIUM", "NONE", "TV", "XHIGH", "XXHIGH", "XXXHIGH", "aaptcompiler"})
    public static final class DENSITY {
        @NotNull
        public static final DENSITY INSTANCE = new DENSITY();
        public static final int DEFAULT = 0;
        public static final int LOW = 120;
        public static final int MEDIUM = 160;
        public static final int TV = 213;
        public static final int HIGH = 240;
        public static final int XHIGH = 320;
        public static final int XXHIGH = 480;
        public static final int XXXHIGH = 640;
        public static final int ANY = 65534;
        public static final int NONE = 65535;

        private DENSITY() {
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/aaptcompiler/android/ResTableConfig$KEYBOARD;", "", "()V", "ANY", "", "NOKEYS", "QWERTY", "TWELVEKEY", "aaptcompiler"})
    public static final class KEYBOARD {
        @NotNull
        public static final KEYBOARD INSTANCE = new KEYBOARD();
        public static final byte ANY = 0;
        public static final byte NOKEYS = 1;
        public static final byte QWERTY = 2;
        public static final byte TWELVEKEY = 3;

        private KEYBOARD() {
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/aaptcompiler/android/ResTableConfig$NAVIGATION;", "", "()V", "ANY", "", "DPAD", "NONAV", "TRACKBALL", "WHEEL", "aaptcompiler"})
    public static final class NAVIGATION {
        @NotNull
        public static final NAVIGATION INSTANCE = new NAVIGATION();
        public static final byte ANY = 0;
        public static final byte NONAV = 1;
        public static final byte DPAD = 2;
        public static final byte TRACKBALL = 3;
        public static final byte WHEEL = 4;

        private NAVIGATION() {
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/aaptcompiler/android/ResTableConfig$INPUT_FLAGS;", "", "()V", "KEYSHIDDEN_ANY", "", "KEYSHIDDEN_MASK", "", "KEYSHIDDEN_NO", "KEYSHIDDEN_SOFT", "KEYSHIDDEN_YES", "NAVHIDDEN_ANY", "NAVHIDDEN_MASK", "NAVHIDDEN_NO", "NAVHIDDEN_SHIFT", "NAVHIDDEN_YES", "aaptcompiler"})
    public static final class INPUT_FLAGS {
        @NotNull
        public static final INPUT_FLAGS INSTANCE = new INPUT_FLAGS();
        public static final int KEYSHIDDEN_MASK = 3;
        public static final byte KEYSHIDDEN_ANY = 0;
        public static final byte KEYSHIDDEN_NO = 1;
        public static final byte KEYSHIDDEN_YES = 2;
        public static final byte KEYSHIDDEN_SOFT = 3;
        public static final int NAVHIDDEN_MASK = 12;
        public static final int NAVHIDDEN_SHIFT = 2;
        public static final byte NAVHIDDEN_ANY = 0;
        public static final byte NAVHIDDEN_NO = 4;
        public static final byte NAVHIDDEN_YES = 8;

        private INPUT_FLAGS() {
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/aaptcompiler/android/ResTableConfig$SCREENSIZE;", "", "()V", "HEIGHT_ANY", "", "WIDTH_ANY", "aaptcompiler"})
    public static final class SCREENSIZE {
        @NotNull
        public static final SCREENSIZE INSTANCE = new SCREENSIZE();
        public static final int WIDTH_ANY = 0;
        public static final int HEIGHT_ANY = 0;

        private SCREENSIZE() {
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/aaptcompiler/android/ResTableConfig$VERSION;", "", "()V", "MINORVERSION_ANY", "", "SDK_ANY", "aaptcompiler"})
    public static final class VERSION {
        @NotNull
        public static final VERSION INSTANCE = new VERSION();
        public static final int SDK_ANY = 0;
        public static final int MINORVERSION_ANY = 0;

        private VERSION() {
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000e\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/aaptcompiler/android/ResTableConfig$SCREEN_LAYOUT;", "", "()V", "DIR_ANY", "", "DIR_LTR", "DIR_MASK", "", "DIR_RTL", "DIR_SHIFT", "SCREENLONG_ANY", "SCREENLONG_MASK", "SCREENLONG_NO", "SCREENLONG_SHIFT", "SCREENLONG_YES", "SIZE_ANY", "SIZE_LARGE", "SIZE_MASK", "SIZE_NORMAL", "SIZE_SMALL", "SIZE_XLARGE", "aaptcompiler"})
    public static final class SCREEN_LAYOUT {
        @NotNull
        public static final SCREEN_LAYOUT INSTANCE = new SCREEN_LAYOUT();
        public static final int DIR_MASK = 192;
        public static final int DIR_SHIFT = 6;
        public static final byte DIR_ANY = 0;
        public static final byte DIR_LTR = 64;
        public static final byte DIR_RTL = -128;
        public static final int SCREENLONG_MASK = 48;
        public static final int SCREENLONG_SHIFT = 4;
        public static final byte SCREENLONG_ANY = 0;
        public static final byte SCREENLONG_NO = 16;
        public static final byte SCREENLONG_YES = 32;
        public static final int SIZE_MASK = 15;
        public static final byte SIZE_ANY = 0;
        public static final byte SIZE_SMALL = 1;
        public static final byte SIZE_NORMAL = 2;
        public static final byte SIZE_LARGE = 3;
        public static final byte SIZE_XLARGE = 4;

        private SCREEN_LAYOUT() {
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\b\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/aaptcompiler/android/ResTableConfig$UI_MODE;", "", "()V", "NIGHT_ANY", "", "NIGHT_MASK", "", "NIGHT_NO", "NIGHT_SHIFT", "NIGHT_YES", "TYPE_ANY", "TYPE_APPLIANCE", "TYPE_CAR", "TYPE_DESK", "TYPE_MASK", "TYPE_NORMAL", "TYPE_TELEVISION", "TYPE_VR_HEADSET", "TYPE_WATCH", "aaptcompiler"})
    public static final class UI_MODE {
        @NotNull
        public static final UI_MODE INSTANCE = new UI_MODE();
        public static final int TYPE_MASK = 15;
        public static final byte TYPE_ANY = 0;
        public static final byte TYPE_NORMAL = 1;
        public static final byte TYPE_DESK = 2;
        public static final byte TYPE_CAR = 3;
        public static final byte TYPE_TELEVISION = 4;
        public static final byte TYPE_APPLIANCE = 5;
        public static final byte TYPE_WATCH = 6;
        public static final byte TYPE_VR_HEADSET = 7;
        public static final int NIGHT_MASK = 48;
        public static final int NIGHT_SHIFT = 4;
        public static final byte NIGHT_ANY = 0;
        public static final byte NIGHT_NO = 16;
        public static final byte NIGHT_YES = 32;

        private UI_MODE() {
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/aaptcompiler/android/ResTableConfig$SCREEN_LAYOUT2;", "", "()V", "SCREENROUND_ANY", "", "SCREENROUND_MASK", "", "SCREENROUND_NO", "SCREENROUND_YES", "aaptcompiler"})
    public static final class SCREEN_LAYOUT2 {
        @NotNull
        public static final SCREEN_LAYOUT2 INSTANCE = new SCREEN_LAYOUT2();
        public static final int SCREENROUND_MASK = 3;
        public static final byte SCREENROUND_ANY = 0;
        public static final byte SCREENROUND_NO = 1;
        public static final byte SCREENROUND_YES = 2;

        private SCREEN_LAYOUT2() {
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/aaptcompiler/android/ResTableConfig$COLOR_MODE;", "", "()V", "HDR_ANY", "", "HDR_MASK", "", "HDR_NO", "HDR_SHIFT", "HDR_YES", "WIDE_GAMUT_ANY", "WIDE_GAMUT_MASK", "WIDE_GAMUT_NO", "WIDE_GAMUT_YES", "aaptcompiler"})
    public static final class COLOR_MODE {
        @NotNull
        public static final COLOR_MODE INSTANCE = new COLOR_MODE();
        public static final int WIDE_GAMUT_MASK = 3;
        public static final byte WIDE_GAMUT_ANY = 0;
        public static final byte WIDE_GAMUT_NO = 1;
        public static final byte WIDE_GAMUT_YES = 2;
        public static final int HDR_MASK = 12;
        public static final int HDR_SHIFT = 2;
        public static final byte HDR_ANY = 0;
        public static final byte HDR_NO = 4;
        public static final byte HDR_YES = 8;

        private COLOR_MODE() {
        }
    }
}

