/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.analytics;

import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.analytics.UsageTracker;
import com.google.wireless.android.play.playlog.proto.ClientAnalytics;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.ProductDetails;
import java.io.Flushable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH&J\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0007H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/analytics/UsageTrackerWriter;", "Ljava/lang/AutoCloseable;", "Ljava/io/Flushable;", "()V", "logAt", "", "eventTimeMs", "", "studioEvent", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "logDetails", "logEvent", "Lcom/google/wireless/android/play/playlog/proto/ClientAnalytics$LogEvent$Builder;", "logNow", "scheduleJournalTimeout", "maxJournalTime", "tracker"})
public abstract class UsageTrackerWriter
implements AutoCloseable,
Flushable {
    public void scheduleJournalTimeout(long maxJournalTime) {
    }

    public final void logNow(@NotNull AndroidStudioEvent.Builder studioEvent) {
        Intrinsics.checkNotNullParameter((Object)studioEvent, (String)"studioEvent");
        this.logAt(AnalyticsSettings.getDateProvider().now().getTime(), studioEvent);
    }

    public final void logAt(long eventTimeMs, @NotNull AndroidStudioEvent.Builder studioEvent) {
        Intrinsics.checkNotNullParameter((Object)studioEvent, (String)"studioEvent");
        studioEvent.setStudioSessionId(UsageTracker.getSessionId());
        studioEvent.setIdeBrand(UsageTracker.getIdeBrand());
        if (UsageTracker.getVersion() != null && !studioEvent.hasProductDetails()) {
            ProductDetails.Builder builder = ProductDetails.newBuilder();
            String string = UsageTracker.getVersion();
            Intrinsics.checkNotNull((Object)string);
            studioEvent.setProductDetails(builder.setVersion(string));
        }
        if (UsageTracker.getIdeaIsInternal()) {
            studioEvent.setIdeaIsInternal(true);
        }
        UsageTracker.INSTANCE.getListener().invoke((Object)studioEvent);
        ClientAnalytics.LogEvent.Builder builder = ClientAnalytics.LogEvent.newBuilder().setEventTimeMs(eventTimeMs).setSourceExtension(studioEvent.build().toByteString());
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder()\n           \u2026t.build().toByteString())");
        this.logDetails(builder);
    }

    public abstract void logDetails(@NotNull ClientAnalytics.LogEvent.Builder var1);
}

