/*
 * Decompiled with CFR 0.152.
 */
package android.support.transition;

import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.transition.ViewUtilsApi18;
import android.util.Log;
import android.view.View;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

@RequiresApi(value=19)
class ViewUtilsApi19
extends ViewUtilsApi18 {
    private static final String TAG = "ViewUtilsApi19";
    private static Method sSetTransitionAlphaMethod;
    private static boolean sSetTransitionAlphaMethodFetched;
    private static Method sGetTransitionAlphaMethod;
    private static boolean sGetTransitionAlphaMethodFetched;

    ViewUtilsApi19() {
    }

    @Override
    public void setTransitionAlpha(@NonNull View view, float alpha) {
        this.fetchSetTransitionAlphaMethod();
        if (sSetTransitionAlphaMethod != null) {
            try {
                sSetTransitionAlphaMethod.invoke((Object)view, Float.valueOf(alpha));
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        } else {
            view.setAlpha(alpha);
        }
    }

    @Override
    public float getTransitionAlpha(@NonNull View view) {
        this.fetchGetTransitionAlphaMethod();
        if (sGetTransitionAlphaMethod != null) {
            try {
                return ((Float)sGetTransitionAlphaMethod.invoke((Object)view, new Object[0])).floatValue();
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        }
        return super.getTransitionAlpha(view);
    }

    @Override
    public void saveNonTransitionAlpha(@NonNull View view) {
    }

    @Override
    public void clearNonTransitionAlpha(@NonNull View view) {
    }

    private void fetchSetTransitionAlphaMethod() {
        if (!sSetTransitionAlphaMethodFetched) {
            try {
                sSetTransitionAlphaMethod = View.class.getDeclaredMethod("setTransitionAlpha", Float.TYPE);
                sSetTransitionAlphaMethod.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                Log.i((String)TAG, (String)"Failed to retrieve setTransitionAlpha method", (Throwable)e);
            }
            sSetTransitionAlphaMethodFetched = true;
        }
    }

    private void fetchGetTransitionAlphaMethod() {
        if (!sGetTransitionAlphaMethodFetched) {
            try {
                sGetTransitionAlphaMethod = View.class.getDeclaredMethod("getTransitionAlpha", new Class[0]);
                sGetTransitionAlphaMethod.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                Log.i((String)TAG, (String)"Failed to retrieve getTransitionAlpha method", (Throwable)e);
            }
            sGetTransitionAlphaMethodFetched = true;
        }
    }
}

