/*
 * Decompiled with CFR 0.152.
 */
package android.support.transition;

import android.animation.Animator;
import android.annotation.TargetApi;
import android.support.annotation.RequiresApi;
import android.support.transition.TransitionInterface;
import android.support.transition.TransitionKitKat;
import android.support.transition.TransitionValues;
import android.support.transition.VisibilityImpl;
import android.support.transition.VisibilityInterface;
import android.transition.Visibility;
import android.view.ViewGroup;

@RequiresApi(value=19)
@TargetApi(value=19)
class VisibilityKitKat
extends TransitionKitKat
implements VisibilityImpl {
    VisibilityKitKat() {
    }

    @Override
    public void init(TransitionInterface external, Object internal) {
        this.mExternalTransition = external;
        this.mTransition = internal == null ? new VisibilityWrapper((VisibilityInterface)external) : (Visibility)internal;
    }

    @Override
    public boolean isVisible(TransitionValues values) {
        return ((Visibility)this.mTransition).isVisible(VisibilityKitKat.convertToPlatform(values));
    }

    @Override
    public Animator onAppear(ViewGroup sceneRoot, TransitionValues startValues, int startVisibility, TransitionValues endValues, int endVisibility) {
        return ((Visibility)this.mTransition).onAppear(sceneRoot, VisibilityKitKat.convertToPlatform(startValues), startVisibility, VisibilityKitKat.convertToPlatform(endValues), endVisibility);
    }

    @Override
    public Animator onDisappear(ViewGroup sceneRoot, TransitionValues startValues, int startVisibility, TransitionValues endValues, int endVisibility) {
        return ((Visibility)this.mTransition).onDisappear(sceneRoot, VisibilityKitKat.convertToPlatform(startValues), startVisibility, VisibilityKitKat.convertToPlatform(endValues), endVisibility);
    }

    private static class VisibilityWrapper
    extends Visibility {
        private final VisibilityInterface mVisibility;

        VisibilityWrapper(VisibilityInterface visibility) {
            this.mVisibility = visibility;
        }

        public void captureStartValues(android.transition.TransitionValues transitionValues) {
            TransitionKitKat.wrapCaptureStartValues(this.mVisibility, transitionValues);
        }

        public void captureEndValues(android.transition.TransitionValues transitionValues) {
            TransitionKitKat.wrapCaptureEndValues(this.mVisibility, transitionValues);
        }

        public Animator createAnimator(ViewGroup sceneRoot, android.transition.TransitionValues startValues, android.transition.TransitionValues endValues) {
            return this.mVisibility.createAnimator(sceneRoot, TransitionKitKat.convertToSupport(startValues), TransitionKitKat.convertToSupport(endValues));
        }

        public boolean isVisible(android.transition.TransitionValues values) {
            if (values == null) {
                return false;
            }
            TransitionValues externalValues = new TransitionValues();
            TransitionKitKat.copyValues(values, externalValues);
            return this.mVisibility.isVisible(externalValues);
        }

        public Animator onAppear(ViewGroup sceneRoot, android.transition.TransitionValues startValues, int startVisibility, android.transition.TransitionValues endValues, int endVisibility) {
            return this.mVisibility.onAppear(sceneRoot, TransitionKitKat.convertToSupport(startValues), startVisibility, TransitionKitKat.convertToSupport(endValues), endVisibility);
        }

        public Animator onDisappear(ViewGroup sceneRoot, android.transition.TransitionValues startValues, int startVisibility, android.transition.TransitionValues endValues, int endVisibility) {
            return this.mVisibility.onDisappear(sceneRoot, TransitionKitKat.convertToSupport(startValues), startVisibility, TransitionKitKat.convertToSupport(endValues), endVisibility);
        }
    }
}

