/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.orchestrator.callback;

import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.test.runner.internal.deps.aidl.BaseProxy;
import android.support.test.runner.internal.deps.aidl.BaseStub;
import android.support.test.runner.internal.deps.aidl.Codecs;

public interface OrchestratorCallback
extends IInterface {
    public void addTest(String var1) throws RemoteException;

    public void sendTestNotification(Bundle var1) throws RemoteException;

    public static abstract class Stub
    extends BaseStub
    implements OrchestratorCallback {
        private static final String DESCRIPTOR = "android.support.test.orchestrator.callback.OrchestratorCallback";
        static final int TRANSACTION_addTest = 1;
        static final int TRANSACTION_sendTestNotification = 2;

        public Stub() {
            super(DESCRIPTOR);
        }

        public static OrchestratorCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin instanceof OrchestratorCallback) {
                return (OrchestratorCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        protected boolean dispatchTransaction(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1: {
                    String test = data.readString();
                    this.addTest(test);
                    break;
                }
                case 2: {
                    Bundle bundle = (Bundle)Codecs.createParcelable(data, Bundle.CREATOR);
                    this.sendTestNotification(bundle);
                    break;
                }
                default: {
                    return false;
                }
            }
            reply.writeNoException();
            return true;
        }

        public static class Proxy
        extends BaseProxy
        implements OrchestratorCallback {
            Proxy(IBinder remote) {
                super(remote, Stub.DESCRIPTOR);
            }

            @Override
            public void addTest(String test) throws RemoteException {
                Parcel data = this.obtainAndWriteInterfaceToken();
                data.writeString(test);
                this.transactAndReadExceptionReturnVoid(1, data);
            }

            @Override
            public void sendTestNotification(Bundle bundle) throws RemoteException {
                Parcel data = this.obtainAndWriteInterfaceToken();
                Codecs.writeParcelable(data, (Parcelable)bundle);
                this.transactAndReadExceptionReturnVoid(2, data);
            }
        }
    }
}

