/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.internal.runner;

import android.support.annotation.VisibleForTesting;
import android.support.test.filters.MediumTest;
import android.test.suitebuilder.annotation.LargeTest;
import android.test.suitebuilder.annotation.SmallTest;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.junit.runner.Description;

public final class TestSize {
    public static final TestSize SMALL = new TestSize("small", android.support.test.filters.SmallTest.class, SmallTest.class, 200.0f);
    public static final TestSize MEDIUM = new TestSize("medium", MediumTest.class, android.test.suitebuilder.annotation.MediumTest.class, 1000.0f);
    public static final TestSize LARGE = new TestSize("large", android.support.test.filters.LargeTest.class, LargeTest.class, Float.MAX_VALUE);
    public static final TestSize NONE = new TestSize("", null, null, 0.0f);
    private static final Set<TestSize> ALL_SIZES = Collections.unmodifiableSet(new HashSet<TestSize>(Arrays.asList(SMALL, MEDIUM, LARGE)));
    private final String mSizeQualifierName;
    private final Class<? extends Annotation> mPlatformAnnotationClass;
    private final Class<? extends Annotation> mRunnerFilterAnnotationClass;
    private final float mTestSizeRunTimeThreshold;

    @VisibleForTesting
    public TestSize(String sizeQualifierName, Class<? extends Annotation> platformAnnotationClass, Class<? extends Annotation> runnerFilterAnnotationClass, float testSizeRuntimeThreshold) {
        this.mSizeQualifierName = sizeQualifierName;
        this.mPlatformAnnotationClass = platformAnnotationClass;
        this.mRunnerFilterAnnotationClass = runnerFilterAnnotationClass;
        this.mTestSizeRunTimeThreshold = testSizeRuntimeThreshold;
    }

    public String getSizeQualifierName() {
        return this.mSizeQualifierName;
    }

    public boolean testMethodIsAnnotatedWithTestSize(Description description) {
        return description.getAnnotation(this.mRunnerFilterAnnotationClass) != null || description.getAnnotation(this.mPlatformAnnotationClass) != null;
    }

    public boolean testClassIsAnnotatedWithTestSize(Description description) {
        Class testClass = description.getTestClass();
        if (null == testClass) {
            return false;
        }
        return testClass.isAnnotationPresent(this.mRunnerFilterAnnotationClass) || testClass.isAnnotationPresent(this.mPlatformAnnotationClass);
    }

    public float getRunTimeThreshold() {
        return this.mTestSizeRunTimeThreshold;
    }

    public static TestSize getTestSizeForRunTime(float testRuntime) {
        if (TestSize.runTimeSmallerThanThreshold(testRuntime, SMALL.getRunTimeThreshold())) {
            return SMALL;
        }
        if (TestSize.runTimeSmallerThanThreshold(testRuntime, MEDIUM.getRunTimeThreshold())) {
            return MEDIUM;
        }
        return LARGE;
    }

    public static boolean isAnyTestSize(Class<? extends Annotation> annotationClass) {
        for (TestSize testSize : ALL_SIZES) {
            if (testSize.getRunnerAnnotation() != annotationClass && testSize.getFrameworkAnnotation() != annotationClass) continue;
            return true;
        }
        return false;
    }

    public static TestSize fromString(String testSize) {
        TestSize testSizeFromString = NONE;
        for (TestSize testSizeValue : ALL_SIZES) {
            if (!testSizeValue.getSizeQualifierName().equals(testSize)) continue;
            testSizeFromString = testSizeValue;
        }
        return testSizeFromString;
    }

    public static TestSize fromDescription(Description description) {
        TestSize testSize = NONE;
        for (TestSize testMethodSizeValue : ALL_SIZES) {
            if (!testMethodSizeValue.testMethodIsAnnotatedWithTestSize(description)) continue;
            testSize = testMethodSizeValue;
            break;
        }
        if (NONE.equals(testSize)) {
            for (TestSize testClassSizeValue : ALL_SIZES) {
                if (!testClassSizeValue.testClassIsAnnotatedWithTestSize(description)) continue;
                testSize = testClassSizeValue;
                break;
            }
        }
        return testSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestSize testSize = (TestSize)o;
        return this.mSizeQualifierName.equals(testSize.mSizeQualifierName);
    }

    public int hashCode() {
        return this.mSizeQualifierName.hashCode();
    }

    private static boolean runTimeSmallerThanThreshold(float testRuntime, float runtimeThreshold) {
        return Float.compare(testRuntime, runtimeThreshold) < 0;
    }

    private Class<? extends Annotation> getFrameworkAnnotation() {
        return this.mPlatformAnnotationClass;
    }

    private Class<? extends Annotation> getRunnerAnnotation() {
        return this.mRunnerFilterAnnotationClass;
    }
}

