/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.runner.screenshot;

import android.graphics.Bitmap;
import android.support.annotation.NonNull;
import android.support.test.annotation.Beta;
import android.support.test.internal.util.Checks;
import android.support.test.runner.screenshot.BasicScreenCaptureProcessor;
import android.support.test.runner.screenshot.ScreenCaptureProcessor;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

@Beta
public final class ScreenCapture {
    private static final Bitmap.CompressFormat DEFAULT_FORMAT = Bitmap.CompressFormat.PNG;
    private final Bitmap mBitmap;
    private ScreenCaptureProcessor mDefaultProcessor = new BasicScreenCaptureProcessor();
    private String mFilename;
    private Bitmap.CompressFormat mFormat;
    private Set<ScreenCaptureProcessor> mProcessorSet = new HashSet<ScreenCaptureProcessor>();

    ScreenCapture(Bitmap bitmap) {
        this.mBitmap = bitmap;
        this.mFormat = DEFAULT_FORMAT;
    }

    ScreenCapture(Bitmap bitmap, ScreenCaptureProcessor defaultProcessor) {
        this.mBitmap = bitmap;
        this.mFormat = DEFAULT_FORMAT;
        this.mDefaultProcessor = defaultProcessor;
    }

    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    public String getName() {
        return this.mFilename;
    }

    public Bitmap.CompressFormat getFormat() {
        return this.mFormat;
    }

    public ScreenCapture setName(String filename) {
        this.mFilename = filename;
        return this;
    }

    public ScreenCapture setFormat(Bitmap.CompressFormat format) {
        this.mFormat = format;
        return this;
    }

    ScreenCapture setProcessors(@NonNull Set<ScreenCaptureProcessor> processorSet) {
        this.mProcessorSet = Checks.checkNotNull(processorSet);
        return this;
    }

    Set<ScreenCaptureProcessor> getProcessors() {
        return this.mProcessorSet;
    }

    public void process() throws IOException {
        this.process(this.mProcessorSet);
    }

    public void process(@NonNull Set<ScreenCaptureProcessor> processorSet) throws IOException {
        Checks.checkNotNull(processorSet);
        if (processorSet.isEmpty()) {
            this.mDefaultProcessor.process(this);
            return;
        }
        for (ScreenCaptureProcessor processor : processorSet) {
            processor.process(this);
        }
    }

    public int hashCode() {
        int prime = 37;
        int result = 1;
        if (this.mBitmap != null) {
            result = 37 * result + this.mBitmap.hashCode();
        }
        if (this.mFormat != null) {
            result = 37 * result + this.mFormat.hashCode();
        }
        if (this.mFilename != null) {
            result = 37 * result + this.mFilename.hashCode();
        }
        if (!this.mProcessorSet.isEmpty()) {
            result = 37 * result + this.mProcessorSet.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScreenCapture)) {
            return false;
        }
        ScreenCapture other = (ScreenCapture)obj;
        boolean bitmapsEqual = this.mBitmap == null ? other.getBitmap() == null : this.getBitmap().sameAs(other.getBitmap());
        boolean nameEqual = this.mFilename == null ? other.getName() == null : this.mFilename.equals(other.getName());
        boolean formatEqual = this.mFormat == null ? other.getFormat() == null : this.mFormat.equals((Object)other.getFormat());
        return bitmapsEqual && nameEqual && formatEqual && this.mProcessorSet.containsAll(other.getProcessors()) && other.getProcessors().containsAll(this.mProcessorSet);
    }
}

