/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.runner.permission;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.support.test.internal.util.Checks;
import android.support.test.runner.permission.ShellCommand;
import android.text.TextUtils;
import java.util.Objects;
import java.util.concurrent.Callable;

@VisibleForTesting
public abstract class RequestPermissionCallable
implements Callable<Result> {
    private final ShellCommand mShellCommand;
    private final Context mTargetContext;
    private final String mTargetPackage;
    private final String mPermission;

    public RequestPermissionCallable(@NonNull ShellCommand shellCommand, @NonNull Context targetContext, String permission) {
        this.mShellCommand = Checks.checkNotNull(shellCommand, "shellCommand cannot be null!");
        this.mTargetContext = Checks.checkNotNull(targetContext, "targetContext cannot be null!");
        String targetPackage = this.mTargetContext.getPackageName();
        Checks.checkState(!TextUtils.isEmpty((CharSequence)targetPackage), "targetPackage cannot be empty or null!");
        this.mTargetPackage = targetPackage;
        this.mPermission = permission;
    }

    protected String getPermission() {
        return this.mPermission;
    }

    protected boolean isPermissionGranted() {
        return 0 == this.mTargetContext.checkCallingOrSelfPermission(this.mPermission);
    }

    protected ShellCommand getShellCommand() {
        return this.mShellCommand;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestPermissionCallable that = (RequestPermissionCallable)o;
        return Objects.equals(this.mTargetPackage, that.mTargetPackage) && Objects.equals(this.mPermission, that.mPermission);
    }

    public int hashCode() {
        return Objects.hash(this.mTargetPackage, this.mPermission);
    }

    public static enum Result {
        SUCCESS,
        FAILURE;

    }
}

