/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.orchestrator.listeners;

import android.support.test.orchestrator.junit.ParcelableDescription;
import android.support.test.orchestrator.junit.ParcelableFailure;
import android.support.test.orchestrator.listeners.OrchestrationResult;
import android.support.test.orchestrator.listeners.OrchestrationRunListener;
import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.List;

public class TextListener
extends OrchestrationRunListener {
    private final PrintStream writer;

    public TextListener(PrintStream writer) {
        this.writer = writer;
    }

    public void testRunFinished(OrchestrationResult result) {
        this.printHeader(result.getRunTime());
        this.printFailures(result);
        this.printFooter(result);
    }

    @Override
    public void testStarted(ParcelableDescription description) {
        this.writer.append('.');
    }

    @Override
    public void testFailure(ParcelableFailure failure) {
        this.writer.append('E');
    }

    @Override
    public void testIgnored(ParcelableDescription description) {
        this.writer.append('I');
    }

    private PrintStream getWriter() {
        return this.writer;
    }

    protected void printHeader(long runTime) {
        this.getWriter().println();
        String string = String.valueOf(this.elapsedTimeAsString(runTime));
        this.getWriter().println(string.length() != 0 ? "Time: ".concat(string) : new String("Time: "));
    }

    protected void printFailures(OrchestrationResult result) {
        int n;
        List<ParcelableFailure> failures = result.getFailures();
        if (failures.isEmpty()) {
            return;
        }
        if (failures.size() == 1) {
            n = failures.size();
            this.getWriter().println(new StringBuilder(30).append("There was ").append(n).append(" failure:").toString());
        } else {
            n = failures.size();
            this.getWriter().println(new StringBuilder(32).append("There were ").append(n).append(" failures:").toString());
        }
        int i = 1;
        for (ParcelableFailure each : failures) {
            int n2 = i++;
            this.printFailure(each, new StringBuilder(11).append(n2).toString());
        }
    }

    protected void printFailure(ParcelableFailure each, String prefix) {
        String string = each.getDescription().getDisplayName();
        this.getWriter().println(new StringBuilder(2 + String.valueOf(prefix).length() + String.valueOf(string).length()).append(prefix).append(") ").append(string).toString());
        this.getWriter().print(each.getTrace());
    }

    protected void printFooter(OrchestrationResult result) {
        if (result.wasSuccessful()) {
            this.getWriter().println();
            this.getWriter().print("OK");
            long l = result.getRunCount();
            String string = result.getRunCount() == 1L ? "" : "s";
            this.getWriter().println(new StringBuilder(28 + String.valueOf(string).length()).append(" (").append(l).append(" test").append(string).append(")").toString());
        } else {
            this.getWriter().println();
            this.getWriter().println("FAILURES!!!");
            long l = result.getExpectedCount();
            long l2 = result.getRunCount();
            int n = result.getFailureCount();
            this.getWriter().println(new StringBuilder(90).append("Tests found: ").append(l).append(", Tests run: ").append(l2).append(",  Failures: ").append(n).toString());
        }
        this.getWriter().println();
    }

    protected String elapsedTimeAsString(long runTime) {
        return NumberFormat.getInstance().format((double)runTime / 1000.0);
    }
}

