/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.internal.runner;

import android.support.annotation.VisibleForTesting;
import dalvik.system.DexFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

@VisibleForTesting
public class ClassPathScanner {
    private Set<String> mApkPaths = new HashSet<String>();

    public ClassPathScanner(String ... apkPaths) {
        this(Arrays.asList(apkPaths));
    }

    public ClassPathScanner(Collection<String> apkPaths) {
        this.mApkPaths.addAll(apkPaths);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEntriesFromApk(Set<String> entryNames, String apkPath, ClassNameFilter filter) throws IOException {
        try (DexFile dexFile = null;){
            dexFile = new DexFile(apkPath);
            Enumeration<String> apkClassNames = this.getDexEntries(dexFile);
            while (apkClassNames.hasMoreElements()) {
                String apkClassName = apkClassNames.nextElement();
                if (!filter.accept(apkClassName)) continue;
                entryNames.add(apkClassName);
            }
        }
    }

    @VisibleForTesting
    Enumeration<String> getDexEntries(DexFile dexFile) {
        return dexFile.entries();
    }

    public Set<String> getClassPathEntries(ClassNameFilter filter) throws IOException {
        LinkedHashSet<String> entryNames = new LinkedHashSet<String>();
        for (String apkPath : this.mApkPaths) {
            this.addEntriesFromApk(entryNames, apkPath, filter);
        }
        return entryNames;
    }

    static class ExcludeClassNamesFilter
    implements ClassNameFilter {
        private Set<String> mExcludedClassNames;

        public ExcludeClassNamesFilter(Set<String> excludedClassNames) {
            this.mExcludedClassNames = excludedClassNames;
        }

        @Override
        public boolean accept(String className) {
            return !this.mExcludedClassNames.contains(className);
        }
    }

    public static class ExcludePackageNameFilter
    implements ClassNameFilter {
        private final String mPkgName;

        ExcludePackageNameFilter(String pkgName) {
            this.mPkgName = !pkgName.endsWith(".") ? String.format("%s.", pkgName) : pkgName;
        }

        @Override
        public boolean accept(String pathName) {
            return !pathName.startsWith(this.mPkgName);
        }
    }

    public static class InclusivePackageNameFilter
    implements ClassNameFilter {
        private final String mPkgName;

        InclusivePackageNameFilter(String pkgName) {
            this.mPkgName = !pkgName.endsWith(".") ? String.format("%s.", pkgName) : pkgName;
        }

        @Override
        public boolean accept(String pathName) {
            return pathName.startsWith(this.mPkgName);
        }
    }

    public static class ExternalClassNameFilter
    implements ClassNameFilter {
        @Override
        public boolean accept(String pathName) {
            return !pathName.contains("$");
        }
    }

    public static class ChainedClassNameFilter
    implements ClassNameFilter {
        private final List<ClassNameFilter> mFilters = new ArrayList<ClassNameFilter>();

        public void add(ClassNameFilter filter) {
            this.mFilters.add(filter);
        }

        public void addAll(ClassNameFilter ... filters) {
            this.mFilters.addAll(Arrays.asList(filters));
        }

        @Override
        public boolean accept(String className) {
            for (ClassNameFilter filter : this.mFilters) {
                if (filter.accept(className)) continue;
                return false;
            }
            return true;
        }
    }

    public static class AcceptAllFilter
    implements ClassNameFilter {
        @Override
        public boolean accept(String className) {
            return true;
        }
    }

    public static interface ClassNameFilter {
        public boolean accept(String var1);
    }
}

