/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.rule.logging;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.test.annotation.Beta;
import android.support.test.rule.logging.LoggingBaseRule;
import android.support.test.rule.logging.RuleLoggingUtils;
import android.util.Log;
import java.io.File;

@Beta
public class LogBatteryInformationRule
extends LoggingBaseRule {
    private static final String TAG = "LogBatteryInformationRule";
    private static final String DEFAULT_LOG_FILE_NAME = "battery.dumpsys.log";

    public LogBatteryInformationRule() {
    }

    public LogBatteryInformationRule(@NonNull File logFileOutputDirectory, @Nullable String fileName) {
        super(logFileOutputDirectory, fileName);
    }

    @Override
    public void afterTest() {
        if (this.getAndroidRuntimeVersion() >= 21) {
            try {
                RuleLoggingUtils.startProcessAndLogToFile(new String[]{"dumpsys", "batterystats"}, this.getLogFile(), this.getAndroidRuntimeVersion());
            }
            catch (Exception exception) {
                Log.e((String)TAG, (String)"Unable to reset dumpsys", (Throwable)exception);
            }
        } else {
            Log.w((String)TAG, (String)"Batterystats dumpsys not supported on API versions less than 21");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeTest() {
        if (this.getAndroidRuntimeVersion() >= 21) {
            Process process = null;
            try {
                process = RuleLoggingUtils.startProcess(new String[]{"dumpsys", "batterystats", "--reset"});
                process.waitFor();
            }
            catch (Exception exception) {
                Log.e((String)TAG, (String)"Unable to reset dumpsys", (Throwable)exception);
            }
            finally {
                if (process != null) {
                    process.destroy();
                }
            }
        } else {
            Log.i((String)TAG, (String)"Batterystats dumpsys not supported on API versions less than 21");
        }
    }

    @Override
    public String getDefaultLogFileName() {
        return DEFAULT_LOG_FILE_NAME;
    }
}

