/*
 * Decompiled with CFR 0.152.
 */
package android.support.v13.view.inputmethod;

import android.annotation.TargetApi;
import android.content.ClipDescription;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v13.view.inputmethod.InputContentInfoCompatApi25;
import android.support.v4.os.BuildCompat;

@RequiresApi(value=13)
@TargetApi(value=13)
public final class InputContentInfoCompat {
    private final InputContentInfoCompatImpl mImpl;

    public InputContentInfoCompat(@NonNull Uri contentUri, @NonNull ClipDescription description, @Nullable Uri linkUri) {
        this.mImpl = BuildCompat.isAtLeastNMR1() ? new Api25InputContentInfoCompatImpl(contentUri, description, linkUri) : new BaseInputContentInfoCompatImpl(contentUri, description, linkUri);
    }

    private InputContentInfoCompat(@NonNull InputContentInfoCompatImpl impl) {
        this.mImpl = impl;
    }

    @NonNull
    public Uri getContentUri() {
        return this.mImpl.getContentUri();
    }

    @NonNull
    public ClipDescription getDescription() {
        return this.mImpl.getDescription();
    }

    @Nullable
    public Uri getLinkUri() {
        return this.mImpl.getLinkUri();
    }

    @Nullable
    public static InputContentInfoCompat wrap(@Nullable Object inputContentInfo) {
        if (inputContentInfo == null) {
            return null;
        }
        if (!BuildCompat.isAtLeastNMR1()) {
            return null;
        }
        return new InputContentInfoCompat(new Api25InputContentInfoCompatImpl(inputContentInfo));
    }

    @Nullable
    public Object unwrap() {
        return this.mImpl.getInputContentInfo();
    }

    public void requestPermission() {
        this.mImpl.requestPermission();
    }

    public void releasePermission() {
        this.mImpl.releasePermission();
    }

    private static final class Api25InputContentInfoCompatImpl
    implements InputContentInfoCompatImpl {
        @NonNull
        final Object mObject;

        public Api25InputContentInfoCompatImpl(@NonNull Object inputContentInfo) {
            this.mObject = inputContentInfo;
        }

        public Api25InputContentInfoCompatImpl(@NonNull Uri contentUri, @NonNull ClipDescription description, @Nullable Uri linkUri) {
            this.mObject = InputContentInfoCompatApi25.create(contentUri, description, linkUri);
        }

        @Override
        @NonNull
        public Uri getContentUri() {
            return InputContentInfoCompatApi25.getContentUri(this.mObject);
        }

        @Override
        @NonNull
        public ClipDescription getDescription() {
            return InputContentInfoCompatApi25.getDescription(this.mObject);
        }

        @Override
        @Nullable
        public Uri getLinkUri() {
            return InputContentInfoCompatApi25.getLinkUri(this.mObject);
        }

        @Override
        @Nullable
        public Object getInputContentInfo() {
            return this.mObject;
        }

        @Override
        public void requestPermission() {
            InputContentInfoCompatApi25.requestPermission(this.mObject);
        }

        @Override
        public void releasePermission() {
            InputContentInfoCompatApi25.releasePermission(this.mObject);
        }
    }

    private static final class BaseInputContentInfoCompatImpl
    implements InputContentInfoCompatImpl {
        @NonNull
        private final Uri mContentUri;
        @NonNull
        private final ClipDescription mDescription;
        @Nullable
        private final Uri mLinkUri;

        public BaseInputContentInfoCompatImpl(@NonNull Uri contentUri, @NonNull ClipDescription description, @Nullable Uri linkUri) {
            this.mContentUri = contentUri;
            this.mDescription = description;
            this.mLinkUri = linkUri;
        }

        @Override
        @NonNull
        public Uri getContentUri() {
            return this.mContentUri;
        }

        @Override
        @NonNull
        public ClipDescription getDescription() {
            return this.mDescription;
        }

        @Override
        @Nullable
        public Uri getLinkUri() {
            return this.mLinkUri;
        }

        @Override
        @Nullable
        public Object getInputContentInfo() {
            return null;
        }

        @Override
        public void requestPermission() {
        }

        @Override
        public void releasePermission() {
        }
    }

    private static interface InputContentInfoCompatImpl {
        @NonNull
        public Uri getContentUri();

        @NonNull
        public ClipDescription getDescription();

        @Nullable
        public Uri getLinkUri();

        @Nullable
        public Object getInputContentInfo();

        public void requestPermission();

        public void releasePermission();
    }
}

