/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.app;

import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.RequiresApi;
import android.support.annotation.RestrictTo;
import android.support.v4.app.RemoteInputCompatApi20;
import android.support.v4.app.RemoteInputCompatBase;
import android.support.v4.app.RemoteInputCompatJellybean;
import android.util.Log;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class RemoteInput
extends RemoteInputCompatBase.RemoteInput {
    private static final String TAG = "RemoteInput";
    public static final String RESULTS_CLIP_LABEL = "android.remoteinput.results";
    public static final String EXTRA_RESULTS_DATA = "android.remoteinput.resultsData";
    private static final String EXTRA_DATA_TYPE_RESULTS_DATA = "android.remoteinput.dataTypeResultsData";
    private final String mResultKey;
    private final CharSequence mLabel;
    private final CharSequence[] mChoices;
    private final boolean mAllowFreeFormTextInput;
    private final Bundle mExtras;
    private final Set<String> mAllowedDataTypes;
    private static final Impl IMPL = Build.VERSION.SDK_INT >= 20 ? new ImplApi20() : (Build.VERSION.SDK_INT >= 16 ? new ImplJellybean() : new ImplBase());
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final RemoteInputCompatBase.RemoteInput.Factory FACTORY = new RemoteInputCompatBase.RemoteInput.Factory(){

        @Override
        public RemoteInput build(String resultKey, CharSequence label, CharSequence[] choices, boolean allowFreeFormInput, Bundle extras, Set<String> allowedDataTypes) {
            return new RemoteInput(resultKey, label, choices, allowFreeFormInput, extras, allowedDataTypes);
        }

        public RemoteInput[] newArray(int size) {
            return new RemoteInput[size];
        }
    };

    RemoteInput(String resultKey, CharSequence label, CharSequence[] choices, boolean allowFreeFormTextInput, Bundle extras, Set<String> allowedDataTypes) {
        this.mResultKey = resultKey;
        this.mLabel = label;
        this.mChoices = choices;
        this.mAllowFreeFormTextInput = allowFreeFormTextInput;
        this.mExtras = extras;
        this.mAllowedDataTypes = allowedDataTypes;
    }

    @Override
    public String getResultKey() {
        return this.mResultKey;
    }

    @Override
    public CharSequence getLabel() {
        return this.mLabel;
    }

    @Override
    public CharSequence[] getChoices() {
        return this.mChoices;
    }

    @Override
    public Set<String> getAllowedDataTypes() {
        return this.mAllowedDataTypes;
    }

    public boolean isDataOnly() {
        return !this.getAllowFreeFormInput() && (this.getChoices() == null || this.getChoices().length == 0) && this.getAllowedDataTypes() != null && !this.getAllowedDataTypes().isEmpty();
    }

    @Override
    public boolean getAllowFreeFormInput() {
        return this.mAllowFreeFormTextInput;
    }

    @Override
    public Bundle getExtras() {
        return this.mExtras;
    }

    public static Map<String, Uri> getDataResultsFromIntent(Intent intent, String remoteInputResultKey) {
        return IMPL.getDataResultsFromIntent(intent, remoteInputResultKey);
    }

    public static Bundle getResultsFromIntent(Intent intent) {
        return IMPL.getResultsFromIntent(intent);
    }

    public static void addResultsToIntent(RemoteInput[] remoteInputs, Intent intent, Bundle results) {
        IMPL.addResultsToIntent(remoteInputs, intent, results);
    }

    public static void addDataResultToIntent(RemoteInput remoteInput, Intent intent, Map<String, Uri> results) {
        IMPL.addDataResultToIntent(remoteInput, intent, results);
    }

    @RequiresApi(value=20)
    static class ImplApi20
    implements Impl {
        ImplApi20() {
        }

        @Override
        public Bundle getResultsFromIntent(Intent intent) {
            return RemoteInputCompatApi20.getResultsFromIntent(intent);
        }

        @Override
        public Map<String, Uri> getDataResultsFromIntent(Intent intent, String remoteInputResultKey) {
            return RemoteInputCompatApi20.getDataResultsFromIntent(intent, remoteInputResultKey);
        }

        @Override
        public void addResultsToIntent(RemoteInput[] remoteInputs, Intent intent, Bundle results) {
            RemoteInputCompatApi20.addResultsToIntent(remoteInputs, intent, results);
        }

        @Override
        public void addDataResultToIntent(RemoteInput remoteInput, Intent intent, Map<String, Uri> results) {
            RemoteInputCompatApi20.addDataResultToIntent(remoteInput, intent, results);
        }
    }

    @RequiresApi(value=16)
    static class ImplJellybean
    implements Impl {
        ImplJellybean() {
        }

        @Override
        public Bundle getResultsFromIntent(Intent intent) {
            return RemoteInputCompatJellybean.getResultsFromIntent(intent);
        }

        @Override
        public Map<String, Uri> getDataResultsFromIntent(Intent intent, String remoteInputResultKey) {
            return RemoteInputCompatJellybean.getDataResultsFromIntent(intent, remoteInputResultKey);
        }

        @Override
        public void addResultsToIntent(RemoteInput[] remoteInputs, Intent intent, Bundle results) {
            RemoteInputCompatJellybean.addResultsToIntent(remoteInputs, intent, results);
        }

        @Override
        public void addDataResultToIntent(RemoteInput remoteInput, Intent intent, Map<String, Uri> results) {
            RemoteInputCompatJellybean.addDataResultToIntent(remoteInput, intent, results);
        }
    }

    static class ImplBase
    implements Impl {
        ImplBase() {
        }

        @Override
        public Bundle getResultsFromIntent(Intent intent) {
            Log.w((String)RemoteInput.TAG, (String)"RemoteInput is only supported from API Level 16");
            return null;
        }

        @Override
        public Map<String, Uri> getDataResultsFromIntent(Intent intent, String remoteInputResultKey) {
            Log.w((String)RemoteInput.TAG, (String)"RemoteInput is only supported from API Level 16");
            return null;
        }

        @Override
        public void addResultsToIntent(RemoteInput[] remoteInputs, Intent intent, Bundle results) {
            Log.w((String)RemoteInput.TAG, (String)"RemoteInput is only supported from API Level 16");
        }

        @Override
        public void addDataResultToIntent(RemoteInput remoteInput, Intent intent, Map<String, Uri> results) {
            Log.w((String)RemoteInput.TAG, (String)"RemoteInput is only supported from API Level 16");
        }
    }

    static interface Impl {
        public Bundle getResultsFromIntent(Intent var1);

        public Map<String, Uri> getDataResultsFromIntent(Intent var1, String var2);

        public void addResultsToIntent(RemoteInput[] var1, Intent var2, Bundle var3);

        public void addDataResultToIntent(RemoteInput var1, Intent var2, Map<String, Uri> var3);
    }

    public static final class Builder {
        private final String mResultKey;
        private CharSequence mLabel;
        private CharSequence[] mChoices;
        private boolean mAllowFreeFormTextInput = true;
        private Bundle mExtras = new Bundle();
        private final Set<String> mAllowedDataTypes = new HashSet<String>();

        public Builder(String resultKey) {
            if (resultKey == null) {
                throw new IllegalArgumentException("Result key can't be null");
            }
            this.mResultKey = resultKey;
        }

        public Builder setLabel(CharSequence label) {
            this.mLabel = label;
            return this;
        }

        public Builder setChoices(CharSequence[] choices) {
            this.mChoices = choices;
            return this;
        }

        public Builder setAllowDataType(String mimeType, boolean doAllow) {
            if (doAllow) {
                this.mAllowedDataTypes.add(mimeType);
            } else {
                this.mAllowedDataTypes.remove(mimeType);
            }
            return this;
        }

        public Builder setAllowFreeFormInput(boolean allowFreeFormTextInput) {
            this.mAllowFreeFormTextInput = allowFreeFormTextInput;
            return this;
        }

        public Builder addExtras(Bundle extras) {
            if (extras != null) {
                this.mExtras.putAll(extras);
            }
            return this;
        }

        public Bundle getExtras() {
            return this.mExtras;
        }

        public RemoteInput build() {
            return new RemoteInput(this.mResultKey, this.mLabel, this.mChoices, this.mAllowFreeFormTextInput, this.mExtras, this.mAllowedDataTypes);
        }
    }
}

