/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.widget;

import android.os.Build;
import android.support.v4.view.GravityCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.PopupWindowCompatApi21;
import android.support.v4.widget.PopupWindowCompatApi23;
import android.support.v4.widget.PopupWindowCompatKitKat;
import android.view.View;
import android.widget.PopupWindow;
import java.lang.reflect.Method;

public final class PopupWindowCompat {
    static final PopupWindowImpl IMPL;

    private PopupWindowCompat() {
    }

    public static void showAsDropDown(PopupWindow popup, View anchor, int xoff, int yoff, int gravity) {
        IMPL.showAsDropDown(popup, anchor, xoff, yoff, gravity);
    }

    public static void setOverlapAnchor(PopupWindow popupWindow, boolean overlapAnchor) {
        IMPL.setOverlapAnchor(popupWindow, overlapAnchor);
    }

    public static boolean getOverlapAnchor(PopupWindow popupWindow) {
        return IMPL.getOverlapAnchor(popupWindow);
    }

    public static void setWindowLayoutType(PopupWindow popupWindow, int layoutType) {
        IMPL.setWindowLayoutType(popupWindow, layoutType);
    }

    public static int getWindowLayoutType(PopupWindow popupWindow) {
        return IMPL.getWindowLayoutType(popupWindow);
    }

    static {
        int version = Build.VERSION.SDK_INT;
        IMPL = version >= 23 ? new Api23PopupWindowImpl() : (version >= 21 ? new Api21PopupWindowImpl() : (version >= 19 ? new KitKatPopupWindowImpl() : new BasePopupWindowImpl()));
    }

    static class Api23PopupWindowImpl
    extends Api21PopupWindowImpl {
        Api23PopupWindowImpl() {
        }

        @Override
        public void setOverlapAnchor(PopupWindow popupWindow, boolean overlapAnchor) {
            PopupWindowCompatApi23.setOverlapAnchor((PopupWindow)popupWindow, (boolean)overlapAnchor);
        }

        @Override
        public boolean getOverlapAnchor(PopupWindow popupWindow) {
            return PopupWindowCompatApi23.getOverlapAnchor((PopupWindow)popupWindow);
        }

        @Override
        public void setWindowLayoutType(PopupWindow popupWindow, int layoutType) {
            PopupWindowCompatApi23.setWindowLayoutType((PopupWindow)popupWindow, (int)layoutType);
        }

        @Override
        public int getWindowLayoutType(PopupWindow popupWindow) {
            return PopupWindowCompatApi23.getWindowLayoutType((PopupWindow)popupWindow);
        }
    }

    static class Api21PopupWindowImpl
    extends KitKatPopupWindowImpl {
        Api21PopupWindowImpl() {
        }

        @Override
        public void setOverlapAnchor(PopupWindow popupWindow, boolean overlapAnchor) {
            PopupWindowCompatApi21.setOverlapAnchor((PopupWindow)popupWindow, (boolean)overlapAnchor);
        }

        @Override
        public boolean getOverlapAnchor(PopupWindow popupWindow) {
            return PopupWindowCompatApi21.getOverlapAnchor((PopupWindow)popupWindow);
        }
    }

    static class KitKatPopupWindowImpl
    extends BasePopupWindowImpl {
        KitKatPopupWindowImpl() {
        }

        @Override
        public void showAsDropDown(PopupWindow popup, View anchor, int xoff, int yoff, int gravity) {
            PopupWindowCompatKitKat.showAsDropDown((PopupWindow)popup, (View)anchor, (int)xoff, (int)yoff, (int)gravity);
        }
    }

    static class BasePopupWindowImpl
    implements PopupWindowImpl {
        private static Method sSetWindowLayoutTypeMethod;
        private static boolean sSetWindowLayoutTypeMethodAttempted;
        private static Method sGetWindowLayoutTypeMethod;
        private static boolean sGetWindowLayoutTypeMethodAttempted;

        BasePopupWindowImpl() {
        }

        @Override
        public void showAsDropDown(PopupWindow popup, View anchor, int xoff, int yoff, int gravity) {
            int hgrav = GravityCompat.getAbsoluteGravity(gravity, ViewCompat.getLayoutDirection(anchor)) & 7;
            if (hgrav == 5) {
                xoff -= popup.getWidth() - anchor.getWidth();
            }
            popup.showAsDropDown(anchor, xoff, yoff);
        }

        @Override
        public void setOverlapAnchor(PopupWindow popupWindow, boolean overlapAnchor) {
        }

        @Override
        public boolean getOverlapAnchor(PopupWindow popupWindow) {
            return false;
        }

        @Override
        public void setWindowLayoutType(PopupWindow popupWindow, int layoutType) {
            if (!sSetWindowLayoutTypeMethodAttempted) {
                try {
                    sSetWindowLayoutTypeMethod = PopupWindow.class.getDeclaredMethod("setWindowLayoutType", Integer.TYPE);
                    sSetWindowLayoutTypeMethod.setAccessible(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                sSetWindowLayoutTypeMethodAttempted = true;
            }
            if (sSetWindowLayoutTypeMethod != null) {
                try {
                    sSetWindowLayoutTypeMethod.invoke((Object)popupWindow, layoutType);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public int getWindowLayoutType(PopupWindow popupWindow) {
            if (!sGetWindowLayoutTypeMethodAttempted) {
                try {
                    sGetWindowLayoutTypeMethod = PopupWindow.class.getDeclaredMethod("getWindowLayoutType", new Class[0]);
                    sGetWindowLayoutTypeMethod.setAccessible(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                sGetWindowLayoutTypeMethodAttempted = true;
            }
            if (sGetWindowLayoutTypeMethod != null) {
                try {
                    return (Integer)sGetWindowLayoutTypeMethod.invoke((Object)popupWindow, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return 0;
        }
    }

    static interface PopupWindowImpl {
        public void showAsDropDown(PopupWindow var1, View var2, int var3, int var4, int var5);

        public void setOverlapAnchor(PopupWindow var1, boolean var2);

        public boolean getOverlapAnchor(PopupWindow var1);

        public void setWindowLayoutType(PopupWindow var1, int var2);

        public int getWindowLayoutType(PopupWindow var1);
    }
}

