/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.preference;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import android.support.v7.preference.ListPreference;
import android.support.v7.preference.PreferenceViewHolder;
import android.support.v7.preference.R;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Spinner;

public class DropDownPreference
extends ListPreference {
    private final Context mContext;
    private final ArrayAdapter<String> mAdapter;
    private Spinner mSpinner;
    private final AdapterView.OnItemSelectedListener mItemSelectedListener = new AdapterView.OnItemSelectedListener(){

        public void onItemSelected(AdapterView<?> parent, View v, int position, long id2) {
            String value;
            if (position >= 0 && !(value = DropDownPreference.this.getEntryValues()[position].toString()).equals(DropDownPreference.this.getValue()) && DropDownPreference.this.callChangeListener(value)) {
                DropDownPreference.this.setValue(value);
            }
        }

        public void onNothingSelected(AdapterView<?> parent) {
        }
    };

    public DropDownPreference(Context context) {
        this(context, null);
    }

    public DropDownPreference(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.dropdownPreferenceStyle);
    }

    public DropDownPreference(Context context, AttributeSet attrs, int defStyle) {
        this(context, attrs, defStyle, 0);
    }

    public DropDownPreference(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.mContext = context;
        this.mAdapter = this.createAdapter();
        this.updateEntries();
    }

    @Override
    protected void onClick() {
        this.mSpinner.performClick();
    }

    @Override
    public void setEntries(@NonNull CharSequence[] entries) {
        super.setEntries(entries);
        this.updateEntries();
    }

    protected ArrayAdapter createAdapter() {
        return new ArrayAdapter(this.mContext, 0x1090009);
    }

    private void updateEntries() {
        this.mAdapter.clear();
        if (this.getEntries() != null) {
            for (CharSequence c : this.getEntries()) {
                this.mAdapter.add((Object)c.toString());
            }
        }
    }

    @Override
    public void setValueIndex(int index) {
        this.setValue(this.getEntryValues()[index].toString());
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int findSpinnerIndexOfValue(String value) {
        CharSequence[] entryValues = this.getEntryValues();
        if (value != null && entryValues != null) {
            for (int i = entryValues.length - 1; i >= 0; --i) {
                if (!entryValues[i].equals(value)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    protected void notifyChanged() {
        super.notifyChanged();
        this.mAdapter.notifyDataSetChanged();
    }

    @Override
    public void onBindViewHolder(PreferenceViewHolder view) {
        this.mSpinner = (Spinner)view.itemView.findViewById(R.id.spinner);
        this.mSpinner.setAdapter(this.mAdapter);
        this.mSpinner.setOnItemSelectedListener(this.mItemSelectedListener);
        this.mSpinner.setSelection(this.findSpinnerIndexOfValue(this.getValue()));
        super.onBindViewHolder(view);
    }
}

