/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.motion.utils;

import android.util.Log;
import java.util.Arrays;

public class Easing {
    static Easing sDefault = new Easing();
    String str = "identity";
    private static final String STANDARD = "cubic(0.4, 0.0, 0.2, 1)";
    private static final String ACCELERATE = "cubic(0.4, 0.05, 0.8, 0.7)";
    private static final String DECELERATE = "cubic(0.0, 0.0, 0.2, 0.95)";
    private static final String LINEAR = "cubic(1, 1, 0, 0)";
    private static final String DECELERATE_NAME = "decelerate";
    private static final String ACCELERATE_NAME = "accelerate";
    private static final String STANDARD_NAME = "standard";
    private static final String LINEAR_NAME = "linear";
    public static String[] NAMED_EASING = new String[]{"standard", "accelerate", "decelerate", "linear"};

    public static Easing getInterpolator(String configString) {
        if (configString == null) {
            return null;
        }
        if (configString.startsWith("cubic")) {
            return new CubicEasing(configString);
        }
        switch (configString) {
            case "standard": {
                return new CubicEasing(STANDARD);
            }
            case "accelerate": {
                return new CubicEasing(ACCELERATE);
            }
            case "decelerate": {
                return new CubicEasing(DECELERATE);
            }
            case "linear": {
                return new CubicEasing(LINEAR);
            }
        }
        Log.e((String)"ConstraintSet", (String)("transitionEasing syntax error syntax:transitionEasing=\"cubic(1.0,0.5,0.0,0.6)\" or " + Arrays.toString(NAMED_EASING)));
        return sDefault;
    }

    public double get(double x) {
        return x;
    }

    public String toString() {
        return this.str;
    }

    public double getDiff(double x) {
        return 1.0;
    }

    static class CubicEasing
    extends Easing {
        private static double error = 0.01;
        private static double d_error = 1.0E-4;
        double x1;
        double y1;
        double x2;
        double y2;

        CubicEasing(String configString) {
            this.str = configString;
            int start = configString.indexOf(40);
            int off1 = configString.indexOf(44, start);
            this.x1 = Double.parseDouble(configString.substring(start + 1, off1).trim());
            int off2 = configString.indexOf(44, off1 + 1);
            this.y1 = Double.parseDouble(configString.substring(off1 + 1, off2).trim());
            int off3 = configString.indexOf(44, off2 + 1);
            this.x2 = Double.parseDouble(configString.substring(off2 + 1, off3).trim());
            int end = configString.indexOf(41, off3 + 1);
            this.y2 = Double.parseDouble(configString.substring(off3 + 1, end).trim());
        }

        public CubicEasing(double x1, double y1, double x2, double y2) {
            this.setup(x1, y1, x2, y2);
        }

        void setup(double x1, double y1, double x2, double y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        private double getX(double t) {
            double t1 = 1.0 - t;
            double f1 = 3.0 * t1 * t1 * t;
            double f2 = 3.0 * t1 * t * t;
            double f3 = t * t * t;
            return this.x1 * f1 + this.x2 * f2 + f3;
        }

        private double getY(double t) {
            double t1 = 1.0 - t;
            double f1 = 3.0 * t1 * t1 * t;
            double f2 = 3.0 * t1 * t * t;
            double f3 = t * t * t;
            return this.y1 * f1 + this.y2 * f2 + f3;
        }

        private double getDiffX(double t) {
            double t1 = 1.0 - t;
            return 3.0 * t1 * t1 * this.x1 + 6.0 * t1 * t * (this.x2 - this.x1) + 3.0 * t * t * (1.0 - this.x2);
        }

        private double getDiffY(double t) {
            double t1 = 1.0 - t;
            return 3.0 * t1 * t1 * this.y1 + 6.0 * t1 * t * (this.y2 - this.y1) + 3.0 * t * t * (1.0 - this.y2);
        }

        @Override
        public double getDiff(double x) {
            double t = 0.5;
            double range = 0.5;
            while (range > d_error) {
                double tx = this.getX(t);
                range *= 0.5;
                if (tx < x) {
                    t += range;
                    continue;
                }
                t -= range;
            }
            double x1 = this.getX(t - range);
            double x2 = this.getX(t + range);
            double y1 = this.getY(t - range);
            double y2 = this.getY(t + range);
            return (y2 - y1) / (x2 - x1);
        }

        @Override
        public double get(double x) {
            if (x <= 0.0) {
                return 0.0;
            }
            if (x >= 1.0) {
                return 1.0;
            }
            double t = 0.5;
            double range = 0.5;
            while (range > error) {
                double tx = this.getX(t);
                range *= 0.5;
                if (tx < x) {
                    t += range;
                    continue;
                }
                t -= range;
            }
            double x1 = this.getX(t - range);
            double x2 = this.getX(t + range);
            double y1 = this.getY(t - range);
            double y2 = this.getY(t + range);
            return (y2 - y1) * (x - x1) / (x2 - x1) + y1;
        }
    }
}

