/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.motion;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.RectF;
import android.support.constraint.R;
import android.support.constraint.motion.Debug;
import android.support.constraint.motion.MotionLayout;
import android.support.constraint.motion.MotionScene;
import android.support.v4.widget.NestedScrollView;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Xml;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import org.xmlpull.v1.XmlPullParser;

class TouchResponse {
    private static final String TAG = "TouchResponse";
    private static final boolean DEBUG = false;
    private int mTouchAnchorSide = 0;
    private int mTouchSide = 0;
    private int mOnTouchUp = 0;
    private int mTouchAnchorId = -1;
    private int mTouchRegionId = -1;
    private int mLimitBoundsTo = -1;
    private float mTouchAnchorY = 0.5f;
    private float mTouchAnchorX = 0.5f;
    private float mTouchDirectionX = 0.0f;
    private float mTouchDirectionY = 1.0f;
    private boolean mDragStarted = false;
    private float[] mAnchorDpDt = new float[2];
    private float mLastTouchX;
    private float mLastTouchY;
    private final MotionLayout mMotionLayout;
    private static final float[][] TOUCH_SIDES = new float[][]{{0.5f, 0.0f}, {0.0f, 0.5f}, {1.0f, 0.5f}, {0.5f, 1.0f}, {0.5f, 0.5f}, {0.0f, 0.5f}, {1.0f, 0.5f}};
    private static final float[][] TOUCH_DIRECTION = new float[][]{{0.0f, -1.0f}, {0.0f, 1.0f}, {-1.0f, 0.0f}, {1.0f, 0.0f}, {-1.0f, 0.0f}, {1.0f, 0.0f}};
    private static final int TOUCH_UP = 0;
    private static final int TOUCH_DOWN = 1;
    private static final int TOUCH_LEFT = 2;
    private static final int TOUCH_RIGHT = 3;
    private static final int TOUCH_START = 4;
    private static final int TOUCH_END = 5;
    private static final int SIDE_TOP = 0;
    private static final int SIDE_LEFT = 1;
    private static final int SIDE_RIGHT = 2;
    private static final int SIDE_BOTTOM = 3;
    private static final int SIDE_MIDDLE = 4;
    private static final int SIDE_START = 5;
    private static final int SIDE_END = 6;
    private float mMaxVelocity = 4.0f;
    private float mMaxAcceleration = 1.2f;
    private boolean mMoveWhenScrollAtTop = true;
    private float mDragScale = 1.0f;
    private int mFlags = 0;
    static final int FLAG_DISABLE_POST_SCROLL = 1;
    static final int FLAG_DISABLE_SCROLL = 2;
    private float mDragThreshold = 10.0f;

    TouchResponse(Context context, MotionLayout layout, XmlPullParser parser) {
        this.mMotionLayout = layout;
        this.fillFromAttributeList(context, Xml.asAttributeSet((XmlPullParser)parser));
    }

    public void setRTL(boolean rtl) {
        if (rtl) {
            TouchResponse.TOUCH_DIRECTION[4] = TOUCH_DIRECTION[3];
            TouchResponse.TOUCH_DIRECTION[5] = TOUCH_DIRECTION[2];
            TouchResponse.TOUCH_SIDES[5] = TOUCH_SIDES[2];
            TouchResponse.TOUCH_SIDES[6] = TOUCH_SIDES[1];
        } else {
            TouchResponse.TOUCH_DIRECTION[4] = TOUCH_DIRECTION[2];
            TouchResponse.TOUCH_DIRECTION[5] = TOUCH_DIRECTION[3];
            TouchResponse.TOUCH_SIDES[5] = TOUCH_SIDES[1];
            TouchResponse.TOUCH_SIDES[6] = TOUCH_SIDES[2];
        }
        this.mTouchAnchorX = TOUCH_SIDES[this.mTouchAnchorSide][0];
        this.mTouchAnchorY = TOUCH_SIDES[this.mTouchAnchorSide][1];
        this.mTouchDirectionX = TOUCH_DIRECTION[this.mTouchSide][0];
        this.mTouchDirectionY = TOUCH_DIRECTION[this.mTouchSide][1];
    }

    private void fillFromAttributeList(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.OnSwipe);
        this.fill(a);
        a.recycle();
    }

    private void fill(TypedArray a) {
        int N = a.getIndexCount();
        for (int i = 0; i < N; ++i) {
            int attr = a.getIndex(i);
            if (attr == R.styleable.OnSwipe_touchAnchorId) {
                this.mTouchAnchorId = a.getResourceId(attr, this.mTouchAnchorId);
                continue;
            }
            if (attr == R.styleable.OnSwipe_touchAnchorSide) {
                this.mTouchAnchorSide = a.getInt(attr, this.mTouchAnchorSide);
                this.mTouchAnchorX = TOUCH_SIDES[this.mTouchAnchorSide][0];
                this.mTouchAnchorY = TOUCH_SIDES[this.mTouchAnchorSide][1];
                continue;
            }
            if (attr == R.styleable.OnSwipe_dragDirection) {
                this.mTouchSide = a.getInt(attr, this.mTouchSide);
                this.mTouchDirectionX = TOUCH_DIRECTION[this.mTouchSide][0];
                this.mTouchDirectionY = TOUCH_DIRECTION[this.mTouchSide][1];
                continue;
            }
            if (attr == R.styleable.OnSwipe_maxVelocity) {
                this.mMaxVelocity = a.getFloat(attr, this.mMaxVelocity);
                continue;
            }
            if (attr == R.styleable.OnSwipe_maxAcceleration) {
                this.mMaxAcceleration = a.getFloat(attr, this.mMaxAcceleration);
                continue;
            }
            if (attr == R.styleable.OnSwipe_moveWhenScrollAtTop) {
                this.mMoveWhenScrollAtTop = a.getBoolean(attr, this.mMoveWhenScrollAtTop);
                continue;
            }
            if (attr == R.styleable.OnSwipe_dragScale) {
                this.mDragScale = a.getFloat(attr, this.mDragScale);
                continue;
            }
            if (attr == R.styleable.OnSwipe_dragThreshold) {
                this.mDragThreshold = a.getFloat(attr, this.mDragThreshold);
                continue;
            }
            if (attr == R.styleable.OnSwipe_touchRegionId) {
                this.mTouchRegionId = a.getResourceId(attr, this.mTouchRegionId);
                continue;
            }
            if (attr == R.styleable.OnSwipe_onTouchUp) {
                this.mOnTouchUp = a.getInt(attr, this.mOnTouchUp);
                continue;
            }
            if (attr == R.styleable.OnSwipe_nestedScrollFlags) {
                this.mFlags = a.getInteger(attr, 0);
                continue;
            }
            if (attr != R.styleable.OnSwipe_limitBoundsTo) continue;
            this.mLimitBoundsTo = a.getResourceId(attr, 0);
        }
    }

    void setUpTouchEvent(float lastTouchX, float lastTouchY) {
        this.mLastTouchX = lastTouchX;
        this.mLastTouchY = lastTouchY;
        this.mDragStarted = false;
    }

    void processTouchEvent(MotionEvent event, MotionLayout.MotionTracker velocityTracker, int currentState, MotionScene motionScene) {
        velocityTracker.addMovement(event);
        switch (event.getAction()) {
            case 0: {
                this.mLastTouchX = event.getRawX();
                this.mLastTouchY = event.getRawY();
                this.mDragStarted = false;
                break;
            }
            case 2: {
                float change;
                float dy = event.getRawY() - this.mLastTouchY;
                float dx = event.getRawX() - this.mLastTouchX;
                float drag = dx * this.mTouchDirectionX + dy * this.mTouchDirectionY;
                if (!(Math.abs(drag) > this.mDragThreshold) && !this.mDragStarted) break;
                float pos = this.mMotionLayout.getProgress();
                if (!this.mDragStarted) {
                    this.mDragStarted = true;
                    this.mMotionLayout.setProgress(pos);
                }
                if (this.mTouchAnchorId != -1) {
                    this.mMotionLayout.getAnchorDpDt(this.mTouchAnchorId, pos, this.mTouchAnchorX, this.mTouchAnchorY, this.mAnchorDpDt);
                } else {
                    float minSize = Math.min(this.mMotionLayout.getWidth(), this.mMotionLayout.getHeight());
                    this.mAnchorDpDt[1] = minSize * this.mTouchDirectionY;
                    this.mAnchorDpDt[0] = minSize * this.mTouchDirectionX;
                }
                float movmentInDir = this.mTouchDirectionX * this.mAnchorDpDt[0] + this.mTouchDirectionY * this.mAnchorDpDt[1];
                movmentInDir *= this.mDragScale;
                if ((double)Math.abs(movmentInDir) < 0.01) {
                    this.mAnchorDpDt[0] = 0.01f;
                    this.mAnchorDpDt[1] = 0.01f;
                }
                if ((pos = Math.max(Math.min(pos + (change = this.mTouchDirectionX != 0.0f ? dx / this.mAnchorDpDt[0] : dy / this.mAnchorDpDt[1]), 1.0f), 0.0f)) != this.mMotionLayout.getProgress()) {
                    float velocity;
                    this.mMotionLayout.setProgress(pos);
                    velocityTracker.computeCurrentVelocity(1000);
                    float tvx = velocityTracker.getXVelocity();
                    float tvy = velocityTracker.getYVelocity();
                    this.mMotionLayout.mLastVelocity = velocity = this.mTouchDirectionX != 0.0f ? tvx / this.mAnchorDpDt[0] : tvy / this.mAnchorDpDt[1];
                } else {
                    this.mMotionLayout.mLastVelocity = 0.0f;
                }
                this.mLastTouchX = event.getRawX();
                this.mLastTouchY = event.getRawY();
                break;
            }
            case 1: {
                float currentPos;
                this.mDragStarted = false;
                velocityTracker.computeCurrentVelocity(1000);
                float tvx = velocityTracker.getXVelocity();
                float tvy = velocityTracker.getYVelocity();
                float pos = currentPos = this.mMotionLayout.getProgress();
                if (this.mTouchAnchorId != -1) {
                    this.mMotionLayout.getAnchorDpDt(this.mTouchAnchorId, pos, this.mTouchAnchorX, this.mTouchAnchorY, this.mAnchorDpDt);
                } else {
                    float minSize = Math.min(this.mMotionLayout.getWidth(), this.mMotionLayout.getHeight());
                    this.mAnchorDpDt[1] = minSize * this.mTouchDirectionY;
                    this.mAnchorDpDt[0] = minSize * this.mTouchDirectionX;
                }
                float movmentInDir = this.mTouchDirectionX * this.mAnchorDpDt[0] + this.mTouchDirectionY * this.mAnchorDpDt[1];
                float velocity = this.mTouchDirectionX != 0.0f ? tvx / this.mAnchorDpDt[0] : tvy / this.mAnchorDpDt[1];
                if (!Float.isNaN(velocity)) {
                    pos += velocity / 3.0f;
                }
                if (pos != 0.0f && pos != 1.0f && this.mOnTouchUp != 3) {
                    this.mMotionLayout.touchAnimateTo(this.mOnTouchUp, (double)pos < 0.5 ? 0.0f : 1.0f, velocity);
                    if (!(0.0f >= currentPos) && !(1.0f <= currentPos)) break;
                    this.mMotionLayout.setState(MotionLayout.TransitionState.FINISHED);
                    break;
                }
                if (!(0.0f >= pos) && !(1.0f <= pos)) break;
                this.mMotionLayout.setState(MotionLayout.TransitionState.FINISHED);
            }
        }
    }

    void setDown(float lastTouchX, float lastTouchY) {
        this.mLastTouchX = lastTouchX;
        this.mLastTouchY = lastTouchY;
    }

    float getProgressDirection(float dx, float dy) {
        float velocity;
        float pos = this.mMotionLayout.getProgress();
        this.mMotionLayout.getAnchorDpDt(this.mTouchAnchorId, pos, this.mTouchAnchorX, this.mTouchAnchorY, this.mAnchorDpDt);
        if (this.mTouchDirectionX != 0.0f) {
            if (this.mAnchorDpDt[0] == 0.0f) {
                this.mAnchorDpDt[0] = 1.0E-7f;
            }
            velocity = dx * this.mTouchDirectionX / this.mAnchorDpDt[0];
        } else {
            if (this.mAnchorDpDt[1] == 0.0f) {
                this.mAnchorDpDt[1] = 1.0E-7f;
            }
            velocity = dy * this.mTouchDirectionY / this.mAnchorDpDt[1];
        }
        return velocity;
    }

    void scrollUp(float dx, float dy) {
        this.mDragStarted = false;
        float pos = this.mMotionLayout.getProgress();
        this.mMotionLayout.getAnchorDpDt(this.mTouchAnchorId, pos, this.mTouchAnchorX, this.mTouchAnchorY, this.mAnchorDpDt);
        float movmentInDir = this.mTouchDirectionX * this.mAnchorDpDt[0] + this.mTouchDirectionY * this.mAnchorDpDt[1];
        float velocity = this.mTouchDirectionX != 0.0f ? dx * this.mTouchDirectionX / this.mAnchorDpDt[0] : dy * this.mTouchDirectionY / this.mAnchorDpDt[1];
        if (!Float.isNaN(velocity)) {
            pos += velocity / 3.0f;
        }
        if (pos != 0.0f && pos != 1.0f & this.mOnTouchUp != 3) {
            this.mMotionLayout.touchAnimateTo(this.mOnTouchUp, (double)pos < 0.5 ? 0.0f : 1.0f, velocity);
        }
    }

    void scrollMove(float dx, float dy) {
        float change;
        float drag = dx * this.mTouchDirectionX + dy * this.mTouchDirectionY;
        float pos = this.mMotionLayout.getProgress();
        if (!this.mDragStarted) {
            this.mDragStarted = true;
            this.mMotionLayout.setProgress(pos);
        }
        this.mMotionLayout.getAnchorDpDt(this.mTouchAnchorId, pos, this.mTouchAnchorX, this.mTouchAnchorY, this.mAnchorDpDt);
        float movmentInDir = this.mTouchDirectionX * this.mAnchorDpDt[0] + this.mTouchDirectionY * this.mAnchorDpDt[1];
        if ((double)Math.abs(movmentInDir) < 0.01) {
            this.mAnchorDpDt[0] = 0.01f;
            this.mAnchorDpDt[1] = 0.01f;
        }
        if ((pos = Math.max(Math.min(pos + (change = this.mTouchDirectionX != 0.0f ? dx * this.mTouchDirectionX / this.mAnchorDpDt[0] : dy * this.mTouchDirectionY / this.mAnchorDpDt[1]), 1.0f), 0.0f)) != this.mMotionLayout.getProgress()) {
            this.mMotionLayout.setProgress(pos);
        }
    }

    void setupTouch() {
        View view = null;
        if (this.mTouchAnchorId != -1 && (view = this.mMotionLayout.findViewById(this.mTouchAnchorId)) == null) {
            Log.e((String)TAG, (String)("cannot find TouchAnchorId @id/" + Debug.getName(this.mMotionLayout.getContext(), this.mTouchAnchorId)));
        }
        if (view instanceof NestedScrollView) {
            NestedScrollView sv = (NestedScrollView)view;
            sv.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View view, MotionEvent motionEvent) {
                    return false;
                }
            });
            sv.setOnScrollChangeListener(new NestedScrollView.OnScrollChangeListener(){

                public void onScrollChange(NestedScrollView v, int scrollX, int scrollY, int oldScrollX, int oldScrollY) {
                }
            });
        }
    }

    public void setAnchorId(int id2) {
        this.mTouchAnchorId = id2;
    }

    public int getAnchorId() {
        return this.mTouchAnchorId;
    }

    public void setTouchAnchorLocation(float x, float y) {
        this.mTouchAnchorX = x;
        this.mTouchAnchorY = y;
    }

    public void setMaxVelocity(float velocity) {
        this.mMaxVelocity = velocity;
    }

    public void setMaxAcceleration(float acceleration) {
        this.mMaxAcceleration = acceleration;
    }

    float getMaxAcceleration() {
        return this.mMaxAcceleration;
    }

    public float getMaxVelocity() {
        return this.mMaxVelocity;
    }

    boolean getMoveWhenScrollAtTop() {
        return this.mMoveWhenScrollAtTop;
    }

    RectF getTouchRegion(ViewGroup layout, RectF rect) {
        if (this.mTouchRegionId == -1) {
            return null;
        }
        View view = layout.findViewById(this.mTouchRegionId);
        if (view == null) {
            return null;
        }
        rect.set((float)view.getLeft(), (float)view.getTop(), (float)view.getRight(), (float)view.getBottom());
        return rect;
    }

    int getTouchRegionId() {
        return this.mTouchRegionId;
    }

    RectF getLimitBoundsTo(ViewGroup layout, RectF rect) {
        if (this.mLimitBoundsTo == -1) {
            return null;
        }
        View view = layout.findViewById(this.mLimitBoundsTo);
        if (view == null) {
            return null;
        }
        rect.set((float)view.getLeft(), (float)view.getTop(), (float)view.getRight(), (float)view.getBottom());
        return rect;
    }

    int getLimitBoundsToId() {
        return this.mLimitBoundsTo;
    }

    float dot(float dx, float dy) {
        return dx * this.mTouchDirectionX + dy * this.mTouchDirectionY;
    }

    public String toString() {
        return this.mTouchDirectionX + " , " + this.mTouchDirectionY;
    }

    public int getFlags() {
        return this.mFlags;
    }
}

