/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.solver.state.helpers;

import android.support.constraint.solver.state.ConstraintReference;
import android.support.constraint.solver.state.HelperReference;
import android.support.constraint.solver.state.State;

public class AlignVerticallyReference
extends HelperReference {
    private float mBias = 0.5f;
    private Object mTopToTop;
    private Object mTopToBottom;
    private Object mBottomToTop;
    private Object mBottomToBottom;

    public AlignVerticallyReference(State state) {
        super(state, State.Helper.ALIGN_VERTICALLY);
    }

    @Override
    public void apply() {
        for (Object key : this.mReferences) {
            ConstraintReference reference = this.mState.constraints(key);
            reference.clearVertical();
            if (this.mTopToTop != null) {
                reference.topToTop(this.mTopToTop);
            } else if (this.mTopToBottom != null) {
                reference.topToBottom(this.mTopToBottom);
            } else {
                reference.topToTop(State.PARENT);
            }
            if (this.mBottomToTop != null) {
                reference.bottomToTop(this.mBottomToTop);
            } else if (this.mBottomToBottom != null) {
                reference.bottomToBottom(this.mBottomToBottom);
            } else {
                reference.bottomToBottom(State.PARENT);
            }
            if (this.mBias == 0.5f) continue;
            reference.verticalBias(this.mBias);
        }
    }

    public void topToTop(Object target) {
        this.mTopToTop = target;
    }

    public void topToBottom(Object target) {
        this.mTopToBottom = target;
    }

    public void bottomToTop(Object target) {
        this.mBottomToTop = target;
    }

    public void bottomToBottom(Object target) {
        this.mBottomToBottom = target;
    }

    public void bias(float bias) {
        this.mBias = bias;
    }
}

