/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet;

import org.mozilla.universalchardet.CharsetListener;
import org.mozilla.universalchardet.Constants;
import org.mozilla.universalchardet.prober.CharsetProber;
import org.mozilla.universalchardet.prober.EscCharsetProber;
import org.mozilla.universalchardet.prober.Latin1Prober;
import org.mozilla.universalchardet.prober.MBCSGroupProber;
import org.mozilla.universalchardet.prober.SBCSGroupProber;

public final class UniversalDetector {
    private InputState inputState;
    private boolean done;
    private boolean start;
    private boolean gotData;
    private byte lastChar;
    private String detectedCharset;
    private CharsetProber[] probers = new CharsetProber[3];
    private CharsetProber escCharsetProber = null;
    private CharsetListener listener = null;

    public UniversalDetector(CharsetListener listener) {
        for (int i = 0; i < this.probers.length; ++i) {
            this.probers[i] = null;
        }
        this.reset();
    }

    public final boolean isDone() {
        return this.done;
    }

    public final String getDetectedCharset() {
        return this.detectedCharset;
    }

    public final void handleData(byte[] buf, int offset, int length) {
        if (this.done) {
            return;
        }
        if (length > 0) {
            this.gotData = true;
        }
        if (this.start) {
            this.start = false;
            if (length > 3) {
                int b1 = buf[0] & 0xFF;
                int b2 = buf[1] & 0xFF;
                int b3 = buf[2] & 0xFF;
                int b4 = buf[3] & 0xFF;
                switch (b1) {
                    case 239: {
                        if (b2 != 187 || b3 != 191) break;
                        this.detectedCharset = Constants.CHARSET_UTF_8;
                        break;
                    }
                    case 254: {
                        if (b2 == 255 && b3 == 0 && b4 == 0) {
                            this.detectedCharset = Constants.CHARSET_X_ISO_10646_UCS_4_3412;
                            break;
                        }
                        if (b2 != 255) break;
                        this.detectedCharset = Constants.CHARSET_UTF_16BE;
                        break;
                    }
                    case 0: {
                        if (b2 == 0 && b3 == 254 && b4 == 255) {
                            this.detectedCharset = Constants.CHARSET_UTF_32BE;
                            break;
                        }
                        if (b2 != 0 || b3 != 255 || b4 != 254) break;
                        this.detectedCharset = Constants.CHARSET_X_ISO_10646_UCS_4_2143;
                        break;
                    }
                    case 255: {
                        if (b2 == 254 && b3 == 0 && b4 == 0) {
                            this.detectedCharset = Constants.CHARSET_UTF_32LE;
                            break;
                        }
                        if (b2 != 254) break;
                        this.detectedCharset = Constants.CHARSET_UTF_16LE;
                    }
                }
                if (this.detectedCharset != null) {
                    this.done = true;
                    return;
                }
            }
        }
        int maxPos = length + 0;
        for (int i = 0; i < maxPos; ++i) {
            int c = buf[i] & 0xFF;
            if ((c & 0x80) != 0 && c != 160) {
                if (this.inputState == InputState.HIGHBYTE) continue;
                this.inputState = InputState.HIGHBYTE;
                if (this.escCharsetProber != null) {
                    this.escCharsetProber = null;
                }
                if (this.probers[0] == null) {
                    this.probers[0] = new MBCSGroupProber();
                }
                if (this.probers[1] == null) {
                    this.probers[1] = new SBCSGroupProber();
                }
                if (this.probers[2] != null) continue;
                this.probers[2] = new Latin1Prober();
                continue;
            }
            if (this.inputState == InputState.PURE_ASCII && (c == 27 || c == 123 && this.lastChar == 126)) {
                this.inputState = InputState.ESC_ASCII;
            }
            this.lastChar = buf[i];
        }
        if (this.inputState == InputState.ESC_ASCII) {
            CharsetProber.ProbingState probingState;
            if (this.escCharsetProber == null) {
                this.escCharsetProber = new EscCharsetProber();
            }
            if ((probingState = this.escCharsetProber.handleData(buf, 0, length)) == CharsetProber.ProbingState.FOUND_IT) {
                this.done = true;
                this.detectedCharset = this.escCharsetProber.getCharSetName();
                return;
            }
        } else if (this.inputState == InputState.HIGHBYTE) {
            for (int i = 0; i < this.probers.length; ++i) {
                CharsetProber.ProbingState probingState = this.probers[i].handleData(buf, 0, length);
                if (probingState != CharsetProber.ProbingState.FOUND_IT) continue;
                this.done = true;
                this.detectedCharset = this.probers[i].getCharSetName();
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void dataEnd() {
        if (!this.gotData) {
            return;
        }
        if (this.detectedCharset != null) {
            this.done = true;
            return;
        }
        if (this.inputState == InputState.HIGHBYTE) {
            void var1_1;
            float maxProberConfidence = 0.0f;
            int maxProber = 0;
            for (int i = 0; i < this.probers.length; ++i) {
                float f;
                float proberConfidence = this.probers[i].getConfidence();
                if (!(f > maxProberConfidence)) continue;
                maxProberConfidence = proberConfidence;
                maxProber = i;
            }
            if (var1_1 > 0.2f) {
                void var2_2;
                this.detectedCharset = this.probers[var2_2].getCharSetName();
            }
            return;
        }
    }

    private void reset() {
        this.done = false;
        this.start = true;
        this.detectedCharset = null;
        this.gotData = false;
        this.inputState = InputState.PURE_ASCII;
        this.lastChar = 0;
        if (this.escCharsetProber != null) {
            this.escCharsetProber.reset();
        }
        for (int i = 0; i < this.probers.length; ++i) {
            if (this.probers[i] == null) continue;
            this.probers[i].reset();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InputState {
        PURE_ASCII,
        ESC_ASCII,
        HIGHBYTE;

    }
}

