/*
 * Decompiled with CFR 0.152.
 */
package com.google.repacked.antlr.v4.runtime.tree.gui;

import com.google.repacked.antlr.v4.runtime.misc.JFileChooserConfirmOverwrite;
import com.google.repacked.antlr.v4.runtime.tree.ErrorNode;
import com.google.repacked.antlr.v4.runtime.tree.Tree;
import com.google.repacked.antlr.v4.runtime.tree.gui.TreeLayoutAdaptor;
import com.google.repacked.antlr.v4.runtime.tree.gui.TreeTextProvider;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.abego.treelayout.Configuration;
import org.abego.treelayout.NodeExtentProvider;
import org.abego.treelayout.TreeLayout;

public class TreeViewer
extends JComponent {
    private static Color LIGHT_RED = new Color(244, 213, 211);
    protected TreeTextProvider treeTextProvider;
    protected TreeLayout<Tree> treeLayout;
    protected List<Tree> highlightedNodes;
    protected String fontName = "Helvetica";
    protected int fontStyle = 0;
    protected int fontSize = 11;
    protected Font font = new Font(this.fontName, this.fontStyle, this.fontSize);
    protected double gapBetweenLevels = 17.0;
    protected double gapBetweenNodes = 7.0;
    protected int nodeWidthPadding = 2;
    protected int nodeHeightPadding = 0;
    protected int arcSize = 0;
    protected double scale = 1.0;
    protected Color boxColor = null;
    protected Color highlightedBoxColor = Color.lightGray;
    protected Color borderColor = null;
    protected Color textColor = Color.black;
    private boolean useCurvedEdges = false;

    /*
     * WARNING - void declaration
     */
    public TreeViewer(List<String> ruleNames, Tree tree) {
        TreeViewer treeViewer;
        TreeViewer treeViewer2 = this;
        TreeTextProvider treeTextProvider = treeViewer;
        treeViewer = treeViewer2;
        treeTextProvider = new TreeTextProvider((List<String>)((Object)treeTextProvider));
        treeViewer = treeViewer2;
        treeViewer2.treeTextProvider = treeTextProvider;
        if (tree != null) {
            void var2_2;
            this.setTree((Tree)var2_2);
        }
        this.setFont(this.font);
    }

    private void updatePreferredSize() {
        TreeViewer treeViewer = this;
        Dimension dimension = treeViewer.treeLayout.getBounds().getBounds().getSize();
        dimension = new Dimension((int)((double)dimension.width * treeViewer.scale), (int)((double)dimension.height * treeViewer.scale));
        this.setPreferredSize(dimension);
        this.invalidate();
        if (this.getParent() != null) {
            this.getParent().validate();
        }
        this.repaint();
    }

    private void paintEdges(Graphics g, Tree parent) {
        TreeViewer treeViewer = this;
        if (!treeViewer.treeLayout.getTree().isLeaf(parent)) {
            BasicStroke stroke = new BasicStroke(1.0f, 1, 1);
            ((Graphics2D)g).setStroke(stroke);
            Serializable parentBounds = this.getBoundsOfNode(parent);
            double x1 = parentBounds.getCenterX();
            double y1 = parentBounds.getMaxY();
            parentBounds = this;
            for (Tree child : ((TreeViewer)parentBounds).treeLayout.getTree().getChildren(parent)) {
                Serializable childBounds = this.getBoundsOfNode(child);
                double x2 = childBounds.getCenterX();
                double y2 = childBounds.getMinY();
                childBounds = this;
                if (((TreeViewer)childBounds).useCurvedEdges) {
                    CubicCurve2D.Double c = new CubicCurve2D.Double();
                    double ctrly1 = (y1 + y2) / 2.0;
                    ((CubicCurve2D)c).setCurve(x1, y1, x1, ctrly1, x2, y1, x2, y2);
                    ((Graphics2D)g).draw(c);
                } else {
                    g.drawLine((int)x1, (int)y1, (int)x2, (int)y2);
                }
                this.paintEdges(g, (Tree)((Object)treeViewer));
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.treeLayout == null) {
            return;
        }
        Object g2 = (Graphics2D)g;
        ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2 = this;
        this.paintEdges(g, ((TreeViewer)g2).treeLayout.getTree().getRoot());
        for (Tree Tree2 : this.treeLayout.getNodeBounds().keySet()) {
            TreeViewer treeViewer;
            String[] stringArray = treeViewer;
            Graphics graphics = g;
            treeViewer = this;
            Rectangle2D.Double double_ = treeViewer.getBoundsOfNode((Tree)stringArray);
            if (treeViewer.isHighlighted((Tree)stringArray) || treeViewer.boxColor != null || stringArray instanceof ErrorNode) {
                if (treeViewer.isHighlighted((Tree)stringArray)) {
                    graphics.setColor(treeViewer.highlightedBoxColor);
                } else if (stringArray instanceof ErrorNode) {
                    graphics.setColor(LIGHT_RED);
                } else {
                    graphics.setColor(treeViewer.boxColor);
                }
                graphics.fillRoundRect((int)double_.x, (int)double_.y, (int)double_.width - 1, (int)double_.height - 1, treeViewer.arcSize, treeViewer.arcSize);
            }
            if (treeViewer.borderColor != null) {
                graphics.setColor(treeViewer.borderColor);
                graphics.drawRoundRect((int)double_.x, (int)double_.y, (int)double_.width - 1, (int)double_.height - 1, treeViewer.arcSize, treeViewer.arcSize);
            }
            graphics.setColor(treeViewer.textColor);
            stringArray = treeViewer.getText((Tree)stringArray);
            stringArray = stringArray.split("\n");
            FontMetrics fontMetrics = treeViewer.getFontMetrics(treeViewer.font);
            int n = (int)double_.x + treeViewer.arcSize / 2 + treeViewer.nodeWidthPadding;
            int n2 = (int)double_.y + fontMetrics.getAscent() + fontMetrics.getLeading() + 1 + treeViewer.nodeHeightPadding;
            for (int i = 0; i < stringArray.length; ++i) {
                int n3 = n2;
                int n4 = n;
                String string = stringArray[i];
                Graphics graphics2 = graphics;
                string = Configuration.escapeWhitespace(string, true);
                graphics2.drawString(string, n4, n3);
                n2 += fontMetrics.getHeight();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Graphics getComponentGraphics(Graphics g) {
        void var1_1;
        Graphics2D g2d = (Graphics2D)g;
        g2d.scale(this.scale, this.scale);
        return super.getComponentGraphics((Graphics)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected static JDialog showInDialog(TreeViewer viewer) {
        void var1_2;
        void var0_1;
        void var3_5;
        JDialog dialog = new JDialog();
        dialog.setTitle("Parse Tree Inspector");
        Preferences prefs = Preferences.userNodeForPackage(TreeViewer.class);
        JPanel mainPane = new JPanel(new BorderLayout(5, 5));
        JPanel contentPane = new JPanel(new BorderLayout(0, 0));
        ((Component)contentPane).setBackground(Color.white);
        JScrollPane scrollPane = new JScrollPane(viewer);
        contentPane.add((Component)scrollPane, "Center");
        JPanel wrapper = new JPanel(new FlowLayout());
        JPanel bottomPanel = new JPanel(new BorderLayout(0, 0));
        contentPane.add((Component)bottomPanel, "South");
        JButton ok = new JButton("OK");
        ok.addActionListener(new ActionListener(dialog){
            private /* synthetic */ JDialog val$dialog;
            {
                this.val$dialog = jDialog;
            }

            @Override
            public final void actionPerformed(ActionEvent e) {
                this.val$dialog.dispatchEvent(new WindowEvent(this.val$dialog, 201));
            }
        });
        wrapper.add(ok);
        JComponent png = new JButton("Export as PNG");
        png.addActionListener(new ActionListener(viewer, dialog){
            private /* synthetic */ TreeViewer val$viewer;
            private /* synthetic */ JDialog val$dialog;
            {
                this.val$viewer = treeViewer;
                this.val$dialog = jDialog;
            }

            @Override
            public final void actionPerformed(ActionEvent e) {
                TreeViewer.access$000(this.val$viewer, this.val$dialog);
            }
        });
        wrapper.add(png);
        bottomPanel.add((Component)wrapper, "South");
        png = viewer;
        double lastKnownViewerScale = prefs.getDouble("dialog_viewer_scale", ((TreeViewer)png).scale);
        viewer.setScale(lastKnownViewerScale);
        int sliderValue = (int)((lastKnownViewerScale - 1.0) * 1000.0);
        JSlider scaleSlider = new JSlider(0, -999, 1000, sliderValue);
        scaleSlider.addChangeListener(new ChangeListener(scaleSlider, viewer){
            private /* synthetic */ JSlider val$scaleSlider;
            private /* synthetic */ TreeViewer val$viewer;
            {
                this.val$scaleSlider = jSlider;
                this.val$viewer = treeViewer;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void stateChanged(ChangeEvent e) {
                void var1_2;
                int v = this.val$scaleSlider.getValue();
                this.val$viewer.setScale((double)var1_2 / 1000.0 + 1.0);
            }
        });
        bottomPanel.add((Component)scaleSlider, "Center");
        JPanel treePanel = new JPanel(new BorderLayout(5, 5));
        EmptyIcon empty = new EmptyIcon(0);
        UIManager.put("Tree.closedIcon", empty);
        UIManager.put("Tree.openIcon", empty);
        UIManager.put("Tree.leafIcon", empty);
        png = viewer;
        Tree parseTreeRoot = ((TreeViewer)png).treeLayout.getTree().getRoot();
        TreeNodeWrapper nodeRoot = new TreeNodeWrapper(parseTreeRoot, viewer);
        TreeViewer.fillTree(nodeRoot, parseTreeRoot, viewer);
        JTree tree = new JTree(nodeRoot);
        tree.getSelectionModel().setSelectionMode(1);
        tree.addTreeSelectionListener(new TreeSelectionListener(viewer){
            private /* synthetic */ TreeViewer val$viewer;
            {
                this.val$viewer = treeViewer;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void valueChanged(TreeSelectionEvent e) {
                void var1_1;
                e = (JTree)e.getSource();
                e = ((JTree)e).getSelectionPath();
                TreeNodeWrapper treeNode = (TreeNodeWrapper)((TreePath)e).getLastPathComponent();
                this.val$viewer.setTree((Tree)var1_1.getUserObject());
            }
        });
        treePanel.add(new JScrollPane(tree));
        JSplitPane splitPane = new JSplitPane(1, treePanel, contentPane);
        mainPane.add((Component)splitPane, "Center");
        dialog.setContentPane(mainPane);
        WindowAdapter exitListener = new WindowAdapter(prefs, dialog, splitPane, viewer){
            private /* synthetic */ Preferences val$prefs;
            private /* synthetic */ JDialog val$dialog;
            private /* synthetic */ JSplitPane val$splitPane;
            private /* synthetic */ TreeViewer val$viewer;
            {
                this.val$prefs = preferences;
                this.val$dialog = jDialog;
                this.val$splitPane = jSplitPane;
                this.val$viewer = treeViewer;
            }

            @Override
            public final void windowClosing(WindowEvent e) {
                this.val$prefs.putInt("dialog_width", (int)this.val$dialog.getSize().getWidth());
                this.val$prefs.putInt("dialog_height", (int)this.val$dialog.getSize().getHeight());
                this.val$prefs.putDouble("dialog_x", this.val$dialog.getLocationOnScreen().getX());
                this.val$prefs.putDouble("dialog_y", this.val$dialog.getLocationOnScreen().getY());
                this.val$prefs.putInt("dialog_divider_location", this.val$splitPane.getDividerLocation());
                this.val$prefs.putDouble("dialog_viewer_scale", this.val$viewer.getScale());
                this.val$dialog.setVisible(false);
                this.val$dialog.dispose();
            }
        };
        dialog.addWindowListener(exitListener);
        dialog.setDefaultCloseOperation(0);
        int width = prefs.getInt("dialog_width", 600);
        int height = prefs.getInt("dialog_height", 500);
        dialog.setPreferredSize(new Dimension(width, (int)var3_5));
        dialog.pack();
        int dividerLocation = prefs.getInt("dialog_divider_location", 200);
        splitPane.setDividerLocation((int)var0_1);
        if (prefs.getDouble("dialog_x", -1.0) != -1.0) {
            void var2_3;
            dialog.setLocation((int)prefs.getDouble("dialog_x", 100.0), (int)var2_3.getDouble("dialog_y", 100.0));
        } else {
            dialog.setLocationRelativeTo(null);
        }
        dialog.setVisible(true);
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    private static File generateNonExistingPngFile() {
        void var0;
        File pngFile = new File(".", "antlr4_parse_tree.png");
        int counter = 1;
        while (pngFile.exists()) {
            pngFile = new File(".", "antlr4_parse_tree_" + counter + ".png");
            ++counter;
        }
        return var0;
    }

    private static void fillTree(TreeNodeWrapper node, Tree tree, TreeViewer viewer) {
        if (tree == null) {
            return;
        }
        for (int i = 0; i < tree.getChildCount(); ++i) {
            Tree childTree = tree.getChild(i);
            TreeNodeWrapper childNode = new TreeNodeWrapper(childTree, viewer);
            node.add(childNode);
            TreeViewer.fillTree(childNode, childTree, viewer);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final Future<JDialog> open() {
        final TreeViewer viewer = this;
        viewer.setScale(1.5);
        Callable<JDialog> callable = new Callable<JDialog>(this){
            JDialog result;
        };
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            Future<JDialog> future;
            future = executor.submit(future);
            executor.shutdown();
            return future;
        }
        catch (Throwable throwable) {
            void var2_3;
            var2_3.shutdown();
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Rectangle2D.Double getBoundsOfNode(Tree node) {
        void var1_1;
        return this.treeLayout.getNodeBounds().get(var1_1);
    }

    protected final String getText(Tree tree) {
        String string;
        string = this.treeTextProvider.getText((Tree)((Object)string));
        string = Configuration.escapeWhitespace(string, true);
        return string;
    }

    private boolean isHighlighted(Tree node) {
        int n;
        TreeViewer treeViewer;
        void var2_2 = treeViewer;
        treeViewer = this;
        if (treeViewer.highlightedNodes != null) {
            for (int i = 0; i < treeViewer.highlightedNodes.size(); ++i) {
                Tree tree = treeViewer.highlightedNodes.get(i);
                if (tree != var2_2) continue;
                n = i;
                break;
            }
        } else {
            n = -1;
        }
        return n >= 0;
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setFont(Font font) {
        void var1_1;
        this.font = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setTree(Tree root) {
        if (root != null) {
            void var1_1;
            this.treeLayout = new TreeLayout<Tree>(new TreeLayoutAdaptor((Tree)var1_1), new VariableExtentProvide(this), new Configuration(this.gapBetweenLevels, this.gapBetweenNodes), true);
            this.updatePreferredSize();
            return;
        }
        this.treeLayout = null;
        this.repaint();
    }

    public final double getScale() {
        return this.scale;
    }

    /*
     * WARNING - void declaration
     */
    public final void setScale(double scale) {
        void var1_1;
        if (scale <= 0.0) {
            scale = 1.0;
        }
        this.scale = var1_1;
        this.updatePreferredSize();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(TreeViewer x0, JDialog x1) {
        block5: {
            void var1_4;
            Object object = x0;
            BufferedImage bufferedImage = new BufferedImage(((Component)object).getSize().width, ((Component)object).getSize().height, 2);
            Object object2 = bufferedImage.createGraphics();
            ((TreeViewer)object).paint((Graphics)object2);
            ((Graphics)object2).dispose();
            try {
                object = TreeViewer.generateNonExistingPngFile();
                object2 = new JFileChooserConfirmOverwrite();
                ((JFileChooser)object2).setCurrentDirectory(((File)object).getParentFile());
                ((JFileChooser)object2).setSelectedFile((File)object);
                object = new FileFilter(){

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final boolean accept(File pathname) {
                        if (pathname.isFile()) {
                            void var1_1;
                            return var1_1.getName().toLowerCase().endsWith(".png");
                        }
                        return true;
                    }

                    @Override
                    public final String getDescription() {
                        return "PNG Files (*.png)";
                    }
                };
                ((JFileChooser)object2).addChoosableFileFilter((FileFilter)object);
                ((JFileChooser)object2).setFileFilter((FileFilter)object);
                int n = ((JFileChooser)object2).showSaveDialog((Component)var1_4);
                if (n == 0) {
                    File file = ((JFileChooser)object2).getSelectedFile();
                    ImageIO.write((RenderedImage)bufferedImage, "png", file);
                    try {
                        Desktop.getDesktop().open(file.getParentFile());
                        break block5;
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog((Component)var1_4, "Saved PNG to: " + file.getAbsolutePath());
                        exception.printStackTrace();
                    }
                }
                return;
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog((Component)var1_4, "Could not export to PNG: " + exception.getMessage(), "Error", 0);
                exception.printStackTrace();
            }
        }
    }

    static final class EmptyIcon
    implements Icon {
        private EmptyIcon() {
        }

        @Override
        public final int getIconWidth() {
            return 0;
        }

        @Override
        public final int getIconHeight() {
            return 0;
        }

        @Override
        public final void paintIcon(Component c, Graphics g, int x, int y) {
        }

        /* synthetic */ EmptyIcon(byte by) {
            this();
        }
    }

    static class TreeNodeWrapper
    extends DefaultMutableTreeNode {
        final TreeViewer viewer;

        /*
         * WARNING - void declaration
         */
        TreeNodeWrapper(Tree tree, TreeViewer viewer) {
            super(var1_1);
            void var2_2;
            void var1_1;
            this.viewer = var2_2;
        }

        @Override
        public String toString() {
            return this.viewer.getText((Tree)this.getUserObject());
        }
    }

    public static final class VariableExtentProvide
    implements NodeExtentProvider<Tree> {
        private TreeViewer viewer;

        /*
         * WARNING - void declaration
         */
        public VariableExtentProvide(TreeViewer viewer) {
            void var1_1;
            this.viewer = var1_1;
        }
    }
}

