/*
 * Decompiled with CFR 0.152.
 */
package com.google.repacked.antlr.v4.runtime.misc;

import com.google.repacked.antlr.v4.runtime.Vocabulary;
import com.google.repacked.antlr.v4.runtime.misc.IntSet;
import com.google.repacked.antlr.v4.runtime.misc.Interval;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.abego.treelayout.Configuration;

public final class IntervalSet
implements IntSet {
    private static IntervalSet COMPLETE_CHAR_SET = IntervalSet.of(0, 65534);
    private static IntervalSet EMPTY_SET;
    private List<Interval> intervals = new ArrayList<Interval>(0);
    private boolean readonly;

    /*
     * WARNING - void declaration
     */
    public IntervalSet(IntervalSet set) {
        this(new int[0]);
        void var1_1;
        this.addAll((IntSet)var1_1);
    }

    public IntervalSet(int ... els) {
    }

    /*
     * WARNING - void declaration
     */
    public static IntervalSet of(int a) {
        void var1_1;
        int n;
        IntervalSet s = new IntervalSet(new int[0]);
        s.add(n);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static IntervalSet of(int a, int b) {
        void var2_2;
        void var1_1;
        int n;
        IntervalSet s = new IntervalSet(new int[0]);
        s.add(n, (int)var1_1);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final void add(int el) {
        void var1_1;
        if (this.readonly) {
            throw new IllegalStateException("can't alter readonly IntervalSet");
        }
        this.add(el, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void add(int a, int b) {
        block6: {
            void var2_3;
            void var1_1;
            Interval interval = Interval.of((int)var1_1, (int)var2_3);
            Object object = this;
            if (((IntervalSet)object).readonly) {
                throw new IllegalStateException("can't alter readonly IntervalSet");
            }
            if (interval.b >= interval.a) {
                ListIterator<Interval> listIterator = ((IntervalSet)object).intervals.listIterator();
                while (listIterator.hasNext()) {
                    Interval interval2 = listIterator.next();
                    if (!interval.equals(interval2)) {
                        if (interval.adjacent(interval2) || !interval.disjoint(interval2)) {
                            object = interval.union(interval2);
                            listIterator.set((Interval)object);
                            while (listIterator.hasNext() && (((Interval)object).adjacent(interval = listIterator.next()) || !((Interval)object).disjoint(interval))) {
                                listIterator.remove();
                                listIterator.previous();
                                listIterator.set(((Interval)object).union(interval));
                                listIterator.next();
                            }
                            return;
                        }
                        if (!interval.startsBeforeDisjoint(interval2)) continue;
                        listIterator.previous();
                        listIterator.add(interval);
                        return;
                    }
                    break block6;
                }
                ((IntervalSet)object).intervals.add(interval);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final IntervalSet addAll(IntSet set) {
        IntervalSet other;
        if (set == null) {
            return this;
        }
        if (set instanceof IntervalSet) {
            other = (IntervalSet)set;
            int n = other.intervals.size();
            for (int i = 0; i < n; ++i) {
                Interval I = other.intervals.get(i);
                this.add(I.a, I.b);
            }
        } else {
            for (int value : other.toList()) {
                void var2_3;
                this.add((int)var2_3);
            }
        }
        return this;
    }

    public static IntervalSet subtract(IntervalSet left, IntervalSet right) {
        IntervalSet intervalSet;
        if (left == null || left.isNil()) {
            return new IntervalSet(new int[0]);
        }
        IntervalSet result = new IntervalSet(left);
        if (right == null || right.isNil()) {
            return result;
        }
        int resultI = 0;
        int rightI = 0;
        while (resultI < result.intervals.size() && rightI < right.intervals.size()) {
            Interval resultInterval = result.intervals.get(resultI);
            Interval rightInterval = right.intervals.get(rightI);
            if (rightInterval.b < resultInterval.a) {
                ++rightI;
                continue;
            }
            if (rightInterval.a > resultInterval.b) {
                ++resultI;
                continue;
            }
            Interval beforeCurrent = null;
            Interval afterCurrent = null;
            if (rightInterval.a > resultInterval.a) {
                beforeCurrent = new Interval(resultInterval.a, rightInterval.a - 1);
            }
            if (rightInterval.b < resultInterval.b) {
                afterCurrent = new Interval(rightInterval.b + 1, resultInterval.b);
            }
            if (beforeCurrent != null) {
                if (afterCurrent != null) {
                    result.intervals.set(resultI, beforeCurrent);
                    result.intervals.add(resultI + 1, afterCurrent);
                    ++resultI;
                    ++rightI;
                    continue;
                }
                result.intervals.set(resultI, beforeCurrent);
                ++resultI;
                continue;
            }
            if (afterCurrent != null) {
                result.intervals.set(resultI, afterCurrent);
                ++rightI;
                continue;
            }
            result.intervals.remove(resultI);
        }
        return intervalSet;
    }

    public final boolean contains(int el) {
        int n = this.intervals.size();
        for (int i = 0; i < n; ++i) {
            Interval I = this.intervals.get(i);
            int a = I.a;
            int b = I.b;
            if (el < a) break;
            if (el < a || el > b) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean isNil() {
        return this.intervals == null || this.intervals.isEmpty();
    }

    public final int getMinElement() {
        if (this.isNil()) {
            return 0;
        }
        return this.intervals.get((int)0).a;
    }

    public final List<Interval> getIntervals() {
        return this.intervals;
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        int n;
        int hash = 0;
        hash = 0;
        for (Interval I : this.intervals) {
            void var3_3;
            hash = Configuration.update(hash, I.a);
            hash = Configuration.update(hash, var3_3.b);
        }
        n = Configuration.finish(n, this.intervals.size() << 1);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object obj) {
        void var1_1;
        if (obj == null || !(obj instanceof IntervalSet)) {
            return false;
        }
        IntervalSet other = (IntervalSet)obj;
        return this.intervals.equals(var1_1.intervals);
    }

    public final String toString() {
        boolean bl = false;
        IntervalSet intervalSet = this;
        StringBuilder stringBuilder = new StringBuilder();
        if (intervalSet.intervals == null || intervalSet.intervals.isEmpty()) {
            return "{}";
        }
        if (intervalSet.size() > 1) {
            stringBuilder.append("{");
        }
        Iterator<Interval> iterator = intervalSet.intervals.iterator();
        while (iterator.hasNext()) {
            Interval interval = iterator.next();
            int n = interval.a;
            int n2 = interval.b;
            if (n == n2) {
                if (n == -1) {
                    stringBuilder.append("<EOF>");
                } else {
                    stringBuilder.append(n);
                }
            } else {
                stringBuilder.append(n).append("..").append(n2);
            }
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        if (intervalSet.size() > 1) {
            stringBuilder.append("}");
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    public final String toString(Vocabulary vocabulary) {
        void var2_2;
        StringBuilder buf = new StringBuilder();
        if (this.intervals == null || this.intervals.isEmpty()) {
            return "{}";
        }
        if (this.size() > 1) {
            buf.append("{");
        }
        Iterator<Interval> iter = this.intervals.iterator();
        while (iter.hasNext()) {
            Interval I = iter.next();
            int a = I.a;
            int b = I.b;
            if (a == b) {
                buf.append(IntervalSet.elementName(vocabulary, a));
            } else {
                for (int i = a; i <= b; ++i) {
                    if (i > a) {
                        buf.append(", ");
                    }
                    buf.append(IntervalSet.elementName(vocabulary, i));
                }
            }
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        if (this.size() > 1) {
            buf.append("}");
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static String elementName(Vocabulary vocabulary, int a) {
        void var1_1;
        Vocabulary vocabulary2;
        if (a == -1) {
            return "<EOF>";
        }
        if (a == -2) {
            return "<EPSILON>";
        }
        return vocabulary2.getDisplayName((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final int size() {
        void var1_1;
        int n = 0;
        int numIntervals = this.intervals.size();
        if (numIntervals == 1) {
            Interval firstInterval = this.intervals.get(0);
            return firstInterval.b - firstInterval.a + 1;
        }
        for (int i = 0; i < numIntervals; ++i) {
            Interval I = this.intervals.get(i);
            n += I.b - I.a + 1;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final List<Integer> toList() {
        void var1_1;
        ArrayList<Integer> values = new ArrayList<Integer>();
        int n = this.intervals.size();
        for (int i = 0; i < n; ++i) {
            Interval I = this.intervals.get(i);
            int a = I.a;
            int b = I.b;
            for (int v = a; v <= b; ++v) {
                values.add(v);
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void remove(int el) {
        if (this.readonly) {
            throw new IllegalStateException("can't alter readonly IntervalSet");
        }
        int n = this.intervals.size();
        for (int i = 0; i < n; ++i) {
            void var3_3;
            Interval I = this.intervals.get(i);
            int a = I.a;
            int b = I.b;
            if (-2 < a) break;
            if (-2 == a && -2 == b) {
                this.intervals.remove(i);
                return;
            }
            if (-2 == a) {
                this.intervals.set(i, Interval.of(I.a + 1, I.b));
                return;
            }
            if (-2 == b) {
                this.intervals.set(i, Interval.of(I.a, I.b - 1));
                return;
            }
            if (-2 <= a || -2 >= b) continue;
            int oldb = I.b;
            this.intervals.set(i, Interval.of(var3_3.a, -3));
            this.add(-1, oldb);
        }
    }

    public final void setReadonly(boolean readonly) {
        this.readonly = true;
    }

    static {
        boolean bl = true;
        IntervalSet intervalSet = COMPLETE_CHAR_SET;
        COMPLETE_CHAR_SET.readonly = true;
        EMPTY_SET = new IntervalSet(new int[0]);
        boolean bl2 = true;
        IntervalSet intervalSet2 = EMPTY_SET;
        EMPTY_SET.readonly = true;
    }
}

