/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.store;

import android.databinding.tool.processing.scopes.LocationScopeProvider;
import com.google.repacked.antlr.v4.runtime.ParserRuleContext;
import com.google.repacked.antlr.v4.runtime.Token;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;

@XmlAccessorType(value=XmlAccessType.NONE)
public class Location {
    public static final int NaN = -1;
    @XmlAttribute(name="startLine")
    public int startLine;
    @XmlAttribute(name="startOffset")
    public int startOffset;
    @XmlAttribute(name="endLine")
    public int endLine;
    @XmlAttribute(name="endOffset")
    public int endOffset;
    @XmlElement(name="parentLocation")
    public Location parentLocation;

    public Location() {
        this.endLine = -1;
        this.startLine = -1;
        this.endOffset = -1;
        this.startOffset = -1;
    }

    /*
     * WARNING - void declaration
     */
    public Location(Location other) {
        void var1_1;
        this.startOffset = other.startOffset;
        this.endOffset = other.endOffset;
        this.startLine = other.startLine;
        this.endLine = var1_1.endLine;
    }

    /*
     * WARNING - void declaration
     */
    public Location(Token start, Token end) {
        void var1_1;
        void var2_2;
        void var3_3;
        if (start == null) {
            this.startOffset = -1;
            this.startLine = -1;
        } else {
            this.startLine = start.getLine() - 1;
            this.startOffset = start.getCharPositionInLine();
        }
        if (end == null) {
            this.endOffset = -1;
            this.endLine = -1;
            return;
        }
        this.endLine = end.getLine() - 1;
        String endText = end.getText();
        int lastLineStart = endText.lastIndexOf(System.lineSeparator());
        String lastLine = lastLineStart < 0 ? endText : endText.substring((int)(var3_3 + true));
        this.endOffset = var2_2.getCharPositionInLine() + var1_1.length() - 1;
    }

    /*
     * WARNING - void declaration
     */
    public Location(ParserRuleContext context) {
        this(context == null ? null : context.getStart(), context == null ? null : var1_1.getStop());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Location(int startLine, int startOffset, int endLine, int endOffset) {
        void var3_3;
        void var1_1;
        void var2_2;
        this.startOffset = var2_2;
        this.startLine = var1_1;
        this.endLine = var3_3;
        this.endOffset = endOffset;
    }

    public String toString() {
        return "Location{startLine=" + this.startLine + ", startOffset=" + this.startOffset + ", endLine=" + this.endLine + ", endOffset=" + this.endOffset + ", parentLocation=" + this.parentLocation + '}';
    }

    /*
     * WARNING - void declaration
     */
    public void setParentLocation(Location parentLocation) {
        void var1_1;
        this.parentLocation = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Location location = (Location)o;
        if (this.endLine != location.endLine) {
            return false;
        }
        if (this.endOffset != location.endOffset) {
            return false;
        }
        if (this.startLine != location.startLine) {
            return false;
        }
        if (this.startOffset != location.startOffset) {
            return false;
        }
        return !(this.parentLocation != null ? !this.parentLocation.equals(location.parentLocation) : var1_1.parentLocation != null);
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int result = this.startLine;
        result = result * 31 + this.startOffset;
        result = result * 31 + this.endLine;
        var1_1 = var1_1 * 31 + this.endOffset;
        return (int)var1_1;
    }

    public boolean isValid() {
        return this.startLine != -1 && this.endLine != -1 && this.startOffset != -1 && this.endOffset != -1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean contains(Location other) {
        void var1_1;
        if (this.startLine > other.startLine) {
            return false;
        }
        if (this.startLine == other.startLine && this.startOffset > other.startOffset) {
            return false;
        }
        if (this.endLine < other.endLine) {
            return false;
        }
        return this.endLine != other.endLine || this.endOffset >= var1_1.endOffset;
    }

    private Location getValidParentAbsoluteLocation() {
        while (this_.parentLocation != null) {
            if (this_.parentLocation.isValid()) {
                return this_.parentLocation.toAbsoluteLocation();
            }
            Location this_ = this_.parentLocation;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Location toAbsoluteLocation() {
        void var2_2;
        void var1_1;
        void var3_3;
        boolean sameLine;
        Location absoluteParent = this.getValidParentAbsoluteLocation();
        if (absoluteParent == null) {
            return this;
        }
        Location copy = new Location(this);
        boolean bl = sameLine = copy.startLine == copy.endLine;
        if (copy.startLine == 0) {
            copy.startOffset += absoluteParent.startOffset;
        }
        if (var3_3 != false) {
            copy.endOffset += absoluteParent.startOffset;
        }
        copy.startLine += absoluteParent.startLine;
        copy.endLine += var1_1.startLine;
        return var2_2;
    }

    public String toUserReadableString() {
        return this.startLine + ":" + this.startOffset + " - " + this.endLine + ":" + this.endOffset;
    }

    /*
     * WARNING - void declaration
     */
    public static Location fromUserReadableString(String str) {
        void var3_4;
        void var1_2;
        String string;
        void var2_3;
        int glue = str.indexOf(45);
        if (glue == -1) {
            return new Location();
        }
        String start = str.substring(0, glue);
        String end = str.substring(glue + 1);
        int[] point = new int[]{-1, -1};
        Location location = new Location();
        Location.parsePoint((String)var2_3, point);
        location.startLine = point[0];
        location.startOffset = point[1];
        point[1] = -1;
        point[0] = -1;
        Location.parsePoint(string, point);
        location.endLine = point[0];
        location.endOffset = var1_2[1];
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean parsePoint(String content, int[] into) {
        void var2_2;
        String string;
        int index = content.indexOf(58);
        if (index == -1) {
            return false;
        }
        into[0] = Integer.parseInt(content.substring(0, index).trim());
        var1_1[1] = Integer.parseInt(string.substring((int)(var2_2 + true)).trim());
        return true;
    }

    public LocationScopeProvider createScope() {
        return new LocationScopeProvider(){

            @Override
            public List<Location> provideScopeLocation() {
                return Arrays.asList(Location.this);
            }
        };
    }
}

