/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.store;

import android.databinding.parser.XMLLexer;
import android.databinding.parser.XMLParser;
import android.databinding.parser.XMLParserBaseVisitor;
import android.databinding.tool.processing.Scope;
import android.databinding.tool.processing.scopes.FileScopeProvider;
import android.databinding.tool.store.Location;
import android.databinding.tool.store.ResourceBundle;
import android.databinding.tool.util.L;
import android.databinding.tool.util.ParserHelper;
import android.databinding.tool.util.Preconditions;
import android.databinding.tool.util.XmlEditor;
import com.google.repacked.antlr.v4.runtime.ANTLRInputStream;
import com.google.repacked.antlr.v4.runtime.CommonTokenStream;
import com.google.repacked.antlr.v4.runtime.ParserRuleContext;
import com.google.repacked.antlr.v4.runtime.TokenStream;
import com.google.repacked.antlr.v4.runtime.tree.RuleNode;
import com.google.repacked.apache.commons.io.FileUtils;
import com.google.repacked.apache.commons.lang3.StringEscapeUtils;
import com.google.repacked.apache.commons.lang3.StringUtils;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LayoutFileParser {
    private static final String XPATH_BINDING_LAYOUT = "/layout";
    private static final String LAYOUT_PREFIX = "@layout/";

    /*
     * WARNING - void declaration
     */
    public ResourceBundle.LayoutFileBundle parseXml(final File xml, String pkg, int minSdk) throws ParserConfigurationException, IOException, SAXException, XPathExpressionException {
        try {
            void var2_3;
            void var3_5;
            ResourceBundle.LayoutFileBundle layoutFileBundle;
            Scope.enter(new FileScopeProvider(){

                @Override
                public String provideScopeFilePath() {
                    return xml.getAbsolutePath();
                }
            });
            String xmlNoExtension = ParserHelper.stripExtension(xml.getName());
            String newTag = xml.getParentFile().getName() + '/' + xmlNoExtension;
            Serializable original = this.stripFileAndGetOriginal(xml, newTag);
            if (original == null) {
                L.d("assuming the file is the original for %s", xml.getAbsoluteFile());
                original = layoutFileBundle;
            }
            layoutFileBundle = this.parseXml((File)var3_5, (String)var2_3);
            return layoutFileBundle;
        }
        finally {
            Scope.exit();
        }
    }

    /*
     * WARNING - void declaration
     */
    private ResourceBundle.LayoutFileBundle parseXml(final File original, String pkg) throws IOException {
        try {
            void var2_3;
            void var3_4;
            void var1_1;
            Scope.enter(new FileScopeProvider(){

                @Override
                public String provideScopeFilePath() {
                    return original.getAbsolutePath();
                }
            });
            String xmlNoExtension = ParserHelper.stripExtension(original.getName());
            ANTLRInputStream inputStream = new ANTLRInputStream(new FileReader(original));
            XMLLexer lexer = new XMLLexer(inputStream);
            Object tokenStream = new CommonTokenStream(lexer);
            tokenStream = new XMLParser((TokenStream)tokenStream);
            tokenStream = ((XMLParser)tokenStream).document();
            XMLParser.ElementContext root = ((XMLParser.DocumentContext)tokenStream).element();
            if (!"layout".equals(root.elmName.getText())) {
                return null;
            }
            XMLParser.ElementContext data = this.getDataNode(root);
            XMLParser.ElementContext rootView = this.getViewNode(original, root);
            if (this.hasMergeInclude(rootView)) {
                L.e("Data binding does not support include elements as direct children of a merge element.", new Object[0]);
                return null;
            }
            boolean isMerge = "merge".equals(rootView.elmName.getText());
            ResourceBundle.LayoutFileBundle bundle = new ResourceBundle.LayoutFileBundle(original, xmlNoExtension, original.getParentFile().getName(), pkg, isMerge);
            String newTag = original.getParentFile().getName() + '/' + xmlNoExtension;
            this.parseData((File)var1_1, data, bundle);
            this.parseExpressions((String)var3_4, rootView, isMerge, bundle);
            var1_1 = var2_3;
            return var1_1;
        }
        finally {
            Scope.exit();
        }
    }

    private void parseExpressions(String newTag, final XMLParser.ElementContext rootView, final boolean isMerge, ResourceBundle.LayoutFileBundle bundle) {
        final ArrayList bindingElements = new ArrayList();
        final ArrayList otherElementsWithIds = new ArrayList();
        rootView.accept(new XMLParserBaseVisitor<Void>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public Void visitElement(XMLParser.ElementContext ctx) {
                void var1_1;
                if (this.filter(ctx)) {
                    bindingElements.add(ctx);
                } else {
                    void var2_2;
                    String name = ctx.elmName.getText();
                    if (!"fragment".equals(var2_2) && LayoutFileParser.attributeMap(ctx).containsKey("android:id")) {
                        otherElementsWithIds.add(ctx);
                    }
                }
                this.visitChildren((RuleNode)var1_1);
                return null;
            }

            /*
             * WARNING - void declaration
             */
            private boolean filter(XMLParser.ElementContext ctx) {
                void var1_1;
                if (isMerge ? ctx.getParent().getParent() == rootView : ctx == rootView) {
                    return true;
                }
                if (this.hasIncludeChild(ctx)) {
                    return true;
                }
                return XmlEditor.hasExpressionAttributes((XMLParser.ElementContext)var1_1);
            }

            private boolean hasIncludeChild(XMLParser.ElementContext ctx) {
                for (XMLParser.ElementContext elementContext : XmlEditor.elements(ctx)) {
                    if (!"include".equals(elementContext.elmName.getText())) continue;
                    return true;
                }
                return false;
            }
        });
        HashMap<XMLParser.ElementContext, String> nodeTagMap = new HashMap<XMLParser.ElementContext, String>();
        L.d("number of binding nodes %d", bindingElements.size());
        int tagNumber = 0;
        for (XMLParser.ElementContext parent : bindingElements) {
            String tag;
            String includeValue;
            Object attributes = LayoutFileParser.attributeMap(parent);
            String nodeName = parent.elmName.getText();
            String viewName = null;
            String includedLayoutName = null;
            String id = attributes.get("android:id");
            String originalTag = attributes.get("android:tag");
            if ("include".equals(nodeName)) {
                includeValue = attributes.get("layout");
                if (StringUtils.isEmpty(includeValue)) {
                    L.e("%s must include a layout", parent);
                }
                if (!includeValue.startsWith(LAYOUT_PREFIX)) {
                    L.e("included value (%s) must start with %s.", includeValue, LAYOUT_PREFIX);
                }
                attributes = includeValue.substring(8);
                includedLayoutName = attributes;
                ParserRuleContext parserRuleContext = parent.getParent();
                Preconditions.check(parserRuleContext instanceof XMLParser.ContentContext, "parent of an include tag must be a content context but it is %s", parserRuleContext.getClass().getCanonicalName());
                ParserRuleContext grandParent = parserRuleContext.getParent();
                Preconditions.check(grandParent instanceof XMLParser.ElementContext, "grandparent of an include tag must be an element context but it is %s", grandParent.getClass().getCanonicalName());
                tag = (String)nodeTagMap.get(grandParent);
            } else {
                if ("fragment".equals(includeValue)) {
                    if (!XmlEditor.hasExpressionAttributes(parent)) continue;
                    L.e("fragments do not support data binding expressions.", new Object[0]);
                    continue;
                }
                viewName = this.getViewName(parent);
                tag = rootView == parent || isMerge && parent.getParent().getParent() == rootView ? newTag + "_" + tagNumber : "binding_" + tagNumber;
                ++tagNumber;
            }
            ResourceBundle.BindingTargetBundle bindingTargetBundle = bundle.createBindingTarget(id, viewName, true, tag, originalTag, new Location(parent));
            nodeTagMap.put(parent, tag);
            bindingTargetBundle.setIncludedLayout(includedLayoutName);
            for (XMLParser.AttributeContext attributeContext : XmlEditor.expressionAttributes(parent)) {
                String value = LayoutFileParser.escapeQuotes(attributeContext.attrValue.getText(), true);
                if (value.charAt(0) != '@' || value.charAt(1) != '{' || value.charAt(value.length() - 1) != '}') continue;
                String strippedValue = value.substring(2, value.length() - 1);
                Location attrLocation = new Location(attributeContext);
                Location valueLocation = new Location();
                new Location().startLine = attributeContext.attrValue.getLine() - 1;
                valueLocation.startOffset = attributeContext.attrValue.getCharPositionInLine() + attributeContext.attrValue.getText().indexOf(strippedValue);
                valueLocation.endLine = attrLocation.endLine;
                valueLocation.endOffset = attrLocation.endOffset - 2;
                bindingTargetBundle.addBinding(LayoutFileParser.escapeQuotes(attributeContext.attrName.getText(), false), strippedValue, attrLocation, valueLocation);
            }
        }
        for (XMLParser.ElementContext elm : otherElementsWithIds) {
            String id = LayoutFileParser.attributeMap(elm).get("android:id");
            String className = this.getViewName(elm);
            bundle.createBindingTarget(id, className, true, null, null, new Location(elm));
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getViewName(XMLParser.ElementContext elm) {
        void var2_2;
        void var1_1;
        String viewName = elm.elmName.getText();
        if ("view".equals(viewName)) {
            String classNode = LayoutFileParser.attributeMap(elm).get("class");
            if (StringUtils.isEmpty(classNode)) {
                L.e("No class attribute for 'view' node", new Object[0]);
            }
            viewName = var1_1;
        } else if ("include".equals(viewName) && !XmlEditor.hasExpressionAttributes((XMLParser.ElementContext)var1_1)) {
            viewName = "android.view.View";
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private void parseData(File xml, XMLParser.ElementContext data, ResourceBundle.LayoutFileBundle bundle) {
        String name;
        void var2_2;
        String type;
        Map<String, String> attrMap;
        if (data == null) {
            return;
        }
        for (XMLParser.ElementContext imp : this.filter(data, "import")) {
            Object split;
            attrMap = LayoutFileParser.attributeMap(imp);
            type = attrMap.get("type");
            String alias = attrMap.get("alias");
            Preconditions.check(StringUtils.isNotBlank(type), "Type of an import cannot be empty. %s in %s", imp.toStringTree(), xml);
            if (StringUtils.isEmpty(alias)) {
                split = StringUtils.split(type, '.');
                split = split[((String[])split).length - 1];
            }
            bundle.addImport((String)split, type, new Location(imp));
        }
        for (XMLParser.ElementContext variable : this.filter(data, "variable")) {
            attrMap = LayoutFileParser.attributeMap(variable);
            type = attrMap.get("type");
            String name2 = attrMap.get("name");
            Preconditions.checkNotNull(type, "variable must have a type definition %s in %s", variable.toStringTree(), xml);
            Preconditions.checkNotNull(name2, "variable must have a name %s in %s", variable.toStringTree(), xml);
            bundle.addVariable(name2, type, new Location(variable), true);
        }
        XMLParser.AttributeContext className = LayoutFileParser.findAttribute((XMLParser.ElementContext)var2_2, "class");
        if (className != null && StringUtils.isNotBlank(name = LayoutFileParser.escapeQuotes(className.attrValue.getText(), true))) {
            void var3_3;
            Location location = new Location(className.attrValue.getLine() - 1, className.attrValue.getCharPositionInLine() + 1, className.attrValue.getLine() - 1, className.attrValue.getCharPositionInLine() + name.length());
            var3_3.setBindingClass(name, location);
        }
    }

    /*
     * WARNING - void declaration
     */
    private XMLParser.ElementContext getDataNode(XMLParser.ElementContext root) {
        void var1_1;
        List<XMLParser.ElementContext> data = this.filter(root, "data");
        if (data.size() == 0) {
            return null;
        }
        Preconditions.check(data.size() == 1, "XML layout can have only 1 data tag", new Object[0]);
        return (XMLParser.ElementContext)var1_1.get(0);
    }

    /*
     * WARNING - void declaration
     */
    private XMLParser.ElementContext getViewNode(File xml, XMLParser.ElementContext root) {
        void var3_3;
        void var2_2;
        void var1_1;
        List<XMLParser.ElementContext> view = this.filterNot(root, "data");
        Preconditions.check(view.size() == 1, "XML layout %s must have 1 view but has %s. root children count %s", var1_1, view.size(), var2_2.getChildCount());
        return (XMLParser.ElementContext)var3_3.get(0);
    }

    /*
     * WARNING - void declaration
     */
    private List<XMLParser.ElementContext> filter(XMLParser.ElementContext root, String name) {
        void var3_3;
        ArrayList<XMLParser.ElementContext> result = new ArrayList<XMLParser.ElementContext>();
        if (root == null) {
            return result;
        }
        XMLParser.ContentContext contentContext = root.content();
        if (contentContext == null) {
            return result;
        }
        for (XMLParser.ElementContext elementContext : XmlEditor.elements(root)) {
            if (!name.equals(elementContext.elmName.getText())) continue;
            result.add(elementContext);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private List<XMLParser.ElementContext> filterNot(XMLParser.ElementContext root, String name) {
        void var3_3;
        ArrayList<XMLParser.ElementContext> result = new ArrayList<XMLParser.ElementContext>();
        if (root == null) {
            return result;
        }
        XMLParser.ContentContext contentContext = root.content();
        if (contentContext == null) {
            return result;
        }
        for (XMLParser.ElementContext elementContext : XmlEditor.elements(root)) {
            if (name.equals(elementContext.elmName.getText())) continue;
            result.add(elementContext);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private boolean hasMergeInclude(XMLParser.ElementContext rootView) {
        void var1_1;
        return "merge".equals(rootView.elmName.getText()) && this.filter((XMLParser.ElementContext)var1_1, "include").size() > 0;
    }

    /*
     * WARNING - void declaration
     */
    private File stripFileAndGetOriginal(File xml, String binderId) throws ParserConfigurationException, IOException, SAXException, XPathExpressionException {
        L.d("parsing resource file %s", xml.getAbsolutePath());
        Object object = DocumentBuilderFactory.newInstance();
        object = ((DocumentBuilderFactory)object).newDocumentBuilder();
        Document doc = ((DocumentBuilder)object).parse(xml);
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        XPathExpression xPathExpression = xPath.compile("//comment()[starts-with(., \" From: file:\")][last()]");
        Object commentElementNodes = (NodeList)xPathExpression.evaluate(doc, XPathConstants.NODESET);
        L.d("comment element nodes count %s", commentElementNodes.getLength());
        if (commentElementNodes.getLength() == 0) {
            L.d("cannot find comment element to find the actual file", new Object[0]);
            return null;
        }
        commentElementNodes = commentElementNodes.item(0);
        String actualFilePath = commentElementNodes.getNodeValue().substring(6).trim();
        L.d("actual file to parse: %s", actualFilePath);
        File actualFile = LayoutFileParser.urlToFile(new URL(actualFilePath));
        if (!actualFile.canRead()) {
            L.d("cannot find original, skipping. %s", actualFile.getAbsolutePath());
            return null;
        }
        boolean bl = this.isBindingLayout((Document)object, xPath);
        if (bl) {
            void var2_2;
            void var1_1;
            this.stripBindingTags((File)var1_1, (String)var2_2);
        }
        return actualFile;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isBindingLayout(Document doc, XPath xPath) throws XPathExpressionException {
        void var2_2;
        void var1_1;
        return !this.get((Document)var1_1, (XPath)var2_2, XPATH_BINDING_LAYOUT).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private List<Node> get(Document doc, XPath xPath, String pattern) throws XPathExpressionException {
        void var1_1;
        void var2_2;
        void var3_3;
        XPathExpression expr = xPath.compile((String)var3_3);
        return this.toList((NodeList)var2_2.evaluate(var1_1, XPathConstants.NODESET));
    }

    /*
     * WARNING - void declaration
     */
    private List<Node> toList(NodeList nodeList) {
        void var2_2;
        ArrayList<Node> result = new ArrayList<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            result.add(nodeList.item(i));
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private void stripBindingTags(File xml, String newTag) throws IOException {
        String res = XmlEditor.strip(xml, newTag);
        if (res != null) {
            void var2_2;
            void var1_1;
            L.d("file %s has changed, overwriting %s", xml.getName(), xml.getAbsolutePath());
            FileUtils.writeStringToFile((File)var1_1, (String)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static File urlToFile(URL url) throws MalformedURLException {
        try {
            return new File(url.toURI());
        }
        catch (IllegalArgumentException e) {
            void var1_2;
            void var0_1;
            MalformedURLException ex = new MalformedURLException(e.getLocalizedMessage());
            ex.initCause((Throwable)var0_1);
            throw var1_2;
        }
        catch (URISyntaxException uRISyntaxException) {
            URL uRL;
            return new File(uRL.getPath());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Map<String, String> attributeMap(XMLParser.ElementContext root) {
        void var1_1;
        HashMap<String, String> result = new HashMap<String, String>();
        for (XMLParser.AttributeContext attributeContext : XmlEditor.attributes(root)) {
            result.put(LayoutFileParser.escapeQuotes(attributeContext.attrName.getText(), false), LayoutFileParser.escapeQuotes(attributeContext.attrValue.getText(), true));
        }
        return var1_1;
    }

    private static XMLParser.AttributeContext findAttribute(XMLParser.ElementContext element, String name) {
        for (XMLParser.AttributeContext attributeContext : element.attribute()) {
            if (!LayoutFileParser.escapeQuotes(attributeContext.attrName.getText(), false).equals(name)) continue;
            return attributeContext;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static String escapeQuotes(String textWithQuotes, boolean unescapeValue) {
        String string;
        void var1_1;
        void var3_3;
        void var2_2;
        char last;
        char first = textWithQuotes.charAt(0);
        boolean start = false;
        int end = textWithQuotes.length();
        if (first == '\"' || first == '\'') {
            start = true;
        }
        if ((last = textWithQuotes.charAt(textWithQuotes.length() - 1)) == '\"' || var2_2 == 39) {
            --end;
        }
        String val = textWithQuotes.substring((int)var3_3, end);
        if (var1_1 != false) {
            return StringEscapeUtils.unescapeXml(val);
        }
        return string;
    }
}

