/*
 * Decompiled with CFR 0.152.
 */
package com.android.billingclient.util;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.ResultReceiver;
import com.android.billingclient.util.BillingHelper;

public class ProxyBillingActivity
extends Activity {
    public static final String RECEIVER_EXTRA = "receiver_extra";
    private static final String TAG = "ProxyBillingActivity";
    private static final int REQUEST_CODE = 100;
    private ResultReceiver mResultReceiver;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        BillingHelper.logVerbose(TAG, "Launching Play Store billing flow");
        PendingIntent pendingIntent = (PendingIntent)this.getIntent().getParcelableExtra("BUY_INTENT");
        this.mResultReceiver = (ResultReceiver)this.getIntent().getParcelableExtra(RECEIVER_EXTRA);
        try {
            this.startIntentSenderForResult(pendingIntent.getIntentSender(), 100, new Intent(), 0, 0, 0);
        }
        catch (IntentSender.SendIntentException e) {
            BillingHelper.logWarn(TAG, "Got exception while trying to start a purchase flow: " + (Object)((Object)e));
            this.mResultReceiver.send(6, null);
            this.finish();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 100) {
            int responseCode = BillingHelper.getResponseCodeFromIntent(data, TAG);
            if (resultCode != -1 || responseCode != 0) {
                BillingHelper.logWarn(TAG, "Got purchases updated result with resultCode " + resultCode + " and billing's responseCode: " + responseCode);
            }
            this.mResultReceiver.send(responseCode, data == null ? null : data.getExtras());
        } else {
            BillingHelper.logWarn(TAG, "Got onActivityResult with wrong requestCode: " + requestCode + "; skipping...");
        }
        this.finish();
    }
}

