/*
 * Decompiled with CFR 0.152.
 */
package com.android.actionsheetdialog;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.StringRes;
import android.support.annotation.StyleRes;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ScrollView;
import android.widget.TextView;
import com.android.actionsheetdialog.R;
import java.util.ArrayList;
import java.util.List;

public class ActionSheetDialog
extends AlertDialog {
    protected ActionSheetDialog(Context context) {
        super(context);
    }

    protected ActionSheetDialog(Context context, boolean cancelable, DialogInterface.OnCancelListener cancelListener) {
        super(context, cancelable, cancelListener);
    }

    protected ActionSheetDialog(Context context, @StyleRes int themeResId) {
        super(context, themeResId);
    }

    public static class ActionSheetBuilder
    extends AlertDialog.Builder {
        Context mContext;
        String mTitle;
        String mMessage;
        String mNegativeText;
        String mPositiveText;
        boolean mCancelable;
        List<ActionSheetItem> mActionSheetItems;
        DialogInterface.OnClickListener mNegativeClickListener;
        DialogInterface.OnClickListener mPositiveClickListener;
        ActionSheetDialog mActionSheetDialog;
        TextView mTitleView;
        TextView mMessageView;
        ScrollView mSheetItemContainer;
        TextView mCancelView;
        TextView mPositiveView;
        SheetItemOnClickListener mSheetItemOnClickListener = new SheetItemOnClickListener();

        public ActionSheetBuilder(Context context) {
            super(context);
            this.mContext = context;
            this.mActionSheetItems = new ArrayList<ActionSheetItem>();
        }

        public AlertDialog.Builder setCancelable(boolean cancelable) {
            this.mCancelable = cancelable;
            return this;
        }

        public AlertDialog.Builder setMessage(CharSequence message) {
            this.mMessage = (String)message;
            return this;
        }

        public AlertDialog.Builder setMessage(@StringRes int messageId) {
            this.mMessage = this.mContext.getString(messageId);
            return this;
        }

        public AlertDialog.Builder setTitle(CharSequence title) {
            this.mTitle = (String)title;
            return this;
        }

        public AlertDialog.Builder setTitle(@StringRes int titleId) {
            this.mTitle = this.mContext.getString(titleId);
            return this;
        }

        public AlertDialog.Builder setNegativeButton(CharSequence text, DialogInterface.OnClickListener listener) {
            this.mNegativeText = (String)text;
            this.mNegativeClickListener = listener;
            this.mCancelable = true;
            return this;
        }

        public AlertDialog.Builder setPositiveButton(CharSequence text, DialogInterface.OnClickListener listener) {
            this.mNegativeText = (String)text;
            this.mNegativeClickListener = listener;
            return this;
        }

        public AlertDialog.Builder addActionSheetItem(CharSequence text, int textColor, ActionSheetItemClickListener listener) {
            if (null != text && !TextUtils.isEmpty((CharSequence)text)) {
                if (textColor <= 0) {
                    textColor = Color.parseColor((String)"#2196f3");
                }
                ActionSheetItem actionSheetItem = new ActionSheetItem(textColor, (String)text, listener);
                this.mActionSheetItems.add(actionSheetItem);
            }
            return this;
        }

        public AlertDialog create() {
            this.mActionSheetDialog = new ActionSheetDialog(this.mContext);
            Window window = this.mActionSheetDialog.getWindow();
            window.setGravity(80);
            WindowManager.LayoutParams params = window.getAttributes();
            params.y = 0;
            ColorDrawable drawable = new ColorDrawable();
            drawable.setAlpha(0);
            window.setBackgroundDrawable((Drawable)drawable);
            this.mActionSheetDialog.setCancelable(this.mCancelable);
            if (this.mCancelable) {
                this.mActionSheetDialog.setCanceledOnTouchOutside(true);
            }
            this.initViews();
            return this.mActionSheetDialog;
        }

        private void initViews() {
            View rootView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_action_sheet_dialog, null);
            this.mTitleView = (TextView)rootView.findViewById(R.id.tv_title);
            this.mMessageView = (TextView)rootView.findViewById(R.id.tv_message);
            this.mSheetItemContainer = (ScrollView)rootView.findViewById(R.id.scrollView_sheet_list);
            this.mCancelView = (TextView)rootView.findViewById(R.id.tv_cancel);
            this.handleTitle();
            this.handleMessage();
            this.handleContent();
            this.handleCancel();
            this.handlePositive();
            this.mActionSheetDialog.setView(rootView);
        }

        private void handlePositive() {
            if (null != this.mPositiveText) {
                this.mPositiveView = new TextView(this.mContext);
                this.mPositiveView.setGravity(17);
                ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -2);
                this.mPositiveView.setLayoutParams(params);
                this.mPositiveView.setPadding(0, this.dpToPx(5.0f), 0, this.dpToPx(5.0f));
                this.mPositiveView.setText((CharSequence)this.mPositiveText);
                this.mPositiveView.setTextSize((float)this.spToPx(5.0f));
                this.mPositiveView.setTextColor(Color.parseColor((String)"#f44336"));
                this.mPositiveView.setTag((Object)-1);
                this.mPositiveView.setOnClickListener((View.OnClickListener)this.mSheetItemOnClickListener);
            }
        }

        private void handleCancel() {
            if (null != this.mCancelView && this.mCancelable) {
                if (null != this.mNegativeText) {
                    this.mCancelView.setText((CharSequence)this.mNegativeText);
                }
                this.mCancelView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (null != ActionSheetBuilder.this.mNegativeClickListener) {
                            ActionSheetBuilder.this.mNegativeClickListener.onClick((DialogInterface)ActionSheetBuilder.this.mActionSheetDialog, -2);
                        }
                    }
                });
            }
        }

        private void handleContent() {
            if (null == this.mActionSheetItems || this.mActionSheetItems.isEmpty()) {
                this.mSheetItemContainer.setVisibility(8);
            } else {
                for (int i = 0; i < this.mActionSheetItems.size(); ++i) {
                    ActionSheetItem item = this.mActionSheetItems.get(i);
                    TextView sheetItemView = new TextView(this.mContext);
                    sheetItemView.setGravity(17);
                    ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -2);
                    sheetItemView.setLayoutParams(params);
                    sheetItemView.setPadding(0, this.dpToPx(5.0f), 0, this.dpToPx(5.0f));
                    sheetItemView.setText((CharSequence)item.text);
                    sheetItemView.setTextSize((float)this.spToPx(5.0f));
                    sheetItemView.setTextColor(item.textColor);
                    sheetItemView.setTag((Object)i);
                    this.mSheetItemContainer.addView((View)sheetItemView);
                }
            }
        }

        private void handleMessage() {
            if (null != this.mMessageView) {
                if (null == this.mMessage) {
                    this.mMessageView.setVisibility(8);
                } else {
                    this.mMessageView.setText((CharSequence)this.mMessage);
                }
            }
        }

        private void handleTitle() {
            if (null != this.mTitleView) {
                if (null == this.mTitle) {
                    this.mTitleView.setVisibility(8);
                } else {
                    this.mTitleView.setText((CharSequence)this.mTitle);
                }
            }
        }

        public int dpToPx(float dp) {
            return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.mContext.getResources().getDisplayMetrics());
        }

        public int spToPx(float sp) {
            return (int)TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)this.mContext.getResources().getDisplayMetrics());
        }

        private class SheetItemOnClickListener
        implements View.OnClickListener {
            private SheetItemOnClickListener() {
            }

            public void onClick(View v) {
                int tag = (Integer)v.getTag();
                if (-1 == tag) {
                    if (null != ActionSheetBuilder.this.mPositiveClickListener) {
                        ActionSheetBuilder.this.mPositiveClickListener.onClick((DialogInterface)ActionSheetBuilder.this.mActionSheetDialog, -1);
                    }
                    ActionSheetBuilder.this.mActionSheetDialog.dismiss();
                } else {
                    ActionSheetBuilder.this.mActionSheetItems.get((int)tag).listener.onClick(tag);
                }
            }
        }

        public static interface ActionSheetItemClickListener {
            public void onClick(int var1);
        }

        static class ActionSheetItem {
            int textColor;
            String text;
            ActionSheetItemClickListener listener;

            public ActionSheetItem(int textColor, String text, ActionSheetItemClickListener listener) {
                this.textColor = textColor;
                this.text = text;
                this.listener = listener;
            }
        }
    }
}

