/*
 * Decompiled with CFR 0.152.
 */
package com.andreabaccega.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.design.widget.TextInputLayout;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.widget.EditText;
import com.andreabaccega.formedittext.R;
import com.andreabaccega.formedittextvalidator.AlphaNumericValidator;
import com.andreabaccega.formedittextvalidator.AlphaValidator;
import com.andreabaccega.formedittextvalidator.AndValidator;
import com.andreabaccega.formedittextvalidator.CreditCardValidator;
import com.andreabaccega.formedittextvalidator.DateValidator;
import com.andreabaccega.formedittextvalidator.DomainValidator;
import com.andreabaccega.formedittextvalidator.DummyValidator;
import com.andreabaccega.formedittextvalidator.EmailValidator;
import com.andreabaccega.formedittextvalidator.EmptyValidator;
import com.andreabaccega.formedittextvalidator.FloatNumericRangeValidator;
import com.andreabaccega.formedittextvalidator.IpAddressValidator;
import com.andreabaccega.formedittextvalidator.MultiValidator;
import com.andreabaccega.formedittextvalidator.NotValidator;
import com.andreabaccega.formedittextvalidator.NumericRangeValidator;
import com.andreabaccega.formedittextvalidator.NumericValidator;
import com.andreabaccega.formedittextvalidator.OrValidator;
import com.andreabaccega.formedittextvalidator.PersonFullNameValidator;
import com.andreabaccega.formedittextvalidator.PersonNameValidator;
import com.andreabaccega.formedittextvalidator.PhoneValidator;
import com.andreabaccega.formedittextvalidator.RegexpValidator;
import com.andreabaccega.formedittextvalidator.Validator;
import com.andreabaccega.formedittextvalidator.WebUrlValidator;
import com.andreabaccega.widget.EditTextValidator;

public class DefaultEditTextValidator
implements EditTextValidator {
    protected MultiValidator mValidator;
    protected String testErrorString;
    protected boolean emptyAllowed;
    protected EditText editText;
    protected int testType;
    protected String classType;
    protected String customRegexp;
    protected String customFormat;
    protected String emptyErrorStringActual;
    protected String emptyErrorString;
    protected int minNumber;
    protected int maxNumber;
    protected float floatminNumber;
    protected float floatmaxNumber;
    private TextWatcher tw;
    private String defaultEmptyErrorString;

    public DefaultEditTextValidator(EditText editText, Context context) {
        this.testType = 10;
        this.setEditText(editText);
        this.resetValidators(context);
    }

    public DefaultEditTextValidator(EditText editText, AttributeSet attrs, Context context) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.FormEditText);
        this.emptyAllowed = typedArray.getBoolean(R.styleable.FormEditText_emptyAllowed, false);
        this.testType = typedArray.getInt(R.styleable.FormEditText_testType, 10);
        this.testErrorString = typedArray.getString(R.styleable.FormEditText_testErrorString);
        this.classType = typedArray.getString(R.styleable.FormEditText_classType);
        this.customRegexp = typedArray.getString(R.styleable.FormEditText_customRegexp);
        this.emptyErrorString = typedArray.getString(R.styleable.FormEditText_emptyErrorString);
        this.customFormat = typedArray.getString(R.styleable.FormEditText_customFormat);
        if (this.testType == 15) {
            this.minNumber = typedArray.getInt(R.styleable.FormEditText_minNumber, Integer.MIN_VALUE);
            this.maxNumber = typedArray.getInt(R.styleable.FormEditText_maxNumber, Integer.MAX_VALUE);
        }
        if (this.testType == 16) {
            this.floatminNumber = typedArray.getFloat(R.styleable.FormEditText_floatminNumber, Float.MIN_VALUE);
            this.floatmaxNumber = typedArray.getFloat(R.styleable.FormEditText_floatmaxNumber, Float.MAX_VALUE);
        }
        typedArray.recycle();
        this.setEditText(editText);
        this.resetValidators(context);
    }

    @Override
    public void addValidator(Validator theValidator) throws IllegalArgumentException {
        if (theValidator == null) {
            throw new IllegalArgumentException("theValidator argument should not be null");
        }
        this.mValidator.enqueue(theValidator);
    }

    public String getClassType() {
        return this.classType;
    }

    public String getCustomRegexp() {
        return this.customRegexp;
    }

    public EditText getEditText() {
        return this.editText;
    }

    public void setEditText(EditText editText) {
        if (this.editText != null) {
            this.editText.removeTextChangedListener(this.getTextWatcher());
        }
        this.editText = editText;
        editText.addTextChangedListener(this.getTextWatcher());
    }

    public String getTestErrorString() {
        return this.testErrorString;
    }

    public int getTestType() {
        return this.testType;
    }

    @Override
    public TextWatcher getTextWatcher() {
        if (this.tw == null) {
            this.tw = new TextWatcher(){

                public void afterTextChanged(Editable s) {
                }

                public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                }

                public void onTextChanged(CharSequence s, int start, int before, int count) {
                    if (!TextUtils.isEmpty((CharSequence)s) && DefaultEditTextValidator.this.isErrorShown()) {
                        try {
                            TextInputLayout textInputLayout = (TextInputLayout)DefaultEditTextValidator.this.editText.getParent();
                            textInputLayout.setErrorEnabled(false);
                        }
                        catch (Throwable e) {
                            DefaultEditTextValidator.this.editText.setError(null);
                        }
                    }
                }
            };
        }
        return this.tw;
    }

    @Override
    public boolean isEmptyAllowed() {
        return this.emptyAllowed;
    }

    @Override
    public void resetValidators(Context context) {
        MultiValidator tmpValidator;
        Validator toAdd;
        this.defaultEmptyErrorString = context.getString(R.string.error_field_must_not_be_empty);
        this.setEmptyErrorString(this.emptyErrorString);
        this.mValidator = new AndValidator();
        switch (this.testType) {
            default: {
                toAdd = new DummyValidator();
                break;
            }
            case 2: {
                toAdd = new AlphaValidator(TextUtils.isEmpty((CharSequence)this.testErrorString) ? context.getString(R.string.error_only_standard_letters_are_allowed) : this.testErrorString);
                break;
            }
            case 3: {
                toAdd = new AlphaNumericValidator(TextUtils.isEmpty((CharSequence)this.testErrorString) ? context.getString(R.string.error_this_field_cannot_contain_special_character) : this.testErrorString);
                break;
            }
            case 1: {
                toAdd = new NumericValidator(TextUtils.isEmpty((CharSequence)this.testErrorString) ? context.getString(R.string.error_only_numeric_digits_allowed) : this.testErrorString);
                break;
            }
            case 15: {
                toAdd = new NumericRangeValidator(TextUtils.isEmpty((CharSequence)this.testErrorString) ? context.getString(R.string.error_only_numeric_digits_range_allowed, new Object[]{this.minNumber, this.maxNumber}) : this.testErrorString, this.minNumber, this.maxNumber);
                break;
            }
            case 16: {
                toAdd = new FloatNumericRangeValidator(TextUtils.isEmpty((CharSequence)this.testErrorString) ? context.getString(R.string.error_only_numeric_digits_range_allowed, new Object[]{Float.valueOf(this.floatminNumber), Float.valueOf(this.floatmaxNumber)}) : this.testErrorString, this.floatminNumber, this.floatmaxNumber);
                break;
            }
            case 0: {
                toAdd = new RegexpValidator(this.testErrorString, this.customRegexp);
                break;
            }
            case 5: {
                toAdd = new CreditCardValidator(TextUtils.isEmpty((CharSequence)this.testErrorString) ? context.getString(R.string.error_creditcard_number_not_valid) : this.testErrorString);
                break;
            }
            case 4: {
                toAdd = new EmailValidator(TextUtils.isEmpty((CharSequence)this.testErrorString) ? context.getString(R.string.error_email_address_not_valid) : this.testErrorString);
                break;
            }
            case 6: {
                toAdd = new PhoneValidator(TextUtils.isEmpty((CharSequence)this.testErrorString) ? context.getString(R.string.error_phone_not_valid) : this.testErrorString);
                break;
            }
            case 7: {
                toAdd = new DomainValidator(TextUtils.isEmpty((CharSequence)this.testErrorString) ? context.getString(R.string.error_domain_not_valid) : this.testErrorString);
                break;
            }
            case 8: {
                toAdd = new IpAddressValidator(TextUtils.isEmpty((CharSequence)this.testErrorString) ? context.getString(R.string.error_ip_not_valid) : this.testErrorString);
                break;
            }
            case 9: {
                toAdd = new WebUrlValidator(TextUtils.isEmpty((CharSequence)this.testErrorString) ? context.getString(R.string.error_url_not_valid) : this.testErrorString);
                break;
            }
            case 12: {
                toAdd = new PersonNameValidator(TextUtils.isEmpty((CharSequence)this.testErrorString) ? context.getString(R.string.error_notvalid_personname) : this.testErrorString);
                break;
            }
            case 13: {
                toAdd = new PersonFullNameValidator(TextUtils.isEmpty((CharSequence)this.testErrorString) ? context.getString(R.string.error_notvalid_personfullname) : this.testErrorString);
                break;
            }
            case 11: {
                Class<?> customValidatorClass;
                if (this.classType == null) {
                    throw new RuntimeException("Trying to create a custom validator but no classType has been specified.");
                }
                if (TextUtils.isEmpty((CharSequence)this.testErrorString)) {
                    throw new RuntimeException(String.format("Trying to create a custom validator (%s) but no error string specified.", this.classType));
                }
                try {
                    Class<?> loadedClass = this.getClass().getClassLoader().loadClass(this.classType);
                    if (!Validator.class.isAssignableFrom(loadedClass)) {
                        throw new RuntimeException(String.format("Custom validator (%s) does not extend %s", this.classType, Validator.class.getName()));
                    }
                    customValidatorClass = loadedClass;
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(String.format("Unable to load class for custom validator (%s).", this.classType));
                }
                try {
                    toAdd = (Validator)customValidatorClass.getConstructor(String.class).newInstance(this.testErrorString);
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(String.format("Unable to construct custom validator (%s) with argument: %s", this.classType, this.testErrorString));
                }
            }
            case 14: {
                toAdd = new DateValidator(TextUtils.isEmpty((CharSequence)this.testErrorString) ? context.getString(R.string.error_date_not_valid) : this.testErrorString, this.customFormat);
            }
        }
        if (!this.emptyAllowed) {
            tmpValidator = new AndValidator();
            tmpValidator.enqueue(new EmptyValidator(this.emptyErrorStringActual));
            tmpValidator.enqueue(toAdd);
        } else {
            tmpValidator = new OrValidator(toAdd.getErrorMessage(), new NotValidator(null, new EmptyValidator(null)), toAdd);
        }
        this.addValidator(tmpValidator);
    }

    public void setClassType(String classType, String testErrorString, Context context) {
        this.testType = 11;
        this.classType = classType;
        this.testErrorString = testErrorString;
        this.resetValidators(context);
    }

    public void setCustomRegexp(String customRegexp, Context context) {
        this.testType = 0;
        this.customRegexp = customRegexp;
        this.resetValidators(context);
    }

    public void setEmptyAllowed(boolean emptyAllowed, Context context) {
        this.emptyAllowed = emptyAllowed;
        this.resetValidators(context);
    }

    public void setEmptyErrorString(String emptyErrorString) {
        this.emptyErrorStringActual = !TextUtils.isEmpty((CharSequence)emptyErrorString) ? emptyErrorString : this.defaultEmptyErrorString;
    }

    public void setTestErrorString(String testErrorString, Context context) {
        this.testErrorString = testErrorString;
        this.resetValidators(context);
    }

    public void setTestType(int testType, Context context) {
        this.testType = testType;
        this.resetValidators(context);
    }

    @Override
    public boolean testValidity() {
        return this.testValidity(true);
    }

    @Override
    public boolean testValidity(boolean showUIError) {
        boolean isValid = this.mValidator.isValid(this.editText);
        if (!isValid && showUIError) {
            this.showUIError();
        }
        return isValid;
    }

    @Override
    public void showUIError() {
        if (this.mValidator.hasErrorMessage()) {
            try {
                TextInputLayout parent = (TextInputLayout)this.editText.getParent();
                parent.setErrorEnabled(true);
                parent.setError((CharSequence)this.mValidator.getErrorMessage());
            }
            catch (Throwable e) {
                this.editText.setError((CharSequence)this.mValidator.getErrorMessage());
            }
        }
    }

    public boolean isErrorShown() {
        try {
            TextInputLayout parent = (TextInputLayout)this.editText.getParent();
            return true;
        }
        catch (Throwable e) {
            return !TextUtils.isEmpty((CharSequence)this.editText.getError());
        }
    }
}

